---
title: Akzeptable GitHub-Nutzungsrichtlinien
redirect_from:
  - /articles/github-acceptable-use-policies
versions:
  free-pro-team: '*'
---

**Kurzversion:** _Wir hosten die unterschiedlichsten Projekte aus der ganzen Welt, an denen viele Benutzer gemeinsam arbeiten. Diese Zusammenarbeit funktioniert nur, wenn unsere Benutzer in gutem Glauben miteinander arbeiten können. Während Sie den Dienst nutzen, müssen Sie unsere akzeptablen Nutzungsbedingungen einhalten. Dazu gehören auch Einschränkungen hinsichtlich der Inhalte, die Sie veröffentlichen können, Ihres Verhaltens bei der Dienstnutzung und andere Beschränkungen. Kurz gesagt erwarten wir einen freundlichen Umgang miteinander._

Für großgeschriebene Begriffe, die in diesen akzeptablen Nutzungsrichtlinien verwendet, aber nicht definiert werden, gelten die Bedeutungen aus unseren [Nutzungsbedingungen](/articles/github-terms-of-service), [Unternehmensnutzungsbedingungen](/articles/github-corporate-terms-of-service) und unserer [Datenschutzerklärung](/articles/github-privacy-statement). Bei Kunden, für die unsere [Unternehmensnutzungsbedingungen](/articles/github-corporate-terms-of-service) gelten, beziehen sich „Sie“, „Ihnen“ und „Ihre“ auf „Kunde“ oder „Benutzer“. „Wir“, „uns“ und „unser“ bezieht sich auf „GitHub“.

### 1. Einhaltung von Gesetzen und Vorschriften
Sie sind dafür verantwortlich, bei der Nutzung des Dienstes alle geltenden Gesetze, Vorschriften und alle unsere akzeptablen Nutzungsrichtlinien einzuhalten. Diese Richtlinien können von Zeit zu Zeit aktualisiert werden und sind nachfolgend aufgeführt. Sie finden Sie auch in unseren [Nutzungsbedingungen](/articles/github-terms-of-service) und [Unternehmensnutzungsbedingungen](/articles/github-corporate-terms-of-service).

### 2. Beschränkungen hinsichtlich der Inhalte
Unter keinen Umständen dürfen Benutzer Inhalte in Repositorys hochladen, veröffentlichen, hosten, ausführen oder übertragen, die

- unrechtmäßig sind oder unrechtmäßige Aktivitäten fördern,

- sexuell oder obszön sind oder solche Inhalte enthalten,

- verleumderisch, beleidigend oder betrügerisch sind,

- diskriminierend oder beleidigend gegenüber einer Einzelperson oder Gruppe sind,

- unnötigerweise Gewalt abbilden oder verherrlichen, einschließlich Gewaltdarstellungen,

- unwahre, ungenaue oder absichtlich irreführende Informationen darstellen oder enthalten, welche die öffentlichen Interessen (einschließlich Gesundheit, Sicherheit, Wahlintegrität und Bürgerbeteiligung) beeinträchtigen können;

- aktive Schadsoftware oder Exploits enthalten oder installieren oder unsere Plattform für die Bereitstellung von Exploits nutzen (z. B. als Teil eines Befehls und Steuerungssystems) oder

- gegen ein Eigentumsrecht irgendeiner Partei verstoßen, einschließlich Patenten, Handelsmarken, Handelsgeheimnissen, Urheberrecht, Öffentlichkeitsrecht und sonstiger Rechte.

### 3. Beschränkungen hinsichtlich des Verhaltens
Während Sie den Dienst nutzen, dürfen Sie unter keinen Umständen

- eine Einzelperson oder Gruppe, einschließlich Ihrer Mitarbeiter, Führungskräfte, Vertreter und anderer Benutzer, belästigen, beleidigen, bedrohen oder zur Gewalt gegen sie aufrufen,

- unsere Server für irgendeine Art von übermäßigen automatisierten Massenaktivitäten (beispielsweise Spam oder Kryptowährungs-Mining) verwenden, die unsere Server durch automatisierte Mittel übermäßig belasten, oder irgendeine andere Form von unerwünschter Werbung oder Aufforderungen, z. B. Systeme, die schnellen Reichtum versprechen, über unsere Server verbreiten,

- unsere Server nutzen, um Dienste, Geräte, Daten, Konten oder Netzwerke zu stören oder zu versuchen, diese zu stören, oder um unbefugten Zugang zu erlangen oder dies zu versuchen (es sei denn, dies wurde im Rahmen des [GitHub Bug Bounty-Programms](https://bounty.github.com) genehmigt),

- sich als eine andere Person oder Entität ausgeben, einschließlich aller unserer Mitarbeiter oder Vertreter; dies gilt auch für falsche Verbindungen mit GitHub oder die arglistige Falschdarstellung Ihrer Identität oder des Zwecks Ihrer Website, oder

- den Datenschutz von Dritten verletzen, beispielsweise durch die Veröffentlichung personenbezogener Daten einer anderen Person ohne deren Zustimmung.

### 4. Einschränkungen hinsichtlich der Dienstnutzung
Sie dürfen keinen Teil des Dienstes, der Nutzung des Dienstes oder des Zugriffs auf den Dienst reproduzieren, duplizieren, kopieren, verkaufen, wiederverkaufen oder ausnutzen.

### 5. Beschränkungen hinsichtlich Scrapings und der API-Nutzung
Der Begriff „Scraping“ bezieht sich auf die Extrahierung von Daten aus unserem Dienst mithilfe automatischer Prozesse wie z. B. Bots oder Webcrawlern. Er umfasst nicht die Erfassung von Informationen über unser API. Please see Section H of our [Terms of Service](/articles/github-terms-of-service#h-api-terms) for our API Terms. Scraping ist Ihnen auf unserer Website für die folgenden Zwecke gestattet:

- Forscher können öffentliche, nicht personenbezogene Daten aus dem Dienst zu Forschungszwecken extrahieren, vorausgesetzt, die sich aus dieser Forschung ergebenden Veröffentlichungen werden öffentlich zugänglich gemacht.
- Archivare können öffentliche Daten zu Archivierungszwecken aus dem Dienst extrahieren.

Sie dürfen keine Daten aus dem Dienst für Spamzwecke extrahieren. Dies gilt auch für den Verkauf von personenbezogenen Daten von Benutzern (gemäß Definition in der [GitHub-Datenschutzerklärung](/articles/github-privacy-statement)) beispielsweise an Personalvermittler, Headhunter und Stellenbörsen.

Alle Daten, die mittels Scraping gesammelt werden, müssen den Vorgaben der [GitHub-Datenschutzerklärung](/articles/github-privacy-statement) entsprechen.

### 6. Datenschutz
Der Missbrauch personenbezogener Daten von Benutzern ist untersagt.

Natürliche oder juristische Personen oder Dienste, die von dem Dienst Daten erfassen, müssen die [GitHub-Datenschutzerklärung](/articles/github-privacy-statement) einhalten, insbesondere im Zusammenhang mit der Erfassung personenbezogener Daten von Benutzern. Wenn Sie personenbezogene Daten von Benutzern von dem Dienst erfassen, erklären Sie sich damit einverstanden, die personenbezogenen Daten von Benutzern nur zu den Zwecken zu verwenden, die der jeweilige Benutzer autorisiert hat. Sie verpflichten sich zum angemessenen Schutz aller personenbezogenen Daten von Benutzern, die Sie von dem Dienst erfasst haben, und beantworten Beschwerden, Aufforderungen zur Löschung und Kontaktverbote von uns oder anderen Benutzern umgehend.

### 7. Exzessive Bandbreitennutzung
Die Bandbreitenbeschränkungen des Dienstes variieren je nach den von Ihnen genutzten Funktionen. Wenn wir feststellen, dass Ihre Bandbreitennutzung im Verhältnis zu anderen Benutzern ähnhlicher Funktionen übermäßig hoch ausfällt, behalten wir uns das Recht vor, Ihr Konto auszusetzen, Ihr Datei-Hosting zu drosseln oder Ihre Aktivität anderweitig zu einzuschränken, bis Sie Ihren Bandbreitenverbrauch reduziert haben. We also reserve the right—after providing advance notice—to delete repositories that we determine to be placing undue strain on our infrastructure. For guidance on acceptable use of object storage in repositories, refer to "[What is my disk quota?](/github/managing-large-files/what-is-my-disk-quota)". For more details on specific features' bandwidth limitations, see the [GitHub Additional Product Terms](/github/site-policy/github-additional-product-terms).

### 8. Werbung auf GitHub
**Kurzversion:** *Wir verbieten nicht generell die Nutzung von GitHub für Werbung. Wir erwarten jedoch, dass unsere Benutzer bestimmte Einschränkungen einhalten, sodass GitHub nicht zu einem Spam-Hafen wird. Das will niemand.*

Wir haben Verständnis dafür, dass Sie für Ihre Inhalte werben möchten, indem Sie die Namen oder Logos Ihrer Unterstützer in Ihrem Konto veröffentlichen, aber der Schwerpunkt der Inhalte, die in oder über Ihr Konto auf den Dienst veröffentlicht werden, sollte nicht auf Werbung oder Promotionsmarketing liegen. Dazu gehören Inhalte, die auf oder über Seiten, Pakete, Repositorys und alle anderen Teile des Dienstes gepostet werden. Sie können in die README-Dokumente oder Projektbeschreibungsabschnitte, die mit Ihrem Konto verknüpft sind, statische Abbildungen, Links und Werbetext aufnehmen. Diese müssen sich jedoch auf das Projekt beziehen, das Sie auf GitHub hosten. Sie können nicht in den Konten anderer Benutzer werben, wie etwa durch das Posten von kostenpflichtigen oder exzessiven Masseninhalten in Issues.

Es ist Ihnen nicht gestattet, Inhalte oder Aktivitäten zu bewerben oder zu verbreiten, die illegal oder anderweitig durch unsere [Nutzungsbedingungen](/github/site-policy/github-terms-of-service/), [Community-Richtlinien](/github/site-policy/github-community-guidelines/) oder [Akzeptable Nutzungsrichtlinien](/github/site-policy/github-acceptable-use-policies/) verboten sind, einschließlich übermäßige automatisierte Massenaktivitäten (beispielsweise Spam), Systeme, die schnellen Reichtum versprechen und Irreführung oder Täuschung im Zusammenhang mit Ihrer Werbung.

Wenn Sie Werbematerialien in Ihrem Konto posten, tragen Sie die alleinige Verantwortung für die Einhaltung aller geltenden Gesetze und Vorschriften, darunter auch, aber nicht nur, die Richtlinien der US-amerikanischen Federal Trade Commission zu Empfehlungen und Referenzen. Federal Trade Commission's Guidelines on Endorsements and Testimonials. Wir behalten uns das Recht vor, Marketingmaterial oder Werbung zu entfernen, die nach unserem alleinigen Ermessen gegen GitHub-Bedingungen oder -Richtlinien verstößt.

### 9. Spam und nicht authentische Aktivitäten auf GitHub
Übermäßige automatisierte Massenaktivitäten und koordinierte, nicht authentische Aktivitäten wie Spam sind auf GitHub verboten. Zu den verbotenen Aktivitäten gehören:
* Massenverbreitung von Werbeaktionen und Werbung, die durch GitHub-Bedingungen und -Richtlinien verboten sind
* nicht authentische Interaktionen wie gefälschte Konten und automatisierte nicht authentische Aktivitäten
* Missbrauch der Rangliste, wie automatisiertes Sternchen oder Folgen
* Schaffung von oder Teilnahme an Sekundärmärkten zum Zwecke der Verbreitung nicht authentischer Aktivitäten
* Verwendung von GitHub als Plattform zur Verbreitung von Missbrauch auf anderen Plattformen
* Phishing oder Phishing-Versuch

GitHub behält sich das Recht vor, Inhalte zu entfernen, die gegen diese Richtlinie verstoßen.

### 10. Schutz der Benutzer
Sie dürfen keine Aktivitäten ausüben, die andere Benutzer deutlich schädigen. Bei legen Streitigkeiten zu Gunsten des allgemeinen Schutzes unserer Benutzer.
