---
title: DMCA Takedown-Richtlinie
redirect_from:
  - /dmca/
  - /dmca-takedown/
  - /dmca-takedown-policy/
  - /articles/dmca-takedown/
  - /articles/dmca-takedown-policy
versions:
  free-pro-team: '*'
---

Willkommen bei GitHubs Übersicht zum Digital Millennium Copyright Act, allgemein bekannt als "DMCA". Diese Seite ist nicht als eine umfassende Anleitung zu diesem Abkommen gedacht. Wenn Du jedoch eine DMCA-Benachrichtigung erhalten hast, die sich auf Inhalte bezieht, die Sie auf GitHub gepostet haben, oder wenn Du ein Rechtsträger bist, der eine solche Benachrichtigung herausgeben möchte, wird diese Seite hoffentlich dazu beitragen, das Gesetz sowie unsere Richtlinien zur Einhaltung des Gesetzes ein wenig zu veranschaulichen.

(Wenn Du nur eine Nachricht absenden möchtest, kannst Du [zum Ende vorspringen](#f-submitting-notices).)

Wie bei allen Rechtsfragen ist es immer am besten, sich mit einem Fachmann über Ihre spezifischen Fragen oder Situationen zu beraten. Wir empfehlen dringend, dies zu tun, bevor Sie Maßnahmen ergreifen, die sich auf Ihre Rechte auswirken könnten. Diese Übersicht ist keine Rechtsberatung und sollte nicht als solche betrachtet werden.

### Was ist die DMCA?

Um den DMCA und einige seiner politischen Leitlinien zu verstehen, ist es vielleicht hilfreich, das Leben vor seiner Verabschiedung zu betrachten.

Der DMCA gewährt Dienstanbietern, die benutzergenerierte Inhalte hosten, eine sichere Basis. Da selbst eine einzige Klage wegen Urheberrechtsverletzung einen gesetzlichen Schadensersatz von bis zu 150.000 US-Dollar nach sich ziehen kann, kann die Gefahr, für nutzergenerierte Inhalte haftbar gemacht zu werden, für die Dienstanbieter sehr schädigend sein. Da sich potenzielle Schadensfälle auf Millionen von Nutzer vervielfachen können, würden Websites mit Cloud-Computing und nutzergenerierten Inhalten wie YouTube, Facebook oder GitHub ohne den DMCA (oder zumindest nicht ohne die Weitergabe eines Teils dieser Kosten an ihre Nutzer) [wahrscheinlich nicht existieren](https://arstechnica.com/tech-policy/2015/04/how-the-dmca-made-youtube/).

Der DMCA behebt dieses Problem durch die Schaffung eines [sicheren Urheberrecht-Haftungsschutzes](https://www.copyright.gov/title17/92chap5.html#512) für Internetdienstanbieter, die angeblich gegen Benutzerinhalte verstoßen. Solange ein Dienstanbieter die Kündigungs- und Takedown-Regeln der DMCA befolgt, haftet er grundsätzlich nicht für Urheberrechtsverletzungen, die auf nutzergenerierten Inhalten basieren. Aus diesem Grund ist es wichtig für GitHub den DMCA Safe-Harbor-Status beizubehalten.

### DMCA-Benachrichtigungen im Überblick

Der DMCA umfasst zwei einfache, unkomplizierte Verfahren, die allen GitHub-Benutzern bekannt sein sollten: (i) ein [Takedown Notice](/articles/guide-to-submitting-a-dmca-takedown-notice)-Verfahren für Urheberrechtsinhaber, um die Entfernung von Inhalten zu beantragen; und (ii) ein [Counter Notice](/articles/guide-to-submitting-a-dmca-counter-notice)-Verfahren für Benutzer, um Inhalte wieder freizuschalten, wenn Inhalte aus Versehen oder wegen fehlerhafter Identifizierung entfernt werden.

DMCAa [Takedown Notices](/articles/guide-to-submitting-a-dmca-takedown-notice) werden von Urheberrechtsinhabern verwendet, um GitHub aufzufordern, Inhalte zu entfernen, die sie für verletzend halten. Wenn Du Software-Designer oder Entwickler bist, erstellst Due jeden Tag urheberrechtlich geschützte Inhalte. If someone else is using your copyrighted content in an unauthorized manner on GitHub, you can send us a DMCA takedown notice to request that the infringing content be changed or removed.

Zum Anderen kann eine [Counter-Notice](/articles/guide-to-submitting-a-dmca-counter-notice) verwendet werden, um Fehler zu korrigieren. Eventuell ist die Person, die die Benachrichtigung abgeschickt hat, nicht im Besitz des Urheberrechts oder hat nicht bemerkt, dass Du eine Lizenz besitzst oder hat irgendeinen anderen Fehler in ihrer Benachrichtigung gemacht. Da GitHub in der Regel nicht wissen kann, ob ein Fehler aufgetreten ist, kannst Du uns mit der DMCA Counter Notice darüber informieren und darum bitten, dass wir den Inhalt wieder freizuschalten.

Das DMCA Notice- und Takedown-Verfahren sollte nur für Beschwerden über Urheberrechtsverletzungen verwendet werden. Die im Rahmen unseres DMCA-Verfahrens gesendeten Benachrichtigungen müssen sich auf urheberrechtlich geschütztes Material beziehen, dessen Urheberrechte angeblich verletzt werden. Das Verfahren kann nicht für andere Beschwerden verwendet werden, z. B. Beschwerden über angebliche [Markenverletzung](/articles/github-trademark-policy/) oder [sensible Daten](/articles/github-sensitive-data-removal-policy/); für diese Situationen bieten wir separate Prozesse an.

### A. Wie funktioniert das eigentlich?

Das DMCA-Rahmenwerk ist ein wenig wie die Weitergabe von Notizzetteln im Unterricht. Der Urheberrechtsinhaber reicht eine Beschwerde über einen Benutzer bei GitHub ein. Wenn diese korrekt formuliert wurde, leiten wir die Beschwerde an den Benutzer weiter. Wenn der Benutzer die Beschwerde bestreitet, kann er einen entsprechenden Kommentar zurücksenden. GitHub verfügt bei diesem Verfahren über wenig Ermessensspielraum, abgesehen von der Feststellung, ob die Benachrichtigungen die Mindestanforderungen des DMCA erfüllen. Es obliegt den Parteien (und ihren Anwälten), die Stichhaltigkeit ihrer Ansprüche zu beurteilen, wobei zu bedenken ist, dass Benachrichtigungen unter dem Strafmaß des Meineids abgegeben werden müssen.

Im Folgenden sind die grundlegenden Schritte des Prozesses aufgeführt.

1. **Der Urheberrechtsinhaber stellt Ermittlungen an.** Ein Urheberrechtsinhaber sollte immer eine erste Ermittlung durchführen, um sowohl (a) zu bestätigen, dass er das Urheberrecht an einem Originalwerk besitzt, als auch (b) dass der Inhalt auf GitHub nicht autorisiert ist und gegen das Urheberrecht verstößt. Dazu gehört die Bestätigung, dass die Verwendung nicht als [Lautere Nutzung](https://www.lumendatabase.org/topics/22) geschützt ist. Eine lautere Nutzung kann vorliegen, wenn nur ein kleiner Teil an urheberrechtlich geschütztem Inhalt verwendet wird, wenn dieser Inhalt in einer umgestaltenden Weise verwendet wird, wenn er für pädagogische Zwecke oder für eine Kombination der oben genannten Zwecke verwendet wird. Da sich Code natürlich für solche Verwendungen eignet, ist jeder Anwendungsfall anders und muss gesondert betrachtet werden.
> **Beispiel:** Ein Mitarbeiter von Acme Web Company findet einen Teil des Unternehmenscodes in einem GitHub-Repository. Acme Web Company lizenziert seinen Quellcode an mehrere vertrauenswürdige Partner. Vor dem Senden einer Takedown-Benachrichtigung sollte Acme diese Lizenzen und seine Vereinbarungen überprüfen, um zu bestätigen, dass der Code auf GitHub unter keiner dieser Genehmigungen autorisiert ist.

2. **Der Urheberrechtsinhaber sendet eine Benachrichtigung.**Nach der durchgeführten Überprüfung verfasst und sendet ein Urheberrechtsinhaber eine [Takedown-Notice](/articles/guide-to-submitting-a-dmca-takedown-notice) an GitHub. Unter der Voraussetzung, dass die Takedown Notice entsprechend den gesetzlichen Anforderungen ausreichend detailliert ist (wie im[Leitfaden](/articles/guide-to-submitting-a-dmca-takedown-notice) beschrieben), [veröffentlichen wir die Benachrichtigung](#d-transparency) in unserem[öffentlichen Repository](https://github.com/github/dmca) und leiten den Link an den betroffenen Benutzer weiter.

3. **GitHub Asks User to Make Changes.** If the notice alleges that the entire contents of a repository infringe, or a package infringes, we will skip to Step 6 and disable the entire repository or package expeditiously. Andernfalls, da GitHub den Zugriff auf spezifische Dateien innerhalb eines Repositorys nicht deaktivieren kann, werden wir uns mit dem Benutzer, der das Repository erstellt hat, in Verbindung setzen und ihm etwa 1 Werktag Zeit geben, um den in der Benachrichtigung angegebenen Inhalt zu löschen oder zu ändern. Wir benachrichtigen den Urheberrechtsinhaber, wenn wir dem Benutzer die Möglichkeit geben, Änderungen vorzunehmen. Because packages are immutable, if only part of a package is infringing, GitHub would need to disable the entire package, but we permit reinstatement once the infringing portion is removed.

4. **Der Benutzer benachrichtigt GitHub bezüglich der Änderungen** Wenn der Benutzer sich entscheidet, die angegebenen Änderungen vorzunehmen *muss* er uns dies innerhalb eines Zeitraums von etwa 1 Werktag mitteilen. Andernfalls werden wir das Repository deaktivieren (wie in Schritt 6 beschrieben). Wenn der Benutzer uns benachrichtigt, dass er Änderungen vorgenommen hat, werden wir überprüfen, ob die Änderungen vorgenommen wurden, und dann den Urheberrechtsinhaber benachrichtigen.

5. **Der Urheberrechtsinhaber ändert oder widerruft die Benachrichtigung. ** Wenn der Benutzer Änderungen vornimmt, muss der Urheberrechtsinhaber diese überprüfen und die Takedown Notice erneuern oder überarbeiten, falls die Änderungen unzureichend sind. GitHub unternimmt keine weiteren Schritte, es sei denn, der Urheberrechtsinhaber setzt sich mit uns in Verbindung, um entweder die ursprüngliche Benachrichtigung zu verlängern oder eine überarbeitete Benachrichtigung einzureichen. Wenn der Urheberrechtsinhaber mit den Änderungen zufrieden ist, kann er entweder einen formellen Widerruf einreichen oder weiter nichts unternehmen. GitHub betrachtet ein länger als zwei Wochen währendes Stillschweigen als eine implizierte Rücknahme der Benachrichtigung.

6. **GitHub May Disable Access to the Content.** GitHub will disable a user's content if: (i) the copyright owner has alleged copyright over the user's entire repository or package (as noted in Step 3); (ii) the user has not made any changes after being given an opportunity to do so (as noted in Step 4); or (iii) the copyright owner has renewed their takedown notice after the user had a chance to make changes. Entscheidet sich der Urheberrechtsinhaber stattdessen dafür, die Benachrichtigung zu*revidieren*, kehren wir zu Schritt 2 zurück und wiederholen den Vorgang, als ob die revidierte Benachrichtigung eine neue Benachrichtigung wäre.

7. **Der Benutzer kann eine Counter Notice versenden.** Wir empfehlen Benutzern, deren Inhalte deaktiviert wurden, sich mit einem Anwalt über ihre Möglichkeiten zu beraten. Wenn ein Benutzer der Meinung ist, dass sein Inhalt aufgrund eines Fehlers oder einer falschen Identifizierung deaktiviert wurde, kann er uns eine [Counter Notice](/articles/guide-to-submitting-a-dmca-counter-notice) senden. Wie bei der ursprünglichen Benachrichtigung werden wir sicherstellen, dass die Counter-Benachrichtigung ausreichend detailliert ist (wie im [Leitfaden](/articles/guide-to-submitting-a-dmca-counter-notice) beschrieben). Ist dies der Fall, werden wir, werden wir [sie](#d-transparency) in unserem [öffentlichen Repository](https://github.com/github/dmca) veröffentlichen und die Benachrichtigung an den Urheberrechtsinhaber weiterleiten, indem wir ihm den Link senden.

8. **Der Urheberrechtsinhaber kann eine Rechtsklage einreichen.** Wenn ein Urheberrechtsinhaber den Inhalt nach Erhalt einer Counter Notice deaktiviert lassen möchte, muss er eine gerichtliche Klage einleiten, um eine gerichtliche Verfügung zu erwirken, die den Benutzer davon abhält, rechtswidrige Aktivitäten bezüglich des Inhalts auf GitHub zu verüben. Mit anderen Worten, Du könntest verklagt werden. Wenn der Urheberrechtsinhaber GitHub nicht innerhalb von 10-14 Tagen benachrichtigt und eine Kopie einer gültigen, bei einem zuständigen Gericht eingereichten Klage übermittelt, wird GitHub den deaktivierten Inhalt wieder aktivieren.

### B. Wie verhält es sich mit Forks? (oder was ist eine Fork?)

Eines der besten Features von GitHub ist die Möglichkeit für Benutzer, die Repositorys des anderen zu "forken". Was bedeutet das? Im Wesentlichen bedeutet dies, dass Benutzer eine Kopie eines Projekts auf GitHub in ihre eigenen Repositorys erstellen können. Wie es die Lizenz oder das Gesetz erlaubt, können die Benutzer dann Änderungen an diesem Fork vornehmen, um ihn entweder auf das Hauptprojekt zurückzuführen oder einfach als ihre eigene Variante eines Projekts beizubehalten. Jede dieser Kopien ist ein "[Fork](/articles/github-glossary#fork)" des ursprünglichen Repositorys, das wiederum auch als "Übergeordnetes Element" des Fork bezeichnet wird.

GitHub deaktiviert Forks *nicht* automatisch, wenn ein übergeordnetes Repository deaktiviert wird. Dies liegt daran, dass Forks verschiedenen Benutzern gehören, unter Umständen erheblich verändert wurden und möglicherweise lizenziert sind oder auf eine andere Art und Weise verwendet werden, die durch die Fair-Use-Doktrin geschützt ist. GitHub führt keine unabhängigen Untersuchungen von Forks durch. Wir erwarten von den Urheberrechtsinhabern, dass sie diese Untersuchung durchführen und, wenn sie der Meinung sind, dass die Forks ebenfalls ihre Rechte verletzen, ausdrücklich Forks in ihre Takedown Notice aufnehmen.

### C. Was passiert, wenn ich aus Versehen die Frist verpasst habe, um Änderungen vorzunehmen?

Wir sind uns bewusst, dass es viele triftige Gründe dafür gibt, dass Du möglicherweise nicht in der Lage bist, innerhalb des von uns angegebenen Zeitraums von ca. 1 Werktag Änderungen vorzunehmen, bevor Dein Repository deaktiviert wird. Vielleicht wurde unsere Nachricht als Spam identifiziert, vielleicht warst Du im Urlaub, vielleicht schaust Du nicht regelmäßig in dieses E-Mail-Konto, oder vielleicht warst Du einfach nur beschäftigt. Wir verstehen das. Wenn Du uns mitteilst, dass Du die Änderungen gerne vorgenommen hättest, aber die erste Gelegenheit dafür irgendwie verpasst hast, aktivieren wir das Repository erneut für ca. 1 Werktag, damit Du die Änderungen vornehmen kannst. Auch hier gilt, dass Du uns mitteilen musst, dass Du die Änderungen vorgenommen hast, damit das Repository nach diesem Zeitfenster von ca. 1 Werktag aktiviert bleibt, wie oben unter [Schritt A.4](#a-how-does-this-actually-work) beschrieben. Bitte beachte, dass wir Dir nur diese eine zusätzliche Gelegenheit dazu geben werden.

### D. Transparenz

Transparenz ist unserer Meinung nach eine Tugend. Die Öffentlichkeit sollte wissen, welche Inhalte von GitHub entfernt werden und warum. Eine informierte Öffentlichkeit kann potenzielle Probleme bemerken und aufdecken, die sonst in einem undurchsichtigen System unbemerkt bleiben würden. Wir veröffentlichen redigierte Kopien aller rechtlichen Benachrichtigungen, die wir erhalten (einschließlich Originalbenachrichtungen, Counter Notices oder Widerrufe) auf [nc="1">https://github.com/github/dmca](https://github.com/github/dmca). Wir geben keine persönlichen Kontaktinformationen öffentlich bekannt; wir werden persönliche Informationen (mit Ausnahme von Benutzernamen in URLs) vor der Veröffentlichung von Benachrichtigungen entfernen. Wir werden jedoch keine weiteren Informationen aus Ihrer Benachrichtigung streichen, es sei denn, Sie bitten uns ausdrücklich darum. Hier sind einige Beispiele für eine veröffentlichte [Notice](https://github.com/github/dmca/blob/master/2014/2014-05-28-Delicious-Brains.md) und [Counter Notice](https://github.com/github/dmca/blob/master/2014/2014-05-01-Pushwoosh-SDK-counternotice.md) um zu sehen, wie diese aussehen. Wenn wir Inhalte entfernen, werden wir an dieser Stelle einen Link zur entsprechenden Benachrichtigung veröffentlichen.

Außerdem weisen wir darauf hin, dass wir zwar keine unbearbeiteten Benachrichtigungen veröffentlichen, jedoch eine vollständige, unbearbeitete Kopie jeder Benachrichtigung, die wir erhalten, direkt an jede Partei weitergeben können, deren Rechte dadurch beeinträchtigt werden können.

### E. Wiederholte Verstöße

GitHub verpflichtet sich, unter angemessenen Umständen und nach eigenem Ermessen die Konten von Benutzern, die die Urheberrechte oder andere geistige Eigentumsrechte von GitHub oder anderen verletzen könnten, zu sperren und zu kündigen.

### F. Benachrichtigungen absenden

Wenn Sie bereit sind, eine Benachrichtigung oder eine Counter Notice einzureichen:
- [So reichen Sie eine DMCA-Benachrichtigung ein](/articles/guide-to-submitting-a-dmca-takedown-notice)
- [So reichen Sie eine DMCA Counter Notice ein](/articles/guide-to-submitting-a-dmca-counter-notice)

### Mehr erfahren und Stellung beziehen

Wenn man im Internet surft, findet man durchaus auch kritische Anmerkungen und Kommentare zum Urheberrechtssystem im Allgemeinen und zum DMCA im Speziellen. Während GitHub die wichtige Rolle anerkennt und schätzt, die der DMCA bei der Förderung von Innovationen im Internet gespielt hat, glauben wir, dass die Urheberrechtsgesetze durch aus ein oder zwei Patches nötig haben – wenn nicht gar eine ganz neue Version. In der Software verbessern und aktualisieren wir unseren Code ständig. Man muss sich überlegen, wie sehr sich die Technologie seit 1998, als der DMCA verfasst wurde, verändert hat. Macht es nicht einfach Sinn, diese Gesetze, die für Software gelten, zu aktualisieren?

Wir maßen uns nicht an, alle Antworten zu haben. Aber falls es euch interessiert, sind hier ein paar Links zu wissenschaftlichen Artikeln und Blog-Beiträgen mit Meinungen und Reformvorschlägen, die wir gefunden haben:

- [Unintended Consequences: Twelve Years Under the DMCA](https://www.eff.org/wp/unintended-consequences-under-dmca) (Electronic Frontier Foundation)
- [Statutory Damages in Copyright Law: A Remedy in Need of Reform](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=1375604) (William & Mary Law Review)
- [Is the Term of Protection of Copyright Too Long?](https://the1709blog.blogspot.com/2012/11/is-term-of-protection-of-copyright-too.html) (The 1709 Blog)
- [If We're Going to Change DMCA's 'Notice & Takedown,' Let's Focus on How Widely It's Abused](https://www.techdirt.com/articles/20140314/11350426579/if-were-going-to-change-dmcas-notice-takedown-lets-focus-how-widely-its-abused.shtml) (TechDirt)
- [Opportunities for Copyright Reform](https://www.cato-unbound.org/issues/january-2013/opportunities-copyright-reform) (Cato Unbound)
- [Fair Use Doctrine and the Digital Millennium Copyright Act: Does Fair Use Exist on the Internet Under the DMCA?](https://digitalcommons.law.scu.edu/lawreview/vol42/iss1/6/) (Santa Clara Law Review)

GitHub stimmt nicht zwangsläufig einem der in diesen Artikeln vertretenen Standpunkte zu. Wir stellen diese Links zur Verfügung, um Euch zu ermutigen, mehr zu erfahren, Euch eine eigene Meinung zu bilden und Euch dann an Eure gewählte(n) Vertretung(en) (z. B. Congress</a> or [E.U. Parliament](https://www.europarl.europa.eu/meps/en/home)) to seek whatever changes you think should be made.
