---
title: Berechtigungsebenen für die Repositorys einer Organisation
intro: 'Den Zugriff auf die einzelnen Repositorys Deiner Organisation kannst Du durch granulare Berechtigungsebenen anpassen. Auf diese Weise kannst Du Deinen Benutzern Zugriff auf genau die Funktionen und Aufgaben gewähren, die sie tatsächlich benötigen.'
redirect_from:
  - /articles/repository-permission-levels-for-an-organization-early-access-program/
  - /articles/repository-permission-levels-for-an-organization
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

Personen mit Administratorberechtigungen können den Zugriff einzelner Benutzer und Teams auf die Repositorys ihrer Organisation steuern.

### Berechtigungsebenen für die Repositorys einer Organisation

Du kannst Organisationsmitgliedern, externen Mitarbeitern und Teams unterschiedliche Zugriffsberechtigungen auf die Repositorys einer Organisation erteilen. Die einzelnen Berechtigungsebenen gewähren progressiv mehr Zugriffsrechte auf die Inhalte und Einstellungen eines Repositorys. Wähle die Ebene aus, die am besten zur jeweiligen Benutzer- oder Teamrolle innerhalb Deines Projekts passt, und achte darauf, den Benutzern nicht mehr als den notwendigen Zugriff auf ein Projekt zu geben.

Vom geringsten zum umfassendsten Zugriff sind die Berechtigungsebenen für die Repositorys einer Organisation wie folgt:
- **Read** (Lesen): Empfohlen für Mitarbeiter, die nicht zum Code beitragen, die aber Dein Projekt anzeigen und mitdiskutieren möchten{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
- **Triage** (Triage): Empfohlen für Mitarbeiter, die Issues und Pull Requests proaktiv verwalten müssen, aber keinen Schreibzugriff benötigen.{% endif %}
- **Write** (Schreiben): Empfohlen für Mitarbeiter, die aktiv zu Deinem Projekt beitragen.{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
- **Maintain** (Betreuen): Empfohlen für Projektmanager, die das Repository verwalten, aber keinen Zugriff auf sensible oder irreversible Aktionen benötigen.{% endif %}
- **Admin** (Verwalten): Empfohlen für Personen, die vollständigen Zugriff auf das Projekt benötigen und auch sensible oder irreversible Aktionen wie die Verwaltung der Sicherheit oder das Löschen eines Repositorys durchführen müssen

{% if currentVersion == "free-pro-team@latest" %}

{% endif %}

Weitere Informationen zum Erteilen von Zugriffsberechtigungen für Repositorys findest Du im Abschnitt „[Zugriff auf die Repositorys Deiner Organisation verwalten](/articles/managing-access-to-your-organizations-repositories).“

Organisationsinhaber können Basis-Berechtigungen festlegen, die für alle Mitglieder einer Organisation gelten, wenn sie auf eines der Repositorys der Organisation zugreifen. Weitere Informationen findest Du auf „[Basis-Berechtigungen für eine Organisation setzen](/github/setting-up-and-managing-organizations-and-teams/setting-base-permissions-for-an-organization#setting-base-permissions)."

Organisationsinhaber können den Zugriff auf bestimmte Einstellungen und Aktionen innerhalb ihrer Organisation noch weiter einschränken. Weitere Informationen zu den Optionen für bestimmte Einstellungen findest Du im Abschnitt „[Einstellungen einer Organisation verwalten](/articles/managing-organization-settings).“

Neben der Berechtigung zum Verwalten der organisationsweiten Einstellungen haben Organisationsinhaber auch vollständigen Zugriff auf jedes Repository ihrer Organisation. Weitere Informationen finden Sie unter „[Berechtigungsebenen für eine Organisation](/articles/permission-levels-for-an-organization)".

{% warning %}

**Warnung:** Wenn einem Repository ein Deployment-Schlüssel hinzugefügt wird, kann jede Person, die über den privaten Schlüssel verfügt, in Abhängigkeit der Schlüsseleinstellungen aus dem Repository lesen bzw. in das Repository schreiben, selbst wenn diese Person später aus der Organisation entfernt wird.

{% endwarning %}

### Repository-Zugriff der einzelnen Berechtigungsebenen
{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Repository-Aktion                                                                                                                                                                                                                                                       | Read (Gelesen) | bewerten | Schreiben | Betreuen |                                                                                   Verwalten                                                                                   |
|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:--------------:|:--------:|:---------:|:--------:|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| Pull (Abrufen) aus den zugewiesenen Repositorys der Person oder des Teams                                                                                                                                                                                               |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Erstellen eines Forks des zugewiesenen Repositorys der Person oder des Teams                                                                                                                                                                                            |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Bearbeiten und Löschen eigener Kommentare                                                                                                                                                                                                                               |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Eröffnen von Issues                                                                                                                                                                                                                                                     |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Schließen der selbst eröffneten Issues                                                                                                                                                                                                                                  |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Erneutes Eröffnen von selbst geschlossenen Issues                                                                                                                                                                                                                       |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Sich-Selbst-Zuweisen von Issues                                                                                                                                                                                                                                         |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Senden von Pull Requests aus Forks der dem Team zugewiesenen Repositorys                                                                                                                                                                                                |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Absenden von Reviews zu Pull Requests                                                                                                                                                                                                                                   |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Anzeigen veröffentlichter Releases                                                                                                                                                                                                                                      |     **X**      |  **X**   |   **X**   |  **X**   |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| [GitHub Actions-Workflow-Ausführungen](/actions/automating-your-workflow-with-github-actions/managing-a-workflow-run) ansehen                                                                                                                                           |     **X**      |  **X**   |   **X**   |  **X**   |                                                                              **X** |{% endif %}
| Bearbeiten von Wikis                                                                                                                                                                                                                                                    |     **X**      |  **X**   |   **X**   |  **X**   |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Melden von Missbrauch oder Spam](/articles/reporting-abuse-or-spam)                                                                                                                                                                                                    |     **X**      |  **X**   |   **X**   |  **X**   |                                                                              **X** |{% endif %}
| Anwenden von Kennzeichnungen                                                                                                                                                                                                                                            |                |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Schließen, erneutes Eröffnen und Zuweisen aller Issues und Pull Requests                                                                                                                                                                                                |                |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Anwenden von Meilensteinen                                                                                                                                                                                                                                              |                |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Markieren von [Issues und Pull Requests als Duplikat](/articles/about-duplicate-issues-and-pull-requests)                                                                                                                                                               |                |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Anfordern von [Pull Request-Reviews](/articles/requesting-a-pull-request-review)                                                                                                                                                                                        |                |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Push (Schreiben) in die zugewiesenen Repositorys der Person oder des Teams                                                                                                                                                                                              |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Bearbeiten und Löschen der Kommentare beliebiger Benutzer zu Commits, Pull Requests und Issues                                                                                                                                                                          |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| [Ausblenden der Kommentare beliebiger Benutzer](/articles/managing-disruptive-comments)                                                                                                                                                                                 |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| [Blockieren von Unterhaltungen](/articles/locking-conversations)                                                                                                                                                                                                        |                |          |   **X**   |  **X**   |                                                    **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Übertragen von Issues (siehe „[Issue auf ein anderes Repository übertragen](/articles/transferring-an-issue-to-another-repository)“)                                                                                                                                    |                |          |   **X**   |  **X**   |                                                                              **X** |{% endif %}
| [Agieren als designierter Codeinhaber eines Repositorys](/articles/about-code-owners)                                                                                                                                                                                   |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| [Markieren eines Pull-Request-Entwurfs als bereit für den Review](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                       |                |          |   **X**   |  **X**   |                                                    **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}
| [Einen Pull Request in einen Entwurf umwandeln](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                                         |                |          |   **X**   |  **X**   |                                                                              **X** |{% endif %}
| Absenden von Reviews, die sich auf die Merge-Fähigkeit eines Pull Request auswirken                                                                                                                                                                                     |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| [Anwenden vorgeschlagener Änderungen](/articles/incorporating-feedback-in-your-pull-request) auf Pull Requests                                                                                                                                                          |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Erstellen von [Statuschecks](/articles/about-status-checks)                                                                                                                                                                                                             |                |          |   **X**   |  **X**   |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| Erstellen, Bearbeiten, Ausführen, Neuausführen und Abbrechen von [GitHub Actions-Workflows](/actions/automating-your-workflow-with-github-actions/)                                                                                                                     |                |          |   **X**   |  **X**   |                                                                              **X** |{% endif %}
| Erstellen und Bearbeiten von Releases                                                                                                                                                                                                                                   |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Anzeigen von Release-Entwürfen                                                                                                                                                                                                                                          |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| Bearbeiten von Repository-Beschreibungen                                                                                                                                                                                                                                |                |          |           |  **X**   |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Pakete anzeigen und installieren](/packages/publishing-and-managing-packages)                                                                                                                                                                                          |     **X**      |  **X**   |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| [Pakete veröffentlichen](/packages/publishing-and-managing-packages/publishing-a-package)                                                                                                                                                                               |                |          |   **X**   |  **X**   |                                                                                     **X**                                                                                     |
| [Pakete löschen](/packages/publishing-and-managing-packages/deleting-a-package)                                                                                                                                                                                         |                |          |           |          |                                                                                     **X**                                                                                     |{% endif %}
| Verwalten von [Themen](/articles/classifying-your-repository-with-topics)                                                                                                                                                                                               |                |          |           |  **X**   |                                                                                     **X**                                                                                     |
| Aktivieren von Wikis und Einschränken der Wiki-Editoren                                                                                                                                                                                                                 |                |          |           |  **X**   |                                                                                     **X**                                                                                     |
| Aktivieren von Projektboards                                                                                                                                                                                                                                            |                |          |           |  **X**   |                                                                                     **X**                                                                                     |
| Configure [pull request merges](/articles/configuring-pull-request-merges)                                                                                                                                                                                              |                |          |           |  **X**   |                                                                                     **X**                                                                                     |
| Configure [a publishing source for {% data variables.product.prodname_pages %}](/articles/configuring-a-publishing-source-for-github-pages)                                                                                                                        |                |          |           |  **X**   |                                                                                     **X**                                                                                     |
| [An geschützte Branches pushen](/articles/about-protected-branches)                                                                                                                                                                                                     |                |          |           |  **X**   |                                                                                     **X**                                                                                     |
| [Erstellen und Bearbeiten sozialer Tickets für Repositorys](/articles/customizing-your-repositorys-social-media-preview)                                                                                                                                                |                |          |           |  **X**   |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Interaktionen in einem Repository](/github/building-a-strong-community/limiting-interactions-in-your-repository) limitieren                                                                                                                                            |                |          |           |  **X**   |                                                                              **X** |{% endif %}
| Löschen von Issues (siehe „[Issue löschen](/articles/deleting-an-issue)“)                                                                                                                                                                                               |                |          |           |          |                                                                                     **X**                                                                                     |
| Mergen von Pull Requests in geschützten Branches auch ohne Genehmigungsreviews                                                                                                                                                                                          |                |          |           |          |                                                                                     **X**                                                                                     |
| [Festlegen der Codeinhaber eines Repositorys](/articles/about-code-owners)                                                                                                                                                                                              |                |          |           |          |                                                                                     **X**                                                                                     |
| Ein Repository zu einem Team hinzufügen (für Details siehe „[Teamzugriff auf ein Organisations-Repository verwalten](/github/setting-up-and-managing-organizations-and-teams/managing-team-access-to-an-organization-repository#giving-a-team-access-to-a-repository)") |                |          |           |          |                                                                                     **X**                                                                                     |
| [Verwalten des Zugriffs externer Mitarbeiter auf ein Repository](/articles/adding-outside-collaborators-to-repositories-in-your-organization)                                                                                                                           |                |          |           |          |                                                                                     **X**                                                                                     |
| [Ändern der Sichtbarkeit eines Repositorys](/articles/restricting-repository-visibility-changes-in-your-organization)                                                                                                                                                   |                |          |           |          |                                                    **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Erstellen einer Vorlage aus einem Repository (siehe „[Repository-Vorlage erstellen](/articles/creating-a-template-repository)“)                                                                                                                                         |                |          |           |          |                                                                              **X** |{% endif %}
| Ändern der Einstellungen eines Repositorys                                                                                                                                                                                                                              |                |          |           |          |                                                                                     **X**                                                                                     |
| Verwalten des Team- und Mitarbeiterzugriffs auf ein Repository                                                                                                                                                                                                          |                |          |           |          |                                                                                     **X**                                                                                     |
| Bearbeiten des Standardbranch eines Repositorys                                                                                                                                                                                                                         |                |          |           |          |                                                                                     **X**                                                                                     |
| Manage webhooks and deploy keys                                                                                                                                                                                                                                         |                |          |           |          |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Aktivieren des Abhängigkeitsdiagramms](/github/visualizing-repository-data-with-graphs/exploring-the-dependencies-and-dependents-of-a-repository) für ein privates Repository                                                                                          |                |          |           |          |                                                                                     **X**                                                                                     |
| Receive [{% data variables.product.prodname_dependabot_alerts %} for vulnerable dependencies](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies) in a repository                                                                |                |          |           |          |                                                                                     **X**                                                                                     |
| [Dismiss {% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/viewing-and-updating-vulnerable-dependencies-in-your-repository)                                                                                     |                |          |           |          |                                                                                     **X**                                                                                     |
| [Designate additional people or teams to receive {% data variables.product.prodname_dependabot_alerts %}](/github/administering-a-repository/managing-security-and-analysis-settings-for-your-repository) for vulnerable dependencies                            |                |          |           |          |                                                                                     **X**                                                                                     |
| [Manage data use settings for your private repository](/github/understanding-how-github-uses-and-protects-your-data/managing-data-use-settings-for-your-private-repository)                                                                                             |                |          |           |          | **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" %}| Create [security advisories](/github/managing-security-vulnerabilities/about-github-security-advisories) | | | | | **X** |{% endif %}
| [Verwalten der Forking-Richtlinie für ein Repository](/github/administering-a-repository/managing-the-forking-policy-for-your-repository)                                                                                                                               |                |          |           |          |                                                                                     **X**                                                                                     |
| [Übertragen von Repositorys auf die Organisation](/articles/restricting-repository-creation-in-your-organization)                                                                                                                                                       |                |          |           |          |                                                                                     **X**                                                                                     |
| [Löschen von Repositorys oder Übertragen von Repositorys aus der Organisation](/articles/setting-permissions-for-deleting-or-transferring-repositories)                                                                                                                 |                |          |           |          |                                                                                     **X**                                                                                     |
| [Archivieren von Repositorys](/articles/about-archiving-repositories)                                                                                                                                                                                                   |                |          |           |          |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| Anzeigen einer Sponsorenschaltfläche (siehe „[Sponsorenschaltfläche in Deinem Repository anzeigen](/articles/displaying-a-sponsor-button-in-your-repository)“)                                                                                                          |                |          |           |          |                                               **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Create autolink references to external resources, like JIRA or Zendesk (see "[Configuring autolinks to reference external resources](/articles/configuring-autolinks-to-reference-external-resources)")                                                                 |                |          |           |          |                                                                              **X** |{% endif %}

{% else %}

| Repository-Aktion                                                                                                                                                                                                                                                                        | Lese-berechtigungen | Schreib-berechtigungen |                      Administratorberechtigungen                       |
|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:-------------------:|:----------------------:|:----------------------------------------------------------------------:|
| Pull (Lesen) aus den zugewiesenen Repositorys der Person oder des Teams                                                                                                                                                                                                                  |        **X**        |         **X**          |                                 **X**                                  |
| Erstellen eines Fork (Kopie) des zugewiesenen Repositorys der Person oder des Teams                                                                                                                                                                                                      |        **X**        |         **X**          |                                 **X**                                  |
| Bearbeiten und Löschen eigener Kommentare zu Commits, Pull Requests und Issues                                                                                                                                                                                                           |        **X**        |         **X**          |                                 **X**                                  |
| Eröffnen von Issues                                                                                                                                                                                                                                                                      |        **X**        |         **X**          |                                 **X**                                  |
| Schließen der selbst eröffneten Issues                                                                                                                                                                                                                                                   |        **X**        |         **X**          |                                 **X**                                  |
| Erneutes Eröffnen von selbst geschlossenen Issues                                                                                                                                                                                                                                        |        **X**        |         **X**          |                                 **X**                                  |
| Sich-Selbst-Zuweisen von Issues                                                                                                                                                                                                                                                          |        **X**        |         **X**          |                                 **X**                                  |
| Senden von Pull Requests aus Forks der dem Team zugewiesenen Repositorys                                                                                                                                                                                                                 |        **X**        |         **X**          |                                 **X**                                  |
| Absenden von Reviews zu Pull Requests                                                                                                                                                                                                                                                    |        **X**        |         **X**          |                                 **X**                                  |
| Anzeigen veröffentlichter Releases                                                                                                                                                                                                                                                       |        **X**        |         **X**          |                                 **X**                                  |
| Bearbeiten von Wikis                                                                                                                                                                                                                                                                     |        **X**        |         **X**          |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Melden von Missbrauch oder Spam](/articles/reporting-abuse-or-spam)                                                                                                                                                                                                                     |        **X**        |         **X**          |                           **X** |{% endif %}
| Push (Schreiben) in die zugewiesenen Repositorys der Person oder des Teams                                                                                                                                                                                                               |                     |         **X**          |                                 **X**                                  |
| Bearbeiten und Löschen der Kommentare beliebiger Benutzer zu Commits, Pull Requests und Issues                                                                                                                                                                                           |                     |         **X**          |                                 **X**                                  |
| [Ausblenden der Kommentare beliebiger Benutzer](/articles/managing-disruptive-comments)                                                                                                                                                                                                  |                     |         **X**          |                                 **X**                                  |
| [Blockieren von Unterhaltungen](/articles/locking-conversations)                                                                                                                                                                                                                         |                     |         **X**          |                                 **X**                                  |
| Anwenden von Kennzeichnungen und Meilensteinen                                                                                                                                                                                                                                           |                     |         **X**          |                                 **X**                                  |
| Schließen, erneutes Eröffnen und Zuweisen aller Issues                                                                                                                                                                                                                                   |                     |         **X**          |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| Markieren von [Issues und Pull Requests als Duplikat](/articles/about-duplicate-issues-and-pull-requests)                                                                                                                                                                                |                     |         **X**          |                           **X** |{% endif %}
| [Agieren als designierter Codeinhaber eines Repositorys](/articles/about-code-owners)                                                                                                                                                                                                    |                     |         **X**          |                                 **X**                                  |
| [Markieren eines Pull-Request-Entwurfs als bereit für den Review](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                                        |                     |         **X**          |                                 **X**                                  |
| Anfordern von [Pull Request-Reviews](/articles/requesting-a-pull-request-review)                                                                                                                                                                                                         |                     |         **X**          |                                 **X**                                  |
| Absenden von Reviews, die sich auf die Merge-Fähigkeit eines Pull Request auswirken                                                                                                                                                                                                      |                     |         **X**          |                                 **X**                                  |
| Anwenden vorgeschlagener Änderungen an Pull Requests (siehe „[Feedback in Deinen Pull Request aufnehmen](/articles/incorporating-feedback-in-your-pull-request)“)                                                                                                                        |                     |         **X**          |                                 **X**                                  |
| Erstellen von [Statuschecks](/articles/about-status-checks)                                                                                                                                                                                                                              |                     |         **X**          |                                 **X**                                  |
| Erstellen und Bearbeiten von Releases                                                                                                                                                                                                                                                    |                     |         **X**          |                                 **X**                                  |
| Anzeigen von Release-Entwürfen                                                                                                                                                                                                                                                           |                     |         **X**          |                                 **X**                                  |
| Löschen von Issues (siehe „[Issue löschen](/articles/deleting-an-issue)“)                                                                                                                                                                                                                |                     |                        |                                 **X**                                  |
| Mergen von Pull Requests in geschützten Branches auch ohne Genehmigungsreviews                                                                                                                                                                                                           |                     |                        |                                 **X**                                  |
| [Festlegen der Codeinhaber eines Repositorys](/articles/about-code-owners)                                                                                                                                                                                                               |                     |                        |                                 **X**                                  |
| Bearbeiten von Repository-Beschreibungen                                                                                                                                                                                                                                                 |                     |                        |                                 **X**                                  |
| Verwalten von [Themen](/articles/classifying-your-repository-with-topics)                                                                                                                                                                                                                |                     |                        | **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Erstellen und Bearbeiten sozialer Tickets für Repositorys (siehe „[Social-Media-Vorschau Deines Repositorys anpassen](/articles/customizing-your-repositorys-social-media-preview)“)                                                                                                     |                     |                        |                           **X** |{% endif %}
| Ein Repository zu einem Team hinzufügen (für Details siehe „[Teamzugriff auf ein Organisations-Repository verwalten](/github/setting-up-and-managing-organizations-and-teams/managing-team-access-to-an-organization-repository#giving-a-team-access-to-a-repository)")                  |                     |                        |                                 **X**                                  |
| Verwalten des Zugriffs externer Mitarbeiter auf ein Repository (siehe „[Externe Mitarbeiter zu Organisationsrepositorys hinzufügen](/articles/adding-outside-collaborators-to-repositories-in-your-organization)“)                                                                       |                     |                        |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Interaktionen in einem Repository](/github/building-a-strong-community/limiting-interactions-in-your-repository) limitieren                                                                                                                                                             |                     |                        |                           **X** |{% endif %}
| Ändern der Sichtbarkeit eines Repositorys (siehe „[Änderungen an der Sichtbarkeit eines Repositorys in Deiner Organisation einschränken](/articles/restricting-repository-visibility-changes-in-your-organization)“)                                                                     |                     |                        | **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Erstellen einer Vorlage aus einem Repository (siehe „[Repository-Vorlage erstellen](/articles/creating-a-template-repository)“)                                                                                                                                                          |                     |                        |                         | | **X** |{% endif %}
| Ändern der Einstellungen eines Repositorys                                                                                                                                                                                                                                               |                     |                        |                                 **X**                                  |
| Verwalten des Team- und Mitarbeiterzugriffs auf ein Repository                                                                                                                                                                                                                           |                     |                        |                                 **X**                                  |
| Bearbeiten des Standardbranch eines Repositorys                                                                                                                                                                                                                                          |                     |                        |                                 **X**                                  |
| Manage webhooks and deploy keys                                                                                                                                                                                                                                                          |                     |                        |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Aktivieren des Abhängigkeitsdiagramms](/github/visualizing-repository-data-with-graphs/exploring-the-dependencies-and-dependents-of-a-repository) für ein privates Repository                                                                                                           |                     |                        |                                 **X**                                  |
| Receive [{% data variables.product.prodname_dependabot_alerts %} for vulnerable dependencies](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies) in a repository                                                                                 |                     |                        |                                 **X**                                  |
| [Dismiss {% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/viewing-and-updating-vulnerable-dependencies-in-your-repository)                                                                                                      |                     |                        |                                 **X**                                  |
| [Designate additional people or teams to receive {% data variables.product.prodname_dependabot_alerts %}](/github/administering-a-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-github-dependabot-alerts) for vulnerable dependencies |                     |                        |                                 **X**                                  |
| [Manage data use settings for your private repository](/github/understanding-how-github-uses-and-protects-your-data/managing-data-use-settings-for-your-private-repository)                                                                                                              |                     |                        |          **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" %}
| [Sicherheitshinweise](/github/managing-security-vulnerabilities/about-github-security-advisories) erstellen")                                                                                                                                                                            |                     |                        |                                 **X**                                  |{% endif %}
| [Verwalten der Forking-Richtlinie für ein Repository](/github/administering-a-repository/managing-the-forking-policy-for-your-repository)                                                                                                                                                |                     |                        |                                 **X**                                  |
| Übertragen von Repositorys auf das Organisationskonto (siehe „[Repository-Erstellung in Deiner Organisation einschränken](/articles/restricting-repository-creation-in-your-organization)“)                                                                                              |                     |                        |                                 **X**                                  |
| Löschen oder Übertragen von Repositorys (siehe „[Berechtigungen zum Löschen oder Übertragen von Repositorys in Deiner Organisation einstellen](/articles/setting-permissions-for-deleting-or-transferring-repositories)“)                                                                |                     |                        |                                 **X**                                  |
| [Archivieren von Repositorys](/articles/about-archiving-repositories)                                                                                                                                                                                                                    |                     |                        |                                 **X**                                  |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Erstellen von automatisch verknüpften Verweisen zu externen Ressourcen wie JIRA oder Zendesk (siehe „[Automatische Verknüpfung zu Verweisen zu externen Ressourcen](/articles/configuring-autolinks-to-reference-external-resources)“)                                                   |                     |                        |                         | | **X** |{% endif %}

{% endif %}

### Weiterführende Informationen

- „[Zugriff auf die Repositorys Deiner Organisation verwalten](/articles/managing-access-to-your-organization-s-repositories)“
- „[Externe Mitarbeiter zu Organisations-Repositorys hinzufügen](/articles/adding-outside-collaborators-to-repositories-in-your-organization)“
- „[Projektboardberechtigungen für eine Organisation](/articles/project-board-permissions-for-an-organization)“
