---
title: Tastenkürzel
intro: 'Auf nahezu allen Seiten auf {% data variables.product.product_name %} gibt es Tastenkürzel, um Aktionen schneller durchführen zu können.'
redirect_from:
  - /articles/using-keyboard-shortcuts/
  - /categories/75/articles/
  - /categories/keyboard-shortcuts/
  - /articles/keyboard-shortcuts
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---


### Informationen zu Tastenkürzeln

Wird <kbd>?</kbd> in {% data variables.product.product_name %} eingegeben, öffnet sich ein Dialogfeld, das die für die jeweilige Seite verfügbaren Tastenkürzel auflistet. Mit diesen Tastenkürzeln kannst Du Aktionen auf der gesamten Website durchführen, ohne Deine Maus zur Navigation verwenden zu müssen.

Im Folgenden findest Du eine Liste mit einigen der verfügbaren Tastenkürzel.

### Seitenweite Tastenkürzel

| Tastenkürzel                   | Beschreibung                                                                                                                                                                                                                                                                                                                                                                       |
| ------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| <kbd>s</kbd> oder <kbd>/</kbd> | Hiermit fokussierst Du die Suchleiste. Weitere Informationen findest Du unter „[Informationen zur Suche auf {% data variables.product.company_short %}](/articles/about-searching-on-github).“                                                                                                                                                                                |
| <kbd>g</kbd> <kbd>n</kbd>      | Gehe zu Deinen Benachrichtigungen. Weitere Informationen findest Du unter {% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}„[Über Benachrichtigungen](/github/managing-subscriptions-and-notifications-on-github/about-notifications){% else %}„[Über Benachrichtigungen](/github/receiving-notifications-about-activity-on-github/about-notifications){% endif %}." |
| <kbd>esc</kbd>                 | Wenn auf eine Benutzer-, Issue- oder Pull-Request-Hovercard (Informationskarte) konzentriert, schließt das Kürzel die Hovercard und konzentriert sich erneut auf das Element, in dem sich die Hovercard befindet                                                                                                                                                                   |

### Repositorys

| Tastenkürzel              | Beschreibung                                                                                                                                                               |
| ------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| <kbd>g</kbd> <kbd>c</kbd> | Hiermit wechselst Du zur Registerkarte **Code**                                                                                                                            |
| <kbd>g</kbd> <kbd>i</kbd> | Hiermit wechselst Du zur Registerkarte **Issues**. Weitere Informationen findest Du unter „[Informationen zu Issues](/articles/about-issues).“                             |
| <kbd>g</kbd> <kbd>p</kbd> | Hiermit wechselst Du zur Registerkarte **Pull Requests**. Weitere Informationen findest Du unter „[Informationen zu Pull Requests](/articles/about-pull-requests).“        |
| <kbd>g</kbd> <kbd>a</kbd> | Go to the **Actions** tab. For more information, see "[About Actions](/actions/getting-started-with-github-actions/about-github-actions)."                                 |
| <kbd>g</kbd> <kbd>b</kbd> | Hiermit wechselst Du zur Registerkarte **Projects** (Projekte). Weitere Informationen findest Du unter „[Informationen zu Projektboards](/articles/about-project-boards).“ |
| <kbd>g</kbd> <kbd>w</kbd> | Hiermit wechselst Du zur Registerkarte **Wiki**. Weitere Informationen findest Du unter „[Informationen zu Wikis](/articles/about-wikis).“                                 |

### Quellcodebearbeitung

| Tastenkürzel                                                                                | Beschreibung                                                                                                        |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| <kbd>e</kbd>                                                                                | Öffne Quellcode-Datei in der Registerkarte **Edit file** (Datei anpassen)                                           |
| <kbd>Steuertaste + f</kbd> oder <kbd>Befehlstaste + f</kbd>                                 | Suchen im Datei-Editor                                                                                              |
| <kbd>Steuertaste + g</kbd> oder <kbd>Befehlstaste + g</kbd>                                 | Suchen nach dem nächsten Eintrag                                                                                    |
| <kbd>Umschalttaste + Steuertaste+g</kbd> oder <kbd>Umschalttaste + Befehlstaste+g</kbd>     | Suchen nach dem vorherigen Eintrag                                                                                  |
| <kbd>Umschalttaste + Steuertaste+f</kbd> oder <kbd>Befehlstaste + f</kbd>                   | Ersetze den Eintrag                                                                                                 |
| <kbd>Umschalttaste + Steuertaste + r</kbd> oder <kbd>Umschalttaste + Befehlstaste + f</kbd> | Ersetze alle Einträge                                                                                               |
| <kbd>Alt+g</kbd>                                                                            | Springe zur entsprechenden Zeile                                                                                    |
| <kbd>Steuertaste + z</kbd> oder <kbd>Befehlstaste + z</kbd>                                 | Mache die Aktion rückgängig                                                                                         |
| <kbd>Steuertaste + y</kbd> oder <kbd>Befehlstaste + y</kbd>                                 | Wiederhole Sie die Aktion                                                                                           |
| <kbd>Befehlstaste + Umschalttaste + p</kbd>                                                 | Umschalten zwischen den Registerkarten **Edit file** (Datei bearbeiten) und **Preview changes** (Änderungsvorschau) |

Weitere Tastenkürzel findest Du in der [CodeMirror-Dokumentation](https://codemirror.net/doc/manual.html#commands).

### Quellcodedurchsuchung

| Tastenkürzel | Beschreibung                                                                                                                                                                             |
| ------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| <kbd>t</kbd> | Hiermit wird die Dateisuche aktiviert                                                                                                                                                    |
| <kbd>l</kbd> | Springe zu einer Zeile in Deinem Code                                                                                                                                                    |
| <kbd>w</kbd> | Wechsle zu einem neuen Branch oder Tag                                                                                                                                                   |
| <kbd>y</kbd> | Erweitere eine URL auf ihre kanonische Form. Weitere Informationen findest Du unter „[Permalinks zu Dateien abrufen](/articles/getting-permanent-links-to-files)“                        |
| <kbd>i</kbd> | Zeige Kommentare zu Diffs an oder blende sie aus. Weitere Informationen findest Du unter „[Kommentare zum Diff eines Pull Requests](/articles/commenting-on-the-diff-of-a-pull-request)“ |
| <kbd>b</kbd> | Öffne die Blame-Ansicht. Weitere Informationen findest Du unter „[Änderungen in einer Datei verfolgen](/articles/tracing-changes-in-a-file)“                                             |

### Kommentare

| Tastenkürzel                                                                                    | Beschreibung                                                                                                                                                                                                                                                                           |
| ----------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| <kbd>Steuertaste + b</kbd> oder <kbd>Befehlstaste + b</kbd>                                     | Hiermit wird die Markdown-Formatierung für den Fettdruck von Text eingefügt.                                                                                                                                                                                                           |
| <kbd>Steuertaste + i</kbd> oder <kbd>Befehlstaste + i</kbd>                                     | Hiermit wird die Markdown-Formatierung für die Kursivsetzung von Text eingefügt.                                                                                                                                                                                                       |
| <kbd>Steuertaste + k</kbd> oder <kbd>Befehlstaste + k</kbd>                                     | Hiermit wird die Markdown-Formatierung zum Erstellen eines Links eingefügt.                                                                                                                                                                                                            |
| <kbd>Steuertaste + Umschalttaste + p</kbd> oder <kbd>Befehlstaste + Umschalttaste + p</kbd>     | Hiermit wird zwischen den Kommentar-Registerkarten **Write** (Schreiben) und **Preview** (Vorschau) umgeschaltet                                                                                                                                                                       |
| <kbd>Steuertaste + Eingabetaste</kbd>                                                           | Hiermit wird ein Kommentar abgesendet.                                                                                                                                                                                                                                                 |
| <kbd>Steuertaste + .</kbd> und dann <kbd>Steuertaste + [Nummer der gespeicherten Antwort]</kbd> | Hiermit wird das Menü für gespeicherte Antworten geöffnet und im Kommentarfeld automatisch eine gespeicherte Antwort eingetragen. Weitere Informationen finden Sie unter „[Informationen zu gespeicherten Antworten](/articles/about-saved-replies)“.{% if currentVersion == "free-pro-team@latest" %}
| <kbd>Steuertaste + g</kbd> oder <kbd>Befehlstaste + g</kbd>                                     | Hiermit wird ein Vorschlag eingefügt. Weitere Informationen findest Du unter „[Vorgeschlagene Änderungen in einem Pull Request überprüfen](/articles/reviewing-proposed-changes-in-a-pull-request).“ |{% endif %}
| <kbd>r</kbd>                                                                                    | Hiermit wird der ausgewählte Text in Deiner Antwort zitiert. Weitere Informationen findest Du unter „[Grundlegende Schreib- und Formatierungssyntax](/articles/basic-writing-and-formatting-syntax#quoting-text).“                                                                     |

### Issue- und Pull-Request-Listen

| Tastenkürzel                                                | Beschreibung                                                                                                                                                                                                                                                             |
| ----------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| <kbd>c</kbd>                                                | Hiermit wird ein Issue erstellt.                                                                                                                                                                                                                                         |
| <kbd>Steuertaste + /</kbd> oder <kbd>Befehlstaste + /</kbd> | Hiermit wird der Fokus Deines Cursors auf die Suchleiste mit den Issues oder mit den Pull Requests gelegt. Weitere Informationen findest Du unter „[Issues und Pull Requests mit der Suchfunktion filtern](/articles/using-search-to-filter-issues-and-pull-requests).“| |
| <kbd>u</kbd>                                                | Hiermit wird nach Autor gefiltert.                                                                                                                                                                                                                                       |
| <kbd>l</kbd>                                                | Hiermit wird nach Kennzeichnungen gefiltert oder werden diese bearbeitet. Weitere Informationen findest Du unter „[Issues und Pull Requests nach Kennzeichnungen filtern](/articles/filtering-issues-and-pull-requests-by-labels).“                                      |
| <kbd>Alt</kbd> und klicken                                  | Hiermit werden Kennzeichnungen beim Filtern nach Kennzeichnungen ausgeschlossen. Weitere Informationen findest Du unter „[Issues und Pull Requests nach Kennzeichnungen filtern](/articles/filtering-issues-and-pull-requests-by-labels).“                               |
| <kbd>m</kbd>                                                | Hiermit wird nach Meilensteinen gefiltert oder werden diese bearbeitet. Weitere Informationen findest Du unter „[Issues und Pull Requests nach Meilensteinen filtern](/articles/filtering-issues-and-pull-requests-by-milestone).“                                       |
| <kbd>a</kbd>                                                | Hiermit wird nach Bearbeitern gefiltert oder werden diese bearbeitet. Weitere Informationen findest Du unter „[Issues und Pull Requests nach Bearbeitern filtern](/articles/filtering-issues-and-pull-requests-by-assignees).“                                           |
| <kbd>o</kbd> oder <kbd>Eingabetaste</kbd>                   | Hiermit wird ein Issue geöffnet.                                                                                                                                                                                                                                         |

### Issues und Pull Requests
| Tastenkürzel                                                                              | Beschreibung                                                                                                                                                                                                                                                 |
| ----------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| <kbd>q</kbd>                                                                              | Hiermit wird ein Reviewer angefordert. Weitere Informationen findest Du unter „[Pull-Request-Review anfordern](/articles/requesting-a-pull-request-review/).“                                                                                                |
| <kbd>m</kbd>                                                                              | Hiermit wird ein Meilenstein festgelegt. Weitere Informationen findest Du unter „[Meilensteine mit Issues und Pull Requests verknüpfen](/articles/associating-milestones-with-issues-and-pull-requests/).“                                                   |
| <kbd>l</kbd>                                                                              | Hiermit wird eine Kennzeichnung angewendet. Weitere Informationen findest Du unter „[Kennzeichnungen auf Issues und Pull Requests anwenden](/articles/applying-labels-to-issues-and-pull-requests/).“                                                        |
| <kbd>a</kbd>                                                                              | Hiermit wird ein Bearbeiter festgelegt. Weitere Informationen findest Du unter „[Issues und Pull Requests anderen {% data variables.product.company_short %}-Benutzern zuweisen](/articles/assigning-issues-and-pull-requests-to-other-github-users/).“ |
| <kbd>Befehlstaste + Umschalttaste+p</kbd> oder <kbd>Steuertaste + Umschalttaste + p</kbd> | Hiermit wird zwischen den Registerkarten **Write** (Schreiben) und **Preview** (Vorschau) umgeschaltet.                                                                                                                                                      |

### Änderungen in Pull Requests

| Tastenkürzel                                            | Beschreibung                                                                                                                                                                                                                                                                                                                                                                             |
| ------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| <kbd>c</kbd>                                            | Hiermit wird die Liste der Commits im Pull Request geöffnet.                                                                                                                                                                                                                                                                                                                             |
| <kbd>t</kbd>                                            | Hiermit wird die Liste der geänderten Dateien im Pull Request geöffnet.                                                                                                                                                                                                                                                                                                                  |
| <kbd>j</kbd>                                            | Hiermit verschiebt sich die Auswahl in der Liste nach unten                                                                                                                                                                                                                                                                                                                              |
| <kbd>k</kbd>                                            | Hiermit verschiebt sich die Auswahl in der Liste nach oben                                                                                                                                                                                                                                                                                                                               |
| <kbd>Befehlstaste + Umschalttaste + Eingabetaste </kbd> | Hiermit fügst Du einen einzelnen Kommentar zu einer Pull-Request-Diff hinzu                                                                                                                                                                                                                                                                                                              |
| <kbd>Alt</kbd> und klicken                              | Umschalten zwischen Reduzieren und Erweitern aller veralteten Review-Kommentare in einem Pull Request durch das Drücken von `alt` und klicken auf **Show outdated** (zeige veraltete) oder **Hide outdated** (blende veraltete aus).|{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}
| Klicke, dann <kbd>Shift</kbd> und klicke                | Kommentiere mehrere Zeilen eines Pull-Requests, indem Du auf eine Zeilennummer klickst, <kbd>shift</kbd> gedrückt hältst und dann auf eine andere Zeilennummer klickst. Weitere Informationen findest Du unter „[Einen Pull Request kommentieren](/github/collaborating-with-issues-and-pull-requests/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)."|{% endif %}

### Projektboards

#### Spalte verschieben

| Tastenkürzel                                                                                                                  | Beschreibung                                                        |
| ----------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------- |
| <kbd>Eingabetaste</kbd> oder <kbd>Leertaste</kbd>                                                                             | Hiermit wird die fokussierte Spalte verschoben.                     |
| <kbd>Esc</kbd>                                                                                                                | Hiermit wird die ausgeführte Verschiebung abgebrochen.              |
| <kbd>Eingabetaste</kbd>                                                                                                       | Hiermit wird die ausgeführte Verschiebung abgeschlossen.            |
| <kbd>←</kbd> oder <kbd>h</kbd>                                                                                                | Hiermit wird die Spalte nach links verschoben.                      |
| <kbd>Befehlstaste + ←</kbd> oder <kbd>Befehlstaste + h</kbd> oder <kbd>Befehlstaste + ←</kbd> oder <kbd>Steuertaste + h</kbd> | Hiermit wird die Spalte an die äußerste linke Position verschoben.  |
| <kbd>→</kbd> oder <kbd>l</kbd>                                                                                                | Hiermit wird die Spalte nach rechts verschoben.                     |
| <kbd>Befehlstaste + →</kbd> oder <kbd>Befehlstaste + l</kbd> oder <kbd>Befehlstaste + →</kbd> oder <kbd>Steuertaste + l</kbd> | Hiermit wird die Spalte an die äußerste rechte Position verschoben. |

#### Karte verschieben

| Tastenkürzel                                                                                                                                                                                 | Beschreibung                                                                               |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------ |
| <kbd>Eingabetaste</kbd> oder <kbd>Leertaste</kbd>                                                                                                                                            | Hiermit wird die fokussierte Karte verschoben.                                             |
| <kbd>Esc</kbd>                                                                                                                                                                               | Hiermit wird die ausgeführte Verschiebung abgebrochen.                                     |
| <kbd>Eingabetaste</kbd>                                                                                                                                                                      | Hiermit wird die ausgeführte Verschiebung abgeschlossen.                                   |
| <kbd>↓</kbd> oder <kbd>j</kbd>                                                                                                                                                               | Hiermit wird die Karte nach unten verschoben.                                              |
| <kbd>Befehlstaste + ↓</kbd> oder <kbd>Befehlstaste + j</kbd> oder <kbd>Befehlstaste + ↓</kbd> oder <kbd>Steuertaste + j</kbd>                                                                | Hiermit wird die Karte in den unteren Bereich der Spalte verschoben.                       |
| <kbd>↑</kbd> oder <kbd>k</kbd>                                                                                                                                                               | Hiermit wird die Karte nach oben verschoben.                                               |
| <kbd>Befehlstaste + ↑</kbd> oder <kbd>Befehlstaste + k</kbd> oder <kbd>Befehlstaste + ↑</kbd> oder <kbd>Steuertaste  + k</kbd>                                                               | Hiermit wird die Karte in den oberen Bereich der Spalte verschoben.                        |
| <kbd>←</kbd> oder <kbd>h</kbd>                                                                                                                                                               | Hiermit wird die Karte in den unteren Bereich der Spalte auf der linken Seite verschoben.  |
| <kbd>Umschalttaste +  ←</kbd> oder <kbd>Umschalttaste + h</kbd>                                                                                                                              | Hiermit wird die Karte in den oberen Bereich der Spalte auf der linken Seite verschoben.   |
| <kbd>Befehlstaste + ←</kbd> oder <kbd>Befehlstaste + h</kbd> oder <kbd>Befehlstaste + ←</kbd> oder <kbd>Steuertaste + h</kbd>                                                                | Hiermit wird die Karte in den unteren Bereich der Spalte ganz links verschoben.            |
| <kbd>Befehlstaste + Umschalttaste + ←</kbd> oder <kbd>Befehlstaste + Umschalttaste + h</kbd> oder <kbd>Steuertaste + Umschalttaste + ←</kbd> oder <kbd>Steuertaste + Umschalttaste + h</kbd> | Hiermit wird die Karte in den oberen Bereich der Spalte ganz links verschoben.             |
| <kbd>→</kbd>                                                                                                                                                                                 | Hiermit wird die Karte in den unteren Bereich der Spalte auf der rechten Seite verschoben. |
| <kbd>Umschalttaste + →</kbd> oder <kbd>Umschalttaste + l</kbd>                                                                                                                               | Hiermit wird die Karte in den oberen Bereich der Spalte auf der rechten Seite verschoben.  |
| <kbd>Befehlstaste + →</kbd> oder <kbd>Befehlstaste + l</kbd> oder <kbd>Befehlstaste + →</kbd> oder <kbd>Steuertaste + l</kbd>                                                                | Hiermit wird die Karte in den unteren Bereich der Spalte ganz rechts verschoben.           |
| <kbd>Befehlstaste + Umschalttaste + →</kbd> oder <kbd>Befehlstaste + Umschalttaste + l</kbd> oder <kbd>Steuertaste + Umschalttaste + →</kbd> oder <kbd>Steuertaste + Umschalttaste + l</kbd> | Hiermit wird die Karte in den unteren Bereich der Spalte ganz rechts verschoben.           |

#### Previewing a card

| Tastenkürzel   | Beschreibung                |
| -------------- | --------------------------- |
| <kbd>esc</kbd> | Close the card preview pane |

{% if currentVersion == "free-pro-team@latest" %}
### {% data variables.product.prodname_actions %}

| Tastenkürzel                                            | Beschreibung                                                                |
| ------------------------------------------------------- | --------------------------------------------------------------------------- |
| <kbd>command space </kbd> oder <kbd>control space</kbd> | Hiermit erhältst Du im Workflow-Editor Vorschläge für Deine Workflow-Datei. |

{% endif %}

### Benachrichtigungen
{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}
| Tastenkürzel                 | Beschreibung            |
| ---------------------------- | ----------------------- |
| <kbd>e</kbd>                 | Als erledigt markieren  |
| <kbd>Umschalttaste + u</kbd> | Als ungelesen markieren |
| <kbd>Umschalttaste + i</kbd> | Als gelesen markieren   |
| <kbd>Umschalttaste + m</kbd> | Kündigen                |

{% else %}

| Tastenkürzel                                     | Beschreibung                             |
| ------------------------------------------------ | ---------------------------------------- |
| <kbd>e</kbd> oder <kbd>I</kbd> oder <kbd>y</kbd> | Als gelesen markieren                    |
| <kbd>Umschalttaste + m</kbd>                     | Hiermit wird der Thread stummgeschaltet. |
{% endif %}

### Netzwerkdiagramm

| Tastenkürzel                                                    | Beschreibung                                 |
| --------------------------------------------------------------- | -------------------------------------------- |
| <kbd>←</kbd> oder <kbd>h</kbd>                                  | Hiermit wird nach links gescrollt.           |
| <kbd>→</kbd> oder <kbd>l</kbd>                                  | Hiermit wird nach rechts gescrollt.          |
| <kbd>↑</kbd> oder <kbd>k</kbd>                                  | Hiermit wird nach oben gescrollt.            |
| <kbd>↓</kbd> oder <kbd>j</kbd>                                  | Hiermit wird nach unten gescrollt.           |
| <kbd>Umschalttaste +  ←</kbd> oder <kbd>Umschalttaste + h</kbd> | Hiermit wird komplett nach links gescrollt.  |
| <kbd>Umschalttaste + →</kbd> oder <kbd>Umschalttaste + l</kbd>  | Hiermit wird komplett nach rechts gescrollt. |
| <kbd>Umschalttaste+↑</kbd> oder <kbd>Umschalttaste+k</kbd>      | Hiermit wird komplett nach oben gescrollt.   |
| <kbd>Umschalttaste+↓</kbd> oder <kbd>Umschalttaste+j</kbd>      | Hiermit wird komplett nach unten gescrollt.  |
