---
title: GitHub Desktop einrichten
shortTitle: Setup
intro: 'You can set up {% data variables.product.prodname_desktop %} to suit your needs and contribute to projects.'
redirect_from:
  - /desktop/getting-started-with-github-desktop/setting-up-github-desktop
versions:
  free-pro-team: '*'
---

### Part 1: Installing {% data variables.product.prodname_desktop %}

You can install {% data variables.product.prodname_desktop %} on any supported operating system. For more information, see "[Supported Operating Systems](/desktop/getting-started-with-github-desktop/supported-operating-systems)."

To install {% data variables.product.prodname_desktop %}, navigate to [https://desktop.github.com/](https://desktop.github.com/) and download the appropriate version of {% data variables.product.prodname_desktop %} for your operating system. Follow the prompts to complete the installation. Weitere Informationen findest Du unter "[Installieren von {% data variables.product.prodname_desktop %}](/desktop/getting-started-with-github-desktop/installing-github-desktop)."

### Part 2: Configuring your account

If you have an account on {% data variables.product.prodname_dotcom %} or {% data variables.product.prodname_enterprise %}, you can use {% data variables.product.prodname_desktop %} to exchange data between your local and remote repositories.

#### Creating an account
If you do not already have an account on {% data variables.product.prodname_dotcom %}, see "[Signing up for a new {% data variables.product.prodname_dotcom %} account](/articles/signing-up-for-a-new-github-account/)."

If you are part of an organization that uses {% data variables.product.prodname_enterprise %} and you do not have an account, contact your {% data variables.product.prodname_enterprise %} site administrator.

#### Bei {% data variables.product.prodname_dotcom %} authentifizieren
To connect to {% data variables.product.prodname_desktop %} with {% data variables.product.prodname_dotcom %}, you'll need to authenticate your account. Weitere Informationen finden Sie unter „[Bei {% data variables.product.prodname_desktop %} authentifizieren](/desktop/getting-started-with-github-desktop/authenticating-to-github)“.

After authenticating your account, you are ready to manage and contribute to projects with {% data variables.product.prodname_desktop %}.

### Part 3: Configuring Git
You must have Git installed before using {% data variables.product.prodname_desktop %}. If you do not already have Git installed, you can download and install the latest version of Git from [https://git-scm.com/downloads](https://git-scm.com/downloads).

After you have Git installed, you'll need to configure Git for {% data variables.product.prodname_desktop %}. For more information, see "[Configuring Git for {% data variables.product.prodname_desktop %}](/desktop/getting-started-with-github-desktop/configuring-git-for-github-desktop)."

### Part 4: Customizing {% data variables.product.prodname_desktop %}
You can adjust defaults and settings to tailor {% data variables.product.prodname_desktop %} to your needs.

#### Choosing a default text editor
You can open a text editor from {% data variables.product.prodname_desktop %} to manipulate files and repositories. {% data variables.product.prodname_desktop %} supports a variety of text editors and integrated development environments (IDEs) for Windows and macOS. You can choose a default editor in the {% data variables.product.prodname_desktop %} settings. For more information, see "[Configuring a default editor](/desktop/getting-started-with-github-desktop/configuring-a-default-editor)."

#### Choosing a theme
{% data variables.product.prodname_desktop %} has multiple themes available to customize the look and feel of the app. You can choose a theme in the {% data variables.product.prodname_desktop %} settings. For more information, see "[Setting a theme for {% data variables.product.prodname_desktop %}](/desktop/getting-started-with-github-desktop/setting-a-theme-for-github-desktop)."
