# GraphQL

## About this directory

* `lib/graphql/*.json` are human-editable.
* `lib/graphql/static/*.json` are generated by [scripts](../script/graphql/README.md).

## Editable files

* `lib/graphql/validator.json`
  - JSON schema used in `tests/graphql.js`.
* `lib/graphql/non-schema-scalars.json`
  - An array of scalar types that live in [`graphql-ruby`](https://github.com/rmosolgo/graphql-ruby/tree/356d9d369e444423bf06cab3dc767ec75fbc6745/lib/graphql/types) only. These are
  not part of the core GraphQL spec.
* `lib/graphql/redirects.json`
  - A list of original `developer.github.com/v4` paths and their corresponding new `docs.github.com/graphql` paths. Used in redirect middleware and tests.
* `lib/graphql/types.json`
  - High-level GraphQL types and kinds.

## Static files

Generated by `script/graphql/update-files.js`:

* `lib/graphql/static/schema-VERSION.json` (separate files per version)
* `lib/graphql/static/previews.json`
* `lib/graphql/static/upcoming-changes.json`

Generated by `script/graphql/build-changelog-from-markdown.js`:

* `lib/graphql/static/changelog.json`

## Rendering docs

When the server starts, `middleware/graphql.js` accesses the static JSON files, fetches the data for the current version, and adds it to the `context` object. The added properties are:

* `context.graphql.schemaForCurrentVersion`
* `context.graphql.previewsForCurrentVersion`
* `context.graphql.upcomingChangesForCurrentVersion`
* `context.graphql.changelog`

Markdown files in `content/graphql` use Liquid to loop over these context properties. The Liquid calls HTML files in the `includes` directory to do most of the rendering.

Note that Markdown files exist in `content/graphql` for every URL available in our GraphQL
documentation. Writers can add content to the Markdown files alongside the Liquid.
