---
title: Global Privacy Practices
redirect_from:
  - /eu-safe-harbor/
  - /articles/global-privacy-practices
versions:
  free-pro-team: '*'
---

Effective date: July 22, 2020

GitHub provides the same high standard of privacy protection—as described in GitHub’s [Privacy Statement](/github/site-policy/github-privacy-statement#githubs-global-privacy-practices)—to all our users and customers around the world, regardless of their country of origin or location, and GitHub is proud of the level of notice, choice, accountability, security, data integrity, access, and recourse we provide. 

GitHub also complies with certain legal frameworks relating to the transfer of data from the European Economic Area, the United Kingdom, and Switzerland (collectively, “EU”) to the United States. When GitHub engages in such transfers, GitHub relies on Standard Contractual Clauses as the legal mechanism to help ensure your rights and protections travel with your personal information. In addition, GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks. To learn more about the European Commission’s decisions on international data transfer, see this article on the [European Commission website](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection_en).

### Standard Contractual Clauses

GitHub relies on the European Commission-approved Standard Contractual Clauses (“SCCs”) as a legal mechanism for data transfers from the EU. SCCs are contractual commitments between companies transferring personal data, binding them to protect the privacy and security of such data. GitHub adopted SCCs so that the necessary data flows can be protected when transferred outside the EU to countries which have not been deemed by the European Commission to adequately protect personal data, including protecting data transfers to the United States. 

To learn more about SCCs, see this article on the [European Commission website](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection/standard-contractual-clauses-scc_en). 

### Privacy Shield Framework

GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on the EU-US Privacy Shield Framework as a legal basis for transfers of personal information in light of the judgment of the Court of Justice of the EU in Case C-311/18.

The EU-US and Swiss-US Privacy Shield Frameworks are set forth by the US Department of Commerce regarding the collection, use, and retention of User Personal Information transferred from the European Union, the UK, and Switzerland to the United States. GitHub has certified to the Department of Commerce that it adheres to the Privacy Shield Principles. If our vendors or affiliates process User Personal Information on our behalf in a manner inconsistent with the principles of either Privacy Shield Framework, GitHub remains liable unless we prove we are not responsible for the event giving rise to the damage.

For purposes of our certifications under the Privacy Shield Frameworks, if there is any conflict between the terms in these Global Privacy Practices and the Privacy Shield Principles, the Privacy Shield Principles shall govern. To learn more about the Privacy Shield program, and to view our certification, visit the [Privacy Shield website](https://www.privacyshield.gov/).

The Privacy Shield Frameworks are based on seven principles, and GitHub adheres to them in the following ways:

- **Notice**
  - We let you know when we're collecting your personal information.
  - We let you know, in our [Privacy Statement](/articles/github-privacy-statement/), what purposes we have for collecting and using your information, who we share that information with and under what restrictions, and what access you have to your data.
  - We let you know that we're participating in the Privacy Shield framework, and what that means to you.
  - We have a {% data variables.contact.contact_privacy %} where you can contact us with questions about your privacy.
  - We let you know about your right to invoke binding arbitration, provided at no cost to you, in the unlikely event of a dispute.
  - We let you know that we are subject to the jurisdiction of the Federal Trade Commission.
- **Choice**
  - We let you choose what happens to your data. Before we use your data for a purpose other than the one for which you gave it to us, we will let you know and get your permission.
  - We will provide you with reasonable mechanisms to make your choices.
- **Accountability for Onward Transfer**
  - When we transfer your information to third party vendors that are processing it on our behalf, we are only sending your data to third parties, under contract with us, that will safeguard it consistently with our Privacy Statement. When we transfer your data to our vendors under Privacy Shield, we remain responsible for it.
  - We share only the amount of data with our third party vendors as is necessary to complete their transaction.
- **Security**
  - We will protect your personal information with [all reasonable and appropriate security measures](https://github.com/security).
- **Data Integrity and Purpose Limitation**
  - We only collect your data for the purposes relevant for providing our services to you.
  - We collect as little information about you as we can, unless you choose to give us more.
  - We take reasonable steps to ensure that the data we have about you is accurate, current, and reliable for its intended use.
- **Access**
  - You are always able to access the data we have about you in your [user profile](https://github.com/settings/profile). You may access, update, alter, or delete your information there.
- **Recourse, Enforcement and Liability**
  - If you have questions about our privacy practices, you can reach us with our {% data variables.contact.contact_privacy %} and we will respond within 45 days at the latest.
  - In the unlikely event of a dispute that we cannot resolve, you have access to binding arbitration at no cost to you. Please see our [Privacy Statement](/articles/github-privacy-statement/) for more information.
  - We will conduct regular audits of our relevant privacy practices to verify compliance with the promises we have made.
  - We require our employees to respect our privacy promises, and violation of our privacy policies is subject to disciplinary action up to and including termination of employment.


#### Dispute resolution process

As further explained in the [Resolving Complaints](/github/site-policy/github-privacy-statement#resolving-complaints) section of our [Privacy Statement](/github/site-policy/github-privacy-statement), we encourage you to contact us should you have a Privacy Shield-related (or general privacy-related) complaint. For any complaints that cannot be resolved with GitHub directly, we have selected to cooperate with the relevant EU Data Protection Authority, or a panel established by the European data protection authorities, for resolving disputes with EU individuals, and with the Swiss Federal Data Protection and Information Commissioner (FDPIC) for resolving disputes with Swiss individuals. Please contact us if you’d like us to direct you to your data protection authority contacts.

Additionally, if you are a resident of an EU member state, you have the right to file a complaint with your local supervisory authority.

#### Independent arbitration

Under certain limited circumstances, EU, European Economic Area (EEA), Swiss, and UK individuals may invoke binding Privacy Shield arbitration as a last resort if all other forms of dispute resolution have been unsuccessful. To learn more about this method of resolution and its availability to you, please read more about [Privacy Shield](https://www.privacyshield.gov/article?id=ANNEX-I-introduction). Arbitration is not mandatory; it is a tool you can use if you so choose.

We are subject to the jurisdiction of the US Federal Trade Commission (FTC).
  
Please see our [Privacy Statement](/articles/github-privacy-statement/) for more information.
