---
title: GitHub's Notice about the California Consumer Privacy Act
versions:
  free-pro-team: '*'
---

Effective January 1, 2020

### GitHub's Notice to California Residents

The [California Consumer Privacy Act](https://leginfo.legislature.ca.gov/faces/billCompareClient.xhtml?bill_id=201720180AB375) of 2018, (Cal. Civ. Code §1798.100 et seq., as amended, “CCPA”) gives California residents rights and control over their personal information. GitHub, Inc. ("GitHub", "we") provides this statement to those residents ("you") in accordance with requirements under the CCPA to make certain disclosures about the collection and processing of their personal information. This is GitHub’s California-specific description of consumers’ privacy rights under the CCPA. For information about how we’ve extended the CCPA core rights to control personal information to all of our users in the United States, please see our [Privacy Statement](/github/site-policy/github-privacy-statement).

### We do not sell your personal information

Under the CCPA, a business that sells California residents' personal information to others: 1) must give notice to California residents before selling their personal information to others; and 2) must provide the right to opt out of the sale of their personal information.

GitHub _does not_ sell personal information, including personal information of anyone under 16 years old. Thus, these notification and opt-out requirements do not apply to GitHub.

## Your rights under the CCPA

The CCPA provides California residents with certain rights related to their personal information. To submit a request based on these rights, please contact us via our [contact form](https://support.github.com/contact).

When receiving a request, we will verify that the individual making the request is the resident to whom the personal information subject to the request pertains. California residents may exercise their rights themselves or may use an authorized agent to make requests to disclose certain information about the processing of their personal information or to delete personal information on their behalf. If you use an authorized agent to submit a request, we may require that you provide us additional information demonstrating that the agent is acting on your behalf.

With respect to their personal information, California residents may exercise the rights described below.

### 1. Right to know what personal information is being collected, for what purposes and with whom it is shared

California residents have the right to request from a business disclosure of the categories and specific pieces of personal information it has collected from them in the preceding 12 months, the categories of sources from which such personal information is collected, the business or commercial purpose for collecting or selling such personal information, and the categories of third parties with whom the business shares personal information.

If you request that a business disclose categories and specific pieces of personal information collected about you, you have the right to receive that information, free of charge, twice a year. The information may be delivered by mail or electronically and, if provided electronically, shall be in a portable and, to the extent technically feasible, readily usable format that allows the California resident to relatively easily transmit this information to another entity. You can use GitHub’s [User Migration API](/v3/migrations/users/) to access and download your data. Learn more [here](https://github.blog/2018-12-19-download-your-data/).

### 2. Right to know whether your personal information is sold or disclosed for a business purpose and to whom

California residents have the right to request from a business that sells or discloses personal information for a business purpose separate lists of the categories of personal information collected, sold or disclosed for a business purpose in the preceding 12 months, including the categories of third parties to whom the personal information was sold or disclosed for a business purpose.

### 3. Right to say no to the sale of your personal information

As explained above, the CCPA requires businesses that sell personal information to allow residents the ability to opt out of the selling of their information.

Again, GitHub does not sell personal information.

### 4. Right to non-discrimination of service or price if you exercise your privacy rights

The CCPA prohibits businesses from discriminating against a California resident for exercising any of their rights under the CCPA, including by
- denying goods or services
- charging different prices or rates for goods or services, including through the use of discounts or other benefits or by imposing penalties
- providing a different level or quality of goods or services
- suggesting that the person exercising their rights will receive a different price or rate for goods or services or a different level or quality of goods or services

### 5. Right to deletion

California residents have the right to request that a business delete any of their personal information that the business collected from them, subject to the exceptions in CCPA §1798.105.

## Our Handling of Personal Information

While the table below contains information about the categories of personal information we collect process and share, please see the [GitHub Privacy Statement](/github/site-policy/github-privacy-statement) for full details.

| **Category of personal information collected in last 12 months** | **Category of sources from which the personal information has been collected** | **Business or commercial purpose(s) for collecting the personal information** | **Categories of third parties with whom the personal information is shared** | **Categories of personal information disclosed for a business or commercial purpose** |
| --- | --- | --- | --- | --- |
| Identifiers (such as real name, alias, postal address, unique personal identifier, online identifier Internet Protocol address, email address, account name, or other similar identifiers) | Information consumer provides directly or automatically through their interaction with our Service and/or Website | Detecting security incidents, protecting against malicious, deceptive, fraudulent, or illegal activity, and prosecuting those responsible for that activity<br /><br />Debugging to identify and repair errors that impair existing intended functionality<br /><br />Performing services on behalf of the business or service provider<br /><br />Undertaking internal research for technological development and demonstration<br /><br />Undertaking activities to verify or maintain the quality or safety of a service, and to improve, upgrade, or enhance the service | Service providers, applicable customers, law enforcement | This category of personal information has been disclosed for a business or commercial purpose |
| Any categories of personal information described in subdivision (e) of Cal. Civ. Code §1798.80 ( which defines “personal information” as “any information that identifies, relates to, describes, or is capable of being associated with, a particular individual”— with examples including name, address, credit card or debit card number—and excludes publicly available information) | Information consumer provides directly | Prosecuting those responsible for malicious, deceptive, fraudulent, or illegal activity.<br /><br />Performing services on behalf of the business or service provider | Service providers, law enforcement | This category of personal information has been disclosed for a business or commercial purpose |
| Characteristics of protected classifications under California or federal law (such as gender, age) | Information consumer may choose to provide directly | Performing services (user profile) |  Service providers | This category of personal information has been disclosed for a business or commercial purpose |
| Commercial information (such as about products or services purchased, obtained, or considered, or other purchasing or consuming histories or tendencies) | Information consumer provides directly or automatically through their interaction with our Services | Debugging to identify and repair errors that impair existing intended functionality<br /><br />Performing services on behalf of the business or service provider | Service providers | This category of personal information has been disclosed for a business or commercial purpose | | Internet or other electronic network activity information (such as browsing history, search history, and information regarding a consumer’s interaction with an internet website, or application) | Information consumer provides automatically through their interaction with our Services |  Detecting security incidents, protecting against malicious, deceptive, fraudulent, or illegal activity, and prosecuting those responsible for that activity<br /><br />Debugging to identify and repair errors that impair existing intended functionality<br /><br />Performing services on behalf of the business or service provider<br /><br />Undertaking internal research for technological development and demonstration<br /><br />Undertaking activities to verify or maintain the quality or safety of a service, and to improve, upgrade, or enhance the service | Service providers, applicable customers, law enforcement | This category of personal information has been disclosed for a business or commercial purpose |
Geolocation data (such as IP address) | Information consumer provides automatically through their interaction with our Services | Detecting security incidents, protecting against malicious, deceptive, fraudulent, or illegal activity, and prosecuting those responsible for that activity <br /><br /> Debugging to identify and repair errors that impair existing intended functionality<br /><br />Performing services on behalf of the business or service provider<br /><br />Undertaking internal research for technological development and demonstration<br /><br />Undertaking activities to verify or maintain the quality or safety of a service, and to improve, upgrade, or enhance the service | Service providers, applicable customers, law enforcement |  This category of personal information has been disclosed for a business or commercial purpose |
Audio, electronic, visual, or similar information | Information consumer may choose to provide directly | Performing services (user profile) | Service providers | This category of personal information has been disclosed for a business or commercial purpose | Professional or employment-related information | Information consumer may choose to provide directly | Performing services (user profile) | Service providers | This category of personal information has been disclosed for a business or commercial purpose | Education information that is not publicly available personally identifiable | This category of personal information has been disclosed for a business or commercial purpose |
Information as defined in the Family Educational Rights and Privacy Act (20 U.S.C. Sec. 1232g; 34 C.F.R. Part 99) | Information consumer may choose to provide directly | Performing services (user profile) | Service providers | This category of personal information has been disclosed for a business or commercial purpose |
 Inferences drawn from any of the information identified in this table to create a profile about a consumer reflecting the consumer’s preferences | Information consumer provides directly or automatically through their interaction with our Services | Performing services on behalf of the business or service provider | Service providers | This category of personal information has been disclosed for a business or commercial purpose |

## Exemptions under the CCPA

The CCPA provides exemptions, until and including December 31, 2020, from certain of the above described disclosures pertaining to the last 12 months including a **business-to-business exemption**:

  personal information reflecting a written or verbal communication or a transaction between GitHub and a natural person, where the natural person is acting as an employee, owner, director, officer, or contractor of a company, partnership, sole proprietorship, nonprofit, or government agency and whose communications or transaction with GitHub occur solely within the context of GitHub conducting due diligence regarding, or providing or receiving a product or service to or from such company, partnership, sole proprietorship, nonprofit or government agency.

If you have any questions about this page, please contact us via our [contact form](https://support.github.com/contact).
