---
title: GitHub Government Takedown Policy
versions:
  free-pro-team: '*'
---
#### What is this?
From time to time, GitHub receives requests from governments to remove content that has been declared unlawful in their local jurisdiction. Although we may not always agree with those laws, we may need to block content if we receive a complete request from a government official so that our users in that jurisdiction may continue to have access to GitHub to collaborate and build software.

#### What is a complete government takedown request?
To count as a complete request, a request or notice must
- come from a relevant, official government agency
- identify illegal content
- specify the source of illegality in that jurisdiction (law or court order).

#### What happens when we receive a complete takedown request from a government?

When we receive a notice from a relevant, official government agency that identifies illegal content and specifies the source of the illegality, we
- notify the affected users of the specific content that allegedly violates the law, and that this is a legal takedown request
- allow the affected users to appeal the decision as part of that notification
- limit the geographic scope of the takedown when possible and include that as part of the notification
- post the official request that led to the takedown in our public [gov-takedowns repository](https://github.com/github/gov-takedowns).

#### Why do we publicly post takedown notices?
We are concerned about Internet censorship, and believe that transparency on a specific and ongoing level is essential to good governance. By publicly posting the notices, we can better inform the public about what content is being withheld from GitHub, and why. We post takedown notices to document their potential to chill speech.

#### What does it mean if we post a notice in our gov-takedowns repository?
It means that we received the notice on the indicated date. It does *not* mean that the content was unlawful or wrong. It does *not* mean that the user identified in the notice has done anything wrong. We don't make or imply any judgment about the merit of the claims they make. We post these notices and requests only for informational purposes.

#### Transparency reporting
In addition to posting government takedown notices in our gov-takedowns repository, we report on them in our transparency report. We also track and report in our transparency report on government takedowns based on violations of GitHub's Terms of Service. We process those violations as we would process a Terms of Service violation reported by anyone else.
