---
title: GitHub Enterprise Subscription Agreement
redirect_from:
  - /articles/github-enterprise-agreement/
  - /articles/github-enterprise-subscription-agreement
versions:
  free-pro-team: '*'
---

Version Effective Date: July 20, 2020

BY CLICKING THE "I AGREE" OR SIMILAR BUTTON OR BY USING ANY OF THE PRODUCTS (DEFINED BELOW), CUSTOMER ACCEPTS THE TERMS AND CONDITIONS OF THIS AGREEMENT. IF CUSTOMER IS ENTERING INTO THIS AGREEMENT ON BEHALF OF A LEGAL ENTITY, CUSTOMER REPRESENTS THAT IT HAS THE LEGAL AUTHORITY TO BIND THE LEGAL ENTITY TO THIS AGREEMENT.

This Agreement applies to the following GitHub offerings, as further defined below (collectively, the **"Products"**):

-   GitHub Enterprise (comprised of GitHub Enterprise Server, which may include Add-On Software, and GitHub Enterprise Cloud) and GitHub One;

-   Any Beta Previews;

-   Any related Support; and

-   Any related Professional Services.

This Agreement includes the following Sections and Exhibits, each of which is incorporated by reference herein:

* SECTION 1: General Terms and Conditions;

* SECTION 2: GitHub Enterprise Server License Terms;

* SECTION 3: GitHub Enterprise Cloud Terms of Service;

* EXHIBIT A: Definitions.

If Customer has purchased any Products from an authorized GitHub reseller, the following Sections of this Agreement are superseded by the terms Customer has agreed upon with the GitHub reseller: Section 1.1 (Term and Termination); 1.2 (Payment); Section 2.3 (Delivery); and Section 2.4 (Verification).

## SECTION 1: GENERAL TERMS AND CONDITIONS

This Section 1 sets forth the terms and conditions applicable to Customer’s purchase and use of any of the Products. Capitalized terms used but not defined in the body of this Agreement are defined in Exhibit A.

### 1.1 Term and Termination.

#### 1.1.1 Term.

This Agreement starts on the Effective Date and will continue in effect until terminated by a Party in accordance with this Section 1.1.

#### 1.1.2 Termination for Convenience. Account Cancellation.

Either Party may terminate an Order Form or this Agreement, without cause, upon at least thirty (30) days' prior written notice before the end of the then-current Subscription Term. If Customer elects to terminate an Order Form or Agreement, it is Customer's responsibility to properly cancel its account with GitHub by going into Settings in the global navigation bar at the top of the screen. GitHub cannot cancel accounts in response to an email or phone request.

#### 1.1.3 Termination for Material Breach.

Either Party may terminate this Agreement immediately upon notice if the other Party breaches a material obligation under this Agreement and fails to cure the breach within thirty (30) days from the date it receives notification. Each Party also reserves the right to terminate this Agreement immediately upon written notice, without giving the other Party a cure period, as follows: by GitHub, if Customer breaches any of the terms of this Agreement relating to GitHub's intellectual property (including Customer’s non-compliance with the license grant or any license restrictions), or if Customer’s account has been suspended for more than ninety (90) days; or by either Party, if the other breaches its confidentiality obligations in Section 1.4.

#### 1.1.4 Effect of Termination; Survival.

Upon termination of this Agreement, Customer may not execute additional Order Forms; however, this Agreement will remain in effect for the remainder of any active Order Forms. When an Order Form terminates or expires, as to that Order Form: (i) the Subscription Term for the Software and/or Service will immediately end; (ii) any Subscription Licenses in the Order Form will automatically terminate, and Customer will no longer have the right to use the Products; (iii) if any Fees were owed prior to termination, Customer must pay those Fees immediately; (iv) Customer must destroy all copies of the Software in Customer’s possession or control, and certify in writing to GitHub that Customer has done so; and (v) each Party will promptly return (or, if the other party requests it, destroy) all Confidential Information belonging to the other to the extent permitted by the Service. Notwithstanding the foregoing, Customer may continue to access the Software to migrate Customer’s data and may request migration of the data in its repositories for up to ninety (90) days after termination or expiration of this Agreement or an Order Form; however, Customer may not use the Software or Service on a production basis during that time. Any provisions which by their nature should reasonably survive will survive the termination or expiration of this Agreement or an Order Form.

### 1.2 Payment.

#### 1.2.1 Fees.

Customer agrees to pay the Fees in full, up front without deduction or setoff of any kind, in U.S. Dollars. Customer must pay the Fees within thirty (30) days of the GitHub invoice date. Amounts payable under this Agreement are non-refundable, except as provided in Sections 1.5.1 and 1.6.2. If Customer fails to pay any Fees on time, GitHub reserves the right, in addition to taking any other action at law or equity, to (i) charge interest on past due amounts at 1.0% per month or the highest interest rate allowed by law, whichever is less, and to charge all expenses of recovery, and (ii) terminate the applicable Order Form or SOW. Customer is solely responsible for all taxes, fees, duties and governmental assessments (except for taxes based on GitHub's net income) that are imposed or become due in connection with this Agreement.

#### 1.2.2 Purchasing Additional Subscription Licenses.

Customer may obtain additional Subscription Licenses under this Agreement by submitting a request through GitHub’s website or via its sales team. If Customer purchases the additional Subscription Licenses, Customer must pay the then-currently applicable Fees for them, prorated for the balance of the applicable Subscription Term. Upon renewal of Customer’s Subscription Licenses for another Subscription Term, GitHub will invoice all Subscription Licenses at once on an annual basis unless otherwise specified in an Order Form.

#### 1.2.3 Add-On Software.

Add-On Software is licensed on a per User basis. For the avoidance of doubt, and unless otherwise set forth in an Order Form, the number of Subscription Licenses Customer has at any given time for Add-On Software must equal the number of Subscription Licenses Customer has for the Products under this Agreement. For example, if Customer wishes to purchase a subscription to Advanced Security and already holds Subscription Licenses for 100 Users for the Products, it must purchase Subscription Licenses for 100 Users for Advanced Security.

### 1.3 Professional Services.

Upon Customer’s request for Professional Services, GitHub will provide an SOW detailing such Professional Services. GitHub will perform the Professional Services described in each SOW. GitHub will control the manner and means by which the Professional Services are performed and reserves the right to determine personnel assigned. GitHub may use third parties to perform the Professional Services, provided that GitHub remains responsible for their acts and omissions. Customer acknowledges and agrees that GitHub retains all right, title and interest in and to anything used or developed in connection with performing the Professional Services, including software, tools, specifications, ideas, concepts, inventions, processes, techniques, and know-how. To the extent GitHub delivers anything to Customer while performing the Professional Services, GitHub grants to Customer a non-exclusive, non-transferable, worldwide, royalty-free, limited-term license to use those deliverables during the term of this Agreement, solely in conjunction with Customer’s use of the Software or Service.

### 1.4 Confidentiality.

Neither Party will use the other Party's Confidential Information, except as permitted under this Agreement. Each Party agrees to maintain in confidence and protect the other Party's Confidential Information using at least the same degree of care as it uses for its own information of a similar nature, but in any event at least a reasonable degree of care. Each Party agrees to take all reasonable precautions to prevent any unauthorized disclosure of the other Party's Confidential Information, including, without limitation, disclosing such Confidential Information only to its Representatives who (i) have a need to know such information, (ii) are parties to appropriate agreements sufficient to comply with this Section 1.4, and (iii) are informed of the restrictions on use and disclosure set forth in this Section 1.4. Each Party is responsible for all acts and omissions of its Representatives. The foregoing obligations will not restrict either Party from disclosing Confidential Information of the other Party pursuant to the order or requirement of a court, administrative agency, or other governmental body, provided that the Party required to make such a disclosure gives reasonable notice to the other Party to enable such Party to contest such order or requirement, unless such notice is prohibited by law. The restrictions set forth in this Section 1.4 will survive the termination or expiration of this Agreement.

### 1.5 Defense of Claims.

The Parties will defend each other against third-party claims, as and to the extent set forth in this Section 1.5 and will pay the amount of any resulting adverse final judgment or approved settlement, but only if the defending Party is promptly notified in writing of the claim and has the right to control the defense and any settlement of it. The Party being defended must provide the defending Party with all requested assistance, information, and authority. The defending Party will reimburse the other Party for reasonable out-of-pocket expenses it incurs in providing assistance, and will not settle or make any admissions with respect to a third-party claim without the other Party’s prior written consent, not to be unreasonably withheld or delayed. This Section 1.5 describes the Parties’ sole remedies and entire liability for such claims.

#### 1.5.1 GitHub.

GitHub will defend Customer against any claim brought by an unaffiliated third party to the extent it alleges Customer’s authorized use of the Software or Service infringes a copyright, patent, or trademark or misappropriates a trade secret of an unaffiliated third party. If GitHub is unable to resolve any such claim under commercially reasonable terms, it may, at its option, either: (i) modify, repair, or replace the Software or Service (as applicable); or (ii) terminate Customer’s subscription and refund any prepaid, unused subscription fees. GitHub will have no obligation under this Section 1.5.1 for any such claim arising from: (a) the modification of the Software or Service, or the combination, operation, or use of the Software or Service with equipment, devices, software, systems, or data, other than as expressly authorized by this Agreement (including the Documentation); (b) Customer’s failure to stop using the Software or Service after receiving notice to do so; (c) Customer’s obligations under Section 1.5.2; (d) products or services (including use of the Software or Service) that are provided by GitHub free of charge; or (e) access or use of Beta Previews. For purposes of GitHub’s obligation under this Section 1.5.1, the Software and the Service include open source components incorporated by GitHub therein.

#### 1.5.2 Customer.

Customer will defend GitHub against any claim brought by an unaffiliated third party arising from: (i) Customer Content that Customer uploads to the Software or the Service; (ii) Customer's violation of this Agreement, including Customer’s breach of confidentiality or violation of GitHub's acceptable use terms; (iii) Customer Modifications to the Software; or (iv) any third party-branded equipment, devices, software, systems, or data that Customer combines, operates, or uses with the Software or Service.

### 1.6 Representations and Warranties; Disclaimer; Limitations of Liability.

#### 1.6.1 General Warranty.

Each Party represents and warrants to the other that it has the legal power and authority to enter into this Agreement, and that this Agreement and each Order Form and SOW is entered into by an employee or agent of such Party with all necessary authority to bind such Party to the terms and conditions of this Agreement.

#### 1.6.2 Limited Warranties.

**(i) Software.** GitHub warrants that: (1) the unmodified Software, at the time it is made available to Customer for download, will not contain or transmit any malware, viruses, or worms (otherwise known as computer code or other technology specifically designed to disrupt, disable, or harm Customer’s software, hardware, computer system, or network); and (2) for ninety (90) days from the date it is made available for initial download, the unmodified Software will substantially conform to its Documentation. GitHub does not warrant that Customer’s use of the Software will be uninterrupted, or that the operation of the Software will be error-free. The warranty in this Section 1.6.2(i) will not apply if Customer modifies or uses the Software in any way that is not expressly permitted by Section 2 and the Documentation. GitHub's only obligation, and Customer’s only remedy, for any breach of this warranty will be, at GitHub's option and expense, to either (a) repair the Software; (b) replace the Software; or (c) terminate this Agreement with respect to the defective Software, and refund the unused, prepaid Fees for the defective Software during the then-current Subscription Term.

**(ii) Professional Services.** GitHub warrants to Customer that any Professional Services performed under this Agreement will be performed in a professional and workmanlike manner by appropriately qualified personnel. GitHub's only obligation, and Customer’s only remedy, for a breach of this warranty will be, at GitHub's option and expense, to either: (1) promptly re-perform any Professional Services that fail to meet this warranty; or (2) if the breach cannot be cured, terminate the SOW and refund the unused, prepaid Fees.

#### 1.6.3	Disclaimer.

**(i) Generally.** Except as expressly provided in this Agreement, GitHub does not make any other warranties and representation of any kind, and hereby specifically disclaims any other warranties, whether express, implied, or statutory, including but not limited to warranties of merchantability, fitness for a particular purpose, non-infringement, or any warranties or conditions arising out of course of dealing or usage of trade. No advice or information, whether oral or written, provided by GitHub or anywhere else will create any warranty or condition not expressly stated in this Agreement.

**(ii) Service.** GitHub provides the Service **“AS IS”** and **“AS AVAILABLE”** without warranty of any kind. Without limiting this, GitHub expressly disclaims all warranties, whether express, implied or statutory, regarding the Service, including, without limitation, any warranty of merchantability, fitness for a particular purpose, title, security, accuracy and non-infringement. GitHub does not warrant that the Service will meet Customer's requirements; that the Service will be uninterrupted, timely, secure, or error-free; that the information provided through the Service is accurate, reliable or correct; that any defects or errors will be corrected; that the Service will be available at any particular time or location; or that the Service is free of viruses or other harmful components. GitHub will not be responsible for any risk of loss resulting from Customer's downloading and/or use of files, information, Content or other material obtained from the Service.

**(iii) Beta Previews.** Customer may choose to use Beta Previews in its sole discretion. Beta Previews may not be supported and may be changed at any time without notice. Beta Previews may not be as reliable or available as the Service. Beta Previews are not subject to the same security measures and auditing to which the Service has been and is subject. GitHub will have no liability arising out of or in connection with Beta Previews. **Customer uses Beta Previews at its own risk.**

#### 1.6.4 Limitations of Liability.

**(i)	Indirect Damages. To the maximum extent permitted by applicable law, in no event will either party be liable to the other party or to any third party for any indirect, special, incidental, punitive, or consequential damages (including for loss of profits, revenue, or data) or for the cost of obtaining substitute products arising out of or in connection with this Agreement, however caused, whether such liability arises from any claim based upon contract, warranty, tort (including negligence), strict liability or otherwise, and whether or not a party has been advised of the possibility of such damages.**

**(ii) Limitation of Total Liability. To the maximum extent permitted by applicable law, in no event will either party's total cumulative liability under this Agreement from all causes of action and all theories of liability exceed the Fees Customer has actually paid to GitHub during the 12 months preceding the claim giving rise to such liability. For products and services (including use of the Products) that are provided free of charge, GitHub’s liability is limited to direct damages up to $5,000.00 USD. For Beta Previews, GitHub's liability is limited to direct damages up to $500.00 USD.**

**(iii) Exceptions. The exclusions and limitations set forth in this Section 1.6.4 will not apply to liability arising out of (1) a Party’s breach of its confidentiality obligations in Section 1.4 (except for all liability related to Content (excluding GitHub Content), which will remain subject to the limitations and exclusions above); (2) a Party’s defense obligations in Section 1.5; or (3) Customer’s non-compliance with the license grant or license restrictions in Sections 2.1 and 2.2.**

### 1.7 Subscription Licenses.

Subscription Licenses are granted on a per User basis and multiple Users may not use the same Subscription License. Customer may reassign a Subscription License to a new User only after ninety (90) days from the last reassignment of that same Subscription License, unless the reassignment is due to (i) permanent hardware failure or loss, (ii) termination of the User’s employment or contract, or (iii) temporary reallocation of Subscription Licenses to cover a User’s absence. When Customer reassigns a Subscription License from one User to another, Customer must block the former User’s access to the Subscription License and Customer’s Organizations.

### 1.8 Affiliates.

Customer’s Affiliates are authorized to use the Software and Service in accordance with this Agreement, so long as Customer remains fully responsible for their access and use of the Software and Service.

### 1.9 Support.

GitHub will provide Support for the Software and Service as follows:

#### 1.9.1 Standard Support.

GitHub will provide standard technical Support for the Software and Service at no additional charge twenty-four (24) hours per day, five (5) days per week, excluding weekends and national U.S. holidays. Standard Support is only offered via web-based ticketing through GitHub Support, and Support requests must be initiated from a User with which GitHub's Support team can interact.

#### 1.9.2 Enhanced Support Offerings.

GitHub may provide enhanced Support offerings for the Software and Service (including the Premium, Premium Plus, and Engineering Direct Support offerings) in accordance with the [Support terms](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise), and at the Support level, Fees, and Subscription Term specified in an Order Form or SOW.

#### 1.9.3 Exclusions.

GitHub will use reasonable efforts to correct any material, reproducible errors in the Software of which Customer notifies GitHub. However, GitHub will not be responsible for providing Support where (i) someone (other than GitHub) modifies the Software; (ii) Customer changes its operating system or environment in a way that adversely affects the Software or its performance; (iii) Customer uses the Software in a manner other than as authorized under this Agreement or the Documentation; or (iv) there is negligence or misuse by Customer of the Software.

### 1.10 Intellectual Property Rights.

As between the Parties, GitHub owns all right, title and interest, including all intellectual property rights, in and to the Products. GitHub reserves all rights in and to the Products not expressly granted to Customer under this Agreement. GitHub may use, modify, and incorporate into its Products, any Feedback, comments, or suggestions that Customer may provide or post in forums without any obligation to Customer.

### 1.11 Feedback.

Customer may provide Feedback to GitHub regarding the Products. Feedback is voluntary and is not Customer Confidential Information, even if designated as such. GitHub may fully exercise and exploit such Feedback for the purpose of (i) improving the operation, functionality and use of GitHub’s existing and future product offerings and commercializing such offerings; and (ii) publishing aggregated statistics about the quality of the Products, provided that no data in any such publication will be used to specifically identify Customer, its employees or Customer’s proprietary software code.

### 1.12 Compliance with Laws and Regulations.

Customer will comply with all applicable laws and regulations, including, but not limited to, data protection and employment laws and regulations, in its use of the Products.

### 1.13 General Provisions.

#### 1.13.1	Governing Law; Venue.

If Customer’s principal office is in the Americas, this Agreement will be governed by and construed in accordance with the laws of the State of California, without giving effect to the principles of conflict of law, any legal action or proceeding arising under this Agreement will be brought exclusively in the federal or state courts located in the Northern District of California, and the Parties hereby consent to personal jurisdiction and venue therein. If Customer’s principal office is outside the Americas, this Agreement will be governed by the laws of Ireland, any legal action or proceeding arising under this Agreement will be brought exclusively in the courts located in Dublin, and the Parties hereby consent to personal jurisdiction and venue therein. The Parties expressly agree that the United Nations Convention on Contracts for the International Sale of Goods and the Uniform Computer Information Transactions Act will not apply to this Agreement. Notwithstanding anything to the contrary in the foregoing, GitHub may bring a claim for equitable relief in any court with proper jurisdiction.

#### 1.13.2	U.S. Government Users.

The Products were developed solely with private funds and are considered "Commercial Computer Software" and "Commercial Computer Software Documentation" as described in Federal Acquisition Regulations 12.212 and 27.405-3, and Defense Federal Acquisition Regulation Supplement 227.7202-3. The Products are licensed to the U.S. Government end user as restricted computer software and limited rights data. No technical data or computer software is developed under this Agreement. Any use, disclosure, modification, distribution, or reproduction of the Products or Documentation by the U.S. Government or its contractors is subject to the restrictions set forth in this Agreement. All other use is prohibited.

#### 1.13.3 Export.

The Products are subject to export restrictions by the U.S. Government and import restrictions by certain foreign governments, and Customer will comply with all applicable export and import laws and regulations in Customer’s use of the Products. Customer must not, and must not allow any third party to, remove or export from the United States or allow the export or re-export of any part of the Products or any direct product thereof: (i) into (or to a national or resident of) any embargoed or terrorist-supporting country; (ii) to anyone on the U.S. Commerce Department's Table of Denial Orders or U.S. Treasury Department's list of Specially Designated Nationals; (iii) to any country to which such export or re-export is restricted or prohibited, or as to which the U.S. government or any agency thereof requires an export license or other governmental approval at the time of export or re-export without first obtaining such license or approval; or (iv) otherwise in violation of any export or import restrictions, laws or regulations of any United States or foreign agency or authority. Customer represents and warrants that (a) Customer is not located in, under the control of, or a national or resident of any such prohibited country or on any such prohibited party list and (b) none of Customer’s data is controlled under the U.S. International Traffic in Arms Regulations. Customer acknowledges and agrees that the Products are restricted from being used for the design or development of nuclear, chemical, or biological weapons or missile technology without the prior permission of the U.S. Government.

#### 1.13.4	No Publicity without Permission.

GitHub may identify Customer as a customer to current and prospective customers. However, GitHub may not use Customer’s name or logo in any advertising or marketing materials without Customer’s permission.

#### 1.13.5	Assignment.

Neither Party may assign or otherwise transfer this Agreement, in whole or in part, without the other Party's prior written consent, such consent not to be unreasonably withheld, and any attempt to do so will be null and void, except that GitHub may assign this Agreement in its entirety, upon notice to the other party but without the other Party's consent, in connection with a merger, acquisition, corporate reorganization, or sale of all or substantially all of the assigning party's business or assets.

#### 1.13.6	Notices.

Unless otherwise stated herein, any notice, request, demand or other communication under this Agreement must be in writing (e-mail is acceptable), must reference this Agreement, and will be deemed to be properly given: (i) upon receipt, if delivered personally; (ii) one (1) business day following confirmation of receipt by the intended recipient, if by e-mail; (iii) five (5) business days after it is sent by registered or certified mail, with written confirmation of receipt and email; or (iv) three (3) business days after deposit with an internationally recognized express courier and email, with written confirmation of receipt. Notices can be sent to the address(es) set forth in this Agreement, unless a Party notifies the other that those addresses have changed.

#### 1.13.7	Force Majeure.

GitHub will be excused from liability to the extent that it is unable to perform any obligation under this Agreement due to extraordinary causes beyond its reasonable control, including acts of God, natural disasters, strikes, lockouts, riots, acts of war, epidemics, or power, telecommunication or network failures.

#### 1.13.8	Independent Contractors.

Each Party is an independent contractor with respect to the subject matter of this Agreement. Nothing contained in this Agreement will be deemed or construed in any manner to create a legal association, partnership, joint venture, employment, agency, fiduciary, or other similar relationship between the Parties, and neither Party can bind the other contractually.

#### 1.13.9	Waiver.

A Party's obligations under this Agreement may only be waived in writing signed by an authorized representative of the other Party. No failure or delay by a Party to this Agreement in exercising any right hereunder will operate as a waiver thereof, nor will any single or partial exercise thereof preclude any other or further exercise thereof or the exercise of any right hereunder at law or equity.

#### 1.13.10 Entire Agreement.

This Agreement, together with the Exhibits and each Order Form and SOW, constitutes the entire agreement and understanding of the Parties with respect to its subject matter, and supersedes all prior or contemporaneous understandings and agreements, whether oral or written, between the Parties with respect to such subject matter. The terms of any Customer purchase order, written terms or conditions, or other document that Customer submits to GitHub that contains terms that are different from or in addition to the terms of this Agreement, any Order Form or SOW will be void and of no effect.

#### 1.13.11 Amendments; Order of Precedence.

GitHub reserves the right, at its sole discretion, to amend this Agreement at any time and will update this Agreement in the event of any such amendments. GitHub will notify Customer of material changes to this Agreement, such as price changes, at least 30 days prior to the change taking effect by posting a notice on the Service. For non-material modifications, Customer's continued use of the Service constitutes agreement to our revisions of this Agreement. Customer can view all changes to this Agreement in our [Site Policy](https://github.com/github/site-policy) repository. In the event of any conflict between the terms of this Agreement and any Order Form or SOW, the terms of the Order Form or SOW will control with respect to that Order Form or SOW only.

#### 1.13.12 Severability.

If any provision of this Agreement is deemed by a court of competent jurisdiction to be illegal, invalid, or unenforceable, the Parties will modify or reform this Agreement to give as much effect as possible to that provision. Any provision that cannot be modified or reformed in this way will be deemed deleted and the remaining provisions of this Agreement will continue in full force and effect.


## SECTION 2: GITHUB ENTERPRISE SERVER LICENSE TERMS

This Section 2 details terms applicable to Customer’s use of the Software.

### 2.1 License Grant.

GitHub grants to Customer a non-exclusive, non-transferable, worldwide, royalty-free, limited-term license to install and use the Software for Customer’s internal business purposes during the applicable Subscription Term, in accordance with the Documentation, and only for the number of Subscription Licenses stated in Customer’s Order Form. The Software includes components licensed to GitHub by third parties, including software whose licenses require GitHub to make the source code for those components available. The source code for such components will be provided upon request. Without limiting the foregoing, this license permits Customer to download and run Microsoft SQL Server Standard Edition container image for Linux files (“**SQL Server Images**”), which may be used only with the Software as documented. Customer’s right to use the SQL Server Images ends when Customer no longer has rights to use the Software, and Customer must uninstall the SQL Server Images when its right to use them ends. Microsoft Corporation may disable SQL Server Images at any time. 

### 2.2 License Restrictions.

Except as expressly permitted by law or by applicable third-party license, Customer and its Affiliates must not and must not allow any third party to: (i) sublicense, sell, rent, lease, transfer, assign, or redistribute the Software; (ii) host the Software for the benefit of third parties; (iii) disclose or permit any third party to access the Software, except as expressly permitted in this Section 2; (iv) hack or modify the License Key, or avoid or change any license registration process; (v) except for Customer Modifications, modify or create derivative works of the Software, or merge the Software with other software; (vi) disassemble, decompile, bypass any code obfuscation, or otherwise reverse engineer the Software or attempt to derive any of its source code, in whole or in part; (vii) modify, obscure, or delete any proprietary rights notices included in or on the Software or Documentation; or (viii) otherwise use or copy the Software or Documentation in a manner not expressly permitted by this Agreement.

### 2.3 Delivery.

GitHub will make the License Key available for Customer to download on a secure, password-protected website. All deliveries under this Section 2 will be electronic. For the avoidance of doubt, Customer is responsible for installation of any Software and acknowledge that GitHub has no further delivery obligation with respect to the Software after delivery of the License Key. As Updates become available, GitHub will make those available for download on the same website. Customer must Update the Software on a commercially reasonable basis but no less than one (1) time per year. Customer is responsible for maintaining the confidentiality of Customer’s usernames and passwords.

### 2.4 Verification.

At GitHub's request, Customer will promptly provide GitHub with a Software-generated report verifying that Customer is using the Software in accordance with this Agreement. GitHub will invoice Customer for any additional use, effective from the date its use first exceeded the terms of the Agreement.

### 2.5 Updates; Releases.

#### 2.5.1 Generally.

GitHub will make Updates and Releases to the Software available to Customer on the same secure website where Customer downloaded the Software and the License Key.

#### 2.5.2 Supported Releases.

GitHub will only Support a given Release of the Software for one (1) year from the original Release date, or six (6) months from the last Update of the Release, whichever is longer. If Customer requires Support for earlier Releases of the Software, then Customer must pay for that Support in accordance with the terms of a mutually agreed upon Order Form or SOW.

### 2.6 Data Protection Considerations for Use of GitHub Insights and Learning Lab for Enterprise Server.

If Customer’s planned use of GitHub Insights or Learning Lab for Enterprise Server involves processing personal data, Customer is solely responsible for determining whether or not to complete a data protection impact assessment or otherwise secure formal legal analysis of Customer’s planned use. It is in Customer’s sole discretion whether to use GitHub Insights or Learning Lab for Enterprise Server to process Customer’s employees’ and/or users’ data, and if Customer does so, Customer is solely responsible for conducting such processing in compliance with applicable law.


### SECTION 3: GITHUB ENTERPRISE CLOUD TERMS OF SERVICE

Upon creation of a Corporate Account and/or an Organization on the Service by Customer or by GitHub on Customer’s behalf, this Section 3 details terms applicable to Customer’s use of the Service.

### 3.1 Account Terms.

#### 3.1.1 Account Controls.

**(i) Users.** Customer acknowledges that Users retain ultimate administrative control over their individual accounts and the Content within them. [GitHub's Standard Terms of Service](/github/site-policy/github-terms-of-service) govern Users' use of the Service, except with respect to Users' activities under this Section 3.

**(ii) Organizations.** Customer retains ultimate administrative control over any Organization created on Customer’s behalf and User-Generated Content posted to the repositories within its Organization(s), subject to this Section 3. This Section 3 will govern the use of Customer’s Organization(s).

#### 3.1.2 Account Requirements.

In order to create an account, Customer must adhere to the following:

**(i)** Customer must not create an account for use of any person under the age of 13. If GitHub learns of any User under the age of 13, it will terminate that User's account immediately. If Customer or its User(s) are located in a country outside the United States, that country's minimum age may be older; in such a case, Customer is responsible for complying with that country's laws.

**(ii)** A User’s login may not be shared by multiple people.

**(iii)** Customer must not use the Service (a) in violation of export control or sanctions laws of the United States or any other applicable jurisdiction, (b) if it is located in or ordinarily resident in a country or territory subject to comprehensive sanctions administered by the U.S. Office of Foreign Assets Control (OFAC), or (c) if Customer is or is working on behalf of a [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) or a person subject to similar blocking or denied party prohibitions. For more information, please see [GitHub’s Export Controls policy](/articles/github-and-export-controls).

#### 3.1.3 Account Security.

Customer is responsible for: (i) all Content posted and activity that occurs under its Corporate Account; (ii) maintaining the security of its account login credentials; and (iii) promptly [notifying GitHub](https://support.github.com/contact) upon becoming aware of any unauthorized use of, or access to, the Service through its account.  GitHub will not be liable for any loss or damage from Customer’s failure to comply with this Section 3.1.3.

#### 3.1.4 Additional Terms.

In some situations, third parties' terms may apply to Customer’s use of the Service. For example, Customer may be a member of an Organization with its own terms or license agreements; Customer may download an application that integrates with the Service; or Customer may use the Service to authenticate to another service. While this Agreement is GitHub's full agreement with Customer, other parties' terms govern their relationships with Customer.

#### 3.1.5 U.S. Federal Government Terms.

If Customer is a U.S. federal government agency or otherwise accessing or using any portion of the Service in a government capacity, the [U.S. Federal Government Amendment](/articles/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions.

### 3.2 Compliance with Laws; Acceptable Use; Privacy.

#### 3.2.1 Compliance with Laws and Regulations.
Customer’s use of the Service must not violate any applicable laws, including copyright or trademark laws, export control laws, or regulations in its jurisdiction.

#### 3.2.2 Acceptable Use.
Customer’s use of the Service must comply with [GitHub's Acceptable Use Policies](/articles/github-acceptable-use-policies) and [GitHub’s Community Guidelines](/articles/github-community-guidelines). Customer must not use the Service in any jurisdiction for unlawful, obscene, offensive or fraudulent Content or activity, such as advocating or causing harm, interfering with or violating the integrity or security of a network or system, evading filters, sending unsolicited, abusive, or deceptive messages, viruses or harmful code, or violating third party rights.

#### 3.2.3 Privacy.
[The GitHub Privacy Statement](/articles/github-privacy-statement) and the [GitHub Data Protection Addendum](/github/site-policy/github-data-protection-addendum) provide detailed notice of GitHub's privacy and data use practices as well as GitHub's processing and security obligations with respect to Customer Personal Data. Any person, entity, or service collecting data from the Service must comply with the [GitHub Privacy Statement](/articles/github-privacy-statement), particularly in regards to the collection of Users' Personal Information (as defined in the GitHub Privacy Statement). If Customer collects any User Personal Information from GitHub, Customer will only use it for the purpose for which the External User has authorized it. Customer will reasonably secure any such Personal Information, and Customer will respond promptly to complaints, removal requests, and "do not contact" requests from GitHub or External Users.

### 3.3 Content Responsibility; Ownership; License Rights.

#### 3.3.1 Responsibility for User-Generated Content.
Customer may create or upload User-Generated Content while using the Service. Customer is solely responsible for any User-Generated Content that it posts, uploads, links to or otherwise makes available via the Service, regardless of the form of that User-Generated Content. GitHub is not responsible for any public display or misuse of User-Generated Content.

#### 3.3.2 Ownership of Content, Right to Post, and License Grants.

**(i)** Customer retains ownership of Customer Content that Customer creates or owns. Customer acknowledges that it: (a) is responsible for Customer Content, (b) will only submit Customer Content that Customer has the right to post (including third party or User-Generated Content), and (c) Customer will fully comply with any third-party licenses relating to Customer Content that Customer posts.

**(ii)** Customer grants the rights set forth in Sections 3.3.3 through 3.3.6, free of charge and for the purposes identified in those sections until such time as Customer removes Customer Content from GitHub servers, except for Content Customer has posted publicly and that External Users have Forked, in which case the license is perpetual until such time as all Forks of Customer Content have been removed from GitHub servers. If Customer uploads Customer Content that already comes with a license granting GitHub the permissions it needs to run the Service, no additional license is required.

#### 3.3.3 License Grant to GitHub.
Customer grants to GitHub the right to store, parse, and display Customer Content, and make incidental copies only as necessary to provide the Service. This includes the right to copy Customer Content to GitHub's database and make backups; display Customer Content to Customer and those to whom Customer chooses to show it; parse Customer Content into a search index or otherwise analyze it on GitHub's servers; share Customer Content with External Users with whom Customer chooses to share it; and perform Customer Content, in case it is something like music or video. These rights apply to both public and Private Repositories. This license does not grant GitHub the right to sell Customer Content or otherwise distribute or use it outside of the Service. Customer grants to GitHub the rights it needs to use Customer Content without attribution and to make reasonable adaptations of Customer Content as necessary to provide the Service.

#### 3.3.4 License Grant to External Users.
**(i)** Any Content that Customer posts publicly, including issues, comments, and contributions to External Users' repositories, may be viewed by others. By setting its repositories to be viewed publicly, Customer agree to allow External Users to view and Fork Customer’s repositories.

**(ii)** If Customer sets its pages and repositories to be viewed publicly, Customer grants to External Users a nonexclusive, worldwide license to use, display, and perform Customer Content through the Service and to reproduce Customer Content solely on the Service as permitted through functionality provided by GitHub (for example, through Forking). Customer may grant further rights to Customer Content if Customer [adopts a license](/articles/adding-a-license-to-a-repository/#including-an-open-source-license-in-your-repository). If Customer is uploading Customer Content that it did not create or own, Customer is responsible for ensuring that the Customer Content it uploads is licensed under terms that grant these permissions to External Users.

#### 3.3.5 Contributions Under Repository License.
Whenever Customer makes a contribution to a repository containing notice of a license, Customer licenses such contribution under the same terms and agrees that it has the right to license such contribution under those terms. If Customer has a separate agreement to license its contributions under different terms, such as a contributor license agreement, that agreement will supersede.

#### 3.3.6 Moral Rights.
Customer retains all moral rights to Customer Content that it uploads, publishes, or submits to any part of the Service, including the rights of integrity and attribution. However, Customer waives these rights and agrees not to assert them against GitHub, solely to enable GitHub to reasonably exercise the rights granted in Section 3.3, but not otherwise.

### 3.4. Private Repositories.

#### 3.4.1 Control.
Customer is responsible for managing access to its Private Repositories, including invitations, administrative control of Organizations and teams, and termination of access.

#### 3.4.2 Confidentiality.
GitHub considers Customer Content in Customer’s Private Repositories to be Customer’s Confidential Information. GitHub will protect and keep strictly confidential the Customer Content of Private Repositories in accordance with Section 1.4.

#### 3.4.3 Access.
GitHub may only access Customer’s Private Repositories (i) with Customer’s consent and knowledge, for support reasons, or (ii) when access is required for security reasons.  Customer may choose to enable additional access to its Private Repositories. For example, Customer may enable various GitHub services or features that require additional rights to Customer Content in Private Repositories. These rights may vary depending on the service or feature, but GitHub will continue to treat Customer Content in Customer’s Private Repositories as Customer’s Confidential Information. If those services or features require rights in addition to those it needs to provide the Service, GitHub will provide an explanation of those rights.

#### 3.4.4 Exclusions.
If GitHub has reason to believe the Content of a Private Repository is in violation of the law or of this Agreement, GitHub has the right to access, review, and remove that Content. Additionally, GitHub may be compelled by law to disclose the Content of Customer’s Private Repositories. Unless otherwise bound by requirements under law or if in response to a security threat or other risk to security, GitHub will provide notice of such actions.

### 3.5. Intellectual Property Notices.

#### 3.5.1 GitHub's Rights to Content.
The look and feel of the Service is copyright © GitHub, Inc. All rights reserved. Customer may not duplicate, copy, or reuse any portion of the HTML/CSS, Javascript, or visual design elements or concepts without express written permission from GitHub.

#### 3.5.2 Copyright Infringement and DMCA Policy.

If Customer is a copyright owner and believes that Content on the Service violates Customer’s copyright, Customer may contact GitHub in accordance with GitHub's [Digital Millenium Copyright Act Policy](https://github.com/contact/dmca) by notifying GitHub via its [DMCA Form](https://github.com/contact/dmca-notice) or by emailing copyright@github.com.

#### 3.5.3 GitHub Trademarks and Logos.

If Customer would like to use GitHub's trademarks, Customer must follow all of GitHub's trademark guidelines, including those on the [GitHub Logos and Usage page](https://github.com/logos).

### 3.6 Suspension.
GitHub has the right to suspend access to all or any part of the Service, including removing Content, at any time for violation of this Agreement or to protect the integrity, operability, and security of the Service, effective immediately, with notice, unless such notice is prohibited by law or legal process or impedes the prevention of imminent harm to the Service or any third party. GitHub typically provides notice in the form of a banner or email on or before such suspension. GitHub will, in its discretion and using good faith, tailor any suspension as needed to preserve the integrity, operability, and security of the Service.

### 3.7 Service Level Agreement.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 3.8 Service Changes.
GitHub changes the Service via Updates and addition of new features. Subject to Section 3.7, GitHub reserves the right at any time to modify or discontinue, temporarily or permanently, the Service (or any part of it) with or without notice.

### 3.9 Additional Service Features.

Some Service features may be subject to additional terms as set forth in the [GitHub Additional Product Terms](/github/site-policy/github-additional-product-terms). By accessing or using these features, Customer agrees to the GitHub Additional Product Terms.

## EXHIBIT A: DEFINITIONS

**"Active User"** means a User trying to access the Service at the time of an Outage.

**”Add-On Software”** means Advanced Security, Insights, Learning Lab for Enterprise Server, and other additional Software add-on products that GitHub may offer from time to time.

**“Advanced Security”** means the Software feature which enables Customer to identify security vulnerabilities through customizable and automated semantic code analysis.

**"Affiliate"** means any entity that directly or indirectly controls, is controlled by, or is under common control with a party where "control" means having more than fifty percent (50%) ownership or the right to direct the management of the entity.

**“All Users”** means, collectively, Customer’s Users and External Users who use the Service.

**“Americas”** means the United States, Canada, Mexico, or a country in Central or South America or the Caribbean.

**"Beta Previews"** mean software, services, or features identified as alpha, beta, preview, early access, or evaluation, or words or phrases with similar meanings.

**"Confidential Information"** means all non-public information disclosed by either Party to the others, whether in writing, orally or by other means, designated as confidential or that the receiving Party knows or reasonably should know, under the circumstances surrounding the disclosure and the nature of the information, is confidential to the disclosing Party. For the avoidance of doubt, no Content posted on the Service will be considered Confidential Information except for Customer Content stored solely in Customer’s Private Repositories. Confidential Information does not include any information that (i) was or becomes publicly known through no fault of the receiving party; (ii) was rightfully known or becomes rightfully known to the receiving Party without confidential or proprietary restriction from a source other than the disclosing party who has a right to disclose it; (iii) is approved by the disclosing Party for disclosure without restriction in a written document which is signed by a duly authorized officer of such disclosing Party; (iv) the receiving Party independently develops without access to or use of the other Party's Confidential Information; or (v) is or has been stored or posted on the Service and outside of Customer’s Private Repositories.

**“Connect”** or **“GitHub Connect”** means a feature included in the Software that enables Customer to connect the Software with the Service. Use of GitHub Connect is subject to the GitHub Connect terms set forth in the [GitHub Additional Product Terms](/github/site-policy/github-additional-product-terms).

**"Content"** means, without limitation, text, data, articles, images, photographs, graphics, software, applications, designs, features, and other materials that are featured, displayed, or otherwise made available through the Service.

**"Corporate Account"** means an account created by a User on behalf of an entity.

**"Customer"** means, collectively, the company or organization that has entered into this Agreement with GitHub by clicking on the "I AGREE" or similar button or by accessing the Products, its Affiliates and Representatives.

**"Customer Content"** means Content that Customer creates, owns, or to which Customer holds the rights.

**“Customer Modifications”** means Software modifications Customer may make solely for the purpose of developing bug fixes, customizations, or additional features to any libraries licensed under open source licenses that may be included with or linked to by the Software.

**"Documentation"** means any manuals, documentation and other supporting materials relating to the Software or Service that GitHub provides or makes available to Customer.

**"Effective Date"** is the earlier of the date on which Customer (i) agrees to the terms and conditions of this Agreement as described above, or (ii) first places an order for the Products.

**"Essential Services"** means the services essential to GitHub's core version control functionality, including creating, Forking, and cloning repositories; creating, committing, and merging branches; creating, reviewing, and merging pull requests; and, web, API, and Git client interfaces to the core Git workflows. The following are examples of peripheral features and services not included: webhooks, Gists, Pages, and email notifications.

**"External User"** means an individual, not including Customer’s Users, who visit or use the Service.
"Fees" means the fees Customer is required to pay GitHub to (i) use the Products during the applicable Subscription Term or (ii) receive Professional Services, as such fees are reflected on an Order Form or SOW.

**"Feedback"** means any ideas, know-how, algorithms, code contributions, suggestions, enhancement requests, recommendations or any other feedback on GitHub products or services.

**“Fees”** means the fees Customer is required to pay GitHub to (i) use the Products during the applicable Subscription Term or (ii) receive Professional Services, as such fees are reflected on an Order Form or SOW.

**“Fork”** means to copy the Content of one repository into another repository.

**"GitHub"** means, collectively, GitHub, Inc., its Affiliates and Representatives.

**"GitHub Content"** means Content that GitHub creates, owns, or to which it holds the rights.

**"GitHub Insights"** or **“Insights”** means the Software feature which provides Customer with metrics, analytics, and recommendations relating to their use of the Software. GitHub Insights does not include legacy features of GitHub including Organization insights and repository insights.

**“GitHub One”** means the Product bundle which includes GitHub Enterprise, Advanced Security, Insights, Learning Lab for Enterprise Server, and Premium Plus or Engineering Direct Support.

**"Learning Lab for Enterprise Server"** means the Software feature that enables Users to learn about GitHub functionality, including associated Documentation.

**"License Key"** means the data file used by the Software's access control mechanism that allows Customer to install, operate, and use the Software.

**“Machine Account”** means an account registered by an individual human who accepts the applicable terms of service on behalf of the Machine Account, provides a valid email address, and is responsible for its actions. A Machine Account is used exclusively for performing automated tasks. Multiple Users may direct the actions of a Machine Account, but the owner of the account is ultimately responsible for the machine's actions.

**"Order Form"** means written or electronic documentation (including a quote) that the Parties use to order the Products.

**“Organization”** means a shared workspace that may be associated with a single entity or with one or more Users where multiple Users can collaborate across many projects at once. A User can be a member of more than one Organization.

**"Outage"** means the interruption of an Essential Service that affects more than 50% of Active Users.

**“Private Repository”** means a repository which allows a User to control access to Content.

**"Professional Services"** means training, consulting, or implementation services that GitHub provides pursuant to a mutually executed SOW. Professional Services do not include Support.

**“Public Repository”** means a repository whose Content is visible to All Users.

**"Release"** means a Software release that GitHub makes generally available to its customers, along with any corresponding changes to Documentation, that contains enhancements, new features, or new functionality, generally indicated by a change in the digit to the right of the first decimal point (e.g., x.x.x to x.y.x) or to the left of the first decimal point (e.g., x.x.x to y.x.x).

**"Representatives"** means a Party’s employees, agents, independent contractors, consultants, and legal and financial advisors.

**“Scraping”** means extracting data from the Service via an automated process, such as a bot or webcrawler, and does not include the collection of information through GitHub's API.

**"Service"** means the hosted GitHub Enterprise Cloud service. The Service includes:  Organization account(s), SAML single sign-on, access provisioning, and any applicable Documentation. This list of features and services is non-exhaustive and may be updated from time to time.

**"Service Credit"** means a dollar credit, calculated as set forth below, that GitHub may credit back to an eligible account.

**"Software"** means GitHub Enterprise Server on-premises software. Software includes the GitHub Connect feature, any applicable Documentation, any Updates to the Software that GitHub provides to Customer or that it can access under this Agreement, and, if included in Customer’s subscription, Add-On Software.

**"SOW"** means a mutually executed statement of work detailing the Professional Services GitHub will perform, any related Fees, and each Party's related obligations.

**“Subscription License”** means the license assigned to each User to install, operate, access, and use the Products on Customer’s behalf. Customer may only assign one Subscription License per User across its GitHub Enterprise Server instances and GitHub Enterprise Cloud Organizations. Each User will have access to as many of Customer’s Enterprise Server instances or Enterprise Cloud Organizations, as Customer permits. For clarity, however, once Customer assigns a Subscription License to a User, Customer will not be authorized to bifurcate the Subscription License so that one User can use a Subscription License on Enterprise Server while another User uses the same Subscription License on another instance of GitHub Enterprise Server or on an Organization on GitHub Enterprise Cloud.

**“Subscription Term”** means one (1) year from the applicable effective date of an order or as otherwise stated in the Order Form.

**“Support”** means technical support for the Software or Service that GitHub may provide.

**“Update”** means a Software release that GitHub makes generally available to its customers, along with any corresponding changes to Documentation, that contains error corrections or bug fixes, generally indicated by a change in the digit to the right of the second decimal point (e.g., x.x.x to x.x.y).

**“Uptime”** means the percentage of time in a given quarter where GitHub's Essential Services will not be interrupted by an Outage affecting more than 50% of Active Users.

**“User”** means (i) with respect to the Software, a single person or Machine Account that initiates the execution of the Software or interacts with or directs the Software in the performance of its functions; and (ii) with respect to the Service, an individual or Machine Account who (a) accesses or uses the Service, (b) accesses or uses any part of Customer’s account, or (c) directs the use of Customer’s account in the performance of functions, in each case on Customer’s behalf. The number of Users should not exceed the number of Subscription Licenses that Customer has purchased.

**“User-Generated Content”** means Content created or owned by a third party or External User.
