---
title: GitHub Data Protection Addendum
versions:
  free-pro-team: '*'
---

Version Effective Date: September 9, 2020

## INTRODUCTION

The parties agree that the GitHub Data Protection and Security Exhibit (together, the **"Data Protection Addendum"** or **“DPA”**) sets forth their obligations with respect to the processing and security of Customer Personal Data in connection with the GitHub Enterprise Cloud hosted service (the **“Service”**). GitHub makes the commitments in this DPA to all customers using the Service. Separate terms, including different privacy and security terms, govern Customer’s use of non-GitHub products. 

In the event of any conflict or inconsistency between the DPA and any other terms in Customer’s agreements with GitHub, the DPA shall prevail. The provisions of the DPA supersede any conflicting provisions of the GitHub Privacy Statement that otherwise may apply to processing of Customer Personal Data as defined herein. For clarity, consistent with Clause 10 of the Standard Contractual Clauses in Attachment 1, the Standard Contractual Clauses prevail over any other terms in the DPA.


## GITHUB DATA PROTECTION

### 1.  Definitions.

1.1 The "**Applicable Data Protection Laws**" means certain laws, regulations, regulatory frameworks, or other legislations relating to the processing and use of Customer Personal Data, as applicable to Customer's use of GitHub and the GitHub Service, including:

  a.  The EU General Data Protection Regulation 2016/679 (**"GDPR"**), along with any implementing or corresponding equivalent national laws or regulations, once in effect and applicable; and

  b.  The California Consumer Privacy Act of 2018, Cal. Civ. Code §§1798.100 et seq. (**"CCPA"**); and
  
  c.  The UK Data Protection Act 2018 and implementation of GDPR contained therein.

1.2 "**Controller**," "**Data Subject**," "**Member State**," "**Personal Data**," "**Personal Data Breach**," "**Processing**," "**Processor**," and "**Supervisory Authority**" have the meanings given to them in the Applicable Data Protection Laws. In the event of a conflict, the meanings given in the GDPR will supersede.

1.3  "**Customer Personal Data**" means any Personal Data for which Customer is a Controller, whether supplied by Customer for processing by GitHub or generated by GitHub in the course of performing its obligations under the Agreement. It includes data such as billing information, IP addresses, corporate email addresses, and any other Personal Data for which Customer is a Controller.

1.4  "**Customer Repository Data**" means any data or information that is uploaded or created by Customer into any of its Private Repositories.

1.5 A "**Data Breach**" means a Personal Data Breach or any other confirmed or reasonably suspected breach of Customer's Protected Data.

1.6  "**End User**" means an individual Data Subject who controls a GitHub account and has agreed to the GitHub Terms of Service, and whose Personal Data is being transferred, stored, or processed by GitHub. For example, each Customer employee or contractor who has a GitHub account is also a GitHub End User.

1.7  "**Permitted Purposes**" for data processing are those limited and specific purposes of providing the Service as set forth in the Agreement, the GitHub Privacy Statement, and this Exhibit A, or the purposes for which a Data Subject has authorized the use of Customer Personal Data.

1.8  "**Protected Data**" includes any Customer Personal Data and any Customer Repository Data processed by GitHub on behalf of Customer under the Agreement.

1.9  "**Sensitive Data**" means any Customer Personal Data revealing racial or ethnic origin; political opinions, religious or philosophical beliefs or trade union membership; processing of genetic data or biometric data for the purposes of uniquely identifying a natural person; data concerning health, a natural person's sex life or sexual orientation; and data relating to offences, criminal convictions, or security measures.

### 2. Status and Compliance.

#### 2.1 Data Processing. 
GitHub acts as a Processor in regard to any Customer Personal Data it receives in connection with the Agreement, and GitHub will process Customer Personal Data only for Permitted Purposes in accordance with Customer's instructions as represented by the Agreement and other written communications. In the event that GitHub is unable to comply with Customer's instructions, such as due to conflicts with the Applicable Data Protection Laws, or where processing is required by the Applicable Data Protection Laws or other legal requirements, GitHub will notify Customer to the extent permissible. GitHub processes all Customer Personal Data in the United States or in the European Union; however, GitHub's subprocessors may process data outside of the United States or the European Union. Additionally, GitHub acts as a Processor for any Customer Repository Data.

#### 2.2 Data Controllers. 
GitHub receives Customer Personal Data both from Customer and directly from Data Subjects who create End User accounts. Customer is a Controller only for the Customer Personal Data it transfers directly to GitHub.

#### 2.3 GitHub Compliance; Data Transfers.
GitHub will comply with Applicable Data Protection Laws in relation to the processing of Customer Personal Data.

All transfers of Customer Personal Data out of the European Union, European Economic Area, United Kingdom, and Switzerland to provide the Service shall be governed by the Standard Contractual Clauses in Attachment 1 (Standard Contractual Clauses).
GitHub will abide by the requirements of European Economic Area and Swiss data protection law regarding the collection, use, transfer, retention, and other processing of Customer Personal Data from the European Economic Area, United Kingdom, and Switzerland. All transfers of Customer Personal Data to a third country or an international organization will be subject to appropriate safeguards as described in Article 46 of the GDPR and such transfers and safeguards will be documented according to Article 30(2) of the GDPR.

In addition, GitHub is certified to the EU-U.S. and Swiss-U.S. Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on them as a legal basis for transfers of Personal Data.  GitHub agrees to notify Customer if it makes a determination that it can no longer meet its obligation to provide the same level of protection as is required by the Privacy Shield principles.


### 3. Data Protection.

#### 3.1 Purpose Limitation.
GitHub will process and communicate the Protected Data only for Permitted Purposes, unless the Parties agree in writing to an expanded purpose.

#### 3.2 Data Quality and Proportionality.
GitHub will keep the Customer Personal Data accurate and up to date, or enable Customer to do so. GitHub will take commercially reasonable steps to ensure that any Protected Data it collects on Customer's behalf is adequate, relevant, and not excessive in relation to the purposes for which it is transferred and processed. In no event will GitHub intentionally collect Sensitive Data on Customer's behalf. Customer agrees that the GitHub Service is not intended for the storage of Sensitive Data; if Customer chooses to upload Sensitive Data to the Service, Customer must comply with Article 9 of the GDPR, or equivalent provisions in the Applicable Data Protection Laws.

#### 3.3 Data Retention and Deletion.
Upon Customer's reasonable request, unless prohibited by law, GitHub will return, destroy, or deidentify all Customer Personal Data and related data at all locations where it is stored after it is no longer needed for the Permitted Purposes within thirty days of request. GitHub may retain Customer Personal Data and related data to the extent required by the Applicable Data Protection Laws, and only to the extent and for such period as required by the Applicable Data Protection Laws, provided that GitHub will ensure that Customer Personal Data is processed only as necessary for the purpose specified in the Applicable Data Protection Laws and no other purpose, and Customer Personal Data remains protected by the Applicable Data Protection Laws.

#### 3.4 Data Processing.
GitHub provides the following information, required by Article 28(3) of the GDPR, regarding its processing of Customer's Protected Data:

a.  *The subject matter and duration of the processing* of Customer Personal Data are set out in the Agreement and this Addendum.

b.  *The nature and purpose of the processing* of Customer Personal Data is described in Section 3.1 of this Addendum.

c.  *The types of Customer Personal Data to be processed* are described in the GitHub Privacy Statement, and include Customer Personal Data such as user names, passwords, email addresses, and IP addresses. GitHub also processes information necessary for billing Customer's account, but does not process or store credit card information. Customer may choose to supply GitHub with additional Customer Personal Data, such as in Customer's profile settings or by uploading Customer Personal Data to its GitHub repositories.

d.  *The categories of Data Subject to whom the Customer Personal Data relates* are the Customer itself and its End Users.

e.  *The obligations and rights of Customer* are set out in the Agreement and this Addendum.

### 4. Security and Audit Obligations.

#### 4.1 Technical and Organizational Security Measures.
Taking into account the state of the art, the costs of implementation, and the nature, scope, context and purposes of processing as well as the risk of varying likelihood and severity for the rights and freedoms of natural persons, GitHub will implement appropriate technical and organizational measures to ensure a level of security appropriate to the risks, such as against accidental or unlawful destruction, or loss, alteration, unauthorized disclosure or access, presented by processing the Protected Data. GitHub will regularly monitor compliance with these measures and will continue to take appropriate safeguards throughout the duration of the Agreement. Please see Section 1.1 of the GitHub Security Exhibit regarding GitHub's responsibilities in relation to security safeguards.

#### 4.2 Incident Response and Breach Notification.
GitHub will comply with the Information Security obligations in the GitHub Security Exhibit and the Applicable Data Protection Laws, including Data Breach notification obligations. Please see Section 1.2 of the GitHub Security Exhibit regarding GitHub's responsibilities in relation to Data Breach response and notification.

#### 4.3 GitHub Personnel.
GitHub represents and warrants that it will take reasonable steps to ensure that all GitHub personnel processing Protected Data have agreed to keep the Protected Data confidential and have received adequate training on compliance with this Addendum and the Applicable Data Protection Laws.

#### 4.4 Records.
GitHub will maintain complete, accurate, and up to date written records of all categories of processing activities carried out on behalf of Customer containing the information required under the Applicable Data Protection Laws. To the extent that assistance does not risk the security of GitHub or the privacy rights of individual Data Subjects, GitHub will make these records available to Customer on request as reasonably required, such as to help Customer demonstrate its compliance under the Applicable Data Protection Laws. To learn more about GitHub's requirements to provide assistance in the event of a security incident, please see Section 1.2 of the GitHub Security Exhibit.

#### 4.5 Compliance Reporting.
GitHub will provide security compliance reporting in accordance with Section 2.3 of the GitHub Security Exhibit and privacy compliance reporting in accordance with Section 2.3 of the GitHub Security Exhibit. Customer agrees that any information and audit rights granted by the Applicable Data Protection Laws (including, where applicable, Article 28(3)(h) of the GDPR) will be satisfied by these compliance reports, and will only arise to the extent that GitHub's provision of a compliance report does not provide sufficient information, or to the extent that Customer must respond to a regulatory or Supervisory Authority audit. Section 3.1 of the GitHub Security Exhibit describes the Parties' responsibilities in relation to a regulatory or Supervisory Authority audit.

#### 4.6 Assistance.
GitHub will provide reasonable assistance to Customer with concerns such as data privacy impact assessments, Data Subject rights requests, consultations with Supervisory Authorities, and other similar matters, in each case solely in relation to the processing of Customer Personal Data and taking into account the nature of processing.

### 5. Use and Disclosure of Protected Data.

#### 5.1 No Use in Marketing.
GitHub will not use the Protected Data for the purposes of advertising third-party content, and will not sell the Protected Data to any third party except as part of a merger or acquisition.

#### 5.2 GitHub Privacy Statement.
The GitHub Privacy Statement, publicly available at [https://docs.github.com/articles/github-privacy-statement](/articles/github-privacy-statement), provides detailed notice of GitHub's privacy and data use practices, including its use of cookies, its dispute resolution process, and further details about GitHub's GDPR compliance.

### 6. Subprocessing and Onward Transfer.

#### 6.1 Protection of Data.
GitHub is liable for onward transfers of Protected Data to its subprocessors, such as its third-party payment processor. In the event that GitHub does transfer the Protected Data to a third-party subprocessor, or GitHub installs, uses, or enables a third party or third-party services to process the Protected Data on GitHub's behalf, GitHub will ensure that the third-party subprocessor is bound by written agreement that requires them to provide at least the same level of confidentiality, security, and privacy protection as is required of GitHub by this DPA and the Applicable Data Protection Laws.

#### 6.2 Acceptance of GitHub Subprocessors.
Customer authorizes GitHub to appoint (and permit each subprocessor appointed in accordance with this Section 6 to appoint) subprocessors in accordance with Section 6 and any other restrictions in the Agreement. GitHub may continue to use those subprocessors currently engaged as of the Effective Date of this Addendum.

#### 6.3 General Consent for Onward Subprocessing.
Customer provides a general consent for GitHub to engage onward subprocessors, conditional on GitHub's compliance with the following requirements:

a.  Any onward subprocessor must agree in writing to only process data in a country that the European Commission has declared to have an "adequate" level of protection; or to only process data on terms equivalent to the Standard Contractual Clauses, or pursuant to a Binding Corporate Rules approval granted by competent European data protection authorities, or pursuant to compliant and valid EU-US Privacy Shield and Swiss-U.S. Privacy Shield certifications; and

b.  GitHub will restrict the onward subprocessor's access to Customer Personal Data only to what is strictly necessary to perform its services, and GitHub will prohibit the subprocessor from processing the Customer Personal Data for any other purpose.

#### 6.4 Disclosure of Subprocessor Agreements.
GitHub maintains a list of onward subprocessors it has engaged to process Customer Personal Data at [https://docs.github.com/articles/github-subprocessors-and-cookies](/articles/github-subprocessors-and-cookies), including the categories of Customer Personal Data processed, a description of the type of processing the subprocessor performs, and the location of its processing. GitHub will, upon Customer's written request, provide Customer with this list of subprocessors and the terms under which they process the Customer Personal Data. Pursuant to subprocessor confidentiality restrictions, GitHub may remove any confidential or commercially sensitive information before providing the list and the terms to Customer. In the event that GitHub cannot disclose confidential or sensitive information to Customer, the Parties agree that GitHub will provide all information it reasonably can in connection with its subprocessing agreements.

#### 6.5 Objection to Subprocessors.
GitHub will provide thirty (30) days' prior written notice of the addition or removal of any subprocessor, including the categories listed in Section 6.4, by announcing changes on its <https://github.com/github/site-policy> site. If Customer has a reasonable objection to GitHub's engagement of a new subprocessor, Customer must notify GitHub promptly in writing. Where possible, GitHub will use commercially reasonable efforts to provide an alternative solution to the affected Service to avoid processing of data by the objectionable subprocessor. In the event that GitHub is unable to provide an alternative solution and the Parties cannot resolve the conflict within ninety days, Customer may terminate the Agreement.

### 7. Termination.

#### 7.1 Suspension.
In the event that GitHub is in breach of its obligations to maintain an adequate level of security or privacy protection, Customer may temporarily suspend the transfer of all Customer Personal Data or prohibit collection and processing of Customer Personal Data on Customer's behalf until the breach is repaired or the Agreement is terminated.

#### 7.2 Termination with Cause.
In addition to any termination rights Customer has under the Agreement, Customer may terminate the Agreement without prejudice to any other claims at law or in equity in the event that:

a.  GitHub notifies Customer that it can no longer meet its privacy obligations;

b.  the transfer, collection, or processing of all Customer Personal Data has been temporarily suspended for longer than one month pursuant to Section 7.1;

c.  GitHub is in substantial or persistent breach of any warranties or representations under this Addendum;

d.  GitHub is no longer carrying on business, is dissolved, enters receivership, or a winding up order is made on behalf of GitHub; or

e.  Customer objects to a subprocessor pursuant to Section 6.5, and GitHub has not been able to provide an alternative solution within ninety days.

#### 7.3 Breach. 
Failure to comply with the material provisions of this Addendum is considered a material breach under the Agreement.

#### 7.4 Failure to perform.
In the event that changes in law or regulation render performance of this Addendum impossible or commercially unreasonable, the Parties may renegotiate the Addendum in good faith. If renegotiation would not cure the impossibility, or if the Parties cannot reach an agreement, the Parties may terminate the Agreement after thirty days.

#### 7.5 Notification.
In the event that GitHub determines that it can no longer meet its privacy obligations under this Addendum, GitHub will notify Customer in writing immediately.

#### 7.6 Modifications.
GitHub may modify this Addendum from time to time as required by the Applicable Data Protection Laws, with thirty days' notice to Customer.

#### 7.7 Termination Requirements.
Upon Termination, GitHub must:

a.  take reasonable and appropriate steps to stop processing the Customer Personal Data;

b.  within ninety days of termination, delete or deidentify any Customer Personal Data GitHub stores on Customer's behalf pursuant to Section 3.3; and

c.  provide Customer with reasonable assurance that GitHub has complied with its obligations in Section 7.7.

### 8. Liability for Data Processing.

#### 8.1 Limitations.
Except as limited by the Applicable Data Protection Laws, any claims brought under this Addendum will be subject to the terms of the Agreement regarding Limitations of Liability.

## Attachment 1 – The Standard Contractual Clauses (Processors)
Execution of the applicable agreement by Customer includes execution of this Attachment 1 to the GitHub Data Protection Addendum, which is countersigned by GitHub, Inc. 

In countries where regulatory approval is required for use of the Standard Contractual Clauses, the Standard Contractual Clauses cannot be relied upon under European Commission 2010/87/EU (of February 2010) to legitimize export of data from the country, unless Customer has the required regulatory approval.

For the purposes of Article 46(2) of the General Data Protection Regulation (EU 2016/679) for the transfer of personal data to processors established in third countries which do not ensure an adequate level of data protection, Customer (as data exporter) and GitHub (as data importer, whose signature appears below), each a “party,” together “the parties,” have agreed on the following Contractual Clauses (the “Clauses” or “Standard Contractual Clauses”) in order to adduce adequate safeguards with respect to the protection of privacy and fundamental rights and freedoms of individuals for the transfer by the data exporter to the data importer of the personal data specified in Appendix 1.

#### Clause 1: Definitions
(a) 'personal data', 'special categories of data', 'process/processing', 'controller', 'processor', 'data subject' and 'supervisory authority' shall have the same meaning as in the General Data Protection Regulation (EU 2016/679) on the protection of individuals with regard to the processing of personal data and on the free movement of such data; 

(b) 'the data exporter' means the controller who transfers the personal data; 

(c) 'the data importer' means the processor who agrees to receive from the data exporter personal data intended for processing on his behalf after the transfer in accordance with his instructions and the terms of the Clauses and who is not subject to a third country's system ensuring adequate protection within the meaning of Article 45(2) of the General Data Protection Regulation (EU 2016/679); 

(d) 'the subprocessor' means any processor engaged by the data importer or by any other subprocessor of the data importer who agrees to receive from the data importer or from any other subprocessor of the data importer personal data exclusively intended for processing activities to be carried out on behalf of the data exporter after the transfer in accordance with his instructions, the terms of the Clauses and the terms of the written subcontract; 

(e) 'the applicable data protection law' means the legislation protecting the fundamental rights and freedoms of individuals and, in particular, their right to privacy with respect to the processing of personal data applicable to a data controller in the Member State in which the data exporter is established; 

(f) 'technical and organisational security measures' means those measures aimed at protecting personal data against accidental or unlawful destruction or accidental loss, alteration, unauthorised disclosure or access, in particular where the processing involves the transmission of data over a network, and against all other unlawful forms of processing. 

#### Clause 2: Details of the transfer
The details of the transfer and in particular the special categories of personal data where applicable are specified in Appendix 1 below which forms an integral part of the Clauses.

#### Clause 3: Third-party beneficiary clause
1. The data subject can enforce against the data exporter this Clause, Clause 4(b) to (i), Clause 5(a) to (e), and (g) to (j), Clause 6(1) and (2), Clause 7, Clause 8(2), and Clauses 9 to 12 as third-party beneficiary. 

2. The data subject can enforce against the data importer this Clause, Clause 5(a) to (e) and (g), Clause 6, Clause 7, Clause 8(2), and Clauses 9 to 12, in cases where the data exporter has factually disappeared or has ceased to exist in law unless any successor entity has assumed the entire legal obligations of the data exporter by contract or by operation of law, as a result of which it takes on the rights and obligations of the data exporter, in which case the data subject can enforce them against such entity. 

3. The data subject can enforce against the subprocessor this Clause, Clause 5(a) to (e) and (g), Clause 6, Clause 7, Clause 8(2), and Clauses 9 to 12, in cases where both the data exporter and the data importer have factually disappeared or ceased to exist in law or have become insolvent, unless any successor entity has assumed the entire legal obligations of the data exporter by contract or by operation of law as a result of which it takes on the rights and obligations of the data exporter, in which case the data subject can enforce them against such entity. Such third-party liability of the subprocessor shall be limited to its own processing operations under the Clauses. 

4. The parties do not object to a data subject being represented by an association or other body if the data subject so expressly wishes and if permitted by national law. 

#### Clause 4: Obligations of the data exporter
The data exporter agrees and warrants: 

(a) that the processing, including the transfer itself, of the personal data has been and will continue to be carried out in accordance with the relevant provisions of the applicable data protection law (and, where applicable, has been notified to the relevant authorities of the Member State where the data exporter is established) and does not violate the relevant provisions of that State; 

(b) that it has instructed and throughout the duration of the personal data processing services will instruct the data importer to process the personal data transferred only on the data exporter's behalf and in accordance with the applicable data protection law and the Clauses; 

(c) that the data importer will provide sufficient guarantees in respect of the technical and organisational security measures specified in Appendix 2 below; 

(d) that after assessment of the requirements of the applicable data protection law, the security measures are appropriate to protect personal data against accidental or unlawful destruction or accidental loss, alteration, unauthorised disclosure or access, in particular where the processing involves the transmission of data over a network, and against all other unlawful forms of processing, and that these measures ensure a level of security appropriate to the risks presented by the processing and the nature of the data to be protected having regard to the state of the art and the cost of their implementation; 

(e) that it will ensure compliance with the security measures; 

(f) that, if the transfer involves special categories of data, the data subject has been informed or will be informed before, or as soon as possible after, the transfer that its data could be transmitted to a third country not providing adequate protection within the meaning of the General Data Protection Regulation (EU 2016/679); 

(g) to forward any notification received from the data importer or any subprocessor pursuant to Clause 5(b) and Clause 8(3) to the data protection supervisory authority if the data exporter decides to continue the transfer or to lift the suspension; 

(h) to make available to the data subjects upon request a copy of the Clauses, with the exception of Appendix 2, and a summary description of the security measures, as well as a copy of any contract for subprocessing services which has to be made in accordance with the Clauses, unless the Clauses or the contract contain commercial information, in which case it may remove such commercial information; 

(i) that, in the event of subprocessing, the processing activity is carried out in accordance with Clause 11 by a subprocessor providing at least the same level of protection for the personal data and the rights of data subject as the data importer under the Clauses; and 

(j) that it will ensure compliance with Clause 4(a) to (i).

#### Clause 5: Obligations of the data importer
The data importer agrees and warrants: 

(a) to process the personal data only on behalf of the data exporter and in compliance with its instructions and the Clauses; if it cannot provide such compliance for whatever reasons, it agrees to inform promptly the data exporter of its inability to comply, in which case the data exporter is entitled to suspend the transfer of data and/or terminate the contract; 

(b) that it has no reason to believe that the legislation applicable to it prevents it from fulfilling the instructions received from the data exporter and its obligations under the contract and that in the event of a change in this legislation which is likely to have a substantial adverse effect on the warranties and obligations provided by the Clauses, it will promptly notify the change to the data exporter as soon as it is aware, in which case the data exporter is entitled to suspend the transfer of data and/or terminate the contract; 

(c) that it has implemented the technical and organisational security measures specified in Appendix 2 before processing the personal data transferred; 

(d) that it will promptly notify the data exporter about: 

(i) any legally binding request for disclosure of the personal data by a law enforcement authority unless otherwise prohibited, such as a prohibition under criminal law to preserve the confidentiality of a law enforcement investigation, 

(ii) any accidental or unauthorised access, and 

(iii) any request received directly from the data subjects without responding to that request, unless it has been otherwise authorised to do so; 

(e) to deal promptly and properly with all inquiries from the data exporter relating to its processing of the personal data subject to the transfer and to abide by the advice of the supervisory authority with regard to the processing of the data transferred; 

(f) at the request of the data exporter to submit its data processing facilities for audit of the processing activities covered by the Clauses which shall be carried out by the data exporter or an inspection body composed of independent members and in possession of the required professional qualifications bound by a duty of confidentiality, selected by the data exporter, where applicable, in agreement with the supervisory authority; 

(g) to make available to the data subject upon request a copy of the Clauses, or any existing contract for subprocessing, unless the Clauses or contract contain commercial information, in which case it may remove such commercial information, with the exception of Appendix 2 which shall be replaced by a summary description of the security measures in those cases where the data subject is unable to obtain a copy from the data exporter; 

(h) that, in the event of subprocessing, it has previously informed the data exporter and obtained its prior written consent; 

(i) that the processing services by the subprocessor will be carried out in accordance with Clause 11; and

(j) to send promptly a copy of any subprocessor agreement it concludes under the Clauses to the data exporter.

#### Clause 6: Liability
1. The parties agree that any data subject who has suffered damage as a result of any breach of the obligations referred to in Clause 3 or in Clause 11 by any party or subprocessor is entitled to receive compensation from the data exporter for the damage suffered. 

2. If a data subject is not able to bring a claim for compensation in accordance with paragraph 1 against the data exporter, arising out of a breach by the data importer or his subprocessor of any of their obligations referred to in Clause 3 or in Clause 11, because the data exporter has factually disappeared or ceased to exist in law or has become insolvent, the data importer agrees that the data subject may issue a claim against the data importer as if it were the data exporter, unless any successor entity has assumed the entire legal obligations of the data exporter by contract of by operation of law, in which case the data subject can enforce its rights against such entity. 
The data importer may not rely on a breach by a subprocessor of its obligations in order to avoid its own liabilities. 

3. If a data subject is not able to bring a claim against the data exporter or the data importer referred to in paragraphs 1 and 2, arising out of a breach by the subprocessor of any of their obligations referred to in Clause 3 or in Clause 11 because both the data exporter and the data importer have factually disappeared or ceased to exist in law or have become insolvent, the subprocessor agrees that the data subject may issue a claim against the data subprocessor with regard to its own processing operations under the Clauses as if it were the data exporter or the data importer, unless any successor entity has assumed the entire legal obligations of the data exporter or data importer by contract or by operation of law, in which case the data subject can enforce its rights against such entity. The liability of the subprocessor shall be limited to its own processing operations under the Clauses. 

#### Clause 7: Mediation and jurisdiction
1. The data importer agrees that if the data subject invokes against it third-party beneficiary rights and/or claims compensation for damages under the Clauses, the data importer will accept the decision of the data subject: 

(a) to refer the dispute to mediation, by an independent person or, where applicable, by the supervisory authority; 

(b) to refer the dispute to the courts in the Member State in which the data exporter is established. 

2. The parties agree that the choice made by the data subject will not prejudice its substantive or procedural rights to seek remedies in accordance with other provisions of national or international law. 

#### Clause 8: Cooperation with supervisory authorities
1. The data exporter agrees to deposit a copy of this contract with the supervisory authority if it so requests or if such deposit is required under the applicable data protection law. 

2. The parties agree that the supervisory authority has the right to conduct an audit of the data importer, and of any subprocessor, which has the same scope and is subject to the same conditions as would apply to an audit of the data exporter under the applicable data protection law. 

3. The data importer shall promptly inform the data exporter about the existence of legislation applicable to it or any subprocessor preventing the conduct of an audit of the data importer, or any subprocessor, pursuant to paragraph 2. In such a case the data exporter shall be entitled to take the measures foreseen in Clause 5(b). 

#### Clause 9: Governing Law.
The Clauses shall be governed by the law of the Member State in which the data exporter is established. 

#### Clause 10: Variation of the contract
The parties undertake not to vary or modify the Clauses. This does not preclude the parties from adding clauses on business related issues where required as long as they do not contradict the Clause. 

#### Clause 11: Subprocessing
1. The data importer shall not subcontract any of its processing operations performed on behalf of the data exporter under the Clauses without the prior written consent of the data exporter. Where the data importer subcontracts its obligations under the Clauses, with the consent of the data exporter, it shall do so only by way of a written agreement with the subprocessor which imposes the same obligations on the subprocessor as are imposed on the data importer under the Clauses. Where the subprocessor fails to fulfil its data protection obligations under such written agreement the data importer shall remain fully liable to the data exporter for the performance of the subprocessor's obligations under such agreement. 

2. The prior written contract between the data importer and the subprocessor shall also provide for a third-party beneficiary clause as laid down in Clause 3 for cases where the data subject is not able to bring the claim for compensation referred to in paragraph 1 of Clause 6 against the data exporter or the data importer because they have factually disappeared or have ceased to exist in law or have become insolvent and no successor entity has assumed the entire legal obligations of the data exporter or data importer by contract or by operation of law. Such third-party liability of the subprocessor shall be limited to its own processing operations under the Clauses. 

3. The provisions relating to data protection aspects for subprocessing of the contract referred to in paragraph 1 shall be governed by the law of the Member State in which the data exporter is established. 

4. The data exporter shall keep a list of subprocessing agreements concluded under the Clauses and notified by the data importer pursuant to Clause 5 (j), which shall be updated at least once a year. The list shall be available to the data exporter's data protection supervisory authority. 

#### Clause 12: Obligation after the termination of personal data processing services
1. The parties agree that on the termination of the provision of data processing services, the data importer and the subprocessor shall, at the choice of the data exporter, return all the personal data transferred and the copies thereof to the data exporter or shall destroy all the personal data and certify to the data exporter that it has done so, unless legislation imposed upon the data importer prevents it from returning or destroying all or part of the personal data transferred. In that case, the data importer warrants that it will guarantee the confidentiality of the personal data transferred and will not actively process the personal data transferred anymore. 

2. The data importer and the subprocessor warrant that upon request of the data exporter and/or of the supervisory authority, it will submit its data processing facilities for an audit of the measures referred to in paragraph 1.

### Appendix 1 to the Standard Contractual Clauses
Data exporter: Customer is the data exporter. 

**Data importer:** The data importer is GitHub, Inc., a global producer of software and services. 

**Data subjects:** Data subjects include the data exporter’s representatives and end-users including employees, contractors, collaborators, and customers of the data exporter. Data subjects may also include individuals attempting to communicate or transfer personal information to users of the services provided by data importer. GitHub acknowledges that, depending on Customer’s use of the Service, Customer may elect to include personal data from any of the following types of data subjects in the Customer Personal Data:

-	Employees, contractors and temporary workers (current, former, prospective) of data exporter;
-	Dependents of the above;
-	Data exporter's collaborators/contact persons (natural persons) or employees, contractors or temporary workers of legal entity collaborators/contact persons (current, prospective, former);
-	Users (e.g., customers, clients, patients, visitors, etc.) and other data subjects that are users of data exporter's services;
-	Partners, stakeholders or individuals who actively collaborate, communicate or otherwise interact with employees of the data exporter and/or use communication tools such as apps and websites provided by the data exporter;
-	Stakeholders or individuals who passively interact with data exporter (e.g., because they are the subject of an investigation, research or mentioned in documents or correspondence from or to the data exporter); or
-	Professionals with professional privilege (e.g., doctors, lawyers, notaries, religious workers, etc.).

**Categories of data:** The personal data transferred that is included in e-mail, documents and other data in an electronic form in the context of the Service.  GitHub acknowledges that, depending on Customer’s use of the Service, Customer may elect to include personal data from any of the following categories in the Customer Personal Data:
-	Authentication data (for example, username, email, password);
-	Contact information (for example, email);
-	Unique identification numbers and signatures (IP addresses, unique identifier in tracking cookies or similar technology). 
-	Other unique identifying information. Data subjects may include more data such as real names, avatar images, and other personal information;

**Special categories of data (if appropriate):** The data importer does not intentionally collect or process any special categories of data in carrying out its services to the data exporter. 

However, because the data importer provides storage services and does not control the categories of data it stores, the data exporter may choose to transfer special categories of data. Consequently, the data exporter is solely responsible for ensuring that it complies with all obligations imposed by applicable laws and regulations relating to the collection and processing of any special categories of data, including obtaining the explicit consent of the data subject prior to processing sensitive personal data.

**Processing operations:** The personal data transferred will be subject to the following basic processing activities: 
GitHub uses personal data for the limited purposes set forth in the GitHub Privacy Statement, available at [https://docs.github.com/articles/github-privacy-statement](/articles/github-privacy-statement), and the “Data Processing” section of the DPA.
Subcontractors: In accordance with the DPA, the data importer may hire other companies to provide limited services on data importer’s behalf, such as providing customer support. Any such subcontractors will be permitted to obtain Customer Personal Data only to deliver the services the data importer has retained them to provide, and they are prohibited from using Customer Personal Data for any other purpose.

### Appendix 2 to the Standard Contractual Clauses
Description of the technical and organizational security measures implemented by the data importer in accordance with Clauses 4(d) and 5(c):

**1. Personnel.** Data importer’s personnel will not process Customer Personal Data without authorization. Personnel are obligated to maintain the confidentiality of any Customer Personal Data and this obligation continues even after their engagement ends. 

**2. Data Privacy Contact.** The data privacy officer of the data importer can be reached at the following address: 
GitHub, Inc.
Attn: Privacy 
88 Colin P. Kelly Jr. Street 
San Francisco, CA 94107 USA 

**3. Technical and Organization Measures.** The data importer has implemented and will maintain appropriate technical and organizational measures, internal controls, and information security routines intended to protect Customer Personal Data, as defined in the GitHub Security Exhibit, against accidental loss, destruction, or alteration; unauthorized disclosure or access; or unlawful destruction as follows: The technical and organizational measures, internal controls, and information security routines set forth in the GitHub Security Exhibit are hereby incorporated into this Appendix 2 by this reference and are binding on the data importer as if they were set forth in this Appendix 2 in their entirety.
Signature of GitHub, Inc. appears below.

Signing the Standard Contractual Clauses, Appendix 1 and Appendix 2 on behalf of the data importer

![Screen Shot 2020-07-20 at 2 20 29 PM](/assets/images/help/site-policy/docusign-signature.png)

Lynn Hashimoto, Head of Product & Regulatory Legal

GitHub, Inc.


## SECURITY EXHIBIT

### 1. Information Security Program.

#### 1.1 Security Management.

Throughout the duration of the Agreement, GitHub will maintain and enforce a written information security program (**"Security Program"**) that aligns with industry recognized frameworks; includes security safeguards reasonably designed to protect the confidentiality, integrity, availability, and resilience of Customer Protected Data; is appropriate to the nature, size, and complexity of GitHub's business operations; and complies with the Applicable Data Protection Laws and other specific information security related laws and regulations that are applicable to the geographic regions in which GitHub does business.

a. Security Officer. GitHub has designated a senior employee to be responsible for overseeing and carrying out its Security Program and for governance and internal communications regarding information security matters.

b. Security Program Changes. GitHub will not make changes to its Security Program that adversely affect the security of any Customer Protected Data where notification is required under applicable laws and regulations.

c. GitHub will maintain standard security industry practices to include, but are not limited to:

- Vulnerability Management Program
- Secure Development Training, Review and Coding Practices
- Production Systems Logical and Physical Access Controls
- External Technical Assessments and Audits
- Security Policies, Standards and Standard Operating Procedures
- Security and Privacy Awareness Training


#### 1.2 Security Incident Management. 
Throughout the duration of the Agreement, and where applicable, GitHub will provide a Security incident management program as follows:

a. Security Availability and Escalation. GitHub will maintain appropriate security contact and escalation processes on a 24-hours-per-day, 7-days-per-week basis to ensure customers and employees can submit issues to the GitHub Security team.

b. Incident Response. If GitHub becomes aware of a breach of security leading to the accidental or unlawful destruction, loss, alteration, unauthorized disclosure of, or access to Customer Personal Data (each a **"Security Incident"**), GitHub will promptly and without undue delay (1) notify Customer of the Security Incident; (2) investigate the Security Incident and provide Customer with detailed information about the Security Incident; (3) take reasonable steps to mitigate the effects and to minimize any damage resulting from the Security Incident.

c. Notification. Notification(s) of Security Incidents will be delivered to one or more of Customer's administrators by any means GitHub selects. It is Customer's sole responsibility to ensure Customer's administrators monitor for and respond to any notifications. Customer is solely responsible for complying with its obligations under incident notification laws applicable to Customer and fulfilling any third-party notification obligations related to any Security Incident.

d. Reasonable Assistance. GitHub will make commercially reasonable efforts to assist Customer in fulfilling Customer's obligation under applicable law or regulation to notify the relevant supervisory authority and data subjects about such Security Incident.

#### 1.3 Due Diligence over Subcontractors and Vendors.
GitHub will maintain appropriate due diligence when utilizing subcontractors and vendors. GitHub will maintain vendor assessment reports and any assessment work for a minimum of three years.

#### 1.4 Data Center Physical Safeguards.
To the extent GitHub utilizes third party vendors to host production environments, GitHub will select vendors that comply with physical security controls outlined in industry standards and that issue an annual external audit report such as SOC 2 or ISO 27001 certification. All access to areas, cabinets, or racks that house telecommunications, networking devices, and other "data transmission lines" or equipment will be controlled as follows:

a. access will be controlled by badge reader at one or more entrance points;

b. doors used only as exit points will have only "one way" doorknobs or crash bar exit devices installed;

c. all doors will be equipped with door alarm contacts;

d. all exit doors will have video surveillance capability; and

e. all card access and video systems will be tied in to generator or UPS backup systems.

### 2. Requests for Information and Compliance Reporting.

#### 2.1 Requests for Information.
Upon Customer's written request and no more than once annually, GitHub will respond to one request for information to assess security and compliance risk-related information. The response will be provided in writing within thirty days of receipt of the request, pending needed clarifications of any request.

#### 2.2 Response Contents. 
GitHub will include in its annual response relevant audit reports for production datacenter, IaaS, PaaS or private hosting providers, as deemed relevant by GitHub, in its sole discretion and based on data and services rendered.

#### 2.3 GitHub Security Audit Report.
GitHub will execute external audits to produce a SOC1, type 2, audit report and a SOC2, type 2, audit report. GitHub will continue to execute audits and issue corresponding reports for the duration of the Agreement on at least an annual basis.

### 3. Cooperation with Regulatory Audits.
Should Customer realize a regulatory audit or an audit in response to a Supervisory Authority that requires participation from GitHub, GitHub will fully cooperate with related requests by providing access to relevant knowledgeable personnel, documentation, and application software. Customer has the following responsibilities regarding any such regulatory or Supervisory Authority audits:

a. Customer must ensure use of an independent third party (meaning the regulator or regulator's delegate), and that findings and data not relevant to Customer are restricted from Customer’s access.

b. Notification of such audit must be written and provided to GitHub in a timely fashion, pending regulator notification, and in a manner that allows for appropriate personnel to be made available to assist. Where regulators provide no advance notice to Customer of audit or investigation, GitHub will respond in as timely a fashion as required by regulators.

c. Any third party auditor must disclose to GitHub any findings and recommended actions where allowed by regulator.

d. In the event of a regulatory audit, access will be permitted only during regular business hours, Pacific time.

e. To the extent permitted by law, Customer must keep confidential any information gathered through any such audit of GitHub that, by its nature, should be confidential.
