---
title: GitHub Acceptable Use Policies
redirect_from:
  - /articles/github-acceptable-use-policies
versions:
  free-pro-team: '*'
---

**Short version:** _We host a wide variety of collaborative projects from all over the world, and that collaboration only works when our users are able to work together in good faith. While using the Service, you must comply with our Acceptable Use Policies, which include some restrictions on content you can post, conduct on the service, and other limitations. In short, be excellent to each other._

Capitalized terms used but not defined in these Acceptable Use Policies have the meanings assigned to them in our [Terms of Service](/articles/github-terms-of-service), [Corporate Terms of Service](/articles/github-corporate-terms-of-service), and [Privacy Statement](/articles/github-privacy-statement). For customers subject to the [Corporate Terms of Service](/articles/github-corporate-terms-of-service), "you" and "your" refer to "Customer" or "Users". "We", "us", "our" refer to "GitHub".

### 1. Compliance with Laws and Regulations
You are responsible for using the Service in compliance with all applicable laws, regulations, and all of our Acceptable Use Policies. These policies may be updated from time to time and are provided below, as well as in our [Terms of Service](/articles/github-terms-of-service) and [Corporate Terms of Service](/articles/github-corporate-terms-of-service).

### 2. Content Restrictions
Under no circumstances will Users upload, post, host, execute, or transmit any Content to any repositories that:

- is unlawful or promotes unlawful activities;

- is or contains sexually obscene content;

- is libelous, defamatory, or fraudulent;

- is discriminatory or abusive toward any individual or group;

- gratuitously depicts or glorifies violence, including violent images;

- is or contains false, inaccurate, or intentionally deceptive information that is likely to adversely affect the public interest (including health, safety, election integrity, and civic participation);

- contains or installs any active malware or exploits, or uses our platform for exploit delivery (such as part of a command and control system); or

- infringes any proprietary right of any party, including patent, trademark, trade secret, copyright, right of publicity, or other right.

### 3. Conduct Restrictions
While using the Service, under no circumstances will you:

- harass, abuse, threaten, or incite violence towards any individual or group, including our employees, officers, and agents, or other users;

- use our servers for any form of excessive automated bulk activity (for example, spamming or cryptocurrency mining), to place undue burden on our servers through automated means, or to relay any form of unsolicited advertising or solicitation through our servers, such as get-rich-quick schemes;

- use our servers to disrupt or to attempt to disrupt, or to gain or to attempt to gain unauthorized access to, any service, device, data, account or network (unless authorized by the [GitHub Bug Bounty program](https://bounty.github.com));

- impersonate any person or entity, including any of our employees or representatives, including through false association with GitHub, or by fraudulently misrepresenting your identity or site's purpose; or

- violate the privacy of any third party, such as by posting another person's personal information without consent.

### 4. Services Usage Limits
You will not reproduce, duplicate, copy, sell, resell or exploit any portion of the Service, use of the Service, or access to the Service without our express written permission.

### 5. Scraping and API Usage Restrictions
Scraping refers to extracting data from our Service via an automated process, such as a bot or webcrawler. It does not refer to the collection of information through our API. Please see Section H of our [Terms of Service](/articles/github-terms-of-service#h-api-terms) for our API Terms. You may scrape the website for the following reasons:

- Researchers may scrape public, non-personal information from the Service for research purposes, only if any publications resulting from that research are open access.
- Archivists may scrape the Service for public data for archival purposes.

You may not scrape the Service for spamming purposes, including for the purposes of selling User Personal Information (as defined in the [GitHub Privacy Statement](/articles/github-privacy-statement)), such as to recruiters, headhunters, and job boards.

All use of data gathered through scraping must comply with the [GitHub Privacy Statement](/articles/github-privacy-statement).

### 6. Privacy
Misuse of User Personal Information is prohibited.

Any person, entity, or service collecting data from the Service must comply with the [GitHub Privacy Statement](/articles/github-privacy-statement), particularly in regards to the collection of User Personal Information. If you collect any User Personal Information from the Service, you agree that you will only use that User Personal Information for the purpose for which that User has authorized it. You agree that you will reasonably secure any User Personal Information you have gathered from the Service, and you will respond promptly to complaints, removal requests, and "do not contact" requests from us or other users.

### 7. Excessive Bandwidth Use
The Service's bandwidth limitations vary based on the features you use. If we determine your bandwidth usage to be significantly excessive in relation to other users of similar features, we reserve the right to suspend your Account, throttle your file hosting, or otherwise limit your activity until you can reduce your bandwidth consumption. We also reserve the right—after providing advance notice—to delete repositories that we determine to be placing undue strain on our infrastructure. For guidance on acceptable use of object storage in repositories, refer to "[What is my disk quota?](/github/managing-large-files/what-is-my-disk-quota)". For more details on specific features' bandwidth limitations, see the [GitHub Additional Product Terms](/github/site-policy/github-additional-product-terms).

### 8. Advertising on GitHub
**Short version:** *We do not generally prohibit use of GitHub for advertising. However, we expect our users to follow certain limitations, so GitHub does not become a spam haven. No one wants that.*

While we understand that you may want to promote your Content by posting supporters' names or logos in your Account, the primary focus of the Content posted in or through your Account to the Service should not be advertising or promotional marketing. This includes Content posted in or through Pages, Packages, repositories, and all other parts of the Service. You may include static images, links, and promotional text in the README documents or project description sections associated with your Account, but they must be related to the project you are hosting on GitHub. You may not advertise in other Users' Accounts, such as by posting monetized or excessive bulk content in issues.

You may not promote or distribute content or activity that is illegal or otherwise prohibited by our [Terms of Service](/github/site-policy/github-terms-of-service/), [Community Guidelines](/github/site-policy/github-community-guidelines/), or [Acceptable Use Policy](/github/site-policy/github-acceptable-use-policies/), including excessive automated bulk activity (for example, spamming), get-rich-quick schemes, and misrepresentation or deception related to your promotion.

If you decide to post any promotional materials in your Account, you are solely responsible for complying with all applicable laws and regulations, including without limitation the U.S. Federal Trade Commission's Guidelines on Endorsements and Testimonials. We reserve the right to remove any promotional materials or advertisements that, in our sole discretion, violate any GitHub terms or policies.

### 9. Spam and Inauthentic Activity on GitHub
Automated excessive bulk activity and coordinated inauthentic activity, such as spamming, are prohibited on GitHub. Prohibited activities include:
* bulk distribution of promotions and advertising prohibited by GitHub terms and policies
* inauthentic interactions, such as fake accounts and automated inauthentic activity
* rank abuse, such as automated starring or following
* creation of or participation in secondary markets for the purpose of the proliferation of inauthentic activity
* using GitHub as a platform for propagating abuse on other platforms
* phishing or attempted phishing

GitHub reserves the right to remove any Content in violation of this policy.

### 10. User Protection
You must not engage in activity that significantly harms other users. We will resolve disputes in favor of protecting users as a whole.
