---
title: About issues
intro: 'Use issues to track ideas, enhancements, tasks, or bugs for work on {% data variables.product.product_name %}.'
redirect_from:
  - /articles/creating-issues/
  - /articles/about-issues/
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

You can collect user feedback, report software bugs, and organize tasks you'd like to accomplish with issues in a repository. Issues can act as more than just a place to report software bugs.

{% data reusables.pull_requests.close-issues-using-keywords %}

To stay updated on the most recent comments in an issue, you can watch an issue to receive notifications about the latest comments. For more information, see {% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}"[About notifications](/github/managing-subscriptions-and-notifications-on-github/about-notifications){% else %}"[About notifications](/github/receiving-notifications-about-activity-on-github/about-notifications){% endif %}." 

To quickly find links to recently updated issues you're subscribed to, visit your dashboard. For more information, see "[About your personal dashboard](/articles/about-your-personal-dashboard)."

### Working with issues

With issues, you can:
- Track and prioritize your work using project boards. For more information, see "[Using project boards](/articles/about-project-boards)."
- Create new issues to track out-of-scope feedback from a comment in an issue or a pull request review. For more information, see "[Opening an issue from a comment](/github/managing-your-work-on-github/opening-an-issue-from-a-comment)."
- Create issue templates to help contributors open meaningful issues. For more information, see "[About issue and pull request templates](/articles/about-issue-and-pull-request-templates)."
- Transfer open issues to other repositories. For more information, see "[Transferring an issue to another repository](/articles/transferring-an-issue-to-another-repository)."
- Pin important issues to make them easier to find, preventing duplicate issues and reducing noise. For more information, see "[Pinning an issue to your repository](/articles/pinning-an-issue-to-your-repository)."
- Track duplicate issues using saved replies. For more information, see "[About saved replies](/articles/about-saved-replies)."{% if currentVersion == "free-pro-team@latest" %}
- Report comments that violate {% data variables.product.prodname_dotcom %}'s [Community Guidelines](/articles/github-community-guidelines). For more information, see "[Reporting abuse or spam](/articles/reporting-abuse-or-spam)."{% endif %}

Issues can also be [assigned to other users](/articles/assigning-issues-and-pull-requests-to-other-github-users), [tagged with labels](/articles/applying-labels-to-issues-and-pull-requests) for quicker searching, and [grouped together with milestones](/articles/creating-and-editing-milestones-for-issues-and-pull-requests).
