---
title: Collaborating in a temporary private fork to resolve a security vulnerability
intro: You can create a temporary private fork to privately collaborate on fixing a security vulnerability in your repository.
redirect_from:
  - /articles/collaborating-in-a-temporary-private-fork-to-resolve-a-security-vulnerability
versions:
  free-pro-team: '*'
---

### Prerequisites

Before you can collaborate in a temporary private fork, you must create a draft security advisory. For more information, see "[Creating a security advisory](/github/managing-security-vulnerabilities/creating-a-security-advisory)."

### Creating a temporary private fork

Anyone with admin permissions to a security advisory can create a temporary private fork.

To keep information about vulnerabilities secure, integrations, including CI, cannot access temporary private forks.

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
4. In the "Security Advisories" list, click the security advisory you'd like to create a temporary private fork in.
  ![Security advisory in list](/assets/images/help/security/security-advisory-in-list.png)
5. Click **New temporary private fork**.
  ![New temporary private fork button](/assets/images/help/security/new-temporary-private-fork-button.png)

### Adding collaborators to a temporary private fork

Anyone with admin permissions to a security advisory can add additional collaborators to the security advisory, and collaborators on the security advisory can access the temporary private fork. For more information, see "[Adding a collaborator to a security advisory](/github/managing-security-vulnerabilities/adding-a-collaborator-to-a-security-advisory)."

### Adding changes to a temporary private fork

Anyone with write permissions to a security advisory can add changes to a temporary private fork.

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
4. In the "Security Advisories" list, click the security advisory you'd like to add changes to.
  ![Security advisory in list](/assets/images/help/security/security-advisory-in-list.png)
5. Add your changes on {% data variables.product.product_name %} or locally:
   - To add changes on {% data variables.product.product_name %}, under "Add changes to this advisory", click **the temporary private fork**. Then, create a new branch and edit files. For more information, see "[Creating and deleting branches within your repository](/articles/creating-and-deleting-branches-within-your-repository)" and "[Editing files in your repository](/articles/editing-files-in-your-repository)."
   - To add changes locally, follow the instructions under "Clone and create a new branch" and "Make your changes, then push."
   ![Add changes to this advisory box](/assets/images/help/security/add-changes-to-this-advisory-box.png)

### Creating a pull request from a temporary private fork

Anyone with write permissions to a security advisory can create a pull request from a temporary private fork.

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
4. In the "Security Advisories" list, click the security advisory you'd like to create a pull request in.
  ![Security advisory in list](/assets/images/help/security/security-advisory-in-list.png)
5. To the right of your branch name, click **Compare & pull request**.
  ![Compare & pull request button](/assets/images/help/security/security-advisory-compare-and-pr.png)
{% data reusables.repositories.pr-title-description %}
{% data reusables.repositories.create-pull-request %}

{% data reusables.repositories.merge-all-pulls-together %} For more information, see "[Merging changes in a security advisory](#merging-changes-in-a-security-advisory)."

### Merging changes in a security advisory

Anyone with admin permissions to a security advisory can merge changes in a security advisory.

{% data reusables.repositories.merge-all-pulls-together %}

Before you can merge changes in a security advisory, every open pull request in the temporary private fork must be mergeable. There can be no merge conflicts, and branch protection requirements must be satisfied. To keep information about vulnerabilities secure, status checks do not run on pull requests in temporary private forks. For more information, see "[About protected branches](/articles/about-protected-branches)."

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
4. In the "Security Advisories" list, click the security advisory with changes you'd like to merge.
  ![Security advisory in list](/assets/images/help/security/security-advisory-in-list.png)
5. To merge all open pull requests in the temporary private fork, click **Merge pull requests**.
  ![Merge pull requests button](/assets/images/help/security/merge-pull-requests-button.png)

After you merge changes in a security advisory, you can publish the security advisory to alert your community about the security vulnerability in previous versions of your project. For more information, see "[Publishing a security advisory](/github/managing-security-vulnerabilities/publishing-a-security-advisory)."

### Further reading

- "[Permission levels for security advisories](/github/managing-security-vulnerabilities/permission-levels-for-security-advisories)"
- "[Publishing a security advisory](/github/managing-security-vulnerabilities/publishing-a-security-advisory)"
