---
title: GitHub for mobile
intro: 'Triage, collaborate, and manage your work on {% data variables.product.company_short %} from your mobile device.'
versions:
  free-pro-team: '*'
---

### About {% data variables.product.prodname_mobile %}

{% data variables.product.prodname_mobile %} is currently available for {% data variables.product.prodname_dotcom_the_website %} users as an Android and iOS app.

{% data variables.product.prodname_mobile %} gives you a way to do high-impact work on {% data variables.product.prodname_dotcom %} quickly and from anywhere. {% data variables.product.prodname_mobile %} is a safe and secure way to access your {% data variables.product.prodname_dotcom %} data through a trusted, first-party client application.

With {% data variables.product.prodname_mobile %} you can:
- Manage, triage, and clear notifications
- Read, review, and collaborate on issues and pull requests
- Search for, browse, and interact with users, repositories, and organizations
- Receive a push notification when someone mentions your username

For more information about notifications for {% data variables.product.prodname_mobile %}, see "[Configuring notifications](/github/managing-subscriptions-and-notifications-on-github/configuring-notifications#enabling-push-notifications-with-github-for-mobile)."

### Installing {% data variables.product.prodname_mobile %}

To install {% data variables.product.prodname_mobile %} for Android or iOS, see [{% data variables.product.prodname_mobile %}](https://github.com/mobile).

### Supported languages for {% data variables.product.prodname_mobile %}

{% data variables.product.prodname_mobile %} is available in the following languages.

- Japanese
- Brazilian Portuguese
- Spanish

If you configure the language on your device to a supported language, {% data variables.product.prodname_mobile %} will default to the language. You can change the language for {% data variables.product.prodname_mobile %} in {% data variables.product.prodname_mobile %}'s **Settings** menu.

### Managing Universal Links for {% data variables.product.prodname_mobile %} on iOS

{% data variables.product.prodname_mobile %} automatically enables Universal Links for iOS. When you tap any {% data variables.product.product_name %} link, the destination URL will open in {% data variables.product.prodname_mobile %} instead of Safari. For more information, see [Universal Links](https://developer.apple.com/ios/universal-links/) on the Apple Developer site.

To disable Universal Links, long-press any {% data variables.product.prodname_dotcom %} link, then tap **Open**. Every time you tap a {% data variables.product.prodname_dotcom %} link in the future, the destination URL will open in Safari instead of {% data variables.product.prodname_mobile %}.

To re-enable Universal Links, long-press any {% data variables.product.prodname_dotcom %} link, then tap **Open in {% data variables.product.prodname_dotcom %}**.

### Sharing feedback

If you have feedback or feature requests for {% data variables.product.prodname_mobile %}, you can email us at <a href="mailto:mobilefeedback@github.com">mobilefeedback@github.com</a>.


### Opting out of beta releases for iOS

If you're testing a beta release of {% data variables.product.prodname_mobile %} for iOS using TestFlight, you can leave the beta at any time.

1. On your iOS device, open the TestFlight app.
2. Under "Apps", tap **{% data variables.product.prodname_dotcom %}**.
3. At the bottom of the page, tap **Stop Testing**.
