---
title: 'Error: Repository not found'
intro: '{% if currentVersion == "free-pro-team@latest" %}If you see this error when cloning a repository, it means that the repository does not exist or you do not have permission to access it. There are a few solutions to this error, depending on the cause.{% else %}If you see this error when cloning a repository, it means that the repository does not exist, you do not have permission to access it, or your GitHub Enterprise instance is in private mode. There are a few solutions to this error, depending on the cause.{% endif %}'
redirect_from:
  - /articles/error-repository-not-found
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### Check your spelling

Typos happen, and repository names are case-sensitive.  If you try to clone `git@{% data variables.command_line.codeblock %}:user/repo.git`, but the repository is really named `User/Repo` you will receive this error.

To avoid this error, when cloning, always copy and paste the clone URL from the repository's page. For more information, see "[Cloning a repository](/articles/cloning-a-repository)."

To update the remote on an existing repository, see "[Changing a remote's URL](/articles/changing-a-remote-s-url)".

### Checking your permissions

If you are trying to clone a private repository but do not have permission to view the repository, you will receive this error.

Make sure that you have access to the repository in one of these ways:

* The owner of the repository
* A [collaborator](/articles/inviting-collaborators-to-a-personal-repository) on the repository
* A [member of a team](/articles/adding-organization-members-to-a-team) that has access to the repository (if the repository belongs to an organization)

### Check your SSH access

In rare circumstances, you may not have the proper SSH access to a repository.

You should ensure that the SSH key you are using is attached to your {% data variables.product.product_name %} user account. You can check this by typing
the following into the command line:

```shell
$ ssh -T git@{% data variables.command_line.codeblock %}
> Hi <em>username</em>! You've successfully authenticated, but GitHub does not
> provide shell access.
```

If the repository belongs to an organization and you're using an SSH key generated by an OAuth App, OAuth App access may have been restricted by an organization owner. For more information, see "<a href="/github/setting-up-and-managing-organizations-and-teams/about-oauth-app-access-restrictions" class="dotcom-only">About OAuth App access restrictions</a>."

For more information, see [Adding a new SSH key to your GitHub account](/articles/adding-a-new-ssh-key-to-your-github-account).

{% if currentVersion != "free-pro-team@latest" %}

### Check if your instance is in private mode

If your site administrator has enabled private mode on your GitHub Enterprise instance, anonymous clones over `git://` will be disabled. If you are unable to clone a repository, contact your site administrator.

{% endif %}

### Check that the repository really exists

If all else fails, make sure that the repository really exists on {% data variables.product.product_location %}!
If you're trying to push to a repository that doesn't exist, you'll get this error.
