---
title: About two-factor authentication
intro: '{% data reusables.two_fa.about-2fa %} With 2FA, you have to log in with your username and password and provide another form of authentication that only you know or have access to.'
redirect_from:
  - /articles/about-two-factor-authentication
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

For {% data variables.product.product_name %}, the second form of authentication is a code that's generated by an application on your mobile device{% if currentVersion == "free-pro-team@latest" %} or sent as a text message (SMS){% endif %}. After you enable 2FA, {% data variables.product.product_name %} generates an authentication code any time someone attempts to sign into your {% data variables.product.product_name %} account. The only way someone can sign into your account is if they know both your password and have access to the authentication code on your phone.

{% data reusables.two_fa.after-2fa-add-security-key %}

You can also configure additional recovery methods in case you lose access to your two-factor authentication credentials. For more information on setting up 2FA, see "[Configuring two-factor authentication](/articles/configuring-two-factor-authentication)" and "[Configuring two-factor authentication recovery methods](/articles/configuring-two-factor-authentication-recovery-methods)."

We **strongly** urge you to enable 2FA for the safety of your account, not only on {% data variables.product.product_name %}, but on other websites and apps that support 2FA. You can enable 2FA to access {% data variables.product.product_name %} and {% data variables.product.prodname_desktop %}.

For more information, see "[Accessing {% data variables.product.prodname_dotcom %} using two-factor authentication](/articles/accessing-github-using-two-factor-authentication)."

### Two-factor authentication recovery codes

{% data reusables.two_fa.about-recovery-codes %} For more information, see "[Recovering your account if you lose your 2FA credentials](/articles/recovering-your-account-if-you-lose-your-2fa-credentials)."

{% if currentVersion == "free-pro-team@latest" %}

{% warning %}

**Warning**: {% data reusables.two_fa.support-may-not-help %} For more information, see "[Recovering your account if you lose your 2FA credentials](/articles/recovering-your-account-if-you-lose-your-2fa-credentials)."

{% endwarning %}

{% endif %}

### Requiring two-factor authentication in your organization

Organization owners can require that organization members{% if currentVersion == "free-pro-team@latest" %}, billing managers,{% endif %} and outside collaborators use two-factor authentication to secure their personal accounts. For more information, see "[Requiring two-factor authentication in your organization](/articles/requiring-two-factor-authentication-in-your-organization)."

{% data reusables.two_fa.auth_methods_2fa %}
