---
title: About authentication to GitHub
intro: 'You can securely access your account''s resources by authenticating to {% data variables.product.product_name %}, using different credentials depending on where you authenticate.'
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### About authentication to {% data variables.product.prodname_dotcom %}

To keep your account secure, you must authenticate before you can access certain resources on {% data variables.product.product_name %}. When you authenticate to {% data variables.product.product_name %}, you supply or confirm credentials that are unique to you to prove that you are exactly who you declare to be. 

You can access your resources in {% data variables.product.product_name %} in a variety of ways: in the browser, via {% data variables.product.prodname_desktop %} or another desktop application, with the API, or via the command line. Each way of accessing {% data variables.product.product_name %} supports different modes of authentication.

- Username and password with two-factor authentication
- Personal access token
- SSH key

### Authenticating in your browser

You can authenticate to {% data variables.product.product_name %} in your browser in different ways.

- **Username and password only**
    - You'll create a password when you create your user account on {% data variables.product.product_name %}. We recommend that you use a password manager to generate a random and unique password. For more information, see "[Creating a strong password](/github/authenticating-to-github/creating-a-strong-password)."
- **Two-factor authentication (2FA)** (recommended)
    - If you enable 2FA, we'll also prompt you to provide a code that's generated by an application on your mobile device or sent as a text message (SMS) after you successfully enter your username and password. For more information, see "[Accessing {% data variables.product.prodname_dotcom %} using two-factor authentication](/github/authenticating-to-github/accessing-github-using-two-factor-authentication#providing-a-2fa-code-when-signing-in-to-the-website)."
    - In addition to authentication with a mobile application or a text message, you can optionally add a secondary method of authentication with a security key using WebAuthn. For more information, see "[Configuring two-factor authentication using a security key](/github/authenticating-to-github/configuring-two-factor-authentication#configuring-two-factor-authentication-using-a-security-key)."

### Authenticating with {% data variables.product.prodname_desktop %}

You can authenticate with {% data variables.product.prodname_desktop %} using your browser. For more information, see "[Authenticating to {% data variables.product.prodname_dotcom %}](/desktop/getting-started-with-github-desktop/authenticating-to-github)."

### Authenticating with the API

You can authenticate with the {% data variables.product.product_name %} API in different ways.

- **Personal access tokens** 
    - In limited situations, such as testing, you can use a personal access token to access the API. Using a personal access token enables you to revoke access at any time. For more information, see "[Creating a personal access token](/github/authenticating-to-github/creating-a-personal-access-token)."
- **Web application flow**
    - For OAuth Apps in production, you should authenticate using the web application flow. For more information, see "[Authorizing OAuth Apps](/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow)."
- **GitHub Apps**
    - For GitHub Apps in production, you should authenticate on behalf of the app installation. For more information, see "[Authenticating with {% data variables.product.prodname_github_apps %}](/apps/building-github-apps/authenticating-with-github-apps/)."

### Authenticating with the command line

You can access repositories on {% data variables.product.product_name %} from the command line in two ways, HTTPS and SSH, and both have a different way of authenticating. The method of authenticating is determined based on whether you choose an HTTPS or SSH remote URL when you clone the repository. For more information about which way to access, see "[Which remote URL should I use?](/github/using-git/which-remote-url-should-i-use)"

* You can work with all repositories on {% data variables.product.product_name %} over HTTPS, even if you are behind a firewall or proxy. Every time you use Git to authenticate with {% data variables.product.product_name %}, you'll be prompted to enter your credentials to authenticate with {% data variables.product.product_name %}, unless you cache them with a [credential helper](/github/using-git/caching-your-github-credentials-in-git). {% data reusables.user_settings.password-authentication-deprecation %}

* You can work with all repositories on {% data variables.product.product_name %} over SSH, although firewalls and proxys might refuse to allow SSH connections. Using SSH requires you to generate an SSH public/private keypair on your local machine and add the public key to your {% data variables.product.product_name %} account. Every time you use Git to authenticate with {% data variables.product.product_name %}, you'll be prompted to enter your SSH key passphrase, unless you've [stored the key](/github/authenticating-to-github/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent#adding-your-ssh-key-to-the-ssh-agent). For more information, see "[Generating a new SSH key and adding it to the ssh-agent](/github/authenticating-to-github/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent)."

{% if currentVersion == "free-pro-team@latest" %}To use a personal access token or SSH key to access resources owned by an organization that uses SAML single sign-on, you must also authorize the personal token or SSH key. For more information, see "[Authorizing a personal access token for use with SAML single sign-on](/github/authenticating-to-github/authorizing-a-personal-access-token-for-use-with-saml-single-sign-on)" or "[Authorizing an SSH key for use with SAML single sign-on](/github/authenticating-to-github/authorizing-an-ssh-key-for-use-with-saml-single-sign-on)."{% endif %}
