---
title: 'Managing users, organizations, and repositories'
shortTitle: 'Managing users, organizations, and repositories'
redirect_from:
  - /enterprise/admin/categories/user-management/
  - /enterprise/admin/developer-workflow/using-webhooks-for-continuous-integration
  - /enterprise/admin/migrations
  - /enterprise/admin/clustering
  - /enterprise/admin/user-management
intro: 'This guide describes authentication methods for users signing in to your {% data variables.product.prodname_enterprise %} instance, how to create organizations and teams for repository access and collaboration, and suggested best practices for user security.'
versions:
  enterprise-server: '*'
---


### Table of Contents

{% topic_link_in_list /managing-users-in-your-enterprise %}
    {% link_in_list /promoting-or-demoting-a-site-administrator %}
    {% link_in_list /best-practices-for-user-security %}
    {% link_in_list /auditing-users-across-your-instance %}
    {% link_in_list /managing-dormant-users %}
    {% link_in_list /suspending-and-unsuspending-users %}
    {% link_in_list /placing-a-legal-hold-on-a-user-or-organization %}
    {% link_in_list /auditing-ssh-keys %}
    {% link_in_list /customizing-user-messages-on-your-instance %}
    {% link_in_list /configuring-email-for-notifications %}
    {% link_in_list /rebuilding-contributions-data %}
    {% link_in_list /managing-global-webhooks %}
{% topic_link_in_list /managing-organizations-in-your-enterprise %}
    {% link_in_list /creating-organizations %}
    {% link_in_list /configuring-visibility-for-organization-membership %}
    {% link_in_list /preventing-users-from-creating-organizations %}
    {% link_in_list /requiring-two-factor-authentication-for-an-organization %}
    {% link_in_list /creating-teams %}
    {% link_in_list /adding-people-to-teams %}
    {% link_in_list /removing-users-from-teams-and-organizations %}
    {% link_in_list /managing-projects-using-jira %}
    {% link_in_list /continuous-integration-using-jenkins %}
{% topic_link_in_list /managing-repositories-in-your-enterprise %}
    {% link_in_list /configuring-git-large-file-storage-for-your-enterprise %}
    {% link_in_list /migrating-to-internal-repositories %}
    {% link_in_list /disabling-git-ssh-access-on-github-enterprise-server %}
    {% link_in_list /troubleshooting-service-hooks %}
{% topic_link_in_list /monitoring-activity-in-your-enterprise %}
    {% link_in_list /activity-dashboard %}
    {% link_in_list /audit-logging %}
    {% link_in_list /searching-the-audit-log %}
    {% link_in_list /audited-actions %}
    {% link_in_list /viewing-push-logs %}
{% topic_link_in_list /migrating-data-to-and-from-your-enterprise %}
    {% link_in_list /about-migrations %}
    {% link_in_list /exporting-migration-data-from-your-enterprise %}
    {% link_in_list /exporting-migration-data-from-githubcom %}
    {% link_in_list /preparing-to-migrate-data-to-your-enterprise %}
    {% link_in_list /migrating-data-to-your-enterprise %}
    {% link_in_list /importing-data-from-third-party-version-control-systems %}
