---
title: Enabling GitHub Actions and configuring storage
intro: 'External storage must be configured as part of enabling {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %}.'
permissions: 'Site administrators can enable {% data variables.product.prodname_actions %} and configure enterprise settings.'
redirect_from:
  - /enterprise/admin/github-actions/enabling-github-actions-and-configuring-storage
versions:
  enterprise-server: '>=2.22'
---

{% if currentVersion == "enterprise-server@2.22" %}
{% note %}

**Note:** {% data variables.product.prodname_actions %} support on {% data variables.product.prodname_ghe_server %} 2.22 is a limited public beta. Review the external storage requirements below and [sign up for the beta](https://resources.github.com/beta-signup/).

{% endnote %}
{% endif %}
{% data reusables.actions.enterprise-github-hosted-runners %}

### About external storage requirements

To enable {% data variables.product.prodname_actions %} on {% data variables.product.prodname_ghe_server %}, you must have access to external blob storage.

{% data variables.product.prodname_actions %} uses blob storage to store artifacts generated by workflow runs, such as workflow logs and user-uploaded build artifacts. The amount of storage required depends on your usage of {% data variables.product.prodname_actions %}.

{% data variables.product.prodname_actions %} supports these storage providers:

* Amazon S3
* Azure Blob storage
* S3-compatible MinIO Gateway for NAS

#### Amazon S3 permissions

If you use Amazon S3, {% data variables.product.prodname_actions %} requires the following permissions for your AWS access key ID and secret:

* `s3:PutObject`
* `s3:GetObject`
* `s3:ListBucketMultipartUploads`
* `s3:ListMultipartUploadParts`
* `s3:AbortMultipartUpload`
* `s3:DeleteObject`

### Enabling {% data variables.product.prodname_actions %}

{% if currentVersion == "enterprise-server@2.22" %}
{% data variables.product.prodname_actions %} support on {% data variables.product.prodname_ghe_server %} 2.22 is a limited public beta. [Sign up for the beta](https://resources.github.com/beta-signup/).
{% endif %}

### Further reading

- "Hardware considerations" for your platform in "[Setting up a {% data variables.product.prodname_ghe_server %} instance](/enterprise/admin/installation/setting-up-a-github-enterprise-server-instance)"
