# Data Vizualization with Plotly

[Plotly](https://plot.ly/python/) is a data visualization library that lets you create beautiful graphs and is easy to use. 

In this lesson we use it to analyze some PyBites blog feed data.

## Day 1: Getting the data

Today you watch the videos. You can follow along with the examples [using my notebook](https://github.com/talkpython/100daysofcode-with-python-course/blob/master/days/82-84-dataviz-plotly/data-viz.ipynb).

We use `feedparser` and `collections.Counter` to prepare PyBites feed data, then use `plotly` to look at:

1. how often we post,
2. what categories we post most often in,
3. and what tags we commonly use on our posts.

At the end of today's lesson, I provide some additional links to data viz work we've done on our PyBites blog.

## Day 2 and 3: Roll your own!

With the materials provided try to get your hands on an interesting data set, be it your own or another source like [Kaggle](https://www.kaggle.com). 

It should not be that hard, data is everywhere! You probably need some parsing and data cleaning, not the most fun part, but an important skill to have. 

Pick one of many data viz libraries and create some cool visualizations and share them with us on Twitter.

Lack inspiration? [Randy Olson](https://twitter.com/randal_olson) tends to tweet really cool [#dataviz stuff](https://twitter.com/hashtag/dataviz?src=hash), however remember to start simple, data viz alone could fill a 100 Days of Code :)

Enjoy and remember: keep calm and code in Python!

## Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfCode**.

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofcode-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofcode-with-python-course/pulls).
