# Refactoring / Pythonic code

In today's videos I will show you 10 ways to improve your Python code. The accompanying Jupyter notebook is [here](https://github.com/talkpython/100daysofcode-with-python-course/blob/master/days/34-36-refactoring/refactoring.ipynb).

This is by no means a complete list, just some tips to get you started. The more time you spend with Python the more patterns you start to recognize and the more elegant your code will become.

## Day 1: Study the materials

Go through the 10 refactoring tips:

1. The problem with big if-elif-else constructs
2. Counting inside a loop
3. Use the with statement to deal with resources
4. Use builtins (learn the stdlib!)
5. Leverage tuple unpacking and namedtuples
6. List comprehensions and generators
7. String formatting and concatenation
8. PEP8 and Zen
9. Explicit is better than implicit
10. (bonus) General coding best practices

There are also some additional resources in the notebook.

Ideally you combine this lesson with [Day 10-12 `pytest`](https://github.com/talkpython/100daysofcode-with-python-course/tree/master/days/10-12-pytest) to get in the habit of writing tests before doing any refactorings.

## Day 2 and 3: Refactor your code

Take our [Blog Code Challenge 30: The Art of Refactoring: Improve Your Code](https://pybit.es/articles/codechallenge30/)

Check out [the notebook](https://github.com/talkpython/100daysofcode-with-python-course/blob/master/days/34-36-refactoring/refactoring.ipynb) for further instructions.

## Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfCode**.

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofcode-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofcode-with-python-course/pulls).
