## 《程序人生》十年风雨技术人的书单整理

> 你知道的越多，你不知道的越多

> 点赞再看，养成习惯

> 给岁月以文明，而不是给文明以岁月

> 本文 **GitHub** [https://github.com/JavaFamily](https://github.com/AobingJava/JavaFamily) 上已经收录，有一线大厂面试点思维导图，也整理了很多我的文档，欢迎Star和完善，大家面试可以参照考点复习，希望我们一起有点东西。

### 前言

王潇：格局决定了一个人的梦想，梦想反过来决定行为。

那格局是什么呢？

**格局是你能够看见的深度、广度和密度。**

王潇认为，格局是一本本书搭建起来的，正如她所言：“**读书让我知道世界很大，然后才知道推开门去看看这个世界。**”

之前有一篇文章我写到了几乎是一个技术人从0到1的整个生涯了，其实大家发现根本就没有终点。

[《程序人生》风雨十年-从大学到技术专家我做了啥？](https://juejin.im/post/5ded1639e51d455830350da5)

我们的一生其实也基本上都在学习，那提到学习，我第一时间想到的就是读书了。

记得帅丙在自己21岁的那个夏天，当时拿到了自己的第一笔实习工资1400块，因为是110块一天嘛，而且入职的第一个月也没上满，但是还是很开心，第一个月师傅就给了一个建议，买本书吧。

就这样我买了出社会之后的第一本技术书籍《Java核心卷一》，也是师傅推荐的，如获至宝。

到现在我的书架都茫茫当当了，但是这本书还是一直陪伴我左右，也是我印象最深刻的技术书籍，因为那感觉就像是**初恋的味道**，甜甜的。

为啥推荐大家读书呢，**书籍的作者都是几年甚至几十年的经验，最后总结为一本书，**那就算里面有错误的点，我想你花几十块，只用几个礼拜甚至几天就可以拜读人家十几年的经验，我觉得怎么算都是血赚？

## 正文

好了扯了这么多只是想要引出今天的主题，我会按照不同的类型把我知道的一些书籍，包括身边朋友推荐的书籍，都在这里列给大家，大家按需自取。

我还推荐了很多非技术的书籍，人文地理悬疑情感都会涉及，反正很多书我是真的很喜欢。

我上一篇提到的我亦师亦友的阿里技术专家朋友，他就是个很喜欢读书的人，说实话他的**学校背景不好**，刚开始出来也是在外包干活的，但是他有个习惯，就是看书，基本上闲暇时候，都能看到他看书的身影。

看他的动态也都是分享各类书籍，**口吐芬芳**，我要是个女人，估计他跑不掉了。

反正经常读书的人，你跟他说话，看他谈吐，自然就知道了，我经常说的那句：**腹有诗书气自华** 希望你能懂，不看真像网上的段子那样，看到美好的景色只能：卧*

下面是我截图的他的几条动态，这种谈吐我爱了❤

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9ngogekz6j30mq0b4adx.jpg)

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9ngob9s4nj30jw0b441o.jpg)

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9ngo5a0u1j30h90b4div.jpg)

### Java

#### Java核心技术·卷 I（原书第10版）| Core Java Volume 

> 讲的很全面，书中的代码示例都很好，很适合Java入门。
>
> 但是作者不太厚道的是把现在没人用的GUI编程放在了第一卷，基本上10~13章是可以不用读的。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9hbdoqljkj309p0dvdl9.jpg)







#### Java性能权威指南|Java Performance: The Definitive Guide

> 市面上介绍Java的书有很多，但专注于Java性能的并不多，能游刃有余地展示Java性能优化难点的更是凤毛麟角，本书即是其中之一。
>
> 通过使用JVM和Java平台，以及Java语言和应用程序接口，本书详尽讲解了Java性能调优的相关知识，帮助读者深入理解Java平台性能的各个方面，最终使程序如虎添翼。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9hbm4gqmnj309p0d3776.jpg)

#### 实战Java高并发程序设计|葛一鸣

> 由部分段落的行文来看，搬了官方文档。
>
> 也有一些第一人称的叙述和思考，也能看出作者也是花了一点心思的。胜在比较基础，涉及到的知识点也还很全面（讲到了流水线计算和并发模型这些边边角角的），但是由于是编著，全书整体上不够统一和深入，适合作为学习高并发的第一本工具书。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9pawpmidhj307d0a4tbj.jpg)

#### Java 8实战

> 对Java8的新特性讲解的十分到位，尤其是lamdba表达式和流的操作。
>
> 再者对于Java8并发处理很有独到见解。对于并行数据处理和组合式异步编程还需要更深的思考才能更加掌握。
>
> 推荐给再用java8但没有去真正了解的人看，有很多你不知道的细节、原理和类库设计者的用心良苦在里面、内容没有很难，抽出几个小时就能看完，花费的时间和收获相比，性价比很高。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7u5iudbj305h06ztah.jpg)

#### Java并发编程实战

> 先不谈本书的内容如何，光书名就足够吸引不少目光。“并发”这个词在Java世界里往往和“高级、核心”等字眼相联系起来，就冲着这两个字，都将勾起软件工程师们埋藏在心底那种对技术的探索欲和对高级API的驾驭感。
>
> 程序员嘛，多少都有点职业病。其实Java对“并发”优化从未停止过，从5.0到7.0，几乎每个版本的新特性里，都会针对前一版本在“并发”上有所改进。这种改进包括提供更丰富的API接口、JVM底层性能优化等诸多方面。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9hkzebashj30d30h3ai8.jpg)

#### Thinking in Java

> 很美味的一本书，不仅有icecreamm，sundae，sandwich，还有burrito！真是越看越饿啊~

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p80v6ph4j305406vn00.jpg)

#### Effective Java中文版（第3版）|Effective Java Third Edition

> Java 高阶书籍，小白劝退。介绍了关于Java 编程的90个经验技巧。
>
> 作者功力非常强悍，导致这本书有时知识面迁移很广。总之，非常适合有一定Java开发经验的人阅读提升。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9o0pa3nvrj309z0d0tfd.jpg)

#### 深入理解Java虚拟机（第3版）| 周志明

> 浅显易懂。最重要的是开启一扇理解虚拟机的大门。
>
> 内存管理机制与Java内存模型、高效并发这三章是特别实用的。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9o0wpiwwtj308d0b3dil.jpg)



#### Java虚拟机规范（Java SE 8版）|爱飞翔、周志明

> 整本书就觉得第二章的方法字节码执行流程，第四章的前8节和第五章能看懂一些。其他的过于细致和琐碎了。
>
> 把Java字节码讲的很清楚了，本质上Java虚拟机就是通过字节码来构建的一套体系罢了。所以字节码说的非常细致深入。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9o11harv8j305807mgn5.jpg)



### 数据&大数据

#### 数据结构与算法分析|Data Structures and Algorithm Analysis in Java

> 数据结构是计算机的核心，这部书以java语言为基础，详细的介绍了基本数据结构、图、以及相关的排序、最短路径、最小生成树等问题。
>
> 但是有一些高级的数据结构并没有介绍，可以通过《数据结构与算法分析——C语言描述》来增加对这方面的了解。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9hbgso21qj30960dldo5.jpg)

#### MySQL必知必会

> 《MySQL必知必会》MySQL是世界上最受欢迎的数据库管理系统之一。
>
> 书中从介绍简单的数据检索开始，逐步深入一些复杂的内容，包括联结的使用、子查询、正则表达式和基于全文本的搜索、存储过程、游标、触发器、表约束，等等。通过重点突出的章节，条理清晰、系统而扼要地讲述了读者应该掌握的知识，使他们不经意间立刻功力大增。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9hl0x53imj30940cr43s.jpg)

#### 数据库系统概念|Datebase System Concepts(Fifth Edition)

> 从大学读到现在，每次拿起都有新的收获。而且这本书还是对各个数据相关领域的概览，不仅仅是数据库本身。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9hl29c07cj307o0b50yt.jpg)

#### 高性能MySQL

> 对于想要了解MySQL性能提升的人来说，这是一本不可多得的书。
>
> 书中没有各种提升性能的秘籍，而是深入问题的核心，详细的解释了每种提升性能的原理，从而可以使你四两拨千斤。授之于鱼不如授之于渔，这本书做到了。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9o16axv7cj305l06z400.jpg)

#### 高可用MySQL

> 很实用的书籍，只可惜公司现有的业务和数据量还没有达到需要实践书中知识的地步。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9o18npb1oj305906xt9q.jpg)

#### 利用Python进行数据分析|唐学韬

> 内容还是跟不上库的发展速度，建议结合里面讲的库的文档来看。
>
> 内容安排上我觉得还不错，作者是pandas的作者，所以对pandas的讲解和设计思路都讲得很清楚。除此以外，作者也是干过金融数据分析的，所以后面专门讲了时间序列和金融数据的分析。

![image-20191207121445898](https://tva1.sinaimg.cn/large/006tNbRwly1g9o1bg9xujj305606x0u4.jpg)

#### HBase

> 看完影印版第一遍，开始以为会是大量讲API，实际上除了没有将HBase源代码，该讲的都讲了，CH8，9章留到最后看的，确实有点顿悟的感觉，接下来需要系统的看一遍Client API，然后深入代码，Come ON！

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7byg8jtj306q090760.jpg)

#### Programming Hive

> Hive工具书，Hive高级特性。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7cxhoe8j305406wzl4.jpg)

#### Hadoop in Practice| Alex Holmes

> 感觉比action那本要强 像是cookbook类型的 整个过完以后hadoop生态圈的各种都接触到了 这本书适合当参考手册用。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7e3axckj305g06pq3z.jpg)

#### Hadoop技术内幕|董西成

> 其实国人能写这样的书，感觉还是不错的，不过感觉很多东西不太深入，感觉在深入之前，和先有整体，带着整体做深入会更好一点， jobclient,jobtracer,tasktracer之间的关系最好能系统化

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7rcs59oj305c064q3s.jpg)

#### Learning Spark

> 很不错，core的原理部分和api用途解释得很清楚，以前看文档和代码理解不了的地方豁然开朗。
>
> 不足的地方是后几章比较弱，mllib方面没有深入讲实现原理。graphx也没有涉及

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7g4tl5pj3057070wfv.jpg)

#### ODPS权威指南

> 基本上还算一本不错的入门，虽然细节方面谈的不多，底层也不够深入，但毕竟是少有的ODPS书籍，且覆盖面很全，例子也还行。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7in91wfj30a20crjtl.jpg)

#### 数据之巅|徐子沛

> 从一个新的视角（数据）切入，写美国历史，统计学的发展贯穿其中，草蛇灰线，伏脉千里，读起来波澜壮阔。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9o1e6dkcaj305706xwh2.jpg)

### 消息队列&Redis

#### RabbitMQ实战

> 很多年前的书了，书中的例子现在已经不适用了，推荐官方教程。
>
> 一些基础还是适用，网上也没有太多讲rab的书籍，将就看下也行，我没用过所以....

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p62utv9aj305s07l0v6.jpg)

#### Apache Kafka源码剖析|徐郡明

> 虽然还没看，但知道应该不差。我是看了作者的mybatis源码分析，再来看这本的，相信作者。
>
> 作者怎么有这么多时间，把框架研究的这么透彻，佩服，佩服。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p640006rj308a0ax407.jpg)

#### 深入理解Kafka：核心设计与实践原理|朱忠华

> 通俗易懂，图文并茂，用了很多图和示例讲解kafka的架构，从宏观入手，再讲到细节，比较好，值得推荐。
>
> 深入理解Kafka是市面上讲解Kafka核心原理最透彻的，全书都是挑了kafka最核心的细节在讲比如分区副本选举、分区从分配、kafka数据存储结构、时间轮、我认为是目前kafka相关书籍里最好的一本。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7pk3qbyj30ag0cvju8.jpg)

#### Kafka

> 认真刷了 kafka internal 那章，看了个talk，算是入了个门。
>
> 系统设计真是门艺术。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p65doei8j306007ztaa.jpg)

#### RocketMQ实战与原理解析|杨开元

> 对RocketMQ的脉络做了一个大概的说明吧，深入细节的东西还是需要自己看代码

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p6723irlj309x0citaz.jpg)

#### Redis设计与实现|黄健宏

> 部分内容写得比较啰嗦，当然往好了说是对新手友好，不厌其烦地分析细节，但也让整本书变厚了😂，个人以为精炼语言可以减少20%的内容。
>
> 对于有心一窥redis实现原理的读者来说，本书展露了足够丰富的内容和细节，却不至于让冗长的实现代码吓跑读者——伪代码的意义在此。下一步是真正读源码了。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7jmsinsj309f0d5acg.jpg)

#### Redis 深度历险：核心原理与应用实践|钱文品

> 真心不错，数据结构原理+实际应用+单线程模型+集群（sentinel, codis, redis cluster）, 分布式锁等等讲的都十分透彻。
>
> 一本书的作用不就是系统性梳理，为读者打开一扇窗，读者想了解更多，可以自己通过这扇窗去Google。这本书的一个瑕疵是最后一章吧，写的仓促了。不过瑕不掩瑜。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7n1yg9qj30860aoace.jpg)

### 技术综合

#### TCP/IP详解 卷1：协议

> 读专业性书籍是一件很枯燥的事，我的建议就是把它作为一本手册，先浏览一遍，遇到问题再去详细查，高效。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p75y7qd2j306408kgof.jpg)

#### Netty in Action

> 涉及到很多专业名词新概念看英文原版顺畅得多，第十五章 Choosing the right thread model 真是写得太好了。另外结合Ron Hitchens 写的《JAVA NIO》一起看对理解JAVA NIO和Netty还是很有帮助的

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p795bqicj305c06r0ue.jpg)

#### ZooKeeper

> 值得使用zookeeper的人员阅读, 对于zookeeper的内部机制及api进行了很详细的讲解, 后半部分深入地讲解了zookeeper中ensemble互相协作的流程, 及group等高级配置, 对zookeeper的高级应用及其它类似系统的设计都很有借鉴意义.

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7a3ko6uj306d08dgn8.jpg)

#### 从Paxos到Zookeeper|倪超

> 分布式入门鼻祖，开始部分深入阐述cap和base理论，所有的分布式框架都是围绕这个理论的做平衡和取舍，中间 zk的原理、特性、实战也讲的非常清晰，同时讲cap理论在zk中是如何体现，更加深你对cap的理解.

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7w6kz33j304n06x411.jpg)

#### 深入理解Nginx（第2版）|陶辉

> 云里雾里的快速读了一遍，主要是读不懂，读完后的感受是设计的真好。
>
> 原本是抱着了解原理进而优化性能的想法来读的，却发现书中的内容都是讲源码，作者对源码的注释超级详细，非常适合开发者，但不适合使用者，给个五星好评是因为不想因为我这种菜鸡而埋没了高质量内容。
>
> 另外别人的代码写的真好看，即便是过程式语言程序也吊打我写的面向对象语言程序。
>
>
> 作者是zookeeper的活跃贡献者，而且是很资深的研究员，内容比较严谨而且较好的把握住了zk的精髓。书很薄，但是没有废话，选题是经过深思熟虑的。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9hl5674ysj30940cndi1.jpg)

#### 深入剖析Tomcat

> 本书深入剖析Tomcat 4和Tomcat 5中的每个组件，并揭示其内部工作原理。通过学习本书，你将可以自行开发Tomcat组件，或者扩展已有的组件。 Tomcat是目前比较流行的Web服务器之一。作为一个开源和小型的轻量级应用服务器，Tomcat 易于使用，便于部署，但Tomcat本身是一个非常复杂的系统，包含了很多功能模块。这些功能模块构成了Tomcat的核心结构。本书从最基本的HTTP请求开始，直至使用JMX技术管理Tomcat中的应用程序，逐一剖析Tomcat的基本功能模块，并配以示例代码，使读者可以逐步实现自己的Web服务器。

![image-20191201222250542](https://tva1.sinaimg.cn/large/006tNbRwly1g9hl6blywnj30a60d5aec.jpg)

#### 深入理解计算机系统 | 布莱恩特

> 无论是内容还是纸张印刷，都是满分。计算机学科的集大成之作。引导你如何练内功的，算是高配版本的计算机导论，目的是釜底抽薪引出来操作系统、组成原理这些专业核心的课程。帮助我们按图索骥，点亮一个一个技能树。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5go30knj305t07k41h.jpg)

#### 架构探险分布式服务框架 |  李业兵

> 刚看前几章的时候，心里满脑子想得都是这特么贴一整页pom文件代码上来干鸡毛，又是骗稿费的，买亏了买亏了，后来到序列化那章开始，诶？还有那么点意思啊。
>
> 到服务注册中心和服务通讯，60块钱的书钱已经赚回来了。
>
> 知识是无价的，如果能花几十块钱帮你扫了几个盲区，那就是赚了。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5465ts4j30820axmzd.jpg)

#### 深入分析JavaWeb技术内幕  |  许令波

> 与这本书相识大概是四年前是在老家的北方图书城里，当时看到目录的感觉是真的惊艳，对当时刚入行的自己来说，这简直就是为我量身定做的扫盲科普集啊。
>
> 但是可惜的是，这本书在后来却一直没机会读上。然后经过四年的打怪升级之后，这次的阅读体验依旧很好。
>
> 其中，java编译原理、 Servlet工作原理、 Tomcat、spring和iBatis这几章的收获很大。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p58vmtbgj305a06xq4a.jpg)

### 前端

#### jQuery 技术内幕| 高云

> 非常棒的一本书，大大降低了阅读jquery源码的难度（虽然还是非常难）。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p7t0px2oj305507kgn6.jpg)

#### Head First HTML与CSS（第2版）

> 翻了非常久的时间 断断续续 其实从头翻到尾 才发现一点都不难。
>
> 可我被自己的懒惰和畏难情绪给拖累了 简单说 我成了自己往前探索的负担。网页基础的语法基本都涵盖了 限于文本形态 知识点都没法像做题一样被反复地运用和复习到。通俗易懂 这不知算是多高的评价？
>
> 作为入门真心算不错了 如果更有耐心 在翻完 HTML 后 对 CSS 部分最好是可以迅速过一遍 找案例练习估计更好 纸上得来终觉浅 总是这样。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p82yw9h2j306206umza.jpg)

#### JavaScript高级程序设计（第3版）

> JavaScript最基础的书籍，要看认真，慢慢地看，累计接近1000小时吧。而且对象与继承，性能优化，HTML5 api由于没有实践或缺乏代码阅读量导致看的很糊涂，不过以后可以遇到时再翻翻，或者看更专业的书。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p84bb5nzj30a30d1475.jpg)

#### 深入理解ES6

> Zakas的又一部杰作，他的作品最优秀的地方在于只是阐述，很少评价，这在帮助我们夯实基础时十分有意义，我也喜欢这种风格。
>
> 我是中英文参照阅读的，译本后半部分有一些文字上的纰漏，但是总体来说忠实原文，水平还是相当不错，希望再版时可以修复这些文字问题。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p85sjtt2j305a06sgnh.jpg)

#### 高性能JavaScript

> 还是挺不错的。尤其是对初学者。总结了好多程序方面的好习惯。
>
> 不过对于老手来说，这些常识已经深入骨髓了。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p87g3d26j306706ymy8.jpg)

#### 深入浅出Node.js|朴灵

> 本书是我看到现在对Node.JS技术原理和应用实践阐述的最深入，也最全面的一本书。鉴于作者也是淘宝的一位工程师，在技术总是国外好的大环境下，没有理由不给本书五颗星。
>
> 作者秉着授人于鱼不如授人于渔的精神，细致入微的从V8虚拟机，内存管理，字符串与Buffer的应用，异步编程的思路和原理这些基础的角度来解释Node.JS是如何工作的，比起市面上众多教你如何安装node，用几个包编写一些示例来比，本书绝对让人受益匪浅。
>
> 认真看完本书，几乎可以让你从一个Node的外行进阶到专家的水平。赞！

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8cjo7t8j30a50cy0wx.jpg)

#### Vue跟React的技术栈的书不多，很多也是官方文档的照搬照抄，我觉得看官网吧哈哈。

### 非技术类

#### 失踪的孩子

> 整本书的能量太密集了，像一个源源不断喷发的火山，读完怅然若失。最后几页，莱农从时间中回望，生命的真相被自己毫不留情的剖白，而即使是这样的时刻，她依然能再次在对莉拉的爱和嫉妒中被激发开始进行她最为重要、最可能留在时间之中的作品的创作，如此的勇气，诚实和坚韧……反正我已经喜欢她了。
>
> 而莉拉依然是个迷。她和莱农是相反的人，莱农会攫住一切填充自己，去成为，但莉拉对任何事情的投入都不会滋养自身，而是燃烧掉自己的一部分。
>
> 她的激情，超越一切的理解和视野与她的情绪化，她的恐惧，都让人困惑。莉拉是所有人的镜子，任何人在她面前都不得不面对自己；同时，是不是没有人，或者说莉拉没有允许任何人了解她？因为她在与外界和自己的对抗中也未能真正看见自己？

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9hb6zxcnrj309a0dvdmf.jpg)



#### 人生|路遥

> 想着和平凡的世界一个调子，都是乡村，都是文革的尾巴，都是那点家长里短绝对真实。
>
> 我总觉得那是作者的真实写照，一切都是从自己的记忆中提炼出来的故事。
>
> 只不过根据高加林我总在思考劳动人民是否应该有文化，有文化了以后就开始痛苦，开始怀春悲秋，开始事逼，开始怨天尤人。
>
> 知识分子那些臭毛病显露无疑。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p4zwk1hkj304r06o74x.jpg)



#### 丝绸之路  |  彼得·弗兰科潘



> 书的颜值很高，厚厚的大开本，包装和纸张都不枉自己百元大洋。书名虽叫【丝绸之路】，但是读后发现其实是以中东为针，一路串起亚欧大陆各个文明两千多年间所发生的故事。
>
> 从史实、文化、宗教、政治、权力、金钱等多方面论述了以中亚和欧洲为主的发展史，信息量非常的大。每个章节的标题都用四个字直接道出当前世界的核心驱动，比如基督之路、铁蹄之路、西欧之路、纳粹之路、争霸之路。
>
> 视野广阔，大开大合，时间跨度可算是穿越千年中东。美中不足的是，中国作为丝绸之路东段上最为重要的国家，描述的篇幅却很少。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p523axbhj308w0d3gxt.jpg)

#### 我的天才女友  |  埃莱娜·费兰特

> 来自意大利作家的小说，“那不勒斯”四部曲的第1部，讲述了两个女主人公莉拉和埃莱娜的少女时代。
>
> 相比七月与安生，跨度更大，情节也要丰富很多，但是作为一个男性阅读角度似乎get不到小说所评价那样优秀的点，代入感很好，时间已经过去好久，现在留在记忆中的还是如西西里的美丽传说般暖色调的意大利小镇上有两个小女生在平淡的生活。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p52yzal1j308i0cujvr.jpg)



#### 长安十二时辰  |  马伯庸

> 开年第一单，阅读体验非常的好，完全是美国个人主义英雄大片的大唐版，而主人公张小敬身上却有着更多的坚忍和矛盾，中间有个片段，讲檀棋在元宵灯会的街上跟着张小敬，在万千盏灯笼一齐高高烛起，光彩明耀，火树银花中，看张小敬的背影显得很是落寞。
>
> 读完之后，这一幕仍然记忆犹新，靠整个故事的支撑，这一幕真的完全可以体会到落寞二字。
>
> 书中很认真的说了一些长安的城建和大唐的民俗，管制，可以看出来为了写出这本书，亲王的确是花费了不少心思的，很佩服。
>
> 一本非常非常适合改编成电影的小说（事实上也的确正在拍摄），值得推荐。
>
> ps：2019年同名电视剧已经上线了…

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p55k5ae1j305x088tbb.jpg)

#### 布谷鸟的呼唤  |  J·K·罗琳

> 大概三年前买的，今年回家整理新书架的时候发现了它，就带回杭州了。
>
> 故事情节比不上哈利波特，但是文笔是真的没得说，毕竟是能写出来哈利波特的人。
>
> 作为推理小说，怕是不及格，但是把它作为犯罪小说之类的非类型小说来看的话，其实阅读体验还是可以的。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p570nyqlj304906c0ut.jpg)

#### 欧洲：1453年以来的争霸之路  |  布伦丹·西姆斯

> 自文艺复兴之后，欧洲开始渐渐的走进地球文明的舞台正中心。
>
> 读到中间德意志民族的内政被周边国家的各种干涉，感觉德国和我们的兔子一样，是个多难的民族，所以统一之后思想家才会这么多，一战二战的德国，如果用兔子的一句话概括，我们走了一些弯路。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p57r7m8bj305106vab6.jpg)



#### 房思琪的初恋乐园 | 林奕含

> 正如文前李银河所说，林奕含属于老天爷赏口饭的那种人，非常有才华的、有灵气的一位年轻作者。我们应当感激，不用亲身经历，就可以看到世界的背面，难以想象出林每次去回忆，然后再去一步一步的描述出当时的心理活动，此间的痛苦。
>
> 最后，书中的话：忍耐不是美德，把忍耐当成美德是这个伪善的世界维持它扭曲的秩序的方式，生气才是美德。

![image-20191208111703561](https://tva1.sinaimg.cn/large/006tNbRwly1g9p59q27ptj308v0d1goe.jpg)

#### 毛泽东传  |  迪克·威尔逊

> 来自英国人的传记，可以当做记事表，而且就算有一些主观评价在里面，作为外国人难免有偏差，也不可信，毛公当称之为我等民族力挽狂澜第一人。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5a4lrkoj30930cvq6k.jpg)

#### 半小时漫画世界史  |  陈磊

> 和上一本中国史一样，阅读体验很轻松，如果是对这段历史毫无概念的话，真的砸墙推荐。但是如果是要有了一定的知识储备的话，那就没啥意思了，半小时也别指望能讲多深了。
>
> 巴黎和罗马真的是太值得去一次的了。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5akzxwcj305q080ju1.jpg)



#### 欧洲现代史：从文艺复兴到现在  |  约翰·梅里曼

> 耶鲁大学历史教授的课堂讲义，采用的是国别和编年混合风格，顺着历史发展的脉络逐一展开，又不失相互关联性，而不是简简单单的说几几年发生了什么，几月几日谁谁谁死了这些。
>
> 5个世纪中葡萄牙西班牙瑞典荷兰法国轮流崛起，俄国西化，德国统一，英国宗教改革，奥地利波兰土耳其相继衰落，文艺复兴，启蒙运动，航海时代，工业革命，世界大战，美苏冷战。
>
> 维多利亚女王拿破仑一世路易十四彼得大帝叶卡捷琳娜俾斯麦希特勒丘吉尔，当称人类群星闪耀时。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8gzwznxj308k0cxgur.jpg)

#### 爱德华•巴纳德的堕落：毛姆短篇小说集1 |  毛姆

> 屯了毛姆这么多书，这次才是第一次看。
>
> 书的纸张倒是很有意思，600多页，却很轻。故事读起来倒像是个老朋友再和你讲故事，叨叨叨的从夏威夷讲到南美洲，又从西海岸讲到东南亚，讲故事的水平非常的高，几乎都是几段字下来，就把人带到了故事场景中。最喜欢的两篇是爱德华•巴纳德的堕落，赴宴之前，和最后的译后记。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8hfbpmwj30910d3q62.jpg)

#### 一句顶一万句 | 刘震云

> 第八届茅盾文学奖获奖作品，叙事架构犹如一生二二生三三生万物绵绵不绝扩散开来，薄薄三百页，前后一百年，初看时以为《平凡的世界》，结局才发现是《百年孤独》，“生活是过以后，而不是过从前”。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5f2o019j30880c977w.jpg)

#### 生活的艺术家  |  李小龙

> 来自李小龙的一本散文集，是的，就是那个李小龙。
>
> 很难想到那个在电影里面喊着啊哒~的他，大学是专修哲学的。书中的文章大都是对于生活和哲学的思考，可以看到那个在大荧幕前面一秒五踢啊哒啊哒的背后，是一个冷静、理性、智慧、通达的李小龙。“我无法教你什么，只能帮助你探求你自己。除此之外，别无他法。”

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5fhyndzj30960d0jv0.jpg)

#### 穷查理宝典 | 查理芒格

> 查理芒格的思想集和演讲稿编，知识面跨学科，洞察力才能足够深，包括数学、物理、生物、历史、经济等这些硬学科，从而形成一个多学科的思维框架。
>
> 致富也不只是赚了多少钱那么简单，而是在道德品质、阅读能力和个人生活上全面提升的过程。应该专注于正在做的事情，多阅读，特别是传记，来和“伟人”交朋友，减少物欲，满足自己已经拥有的，不嫉妒别人。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5g0q0xrj308x0cu790.jpg)





#### 汉密尔顿传 | 罗恩·切诺

> 我只能说汉密尔顿，这个被印在美元上的人，人生只能用精彩至极来形容了。
>
> 书中详细介绍了汉密尔顿在独立战争、费城制宪、宪法批准、首届国会以及建国初期等不同历史阶段中发挥的巨大作用，尤其是建国之初，在一切都没有先例的情况下，汉密尔顿为奠定美国联邦的政治体制、经济秩序和金融体系做出了巨大的贡献——建立美国信用体系，建立联邦银行，建立联邦税收体系，建立海关，建立海岸警卫队，以及促进制造业发展等。
>
> 在这本波澜壮阔的自传的最后，本以为能写上一大段对他的盖棺定论，然而却很平淡随意的用他写给艾丽萨的一封信作为了结尾，可能是不再需要作者去告诉书前的人他该如何评价，历史已经给出了答案。
>
> “艾丽萨，你治愈了我此生因爱而生的伤痛。”

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5h41987j308r0d4jxn.jpg)

#### 百年孤独|加西亚·马尔克斯

> 久负盛名的大作，读完只能说，果然只有这种书才配得上诺奖。
>
> 先前看《霍乱时期的爱情》，印象最深的就是华丽魔幻文笔和细腻的心理活动描写，到这本《百年孤独》，震撼的目瞪口呆，怎么能有人写得出这样的小说。
>
> 只能说，无论怎么列必读书籍，都绕不开此书。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9payh7k2gj304w06zjtm.jpg)

#### 月亮与六便士

> 毛大爷名气最具盛名的一本书，很易读的文学作品。
>
> 全篇小说都是从第一人称“我”的角度，对斯特里克兰德进行了主观的描写，从斯特里克兰德开始离家出走开始渐入佳境，毛姆在环球旅行中写作，以至于场景地点的代入感都非常强，带着读者登上塔希提岛上，在酒馆里和众人逐个聊起斯特里克兰德，“我”和读者一起，在一来一去的谈话中，了解到了这个天才最后的经历。后半生穷困潦倒的他在死的时候，肯定不会知道自己在死后的一个世纪，被称之为天才，画作也被收藏在美术馆作为镇馆之宝，流传百年。但他是自由的，没有遗憾的。
>
> 最后引用一段话，“只要在我的生活中能有变迁——变迁和无法预见的刺激，**我是准备踏上怪石嶙峋的山崖，奔赴暗礁遍布的海滩的**。”

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9pazz9ps7j305d08fabf.jpg)

#### 股票作手回忆录|杰西·利弗莫尔

> 被誉为百年美股第一人，杰西·利弗莫尔的自传，五美元起家，到日赚一亿美金的投机之路，可以看到利弗莫尔在小的时候就对数字有着非常人的敏感和对波动线的记忆力，十多岁只身一人远走纽约，更见其杀伐果断之气。全书并没有讲操作细节，但是传主的做事风格很值得研究，时机、独立思考、判断、知错能改、以及鳄鱼般的耐心。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9pb22853bj307h0avjw3.jpg)

#### 万历十五年 | 黄仁宇

> 一本表面上写历史，却涵盖当时的政治、经济、社会民俗、当世思想的大作，对中国历史上诸多王朝暗流下那道潜规则的分析和批判。格局之大，立意之高，实属罕见。
>
> 读罢全书，我们明白明王朝的覆灭是必然的，而后的满清，只不过是改朝换代，骨子里与前朝无异，灭亡也是迟早的。
>
> 我们的身上被锁住了一个牢固的枷锁，丢在泥坑，都在挣扎，越来越烂。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5hlkzacj306q0a678y.jpg)

#### 第五项修炼| 彼得·圣吉

> 前半部分理论，后半部分讲实战。捞干的来说，大局观的系统思考能力、增长极限和转移负担的自我超越能力、正向暗示的心智能力，拓展认知边界建立跨学科的思维架构能力。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9paqbo315j307o0aegq9.jpg)

#### 海边的卡夫卡|村上春树

> 卡夫卡，舒伯特，艾希曼，琼尼沃克，乌鸦少年，短毛猫语，竹筴鱼雨，肠子迷宫，夏目漱石，雨月物语，俄狄浦斯。在这个世界上，不单调的东西让人很快厌倦，不让人厌倦的大多是单调的东西。
>
> 我的人生可以有把玩单调的时间，但没有忍受厌倦的余地,而大部分人分不出二者的差别。
>
> 孤独因你本身而千变万化。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8j94vu8j305l080tau.jpg)

#### 白夜行|东野圭吾

> 把小说写成这样绝对是开挂了吧，除了连番登场的几十号人物，随处雕琢的大时代的背景也让人叹为观止。对人性的挖掘比起吉田修一还是弱一些，就是纯好看，从第一句开始吸住你逐渐往往里掉。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8lcl2kjj308v0cjta5.jpg)

#### 嫌疑人X的献身|东野圭吾

> 这个社会 每一个人都是时钟上的齿轮，为了自己的意愿，也不该牺牲掉他人，哪怕那是出于爱，一个错误尚且为错，付出更大的努力用更大错误也扭转不了的，
>
> 这毕竟不是数学的负负得正，逻辑之所以没法解决罪恶的问题，只因为最初就规避了人性。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8mu1j9ij303v05wq3o.jpg)

#### 追风筝的人|卡勒德·胡赛尼

> 为什么忠诚善良的人反而遭到这样的结局，面对阿米尔的污蔑，他和阿里选择离去。
>
> 当房屋需要他时，他又毅然决然的选择坚守，为了阿米尔能够得到父亲的赞许，哈桑却受到那样的凌辱，换来的却是懦弱的阿米尔的回避，身份，阶级，好可笑的头衔，生命与忠诚在那些虚无的名誉不值一提。
>
> 犹如草芥浮萍....

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8pkbzjzj30890ba449.jpg)



#### 恋情的终结 | 格雷厄姆

> 现在看的小说都不多了，而爱情小说更是少之又少，但幸运的是，这本和上一本霍乱时期的爱情一样，都是不可多得的大师之作。
>
> 小说情节简单来说就是爱上了个有妇之夫，然后阴差阳错私奔失败，接着分道扬镳直到多年之后的偶遇，最后女主患病而亡。
>
> 但文笔是真的细腻到不敢相信是个男人写的，书里穷尽了爱情中所有狂热的情感，狂热的爱，狂热的恨，狂热的猜疑，狂热的嫉妒，狂热的占有。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5i3ws6rj308w0cx433.jpg)

#### 龙族I-IV|江南

> 我十六岁的时候，看《缥缈录》，心中念着那个拿着虎牙枪的少年。
>
> 如今我二十三岁了，看《龙族》，面对一堆白烂中二的吐槽不知所措。
>
> 就像拿枪的少年穿起了风衣，救美的英雄接受了金币。我看着商业化写作对一个作者的侵蚀和改变，这让我觉得难过极了。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8rgagdzj307g0afwjl.jpg)

#### 三体I-Ⅲ|刘慈欣

> 《三体》就是那种让你在读完三部之后掩卷抬头，感觉眼中的世界都从此不一样了的书。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8vyqi5aj306t09s0xq.jpg)

#### 流浪地球|刘慈欣

>觉得文笔胜于三体，且惊觉是三体之前的作品。
>
>对于其中地球变轨后的生态变化仍存在疑惑，那段地球与木星擦肩表现力强,不错的作品。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p8x4x6grj306o09tn1b.jpg)

#### 全球通史

> 这种时间跨度如此之长的，有之前的《丝绸之路》和《人类简史》，但是无论是整体行文的架构、视野的宽度、以及分析思考的深度上来说，此书都要比这两本要优秀得多，尤其是到一战之前的部分。
>
> 幸亏之前大量零碎的知识点做背书，再遇此书建立整体体系，穿针引线，才有所体会到书前序中的"思接千载，视通万里"之感。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5ikz4iqj305d06emyk.jpg)

#### 程序员的自我修养|俞甲子 / 石凡 / 潘爱民

> 讲的不错，将硬件与系统、机器层与实现层整合了起来，有了一个很清晰的视角。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5yfbt7nj3062081q5e.jpg)

#### 颈椎病康复指南|董晓俊

> 出来打工不容易，大家照顾好自己。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p9d2xa3fj304v06pwgh.jpg)

#### 活着|余华

> 为啥安利这个，大家懂就好了

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p5vdln2rj306a09h0u9.jpg)

#### 我们一无所有|安东尼·马拉

> 艺术让我们不因真实而亡故，结构相当特别，像是在看电影。
>
> 讲述从苏联联邦到新俄罗斯近80年历史车轮下一些动人心魄的小人物微尘。
>
> 语言克制、平静，读来却十分疼痛，或是戏谑嘲讽像是苦中求乐，非常喜欢。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p92czed3j30930cxtdg.jpg)

### 总结

其实我觉得在我们现在这个浮躁的社会，大家闲暇时间都是刷抖音，逛淘宝，微博......他们都在一点点吞噬你的碎片时间，如果你尝试着去用碎片的时间看看书，我想时间久了你自然能体会这样的好处。

美团技术团队甚至会奖励读完一些书本的人，很多公司都有自己的小图书馆，我觉得挺好的。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p9ws50vbj309w02smx9.jpg)

我现在也认识很多作者，像程序员小灰，老钱这样的作者，都很不错，如果未来自己能达到写作的条件的话我也想写哈哈。

至于我为啥不敢懈怠......三歪（java3y作者）在我对面我真的不敢有丝毫放松，每次闲暇之余我准备拿起手机玩耍的时候，看到他在看书，我默默的放下手机，就是这样的人在不断鞭笞着我。

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9p9inda6cj30ci0bk3zp.jpg)

### 鸣谢

自己技术群的小伙伴：很多书籍我没写进去，主要是记录被刷走太多了，我让大家私聊，结果都发群里了，我就懒得整理了，主要是没书评我没看过也不敢写。

豆瓣小伙伴：很多我没有的书籍我都是找的豆瓣书评。

阿里技术团队的小伙伴：文章有很多书评都是来自他。

博文视点：对文末抽奖的赞助

**其实很多好书我都没写到，一时想不到，大家有喜欢的也留言让更多朋友看到嘛，我有空会修改文章。**

**还有就是本文主要的目的不是安利多少书，主要是想大家放下手机翻开你在角落积灰的书籍，你会发现里面有光的。**

这周双十二有点小忙，年会的事情也紧锣密鼓的筹备着，我下周要是鸽了那......

### 抽书！！！

#### 书名：Java系统性能优化实战

![](https://tva1.sinaimg.cn/large/006tNbRwly1g9rvg6ddgyj30b20ey76x.jpg)

个人推荐理由：

- 20多个优化技巧：说明Java性能优化的各种方法。

- 30多个具有“坏味道”的代码片段：实战演练优化技巧。

- 常用的高性能工具：以Caffeine、Jackson、HikariCP为例进行讲解，并对其高性能的原因做一定的源码解析。

- 容易阅读的代码：从代码注释、代码分解和面向对象三方面讲解如何编写容易阅读的代码。

#### 规则：

抽两本，公众号「**三太子敖丙**」这个文章下面留言点赞排名前两位送两本，截止本周我发周报之前，公众号和掘金周六我会写周报。

觉得概率不大？

**月底会有一个文章抽30本书**，至于送啥书，贫穷的我得好好想想。



## 点关注，不迷路

好了各位，以上就是这篇文章的全部内容了，能看到这里的人呀，都是**人才**。

我后面会每周都更新几篇一线互联网大厂面试和常用技术栈相关的文章，非常感谢**人才**们能看到这里，如果这个文章写得还不错，觉得「敖丙」我**有点东西**的话   **求点赞👍** **求关注❤️**  **求分享👥**  对暖男我来说真的 **非常有用**！！！

创作不易，各位的支持和认可，就是我创作的最大动力，我们下篇文章见！

敖丙 | 文  【原创】

如果本篇博客有任何错误，请批评指教，不胜感激 ！

------

> 文章每周持续更新，可以微信搜索「 **三太子敖丙** 」第一时间阅读和催更（比博客早一到两篇哟），本文 **GitHub** [https://github.com/JavaFamily](https://github.com/AobingJava/JavaFamily) 已经收录，有一线大厂面试点思维导图，也整理了很多我的文档，欢迎Star和完善，大家面试可以参照考点复习，希望我们一起有点东西。
