# गिटहब कोड वॉल्ट की मार्गदर्शिका

## परिचय

इस पुरालेख को, यानी गिटहब कोड वॉल्ट को, गिटहब पुरालेख कार्यक्रम द्वारा स्थापित किया गया है। इसका उद्देश्य है, भावी पीढ़ियों के लिए मुक्त स्रोत वाले सॉफ्टवेयर को परिरक्षित करना। आप इसे अबसे एक साल बाद पढ़ रहे हो सकते हैं, या एक हज़ार साल बाद, पर दोनों स्थिति में हम आशा करते हैं कि इसकी सामग्री, और शायद मुक्त स्रोत वाली अवधारणा ही, आपको उपयोगी प्रतीत होगी।

यह मुख्य रूप से सॉफ्टवेयर का पुरालेखागार है। सॉफ्टवेयर आदेशों का एक क्रम है, जिसे कंप्यूटर के कार्यों को नियंत्रित करने के लिए उपयोग किया जाता है। कंप्यूटर एक ऐसा उपकरण है जो गणितीय गणनाओं को मानव-मस्तिष्क से कहीं अधिक तेजी से अपने-आप पूरा कर सकता है, इसलिए उसमें हमसे कहीं ज्यादा ताकत है। हमारे कंप्यूटरों का उपयोग कुछ इस तरह के कामों में किया जाता है - ब्रह्मांड के रहस्यों का उद्घाटन करने के लिए; समस्त मानव-जाति को सदा मौजूद रहने वाली जानकारियों के एक जाल द्वारा जोड़ने के लिए; सिग्नलों में इतनी तेजी से फेर-बदल करने के लिए कि उसके जरिए ध्वनि का प्रसारण हो सके और विस्तृत चलायमान छवियों को इलेक्ट्रॉनी पर्दों पर प्रोजेक्ट किया जा सके; और अति-विशाल यंत्रों को नियंत्रित करने के लिए, जिनकी क्षमता और सटीकता मानव-श्रम से कहीं अधिक होती है।

बिना सॉफ्टवेयर के कंप्यूटर उपर्युक्त में से कोई भी कार्य नहीं कर सकता है। कंप्यूटर एक असाधारण और अद्भुत चीज है, लेकिन बिना सॉफ्टवेयर के उसकी सारी ताकत व्यर्थ हो जाती है। इस पुरालेख का उद्देश्य, सॉफ्टवेयर के बारे में हम जो कुछ भी जानते हैं, उसे आपको सौंपना है।

सॉफ्टवेयर को एक जटिल किंतु मनुष्य द्वारा पढ़े जा सकने योग्य आदेशों के रूप में लिखा जाता है। इसकी विभिन्न शैलियों को प्रोग्रामन भाषाएँ कहा जाता है, क्योंकि सॉफ्टवेयर के एक अखंड अंश को अक्सर प्रोग्राम कहा जाता है। इन प्रोग्रामों को इसके बाद कंप्यूटरों द्वारा उपयोग किए जाने वाले एक और शून्य वाली बाइनेरी भाषा में बदला जाता है। इस प्रक्रिया को संकलन कहते हैं।

चूँकि इस संकलित सॉफ्टवेयर को पढ़कर उससे मूल प्रोग्राम (जिसे सो्र्स कोड भी कहते हैं) के रूप में बदलना कठिन होता है, इसलिए लोगों के लिए इस मूल रूप को गुप्त रखना और उस पर स्वामित्व का दावा करना संभव होता है। मुक्त स्रोत सॉफ्टवेयर कोई अलग प्रकार का सॉफ्टवेयर नहीं है, बस उसकी मूल धारणाएँ भिन्न हैं। मुक्त स्रोत गोपनीयता और स्वामित्व की धारणाओं को अस्वीकार करता है। मुक्त स्रोत सॉफ्टवेयर प्रोग्रामों को उन सबके लिए सुलभ कर दिया जाता है, जो सब उसका उपयोग करना चाहते हैं, और वह भी मुफ्त में, ताकि वे आगे इन प्रोग्रामों में और सुधार कर सकें, या इनका उपयोग करके कोई नई और बेहतर चीज बना सकें।

मुक्त स्रोत परियोजना एक सामूहिक प्रयत्न होता जिसे स्वयं व्यवस्थित करने वला कोई समुदाय अंजाम देता है। इस समुदाय में हजारों लोग शामिल हो सकते हैं। यहाँ जिन सब मुक्त स्रोत सॉफ्टवेयर परियोजनाओं को उपलब्ध कराया जा रहा है, वह करोड़ों लोगों के समुदाय के प्रयत्नों का नतीजा है। हलाँकि किसी परियोजना में कुछ व्यक्तियों को विशेष अधिकार हो सकते हैं, जैसे उसके सोर्स कोड के अद्यतन संस्करण पर सुझाए गए परिवर्तनों को अनुमोदित करने या अस्वीकार करने का अधिकार, फिर भी कोई भी उसका स्वामी नहीं कहलाता है। हर व्यक्ति को कभी भी किसी भी मुक्त स्रोत परियोजना को लेने और उसकी संपूर्ण प्रतिलिपि का मुफ्त में और बिना किसी दंड के उपयोग करने का अधिकार है। इसे फॉर्किंग परियोजना कहते हैं।

जब एक समय में कई लोग किसी सोर्स कोड पर काम करते हैं, तब उनके द्वारा किए गए सभी परिवर्तनों का हिसाब रखना और उन्हें समेकित करना कठिन होता है। इस समस्या का समाधान करने वाली एक मुक्त स्रोत परियोजना का नाम 'गिट' है। यह किसी परियोजना में किए गए सभी इजाफों और परिवर्तनों के संपूर्ण इतिहास को गिट रेपोसिटरी नाम की एक ऐंटिटी में समेकित करता है। यह पुरालेख मूलतः ऐसी ही रेपोसिटरियों का पुरालेख है।

इस पुरालेख को 'गिटहब' नामक एक कंपनी ने बनाया है, जो विश्व भर के लोगों को उनके द्वारा लिखे गए सॉफ्टवेयर प्रोग्रामों को संग्रहित करने, इन प्रोग्रामों में किए गए परिवर्तनों का हिसाब रखने, और दूसरे लोगों के साथ सहयोग करके उनमें सुधार करने और उन्हें विस्तार देने में मदद करती है। गिटहब सार्वजनिक मुक्त स्रोत सॉफ्टवेयर बनाने वाले डेवलपरों को अपनी सेवाएँ मुफ्त में उपलब्ध कराता है। इसका उपयोग करने वालों की संख्या करोड़ों में है।

नीचे इसका वर्णन है कि इस सॉफ्टवेयर पुरालेख का सर्वोत्तम उपयोग करने के लिए हमारे विचार आपको क्या-क्या जानने की आवश्यकता है तथा आपके पास क्या-क्या सुविधाएँ होनी चाहिए। यदि आपको इस वर्णन के कुछ हिस्से समझ में नहीं आएँ, तो निराश मत होइए! इन सब आवश्यकताओं को पूरा करने में मदद करने वाली एक मार्गदर्शिका भी हमने शामिल की है। यदि किसी कारण से आप स्वयं इन जरूरतों को पूरा करने में समर्थ नहीं हो पाते हैं, तब आपकी आने वाली पीढ़ियाँ समर्थ हो सकती हैं।

## इस पुरालेख का उपयोग करने के लिए आपके पास क्या-क्या होना चाहिए

सिद्धांतः, इस पुरालेख की सामग्री तक पहुँचने के लिए आपको बस रोशनी और किसी तरह का आवर्धक की ही जरूरत पड़ेगी। लेकिन, इस डेटा के अधिकांश को (पर सबको नहीं) फिल्म की रीलों में कूटलेखित और संपीडित रूप से बहुत कसे हुए ढंग से पैक किया गया है। इस डेटा को पढ़ने, विकूटलेखित करने और विसंपीडित करने के लिए भी काफी कंप्यूटिंग क्षमता की आवश्यकता पड़ेगी। कहने को तो इसे कंप्यूटरों के बिना भी किया जा सकता है, लेकिन वह बहुत ही श्रम-साध्य और कठिन होगा।

हमारी अपेक्षा है कि आपको सॉफ्टवेयर, कंप्यूटर, और अन्य शब्दों की हमारी परिभाषाओं की आवश्यकता नहीं होगी। हम कल्पना करते हैं कि आपके पास आपके खुद के कंप्यूटर होंगे, जो हमारे कंप्यूटरों से कहीं ज्यादा उन्नत किस्म के होंगे और शायद उनका वास्तु भी मौलिक स्तर पर भिन्न होगा। जब आपने नीचे दी गई सूचनाओं और मार्गदर्शिका को समझ लिया हो, तब आप इस डेटा में आसानी से पहुँच सकेंगे।

लेकिन, यह भी हो सकता है कि आपके कंप्यूटर हमारे कंप्यूटरों जितने उन्नत नहीं हों, या आपके पास कंप्यूटर ही न हों। ऐसी स्थिति के लिए हमने, असंपीडित, अ-कूटलिखित, मनुष्यों द्वारा पढ़े जा सकने वाले डेटा का रील भी बनाया है, जिसे हम टेक ट्री कह रहे हैं। टेक ट्री में हमारी मूलभूत प्रौद्योगिकियों, हमारे कंप्यूटरों और हमारे सॉफ्टवेयर के बारे में जानकारी है, और वह आशा करता है कि कुछ समय में आप इस जानकारी का उपयोग करके ऐसे कंप्यूटर बना सकेंगे जो इस पुरालेख में मौजूद मुक्त स्रोत सॉफ्टवेयर का उपयोग कर सकेंगे।

## इसमें क्या है

यह पुरालेख इतना बड़ा -- लगभग 24 खरब बाइट (नीचे समझाया गया है) -- इसलिए है क्योंकि वह चरम स्तर तक समावेशी और लोकतांत्रिक है। कई लाख लोग उनके द्वारा लिखे गए सॉफ्टवेयर को सर्वसाधारण के लिए सुलभ कर देते हैं। इस पुरालेख में गिटहब के उपयोगकर्ताओं द्वारा सक्रिय रूप से विकसित किए जा रहे सभी सार्वजनिक सॉफ्टवेयर का एक स्नैपशॉट - अर्थात एक विशिष्ट समय पर उनकी एक प्रतिलिप -- शामिल की गई है। इसका मतलब है कि इसमें करोड़ों अलग-अलग रेपोसिटरियाँ हैं। हम आशा करते हैं कि यह विशद, लौकतांत्रिक पद्धति भविष्य के इतिहासकारों की रुचि का विषय बनेगी।

इस पुरालेख में शामिल की गई रेपोसिटरियों का निर्धारण शुद्ध रूप से उनके अंतिम कमिट समय के आधार पर, जिसका मतलब है वह समय जब उन्हें अंतिम बार अद्यतित किया गया था, तथा उनके स्टार गिनती के आधार पर किया गया है। (गिटहब के सभी उपयोगकर्ता सार्वजनिक रिपोसिटरियों को स्टार देकर यह सूचित कर सकते हैं कि वे उनकी रुचि के विषय हैं या वे उनके लिए महत्वपूर्ण हैं।) यह स्नैपशॉट 02/02/2020 को शुरू किया गया था, यानी जिस तरह हम समय की गणना करते हैं, उसके अनुसार ग्रिगोरियन कैलेंडर के 2020 वर्ष के फरवरी महीने के दूसरे दिन। इसमें ये सब रेपोसिटरियाँ शामिल की गई हैं: वे सभी रेपोसिटरियाँ जिन्हें पिछले 80 दिनों में कमिट किया गया था; वे सभी रेपोसिटरियाँ जिन्हें कम से कम 1 स्टार मिला है और जिन्हें पिछले 365 दिनों में कमिट किया गया था; और वे सभी रेपोसिटरियाँ जिन्हें कम से कम 250 स्टार मिले हैं, भलें ही उन्हें जब भी अद्यतित किया गया हो।

हाँ, यह नहीं कहा जा सकता कि ये सभी रेपोसिटरियाँ उनके प्रभाव और निर्भरताओं के हिसाब से बराबर महत्व की नहीं हैं। टेक ट्री में इस पुरालेख की सबसे अधिक महत्वपूर्ण रिपोसिटरियों की एक अनुक्रमणिका और संक्षिप्त विवरण भी शामिल किया गया है, और वह इसे भी सूचीबद्ध करता है कि प्रत्येक रिपोसिटरी किस रील में मिल सकती है, ताकि बिना करोड़ों रिपिसिटरियों में खोजे, अधिक उपयोगीऔर व्यावहारिक रिपोसिटरियों को ढूँढ़ा जा सके।

## पुरालेख का विहंगम-दृश्य

इस पुरालेख में फिल्म की 201 रील हैं: मनुष्य द्वारा पढ़ी जा सकने वाली सूचनाओं और मार्गदर्शन प्रदान करने वाली एक "मार्गदर्शक" रील, और पुरालेखित सॉफ्टवेयरों की 200 रीलें। प्रत्येक रील में 65,000 अलग-अलग फ्रेम हैं। प्रत्येक रील के प्रारंभ में जो फ्रेम हैं, उसमें और मार्गदर्शक रील के फ्रेमों में मनुष्य द्वारा पढ़ा जा सकने वाला पाठ और छवियाँ हैं। फिल्म के बाकी सभी फ्रेमों में क्यूआर कोड कहे जाने वाले दृश्यात्मक रूप में डिजिटल डेटा संग्रहित किया गया है।

डिजिटल डेटा वह डेटा है जो अंततः बाइनेरी संरूप में, यानी 0 और 1 के रूप में, संग्रहित है, क्योंकि कंप्यूटर स्वयं भी बाइनेरी हैं -- वे विद्युत सिग्नलों द्वारा नियंत्रित होते हैं, जो या तो "चालू" होती हैं, या "बंद", और ये ही 1 और 0 हैं -- इसलिए बाइनेरी डेटा को अन्य सभी प्रकार के डेटा की तुलना में कंप्यूटर बड़ी आसानी से समझ जाते हैं।

मनुष्य द्वारा पढ़े जा सकने वाले मेटाडेटा को प्रत्येक रील के शुरू में संग्रहित किया गया है, और इसमें स्वयं उस फिल्म के बारे में जानकारी, उपयोग किए गए क्यूआर कोड के लिए एक मार्गदर्शिका, उसे विकूटलेखित करने के लिए एक सॉफ्टवेयर प्रोग्राम और एक अनुक्रमणिका है। अनुक्रमणिका में शीर्षक, प्रारंभिक फ्रेम की संख्या और उस रील में संग्रहित प्रत्येक फाइल का चेकसम रहता है।

फाइल एक अखंड डेटा ऐंटिटी है। चेकसम एक अद्वितीय मान है, जो हैश फंक्शन कहे जाने वाली एक परिगणना का फल है, जिसे उस पूरी फाइली की सामग्री पर चलाया जाता है, और इससे यह सुनिश्चित होता है कि फाइल की सामग्री क्षतिग्रस्त या भ्रष्ट नहीं हुई है। इस पुरालेख में उपयोग किए गए हैश फंक्शन को 'एसएचए-1' कहा जाता है।

प्रत्येक क्यूआर कोड में बहुत छोटे-छोटे सफेद या काले वर्गों का एक क्षेत्र होता है, जो फिल्म के प्रत्येक फ्रेम को लगभग पूरा-पूरा भरता है। हम क्यूआर कोडों का उपयोग इसलिए कर रहे हैं क्योंकि वह मनुष्यों द्वारा पढ़े जा सकने वाले पाठ से अधिक सुगठित और टिकाऊ होता है। क्यूआर कोड को विकूटलेखित करने पर बाइनेरी डेटा प्राप्त होता है, यानी एक और शून्य अंकों की शृंखला।

यह विकोडिंग बाइनेरी डेटा को अर्थपूर्ण सूचनाओं में बदलने का प्रथम चरण मात्र है। यह संपीडित डेटा है, जिसका मतलब है कि जगह बचाने के लिए उसे संपीडित किया गया है, कुछ-कुछ वैसे ही जैसे कोई ए अक्षर को 128 बार लिखने के बजाय "128 x ए" लिख दे। विकोडित करने के बाद, उसे विसंपीडित भी करना होगा।

विसंपडन से जो प्राप्त होगा, उसे एक पुरालेख फाइल कहा जाएगा: एक अकेली फाइल जिसमें किसी एक सॉफ्टवेयर परियोजना की रिपोसिटरी की संपूर्ण सामग्री रहती है। कई रेपोसिटरियों में कई फाइलें रहती हैं, इसलिए यह पुरालेख फाइल एक पुस्तक के समान है, जिसमें अनेक अलग-अलग अध्याय होते हैं, या किसी बक्से के समान जिसमें कई बक्से हों। सामान्यतः इस पुरालेख फाइल को एक्सेस करने से पहले उसके घटक फाइलों में खोल लेना लाभदायक होता है, हालाँकि यह नितांत आवश्यक भी नहीं है।

और अंत में, प्रत्येक घटक फाइल की अपना खुद का बाइनेरी डेटा होता है, यानी एक और शून्यों की शृंखला। यदि आपको डेटा के संरूप की जानकारी हो, तो आप उसे समझ सकते हैं। मसलन, 'यूटीएफ-8' कहे जाने वाले संरूप में, जो इस पुरालेख की सबसे सामान्य संरूप है, एक और शून्यों को आठ-आठ के समूहों में बाँटा गया है, जिसे बाइट कहा जाता है, 01000001 यह बाइट अँग्रेजी का A वर्ण है;  01101001 01101110 01110100 ये तीन बाइट int यह शब्द है; और 11000011 10000011 यह Ã वर्ण है (यानी वह वर्ण जिसमें A के ऊपर टिल्डे एसेंट नामक चिह्न होता है)।

डेटा को पुरालेखित करने की यह प्रक्रिया, यानी बाइनरी फाइलों को संपीडित और क्यूआर कोडित करके पुरालेख फाइलों में पैक करना, मनुष्यों द्वारा पढ़े जा सकने वाले पाठ की तुलना में बेशक जटिल है। विपुरालेखित करने की प्रक्रिया भी -- क्यूआर से संपीडित बाइनेरी; संपीडित से विसंपीडित; एक पुरालेख फाइल से अनेक फाइलें; पाठ फाइलों से मनुष्य द्वारा पढ़ा जा सकने वाला पाठ -- इसी तरह जटिल है। यह इसलिए है कि इस जटिलता के कारण हम अपेक्षाकृत सरलता के साथ कंप्यूटर द्वारा पढ़े जा सकने वाले रूप में अतिविशाल डेटा को संग्रहित कर पाते हैं, जो अन्यथा संभव नहीं हो पाता।

यदि यह जटिलता आपके लिए कठिन और व्यय-साध्य है, तो हम क्षमा चाहते हैं, पर हमारी अपेक्षा यह है कि यदि ऐसा हो, तो यह मार्गदर्शिका और मनुष्य द्वारा पढ़े जाने के योग्य टेक ट्री, इस जटिलता को थोड़ा कम करने में मदद करेंगे, और शायद वह आपको पुरालेखित सामग्री से अधिक उपयोगी रहे, कम से कम तब तक जब तक आपके कंप्यूटर इतने उन्नत नहीं हो जाते हैं कि वे पुरालेखित डेटा की जटिलता को आसानी से सँभाल सकें।

## फाइलें, निर्देशिकाएँ, रेपोसिटरियाँ, और डेटा संरूप

यह जानना लाभदाय हो सकता है कि पुरालेख को तर्क-संगत रीति से कैसे बाँटा गया है। विशेषकर, फाइलों, निर्देशिकाओं और डेटा संरूपों की चर्चा उपयोगी रहेगी।

फाइल एक सुसंगत ऐंटिटी में समूहित डेटा का संग्रह है, जिसका कोई एक नाम होता है: इस तरह से समझें कि डेटा रेत है, और फाइल वह बोरी है जिसमें रेत रखा हुआ है, और उस बोरी में केवल रेत ही रखा गया है। निर्देशिका फाइलों का समूह है: इसे इस तरह से समझें कि वह कोई थैली है, जिसमें केवल दूसरी थैलियाँ रखी जा सकती हैं। इस उपमा को आगे बढ़ाते हुए, हर रेपोसिटरी में एक बाहरी निर्देशिका होती है, जिसे मूल निर्देशिका कहा जाता है, और उसमें कई फाइलें और/या निर्देशिकाएँ रहती हैं। प्रत्येक निर्देशिका में फाइलें भी हो सकती हैं और दूसरी निर्देशिकाएँ भी।

यह संरचना बेहतर है क्योंकि समूहों में व्यवस्थित फाइलों के साथ काम करना सभी फाइलों के केवल एक समूह के साथ काम करने की तुलना में अधिक आसान है। बाहरी निर्देशिका में मौजूद किसी फाइल का अभिनिर्धारक मूल निर्देशिका से शुरू करते हुए उन सभी समावेशी निर्देशिकाओं के नामों से बना होता है, और अंत में स्वयं उस व्यक्तिगत फाइल का नाम रहता है, प्रत्येक नाम को / इस वर्ण से अलगाया जाता है। उदाहरण के लिए, मूल निर्देशिका में मौजूद README.md नामक फाइल का अभिनिर्धारण /README.md होगा, और /public/www/index.html इससे अभिनिर्धारित कोई फाइल मूल निर्देशिका में मौजूद 'public' नामक निर्देशिका में मौजूद 'www' नाम निर्देशिका में मौजूद index.html नामक फाइल है।

प्रत्येक रिपोसिटरी के दो नाम होते हैं, जिन्हें एक विभाजक से अलग किया जाता है, जो इस पुरालेख में _ यह वर्ण है, जिसे अंडरस्कोर वर्ण कहा जाता है। (पारंपरिक रूप से यह विभाजक / या स्लैश होता था, लेकिन इसका उपयोग निर्देशिका को सूचित करने के लिए भी किया जाता है, इसलिए, स्पष्टता के तकाजे से हमने _ का उपयोग किया है)। सबसे पहला नाम वह गिटहब खाता है, जो उस रिपोसिटरी का स्वामी है; दूसरा है उस व्यक्तिगत रिपोसिटरी का नाम। रिपोसिटरी और फाइल अभिनिर्धारकों के संयोजन के दावारा पुरालेख के किसी फाइल को अद्वितीय रूप से अभिनिर्धारित किया जा सकता है। उदाहरण के लिए, 'rezendi' नामक गिटहब खाते में मौजूद 'ykarma' नामक रिपोसटरी में मौजूद 'web' नामक निर्देशिका में मौजूद 'package.json' नामक फाइल को इस पुरालेख में rezendi_ykarma की /web/package.json इस रूप में अद्वितीय रूप से पहचाना जा सकता है।

अलग-अलग प्रकार के फाइलों के अलग-अलग प्रयोजन हैं। गिटहब पुरालेख में मुख्य रूप से पाठ फाइलें हैं, यानी वे फाइलें जिनका डेटा लिखित भाषा का प्रतिनिधित्व करने के लिए होता है। अधिकांश सॉफ्टवेयर को पाठ फाइलों में लिखा जाता है और उनमें अत्यंत संरचित पाठ होता है, जिसे सोर्स कोड कहते हैं। संकलक नामक एक विशेष प्रकार का प्रोग्राम मनुष्यों द्वारा पढ़े जा सकने वाले सोर्स कोड को कंप्यूटरों द्वारा पढ़े जा सकने वाले आदेशों में बदलता है, और इस बदलाव के बाद वह संकलित कोड या मशीन कोड कहलाता है।

वे फाइलें जो पाठ फाइलें नहीं हैं, जैसे छवियों का प्रतिनिधित्व करने वाली फाइलें, या जिनमें संकलित कोड होता है, उन्हें अक्सर बाइनेरी फाइल कहा जाता है। यह एक दुर्भाग्यपूर्ण और भ्रामक शब्द है, क्योंकि पाठ फाइलें भी अंततः 1 और 0 ही होती हैं। हम उन फाइलों को जो पाठ फाइलें नहीं हैं, गैर-पाठ फाइलें कहेंगे।

लिखित मानव भाषा को 1 और 0 में बदलने के अनेक तरीके हैं। ऐतिहासिक कारणों से, शुरू में जो भी सोर्स कोड लिखे जाते थे, सब लैटिन कही जाने वाली लिपि में ही लिखे जाते थे। लैटिन लिपि में 26 मूल वर्ण हैं, जिनका उपयोग बोले जा सकने वाले शब्दों को दर्शाने के लिए किया जाता है, इन 26 वर्णों के दो रूप होते हैं, अपर केस और लोवर केस। इस लिपि में संख्याओं को दर्शाने के लिए 10 अंक भी होते हैं। लैटिन लिपि तथा संरचना और अन्य अवधारणाओं को दिखाने के लिए उपयोग किए जाने वाले कुछ अन्य चिह्नों को, 'आस्की' कहे जाने वाले संरूप में 1 और 0 में कूटलिखित किया जा सकता है। यह संरूप 128 अलग-अलग वर्णों को दर्शा सकता है, और ऐतिहासिक कारणों से, कई सालों तक इसी में अधिकांश सॉफ्टवेयर लिखा जाता था।

लेकिन, लैटिन लिपि उन विविध तरीकों में से केवल एक छोटा अंश मात्र है, जिनसे मनुष्य अपने आपको लिखित भाषा में अभिव्यक्त करते हैं। अन्य लिपियों को भी समर्थित करने के लिए, और पहले आस्की संरूप में लिखे गए सॉफ्टवेयर को भी अब भी बिना बदलाव के उपयोग योग्य रखने के लिए (जो बैकवर्ड कंपैटिबिलिटि नामक एक अवधारणा है), 'यूटीएफ-8' कहा जाने वाला एक नया डेटा संरूप जारी किया गया।

आस्की सोर्स कोड का सबसे सामान्य संरूप बना हुआ है। इस पुरालेख की हर रील में आस्की वर्णों की एक मार्गदर्शिका शामिल की गई है। आस्की यूटीएफ-8 एक छोटा समुच्चय है, जिसका मतलब है कि आस्की में लिखा गया सभी कोड यूटीएफ-8 संरूप में भी काम करता है। मार्गदर्शिका रील में सभी यूटीएफ-8 वर्णों का विनिर्देश भी दिया गया है। इस पुरालेख के लगभग सभी पाठ फाइलें में यूटीएफ-8 संरूप में लिखित होनी चाहिए।

गैर-पाठ फाइलें छवियों और संरूपित दस्तावेजों का प्रतिनिधित्व करती हैं। एक बहुत व्यापक प्रथा के अनुसार फाइलों का नाम '.' वर्ण में समाप्त होता है और उसके बाद एक प्रत्यय रहता है जो उस फाइल के प्रकार को दर्शाता है। मसलन, जो फाइल नाम .jpg में समाप्त होता है, वह सामान्यतः जेपीईजी छवि फाइल होती है; और जो .png में समाप्त होता है, वह सामान्यतः पोर्टेबल नेटवर्क ग्राफिक इमेज फाइल होती है; और जो .pdf में समाप्त होता है, वह सामान्यतः पोर्टेबल डॉक्युमेंट फॉर्मेट वाली फाइल होती है।

पाठ फाइलों को दर्शाने वाला कोई एक प्रत्यय नहीं है। इसके बजाय, सोर्स कोड के में, प्रत्यय सामान्यतः उस प्रोग्रामन या मार्क-अप भाषा को दर्शाता है, जिसमें वह कोड लिखा गया है। प्रोग्रामन और मार्क-अप भाषाओं को अधिक विस्तार से नीचे वर्णित किया जाएगा।

## पुरालेख की सामग्री को निष्कर्षित कैसे करें

यहाँ हम इसकी समीक्षा करेंगे कि किसी पुरालेखित रिपोसिटरी को उसको विभिन्न घटक फाइलों में कैसे खोला जाता है। यहाँ भी, प्रक्रिया वही रहती है:

1.  उस विशिष्ट रील और फ्रेमों को पहचानना जिनमें रिपोसिटरी डेटा को पुरालेखित किया गया है।

2.  उन फ्रेमों में मौजूद क्यूआर कोडों को, यानी काले, सफेद और धूसर पिस्कल वाले फील्डों को क्यूआर कोडों को एक बाइनेरी फाइल में विकोडित करना, जो (न्यूनतम रूप में हजारों, और कभी कभी करोडों) 1 और 0 का एक क्रम होती है।

3.  उस बाइनेरी फाइल को अनजिप करके, एक अधिक लंबी, असंपीडित पुरालेख फाइल में बदला।

4.  पुरालेख फाइल को उसमें मौजूद अलग-अलग उपफाइलों में खोल लेना। लेकिन ध्यान में रखें कि यदि इस चरण को छोड़ भी दिया जाए, तो भी पुरालेख डेटा ले-देकर समझ में आने योग्य स्थिति में होती है, हालाँकि वह बहुत ही अव्यवस्थिति स्थिति में रहती है।

5.  और अंत में, उन उपफाइलों में से प्रत्येक को - जो स्वयं भी 1 और 0 के क्रम में रहती हैं, और ये क्रम काफी छोटे से लेकर बहुत लंबे-लंबे हो सकते हैं -- लिखित वर्णों में बदलना, यदि ये फाइलें पाठ फाइलें हों।

### जिस विशिष्ट रील और फ्रेमों में रिपोसिटरी के डेटा को पुरालेखित किया गया है, उसे पहचानना

फिल्म की प्रत्येक की शुरुआत खाली फिल्म के लीडर से होती है, जिसके बाद शून्य संदर्भ फ्रेम रहता है, जिसमें एक कोने में एक ठोस काला आयात होता है और बाकी फ्रेम खाली होता है। अगला मनुष्य द्वारा पढ़ा जा सकने वाला फ्रेम नियंत्रण फ्रेम है, जिसमें उस रील के बारे में जानकारी रहती है। इसके बाद विषय सूची होती है, जिसमें उपयोगकर्ता डेटा फाइलों की सूची होती है।

इस रिपोसिटरी की प्रत्येक रील उन उपयोगकर्ता डेटा फाइलों में से एक है। इस सूची में एक अद्वितीय आईडी, एक फाइल आईडी और उनमें से प्रत्येक फाइल का नाम होता है। मसलन, पाइथन के खाते में सीपाइथन रिपोसिटरी में फाइल आईडी 12345 के रूप में सूचीबद्ध हो सकती है, और नाम python_cpython.tar हो सकता है।

उपयोगकर्ता डेटा फाइलों की सूची के बाद डिजिटल डेटा स्थानों की एक सूची रहती है। इस सूची में फाइल आईडी, एक शुरू फ्रेम, एक शुरू बाइट, एक अन्त फ्रेम, एक अन्म बाइट होते हैं। इस तरह, सीपाइथन के काल्पनिक उदाहरण का उपयोग करते हुए, इस सूची में जिस आइटम की आईडी 12345 है, उसका शुरू फ्रेम 054321, शुरू बाइट 03210321, अंत फ्रेम 054545, और अंत बाइट 12321232 हो सकता है।

इसका मतलब है कि सीपाइथन के डेटा को प्राप्त करने के लिए: फिल्म की इस रील में फ्रेम 54321 फ्रेम पर जाएँ। शुरू फ्रेम 54321 से लेकर अंत फ्रेम 54545 तक के सभी फ्रेमों को बाइनेरी मानों में वि-कोडित करें, जिसकी विधि नीचे बताई गई है। इससे आपको डेटा के 225 खंड मिलेंगे, यानी 54321 से 54545 तक के, जिनकी शुरुआत बिना डेटा वाले कुछ खाली खंड होते हैं। पहले गैर-रिक्त डेटा खंड के प्रथम 3210320 बाइटों को छोड़ दें। "बीच के" सभी डेटा खंडों को क्रम से लगाएँ। और अंत में, आखिरी डेटा खंड 54545 के प्रथम 12321232 बाइटों को जोड़ें। अब आपने संपूर्ण सीपाइथन रिपोसिटरी को एक संपीडित पुरालेख फाइल में जोड़ लिया है।

### क्यूआर कोडों से बाइनेरी फाइल में वि-कोडन की विधि

फिल्म के फ्रेमों को बाइनेरी डेटा में विकोडित करने का ब्योरा मनुष्य द्वारा पढ़े जा सकने वाले प्रतिनिधित्व जानकारी में है। यह जानकारी पुरालेख की प्रत्येक फिल्म रील के शुरू में विषय सूची के बाद दी गई है। यह जानकारी हर रील पर दी गई हे, ताकि यदि कोई रील पुरालेख अलग भी हो जाए, तो भी उसकी सामग्री को विकोडित करना संभव हो सके। उस प्रतिनिधित्व जानकारी में क्रमशः यह जानकारी है:

1.  गिटहब पुरालेख कार्यक्रम की मार्गदर्शिका (यह दस्तावेज)

2.  गिटहब विवरणात्मक अनुक्रमणिका, जो इस रील में मौजूद सभी रिपोसिटरियों की सूची तथा उनका संक्षिप्त विवरण है

3.  प्रतिनिधित्व जानकारी का विवरण

4.  डिजिटल परिरक्षण और डेटा को कैसे पुनर्प्राप्त करें, डेटा पुनर्प्राप्ति विधियों की समीक्षा

5.  संग्रहण माध्यम का विवरण

6.  डेटा पुनर्प्राप्ति प्रौद्योगिकी

7.  सामान्य परिरक्षण रील संरचना (रील संरूप)

8.  सामान्य 4के फ्रेम संरूप विवरण

9.  लाइब्रेरी को खोलने का विवरण (क्यूआर कोड के लिए)

10. लाइब्रेरी सोर्स कोड को खोलना

11. आस्की डेटा संरूप का विनिर्देश

12. सी प्रोग्रामन भाषा का विनिर्देश

13. टार पुरालेख फाइल सोर्स कोड

14. पीडीएफ सोर्स कोड

15. एक्सज़ेड फाइल संरूप विनिर्देश (संपीडिन / विसंपीडन के लिए, जो नीचे वर्णित है)

इनमें से छठा आइटम, डेटा पुनर्प्राप्ति प्रौद्योगिकी दस्तावेज, एक स्कैनर का उपयोग करके डेटा को एक डिजिटल रूप से कूटलिखित फिल्म फ्रेम में पकड़ने की प्रक्रिया और इसकी आवश्यकताओं को, और उसे कंप्यूटर द्वारा विश्लेषित करने योग्य रूप में बदलने का वर्णन करता है। आठवाँ आइटम, सामान्य 4के फ्रेम संरूप विवरण, इस तरह स्कैन की गई छवि को लेकर उसे कंप्यूटर द्वारा बाइनेरी डेटा में बदलने के लिए आवश्यक तकनीकी जानकारी प्रस्तुत करता है, जिसमें सोर्स कोड भी शामिल है।

सैद्धांतिक रूप से रिपोसिटरी के क्यूआर कोडित डेटा को बिना कंप्यूटर की सहायता के बाइनेरी डेटा में बदलना संभव है। लेकिन, यह बेहद मुश्किल होगा और इसमें एक सुसंगठित समुदाय को कई हफ्तों तक और कभी-कभी कई महीनों या सालों तक मेहनत करनी पड़ेगी। चूँकि रिपोसिटरियों की सामग्री कंप्यूटर पर चलने के लिए बने सॉफ्टवेयर हैं, कंप्यूटरों के अभाव में उनकी उपोयगिता लगभग नहीं के बराबर होगी।

यदि इस पुरालेख को प्राप्त करने वाले के पास कंप्यूटर नहीं हों, तो उन्हें इस पुरालेख को तब तक सुरक्षित रूप से कहीं रख देना चाहिए जब तक उनके पास कंप्यूटर नहीं आ जाएँ। मनुष्यों द्वारा पढ़े जा सकने वाले टेक ट्री का एक प्रयोजन ऐसी स्थिति होने पर उन प्रौद्योगिकियों और कंप्यूटरों के विकास में तेजी लाने में मदद करना भी है। (उसके अन्य प्रयोजन है, हमारी प्रौद्योगिकी और उसके विकास को भावी इतिहासकारों के उपयोग हेतु संग्रहित करना।)

### पुरालेख फाइल को उसमें मौजूद उपफाइलों में खोलना

प्रत्येक फाइल की बाइनेरी फाइल टार (टेप आर्काइव का संक्षेपण) नामक संरूप में होती है। मूलतः टार फाइल को अनेक फाइलों को जोड़कर बनाया जाता है, जिसके लिए एक फाइल के छोर को दूसरी फाइल के शीर्ष के साथ जोड़ा जाता है, मानो कागज के अलग-अलग फीतों को परस्पर जोड़कर एक लंबी पट्टी बानाई जा रही हो। टार फाइल में चाहे जितने फाइल हो सकती हैं, उनका आमाप कुछ भी हो सकता है, और इन्हें चाहे जितनी निर्देशिकाओं और उपनिर्देशिकाओं में बाँटा जा सकता है।

टार फाइल की प्रत्येक उपफाइल के अग्र भाग में 512 बाइट का हेडर रेकॉर्ड होता है, जो कागज की पट्टियों के उदाहरण के टेप का काम करता है। हेडर रिकॉर्ड में उस फाइल के बारे में जानकारी रहती है, जैसे उसका नाम और आमाप। पुरालेख के अंत को दो लगातार आने वाले 512-बाइट के खंडों द्वारा सूचित किया जाता है।

चूँकि टार फाइलें मूलतः फाइलों का समुच्चय ही होती हैं जिनके बीच में पाठ रेकॉर्ड होते हैं, इसलिए यदि किसी टार फाइल की सभी फाइलें पाठ फाइलें ही हों, तो उस टार फाइल को भी एक पाठ फाइल ही माना जा सकता है। यदि उसमें अलग अलग संरूपों की फाइलें हों, तो उसे एक ऐसी पाठ फाइल माना जा सकता है जिसमें संरचित और अर्थपूर्ण पाठ (उसकी पाठ फाइल घटक) और अर्थ-रहित अंशों (उसकी गैर-पाठ फाइल घटक) का मिश्रण है।

एक टार फाइल को एक दूसरी टार फाइल में रखना संभव है, यानी एक कंटेनर को एक अन्य कंटेनर में रखना, और इसी तरह हमारे पुरालेखित डेटा के अधिकतर हिस्से को संग्रहित किया गया है। किसी भी रिपोसिटरी के लिए, बाहरी टार फाइल में न्यूनतम रूप से ये होंगे:

* एक अकेली META नामक असंपीडित मेटाडेटा फाइल, जिसमें रिपोसिटरी का नाम, खाता नाम, विवरण, प्रोग्रामन भाषा, स्टार गिनती, और फोर्क गिनती शामिल की गई हैं
* COMMITS नामक एक संपीडित (नीचे देखें) फाइल, जिसमें समय-समय पर रिपोसिटरी में किए गए परिवर्तनों का अभिलेख है
* repo.tar.xz नामक संपीडित टार फाइल, जिसमें असल रिपोसिटरी सामग्री है

अन्य मेटाडेटा, जैसे विकी, जीएच-पृष्ठ, मुद्दे, और पुल अनुरोध भी अलग संपीडित फाइलों के रूप में शामिल किए जा सकते हैं।

टार फाइलों के बारे में विशेष विवरण, और उन्हें कोडित और विकोडित करने के सॉफ्टवेयर पुरालेख की हर रील के प्रतिनिधित्व जानकारी में मिल सकते हैं।

### संपीडित फाइलों को पढ़ने योग्य असंपीडित फाइलों में अनजिप करना

ज्यादा से ज्याद रेपोसिटरियाँ और अधिकाधिक मेटाडेटा शामिल करने के लिए, अधिकांश डेटा को संपीडित किया गया है। संपीडन का मतलब है बड़ी मात्रा में डेटा का कम मात्रा में डेटा द्वारा प्रतिनिधीकरण, जिसके लिए डेटा की बड़ी मात्रा में मौजूद उपयोग के पैटर्नों और दुहराव से लाभ उठाया जाता है। मसलन, a जैसे किसी वर्ण को किसी पंक्ति में लगातार नौ बार लिखने के बजाए, उसे 9a इस संपीडित रूप में लिखा जा सकता है, यह तब काम करेगा जब यह भरोसा हो कि पाठक 9a को असंपीडित पाठ aaaaaaaaa के रूप में समझ लेगा।

प्रभावशाली संपीडन कलनविधियाँ (एल्गोरिथम) इससे कहीं ज्यादा जटिल होती हैं, पर वे सब इसी सिद्धांत का अनुसरण करती हैं। यह पुरालेख 'XZ' नाम के एक संपीडन प्रोग्राम का उपयोग करता है, जो स्वयं 'LZMA' नामक कलन-विधि का उपयोग करता है। हर रील की दूसरी डेटा फाइल में एक अकेले टार पुरालेख फाइल के रूप में XZ सोर्स कोड और दस्तावेजन शामिल है, जिसका विवरण नीचे दिया गया है। (पहली डेटा फाइल में मानवाधिकारों की सार्वत्रिक उद्घोषणा को हर मानवीय भाषा में लिखकर शामिल किया गया है।)

LZMA 'LZ77' कलन-विधि और "रेंज एनकोडिंग" को मिलाती है। LZ77 दुहराए गए डेटा के स्थान पर उस डेटा के पहले आए अंशों का संदर्भ देती है। मसलन, बहुत ही ज्याद सरलीकृत करके कहें तो, यदि कोई 80-बाइट का वाक्यांश 400 बाइटों के फासलों पर दुबारा आता है, तो यह कलन-विधि मूलता उस डेटा को यह कहते हुए संपीडित करता है कि "400 बाइट पहले के स्थान से 80 बाइट को दुहराओ"। रेंज एन्कोडिंग मूलतः एक पूरे संदेश को एक बहुत लंबी संख्या में बदल देता है, जिसे बाद में कूटलिखित किया जा सकता है।

डेटा को विसंपीडित करने के लिए कलनविधि के जो विशेष चरण अपनाए जाते हैं, उन्हें हर रील में मोजूद दूसरी डेटा फाइल में XZ सोर्स कोड में वर्णित किया गया है। हलाँकि सिद्धांतः हाथ से संपीडित करना संभव है लेकिन इसमें बहुत ही अधिक समय लगेगा और श्रम भी। व्यवहार में, इसके लिए किसी कामचलाऊ कंप्यूटर का उपोयग अपेक्षित है।

### प्रत्येक फाइल को लिखित वर्णों में परिवर्तित करना

मनुष्य हजारों सालों से लिखित वर्णों का उपयोग करता आ रहा है। इन वर्णों को 1 और 0 में दर्शाने के लिए इस पुरालेख में जो कूटलेखन उपयोग किया जाता है, उसे 'यूटीएफ-8' कहा जाता है। एक अकेला यूटीएफ-8 वर्ण, अर्थात कोई एक लिखित चिह्न, 1 से लेकर 4 बाइटों तक का बाइनेरी डेटा हो सकता है।

ऐतिहासिक कारणों से, और चूँकि जिस क्षेत्र में और जिस समय सॉफ्टवेयर विकास आरंभ हुआ, वहाँ इसका सर्वाधिक उपयोग होता था, 'आस्की' कहे जाने वाले वर्णों के समूह को (और अवधारणाओं को) सबसे कार्य-दक्ष रीति से 1 बाइट प्रति वर्ण के रूप में कूटलिखित किया गया है। जो भी आस्की नहीं हो, उसे 2 या अधिक बाइट प्रति वर्ण के रूप में कूटलिखित किया जाता है। इस पुरालेख के अधिकांश पाठ फाइल आस्की में हैं, पर काफी इसमें नहीं भी हैं। कई फाइलें ऐसी होंगी जो मुख्यतः तो आस्की में हैं, पर उनमें कुछ गैर-आस्की वर्ण भी होंगे।

आस्की का विस्तृत विनिर्देश इस पुरालेख की हर रील में प्रतिनिधित्व जानकारी के तहत दिए गए हैं। यूटीएफ-8 का विस्तृत विनिर्देश मार्गदर्शिका रील में दिया गया है। हर रील की पहली डेटा फाइल में मानवाधिकारों की सार्वत्रिक उद्घोषणा को हर मानवीय भाषा में लिखकर शामिल किया गया है। यह अनुवाद करने के एक उपकरण के रूप में भी और आस्की और यूटीएफ-8 के नमूनों के रूप में भी काम करेगा।

## फाइलों के प्रकार

कई प्रकार के पाठ फाइलें हैं, जिन्हें अलग-अलग कारणों से बनाया गया है। इनमें से प्रमुख प्रकार, जिसकी वजह से यह पुरालेख अस्तित्व में आया है, सोर्स कोड है। सोर्स कोड बहुत ही घना, अत्यंत संरचित पाठ है, जिसमें '{' और ';' जैसे चिह्नों का बहुत बड़ा महत्व होता है।

सोर्स कोड की खास बात यह है कि वह कंप्यूटरों द्वारा पढ़े जाने के लिए लिखा गया है। चूँकि संकलक (कंपाइलर) सॉफ्टवेयर ही होते हैं, इसे यों भी कहा जा सकता है कि सोर्स कोड कंप्यूटरों द्वारा पढ़े जाने के लिए लिखा जाता है। अच्छा सोर्स कोड मनुष्यों द्वारा पढ़े जाने के लिए भी सुगम होता है, यदि वे इस काम में कुशल हों, या उन्हें सॉफ्टवेयर के क्षेत्र में प्रशिक्षण मिला हो, तब वे उसे समझ सकते हैं; पर वह सही तभी है जब संकलक उसे समझ सके।

वह संकलक, फिर उस सोर्स कोड को एक जटिल क्रम के अनुसार, जिसका वर्णन टेक ट्री में दिया गया है, एक और शून्य के एक क्रम में बदल देता है, जिससे कंप्यूटर उस कोड द्वारा कहे गए कार्यों और गतिविधियों को करने लगेगा। एक सरल उदाहरण यह होगा - नीचे की कोड पंक्ति

_for (int i=0; i<5; i++) { }_

को संकलक बाइनेरी निर्देशों के एक क्रम में बदल देगा और उसे कंप्यूटर को सौंप देगा, जिससे कंप्यूटर का एक बहुत ही छोटा हिस्सा, जिसे रेजिस्टर कहते हैं, अपने मान को 0 कर लेगा, और फिर उस मान को क्रमशः 1,2,3 और फिर 4 में बढ़ा लेगा। (यह कोई उपयोगी कोड के उदाहरण के रूप में नहीं दिया गया है; इसे केवल सोर्स कोड को चालू सॉफ्टवेयर में बदलने के बहुस्तरीय प्रक्रिया को चित्रित करने के लिए यहाँ दिया गया है।)

अन्य प्रकार की पाठ फाइलों, जैसे, जेसन, एक्सएमएल, और एचटीएमएल, का उपयोग कंप्यूटरों के लिए डेटा को संग्रहित करने (जो आदेशों से भिन्न है) के लिए किया जाता है। सामान्यतः इन्हें मनुष्य पढ़ सकते हैं, हालाँकि उनके संरचित संरूप के कारण उन्हें पढ़ना कम संरचना वाले कहानी कहने वाले पाठ को, जैसे यह फाइल, पढ़ने की तुलना में ज्यादा कठिन होगा।

बाकी के लगभग सभी फाइलें अंततः मनुष्यों द्वारा पढ़े जाने के लिए ही होते हैं। कुछ सरल और ज्यादातर असंरचित होते हैं, जैसे यह फाइल, जिसे आप इस समय पढ़ रहे हैं। एक प्रकार की फाइल आपको इस पुरालेख में अक्सर मिलेगी और वह है मार्कडाउन, जिसे फाइल के नाम में .md इस प्रत्यय द्वारा सूचित किया जाता है, यह एक प्रकार से अनन्तिम प्रकार की फाइल है, अपने असंसाधित रूप में मनुष्यों द्वारा पढ़े जाने के लिए है और साथ ही, संरचित भी, ताकि कंप्यूटर उन्हें संरूपित करके उन्हें दृश्यात्मक स्तर पर अधिक आकर्षक और उपयोगी भी बना सके। इस पुरालेख की अधिकांश रिपोसिटरियों में एक README.md मार्कडाउन फाइल होगी, जो सामान्य रूप से उस रिपोसिटरी का परिचय देती है, और वर्णित करती है कि उसमें क्या है, क्यों है और उसका उपयोग कैसे करना है।

कुछ अधिक सामान्य गैर-पाठ फाइलों का संक्षिप्त परिचय भी उपयोगी रहेगा। संकलित कोड गैर-पाठ फाइल होती है। जेपीजी और पीएनजी फाइलें छवियों को डिजिटल संरूप में कोडित करती हैं, और एमपी3 और वेब श्रव्य डेटा को कोडित करती हैं। पीडीएफ फाइलें दस्तावेजों को सटीक और सही संरूपण के साथ कोडित करती हैं। और ज़िप और टार फाइलें, जैसे पहले भी बताया गया, कंटेनर फाइलें होती हैं, जिनमें और भी फाइलें हो सकती हैं।

## मानव भाषाएँ और प्रोग्रामन भाषाएँ

### मानव भाषाएँ

आज मनुष्य हजारों लिखित भाषाओं का उपयोग करता है, और केवल बोली जाने वाली भाषाओं की संख्या तो इससे भी अधिक है। इनमें से अधिकांश को अपेक्षाकृत कम संख्या में लोगों द्वारा उपयोग किया जाता है। फिर भी ऐसी बीस के करीब भाषाएँ जिनमें से प्रत्येक को पहली या द्वितीय भाषा के रूप में 6 करोड़ से अधिक लोग उपयोग करते हैं।

विश्व में सर्वाधिक उपयोग की जाने वाली भाषाएँ अँग्रेजी और चीनी है। ऐतिहासिक कारणों से, कई वर्षों तक अधिकांश सॉफ्टवेयर विकास अँग्रेजी बोलने वाले देशों में हुई, इसलिए, अँग्रेजी एक प्रकार से सॉफ्टवेयरों के लिए सामान्य भाषा हो गई। अधिकांश प्रोग्रामन भाषाएँ अपने वाक्य-विन्यास में अँग्रेजी के शब्दों का उपयोग करते हैं। इस पुरालेख की मार्गदर्शिका को भी पहले इसी भाषा में लिखा गया।

इसकी कोई गारंटी नहीं है कि उस पुरालेख को पाने वाले लोग अँग्रेजी जानेंगे, हालाँकि इस भाषा के काफी समय तक बने रहने की प्रबल संभावना आज नजर आ रही है। यह सोचकर कि कुछ अन्य भाषाओं में भी कुछ मार्गदर्शन उपलब्ध कराना उपयोगी होगा, हमने मानव अधिकारों की सार्वभौम उद्घोषणा के अन्य 500 से अधिक भाषाओं में अनुवाद को भी असंपीडित यूटीएफ-8 फाइल के रूप में हर रील के प्रारंभ में, और टेक ट्री के भीतर भी उपलब्ध करा रहे हैं। यह घोषण उन आजादियों की एक सूची है जो हमारे जमाने के हर मनुष्य को मिलनीं चाहिए और जिन्हें किसी भी हालत में किसी भी मनुष्य से कभी भी नहीं छीना जाना चाहिए।

### प्रोग्रामन भाषाएँ

प्रोग्रामन भाषाएँ वे हैं जिनका उपयोग मनुष्य कंप्यूटरों को निर्देश देने के लिए उपयोग करते हैं। सॉफ्टवेयर इन्हीं भाषाओं में लिखे जाते हैं। अन्य (प्रशिक्षित) मनुष्य भी प्रोग्रामन भाषाओं में लिखे सॉफ्टवेयर को पढ़ सकेंगे, पर यह उनका गौण उद्देश्य है।

प्रोग्रामन भाषा पहले से यह घटकों का समुच्चय होता है, जिनमें ज्यादातर कुछ शब्द होते हैं, जिन्हें एक संरचित रीति से रखकर कंप्यूटरों को कुछ विशिष्ट कार्य करने का आदेश दिया जा सकता है। इस तरह के निर्देशों के एक समुच्चय को प्रोग्राम या सोर्स कोड कहते हैं। सोर्स कोड मूलतः अन्तिम रूप दिया जा चुका और लिखित रूप में मौजूद सॉफ्टवेयर ही है।

प्रोग्रामों को सामान्यतः सुस्पष्ट चरणों में बाँटा जाता है, जिन्हें कथन (स्टेटमेंट) कहते हैं, जो स्वयं भी फंक्शन कहे जाने वाले समुच्चयों में इकट्ठा किया जाता है। एक पूरा प्रोग्राम एक ही फाइल में समा सकता है, या वह हजारों फाइलों में फैला हुआ हो सकता है।

सैकड़ों प्रकार के प्रोग्रामन भाषाएँ मौजूद हैं, जो कई रूपों, पद्धतियों और विचारधाराओं को अपनाते हैं। कुछ को अलग-अलग बाइनेरी फाइलों में संकलित किया जाता है और फिर इन्हें निष्पादित किया जाता है; और कुछ अन्य को जिन्हें "इन्टेरप्रेट की गई" भाषाएँ कहा जाता है, मूलता एक साथ संकलित करके चलाया जाता है, और इनके बीच में कोई दूसरा चरण नहीं होता है। अधिकतर आधुनिक प्रोग्रामन भाषाओं में पहले से ही लिखे हुए फंक्शनों की लाइब्रेरियाँ शामिल होती हैं, और ये लाइब्रेरियाँ काफी विशद और विस्तृत हो सकती हैं। आजकल के कुछ लोकप्रिय प्रोग्रामन भाषाओं में शामिल हैं:

-   सी, जो सबसे पुराने, सबसे तेज और लगभग सार्वत्रिक, और सबसे ताकतवर प्रोग्रामन भाषाओं में से एक है, जो कुछ लिहाज से सरल है, पर कुछ अन्य लिहाज से सीमित है, और यह हमेशा सुग्राह्य, या सुपाठ्य नहीं होती है और इसे सीखना भी उतना सरल नहीं है।

-   सी++, यह सी भाषा का अधिक जटिल, अमूर्त और अधिक ताकतवर वंशज है।

-   सी#, और सी का ही और अधिक विकसित रूप है, जिसे बाइनेरी मशीन कोड में संकलित नहीं किया जाता है, बल्कि "रनटाइम" में इंटर्प्रेट किया जाता है।

-   जावा, जो सी# के ही समान है (पर उससे पहले का है), शायद आज की सबसे ज्यादा उपयोग की जाने वाली प्रोग्रामन भाषा है।

-   जावास्क्रिप्ट, जो नाम समान होने पर भी जावा से काफी अलग है। इसे 'ईसीएमए-स्क्रिप्ट' भी कहते हैं। शुरू में इसका उपयोग केवल वेब ब्राउसर के भीतर ही उपयोग किया जाता था। वेब ब्राउसर एक ऐसा प्रोग्राम है जो इंटरनेट सर्वर कहे जाने वाले दूर स्थित कंप्यूटर से डेटा लाता है, उसे इंटर्प्रेट करता है और कंप्यूटर स्क्रीन पर प्रदर्शित करता है; लेकिन आज जावास्क्रिप्ट का उपयोग उन सर्वरों में भी होता है।

-   टाइस्क्रिट, जावस्क्रिप्ट का एक रूप है जिसमें नियम अधिक सख्त होते हैं ताकि त्रुटियाँ, जिन्हें बग भी कहते हैं, कम हों और ये बग प्रोग्रामों में प्रवेश नहीं कर सकें।

-   पाइथन, एक सुंदर भाषा है, जो वैज्ञानिकों में बहुत लोकप्रिय है। यह शक्तिशाली भी है और पहले सीखने के लिए एक अच्छी भाषा भी है।

-   रूबी, एक सुग्राह्य भाषा है, जिसका वाक्य-विन्यास काफी कुछ अँग्रेजी जैसा ही होता है।

-   गो, एक सरल, शक्तिशाली भाषा है, जो समांतरीकृत प्रोग्रामों में बढ़िया काम करता है। समांतरीकृत प्रोग्राम वे हैं जिन्हें अनेक फंक्शनों के रूप में लिखा जाता है, जो साथ-साथ एक ही समय में चलते हैं।

-   स्विफ्ट, एक नई भाषा है, जिसका उपयोग अरबों लोगों द्वारा उपयोग किए जाने वाले फोनों और अन्य उपकरणों के लिए प्रोग्राम लिखने के लिए किया जाता है।

-   रस्ट, को सी का प्रतिस्थापन करने के लिए बनाया गया था, और यह खतरनाक बग की संभावना को बहुत कम कर देता है।

-   पीएचपी, एक साफ-सुथरी भाषा है, जिसका उपयोग इंटरनेट सर्वरों में होता है।

-   लिस्ट, एक बहुत पुरानी भाषा है, जो फंक्शन-आधिरत प्रोग्रामन से बिलकुल ही अलग अवधारणा पर आधारित है।

-   एसक्यूएल, एक बिलकुल ही अलग प्रकार की भाषा है जिसका उपयोग डेटाबेस कहे जाने वाले, अत्यंत संरचित और कार्य-दक्ष डेटा संग्रहों से डेटा ले आने के लिए किया जाता है।

-   असेंब्लर (या असेंब्ली), बहुत ही कूट, सीमित, किंतु अत्यंत तेज और शक्तिशाली प्रोग्रामन भाषाओं का नाम है, जिनमें उस भाषा की संरचनाओं में और ये जिस मशीन पर चलने वाले हैं, उसके मशीन कोड के बीच बहुत ही निकट का और सीधा संबंध होता है; इसे अर्ध-संकलित कोड कहा जा सकता है।

## विकास, निर्भरताएँ और मुक्त स्रोत

### विकास

एक अकेली, सरल सोर्स कोड फाइल को लेकर उसे कंप्यूटर के अंदर बिजली के आवेगों में बदलने की प्रक्रिया बहुत ही जटिल होती है। हम इस जटिलता से निपटने के लिए अमूर्तता के कई स्तरों का उपयोग करते हैं। इंस्ट्रक्शन सेट (निर्देश समुच्चय) नाम एक अमूर्तता हमें एक संकलक से प्राप्त मशीन कोड आउटपुट को कई प्रकार के अनेक कंप्यूटरों पर उपयोग करने देती है। सोर्स कोड के लेखक को सामान्यतः यह जानने की आवश्यकता नहीं होती है कि उस कोड को किस प्रकार का कंप्यूटर या किस प्रकार का इंस्ट्रक्शन सेट का उपयोग करके चलाया जाएगा; इसं संकलक से अमूर्तित कर लिया जाता है।

आधुनिक सॉफ्टवेयर भी, एक अकेले कंप्यूटर के लिए एक अकेले कोड लेखक द्वारा लिखे जाने वाले अकेल प्रोग्राम से कहीं अधिक जटिल हो गया है। उसे अनेक लेखक निर्मित करते हैं जो एक ही परियोजना के तहत अनेक फाइलों पर काम करते हैं। वे अपना काम एक ही समय करते हैं, पर कई प्रोग्रामन भाषाओं का उपयोग कर सकते हैं। और तो और, हर परियोजना अन्य, अलग, स्वतःपूर्ण परियोजना को उपकरणों और/या घटकों के रूप में उपयोग करती हैं और इस तरह उन पर आश्रित होती है। ये पिरोयजनाएँ स्वयं भी सक्रिय रूप से विकासमान होती हैं, और दूसरी परियोजनाओं पर निर्भर होती हैं। इन सभी चलायमान हिस्सों को एक साथ और सुचारु रूप से और कार्य-दक्ष रीति से चलाना आधुनिक सॉफ्टवेयर विकास के सामने एक विकट चुनौती के रूप में पेश आती है।

जब अनेक सोर्स कोड लेखक, जिन्हें सॉफ्टवेयर डेवलपर भी कहा जाता है, एक परियोजना पर काम करते हैं, तब उनके पास अपना खुद का कंप्यूटर होता है, और वे संपूर्ण परियोजना को अपने कंप्यूटर पर कॉपी कर लेते हैं। यदि वे अनेक परिवर्तन करें, तो प्रत्येक के पास उस परियोजना के अलग-अलग संस्करण हो जाएँगे। किसी परियोजना के इन विभिन्न संस्करणों को समेकित करने की प्रक्रिया को संस्करण नियंत्रण कहा जाता है। इसे संस्करण नियंत्र सॉफ्टवेयर द्वारा प्रबंधित किया जाता है। इस पुरालेख में इस सॉफ्टवेयर को गिट कहा गया है, और इसी के आधार पर स्वयं गिटहब का नामकरण हुआ है। इस पुरालेख की हर रिपोसिटरी एक गिट रिपोसिटरी है।

गिट अपने आप ही किसी सॉफ्टवेयर के विभिन्न संस्करणों को एक सुसंगत संस्करण में मिला लेती है, और इस प्रक्रिया में मानव हस्तक्षेप की न्यूनतम आवश्यकता होती है। गिट इसका संपूर्ण इतिहास भी रखता है, जिससे आवश्यकता होने पर पिछले संस्करण पर परियोजना को ले आना भी संभव होता है। लेकिन, जगह बचाने के लिए, इस पुरालेख की रिपोसिटरियों में सामान्यतः गिट इताहिस नहीं शामिल किए गए हैं।

जब अनेक डेवलपर एक साथ किसी परियोजना को अलग-अलग दिशाओं में ले जाते हैं, तब इसे उस परियोजना का शाखन कहते हैं, और उन पथों को शाखाएँ कहा जाता है। परियोजना की सर्वसम्मत मुख्य शाखा तो तना, या मास्टर शाखा कहा जाता है। गिट डेवलपरों को ऐसी सुविधा भी प्रदान करता है, जिसका उपयोग किन्हीं दो शाखाओं में मौजूद विभिन्नताओं का सारांश तैयार किया जा सकता है और वे अपनी शाखाओं को किसी दूसरी शाखा में मिलाने का प्रस्ताव भी कर सकते हैं। इस पुल अनुरोध कहा जाता है। आधुनिक सॉफ्टवेयर विकास में मुख्य रूप से किसी परियोजना, सॉफ्टवेयर लेखन या संपादन को अपनी शाखा में शाखित करना शामिल होता है, और जब यह काम पूरा हो जाता है, तब पुल अनुरोध करके अपने काम को मास्टर शाखा में वापस मिला दिया जाता है।

### निर्भरताएँ

मुख्यतः हर प्रोग्रामन भाषा अन्य लोगों के काम को आगे बढ़ाने को समर्थित करती है। दूसरों के कामों का पुनरुपयोग न करने पर, हर परियोजना बहुत ही ज्यादा मुश्किल हो जाएगी, और बेहद धीमी चाल से आगे बढ़ेगी, और बहुत ही कम परियोजनाएँ वास्तव में उपयोग में आ सकेंगी।

यदि परियोजना ए के लिए अपने काम को पूरा करने के लिए उसमें परियोजना बी को शामिल करना आवश्यक हो, तो ए के बारे में कहा जा सकता है कि वह बी पर निर्भर है, और बी को परियोजना ए की निर्भरता कह सकते हैं। ए की अनेक निर्भरताएँ हो सकती हैं, जिनमें से प्रत्येक की अपनी अनेक निर्भरताएँ हो सकती हैं। और तो और, प्रत्येक निर्भरता किसी एक संस्करण, या संस्करणों की रेंज या किसी विशिष्ट परियोजना के लिए होती है। किसी परियोजना के बहुस्तरीय निर्भरताओं के प्रत्येक आइटम को स्पष्ट करने वाली चीज को निर्भरता वृक्ष कहा जाता है।

आम तौर पर निर्भरताओं को सोर्स कोड फाइलों में ही आइटमीकृत किया जाता है, सामान्यतः सबसे ऊपर, और हर बार संकलक या इंटरप्रेटर को कोई निर्भरता मिलती है, तो वह पहले से परिभाषित कुछ निर्देशिकाओं के समुच्चय में देखता है। चूँकि किसी परियोजना का निर्भरता वृक्ष काफी जटिल हो सकता है, इसलिए कभी-कभी उस संपूर्ण रूप से परियोजना की किसी एक फाइल में आइटमीकृत किया जाता है, और इसे पैकेज सूची कहते हैं। मसलन, रूबी परियोजनाओं में इस उद्देश्य के लिए एक जेमफाइल होती है, और जावास्क्रिप्ट परियोजनाओं में एक package.json फाइल होती है। इससे पैकेज प्रबंधन उपकरण जैसे कुछ उपकरणों को किसी परियोजना की सभी निर्भरताओं को एक या अधिक इंटरनेट सर्वरों से ले आने में सुविधा होती है।

जहाँ तक इस पुरालेख का संबंध है, इसकी संभावना है कि किसी विशिष्ट परियोजना की निर्भरताएँ इस पुरालेख में अन्य स्थानों पर मौजूद हों। इस पुरालेख में किसी निर्भरता को खोजने के लिए, सबसे पहले सोर्स कोड या पैकेज सूची में उस निर्भरता का नाम ढूँढ़ना होगा, जिसका सटीक विवरण भाषा और फ्रेमवर्क के अनुसार अलग-अलग हो सकता है, और फिर मार्गदर्शिका रील में मौजूद मास्टर अनुक्रमणिका का उपयोग करना होगा, या यदि यह न हो, तो प्रत्येक रील के अग्र भाग में मौजूद अनुक्रमणिकाओं का उपयोग करना होगा, और इस तरह यह पता करना होगा कि खोजी जा रही रिपोसिटरी किस रील और फ्रेमों में है।

### मुक्त स्रोत

चूँकि किसी प्रोग्राम को कंप्यूटर पर चलाने के लिए केवल संकलित मशीन कोड की ही आवश्यकता होती है, इसलिए सोर्स कोड को गुप्त रखते हुए केवल उस मशीन कोड को वितरित करना संभव है। इसे बंद स्रोत मॉडल कहते हैं। कंप्यूटिंग के प्रारंभिक दिनों में, मशीन कोड के साथ सोर्स कोड को भी वितरित किया जाता था, लेकिन बाद में सॉफ्टवेयर उद्योगों के लिए बेहद मुनाफेदार साबित होने लगा, और बंद स्रोत वाला मॉडल अधिक सामान्य होता गया।

बाद में यह मालूम हुआ कि सोर्स कोड को सार्वजनिक करना, और उसे किसी के लिए भी कॉपी करने, शाखित करने, और सुधारने के लिए उपलब्ध कराना, सॉफ्टवेयर विकास का अधिक कार्य-दक्ष तरीका है। यदि अधिक लोग किसी परियोजना के स्रोत कोड को पढ़ सकें, तो संभावित उपयोगों और नई सुविधाओं की कल्पना करने के लिए अधिक लोग उपलब्ध हो जाएँगे, और परियोजना की पर्याप्त समझ रखने वाले लोगों की संख्या भी अधिक हो जाएगी, जो उसके विकास में योगदान कर सकेंगे, तथा अधिक लोग परियोजना की गलतियों और बगों को ढूँढ़ने तथा उन्हें दूर करने के लिए उपलब्ध हो जाएँगे, तथा परियोजना का परीक्षण करने और कोड का पुष्टीकरण करने लिए कि वह ठीक से काम कर रहा है, अधिक लोग मिल जाएँगे।

सामान्यतः बंद सोर्स से अधिक छोटे, अधिक संकीर्ण, अधिक खंडित समुदाय बनते हैं, जो नए और बेहतर तरीकों को अपनाने के लिए संघर्ष करते रहते हैं। मुक्त स्रोत से बड़े, परस्पर जुड़े समुदाय बनते हैं, जो एक-दूसरे की परियोजनाओं में सहायता करते हुए और उन्हें विकसित करते हैं, फैलाते हैं और सफल बनाते हैं, और एक-दूसरे के कामों को निर्भरताओं के रूप में लेकर और/या एक दूसरे को कोड का पुनरुपयोग करके एक-दूसरे से सीखते जाते हैं। मुक्त स्रोत सॉफ्टवेयर संपूर्ण मानवजाति के सामूहिक उपयोग हेतु एक टूलकिट है, और हमारे पास जितने अधिक और जितने बेहतर उपकरण रहेंगे, उतनी ही तेजी से और उतनी ही अच्छी तरह से हम एक जीव-जाति के रूप में प्रगति करेंगे।