# دليل GitHub Code Vault

## مقدمة

تم إنشاء هذا الأرشيف، GitHub Code Vault، من خلال برنامج GitHub Archive، الذي يعمل على الحفاظ على البرامج مفتوحة المصدر للأجيال القادمة. ربما تقرأ هذا بعد عام من الآن، أو بعد ألف عام، إلا أن نأمل أن تكون محتوياته، ومفهوم المصدر المفتوح، مفيدة لك.

فهذا ما يطلق عليه بشكل أساسي اسم أرشيف البرامج. فالبرنامج عبارة عن سلسلة من الأوامر المستخدمة للتحكم في عمل الكمبيوتر. وجهاز الكمبيوتر عبارة عن أداة قادرة على القيام بالعمليات الحسابية تلقائيًا بشكل أسرع بكثير من العقل البشري الذي يتمتع بقدرات وإمكانيات هائلة. ويتم استخدام أجهزة الكمبيوتر للمساعدة في استكشاف أسرار الكون، وربط البشرية جمعاء بشبكة معلومات متاحة في كل مكان، ومعالجة الإشارات بسرعة كافية لنقل الأصوات وعرض الصور المتحركة المفصلة على الشاشات الكهربائية، والتحكم في الآلات الضخمة التي تتجاوز قدرات وإمكانيات العمل البشري.

ولا يمكن لأي كمبيوتر بدون برامج القيام بأي من هذه الأشياء. ويعد الكمبيوتر أمرًا استثنائيًا ورائعًا، ولكن بدون برامج، فإن هذا القوة لا طائل ولا فائدة منها. ويتمثل الغرض من هذا الأرشيف في نقل ما نعرفه عن البرنامج إليك.

في الحقيقة، يتم كتابة البرامج بشكل معقد باستثناء سلسلة الأوامر القابلة للقراءة من جانب أي شخص، والتي تُعرف أشكالها المختلفة بأنها لغات برمجة، لأن الوحدة الكاملة للبرنامج تُسمى غالبًا بالبرنامج. ثم يتم تحويل هذه البرامج إلى لغة ثنائية خاصة بالأحاد والأصفار التي تستخدمها أجهزة الكمبيوتر. وتعرف هذه العملية باسم التحويل البرمجي.

ونظرًا لأنه من الصعوبة بمكان فك ذلك التشفير إلى صيغة البرنامج الأصلي، والمعروف أيضًا باسم كود المصدر، فإنه يمكن لأي شخص الاحتفاظ بهذا الشكل الأصلي سريًا والمطالبة بملكيته. كما أن البرامج مفتوحة المصادر ليست نوعًا مختلفًا من البرامج، وإنما هي روحا مختلفة. وترفض تلك الروح مفتوحة المصدر السرية والملكية. كما تتاح البرامج مفتوحة المصدر لأي وجميع الذين يرغبون في استخدامها، دون أي تكلفة، حتى يتمكنوا بدورهم من تحسين تلك البرامج، أو استخدامها لبناء شيء جديد وأفضل.

ويعتبر أي مشروع مفتوح المصدر بمثابة عمل جماعي لمجتمع تنظيم ذاتي قد يصل إلى الآلاف. وأن تراكم جميع مشاريع البرامج مفتوحة المصدر المحفوظة هنا هو عمل لمجتمع الملايين. وعلى الرغم من أن بعض الأفراد قد يتمتعون بحقوق خاصة في أي مشروع، مثل القدرة على الموافقة أو رفض التغييرات المقترحة على أحدث نسخة رسمية من كود المصدر الخاصة به، فلا يملكها أحد على الإطلاق. وأن كل شخص لديه كل الحق في الحصول على نسخة كاملة واستخدامها من أي مشروع مفتوح المصدر في أي وقت، دون أي تكلفة أو رسوم. وهذا ما يعرف باسم تفريع مشروع.

عندما يعمل الكثير من الأشخاص على كود المصدر في نفس الوقت، يكون من الصعب تتبع جميع تغييراتهم ودمجها. ويخصص أي مشروع مفتوح المصدر يُعرف باسم "Git" لحل هذه المشكلة. فهو يعمل على دمج سجل كامل من جميع الإضافات والتغييرات في أي مشروع إلى كيان يعرف باسم مركز Git. وهذا الأرشيف هو في الأساس أرشيف لهذه المراكز.

تم إنشاء هذا الأرشيف من خلال شركة تدعى "GitHub"، والتي توفر خدمة تتاح للأشخاص في جميع أنحاء العالم، وتقوم بتخزين البرامج التي كتبوها وتتبع تغييرات هذه البرامج والتعاون مع الآخرين لتحسينها وتوسيعها. وتتيح GitHub خدماتها مجانًا لمطوري البرامج مفتوحة المصدر العامة. فلديها عشرات الملايين من هؤلاء المستخدمين.

فيما يلي وصف لما نعتقد أنك ستحتاج إلى معرفته والاستفادة منه على أفضل وجه في أرشيف البرامج هذا. فإذا كنت لا تعرف أو تفهم بعضًا من هذا أو أي منه، فلا تيأس! لقد قمنا أيضًا بتضمين دليل حول كيفية تحقيق هذه المتطلبات. إذا لم تستطع أن تحقق أي لأي سبب من الأسباب، فإن من يتبعونكم يستطيعون ذلك.

## ما تحتاجه لاستخدام الأرشيف

من حيث المبدأ، كل ما تحتاجه للوصول إلى محتويات هذا الأرشيف هو مصدر إضاءة ومكبر. إلا أن معظم (وإن لم يكن كل) بياناته قد تم تعبئتها بإحكام شديد على بكرات الأفلام في شكل مشفر ومضغوط. وتتطلب قراءة هذه البيانات وفك تشفيرها وإلغاء ضغطها حسابًا كبيرًا بحد ذاته. فمن الناحية النظرية، يمكن أن يتم ذلك بدون أجهزة كمبيوتر، ولكنه سيكون مملاً وصعبًا للغاية.

وتوقعنا هو أنك لست بحاجة إلى تعريفاتنا للبرامج والكمبيوتر والمصطلحات الأخرى. نحن نتخيل أن لديك أجهزة كمبيوتر خاصة بك، وربما تكون أكثر تطوراً بشكل كبير من أجهزة الكمبيوتر لدينا، وربما يتم تخزينها بطريقة مختلفة بشكل أساسي. وبمجرد فهم النظرة العامة والدليل أدناه، ستتمكن بسهولة من الوصول إلى جميع البيانات.

ويحتمل أن يكون لديك أجهزة كمبيوتر أقل من أجهزتنا، أو حتى لا توجد أجهزة كمبيوتر على الإطلاق. وعند ذلك، قمنا بإعداد بكرة بيانات غير مضغوطة وغير مشفرة يمكن قراءتها من جانب أي شخص ونطلق عليها Tech Tree. حيث تحتوي Tech Tree على معلومات حول تقنياتنا الأساسية وأجهزة الكمبيوتر والبرامج الخاصة بنا، على أمل أن تتمكن من استخدام هذه المعرفة بمرور الوقت لإعادة إنشاء أجهزة الكمبيوتر التي يمكن أن تستخدم البرامج مفتوحة المصادر في هذا الأرشيف.

## ماذا يوجد في الداخل

الأرشيف كبير جدًا - حوالي 24 تريليون بايت (موضح أدناه) - حيث أنه شامل وديمقراطي. ويتيح ملايين الأشخاص البرامج الذي يكتبونها للجميع. ويتضمن هذا الأرشيف لقطة شاشة - أي نسخة واحدة، في لحظة واحدة وفي الوقت المناسب - لجميع البرامج العامة التي يقوم مستخدمو GitHub بتطويرها بنشاط. وهذا يعني أنه يتضمن عشرات الملايين من المراكز المنفصلة. وأملنا هو أن هذا النهج الديمقراطي الواسع سيكون ذا أهمية للمؤرخين في المستقبل.

تم تحديد مركز التخزين المدرج في هذا الأرشيف حسب وقت الإيداع الأخير، حيث آخر مرة تم فيها التحديث وعدد النجوم. (يستطيع مستخدمو GitHub جميعهم "تمييز" المراكز العامة، للإشارة إلى أنهم مهتمون أو يهمهم.) لقد سجلت لقطة الشاشة في 2/2/2020، أي في اليوم الثاني من شهر فبراير في عام 2020، ونحن نحسب الوقت. كما أن مركز التخزين المضمن هو: جميع مراكز التخزين خلال مدة 80 يومًا السابقة؛ وجميع المركز ذات نجمة واحدة على الأقل مع أي إيداع خلال مدة 365 يومًا السابقة؛ وجميع المركز التي تضم 250 نجمًا على الأقل، بغض النظر عن تاريخ آخر تحديث لها.

بالطبع، ليست كل هذه المراكز مهمة بنفس القدر من حيث نفوذها وتوابعها. حيث يتضمن Tech Tree فهرسًا ووصفًا موجزًا لأهم مركز في الأرشيف، والقوائم التي يمكن أن نجد عليها بكرة لكل منها، بحيث يمكن الوصول إليها دون الحاجة إلى التنقل عبر ملايين المراكز لتحديد أكثرها إفادة.

## نظرة عامة على الأرشيف

يتكون الأرشيف من 201 بكرة فيلم: "بكرة توجيه" للمعلومات والإرشادات القابلة للقراءة من جانب أي شخص، و200 بكرة من البرامج المحفوظة. وتتضمن كل بكرة 65,000 إطار فردي. وتشتمل الإطارات الموجودة في بداية كل بكرة وإطارات بكرة التوجيه على نصوص وصور يمكن قراءتها من جانب أي شخص. وتتكون جميع إطارات الأفلام الأخرى من بيانات رقمية مخزنة في شكل مرئي تعرف باسم كود الاستجابة السريعة (QR).

وتعني البيانات الرقمية البيانات المخزنة بشكل نهائي بتنسيق ثنائي، مثل 0s و1s، حيث أن أجهزة الكمبيوتر نفسها يتم التحكم فيها من خلال إشارات كهربائية "تعمل" أو "لا تعمل"، وتوافق 1 أو 0، وهكذا فإن البيانات الثنائية هي أسهل بكثير لأجهزة الكمبيوتر للتعرف عليها أكثر من أي شيء آخر.

وتتضمن البيانات الوصفية القابلة للقراءة من جانب أي شخص والمخزنة في بداية كل بكرة معلومات حول الفيلم نفسه دليلًا لترميز الاستجابة السريعة المستخدم، وبرنامجًا لفك تشفيره، وفهرسًا. كما يسرد الفهرس العنوان ورقم بداية الإطار والمجموع الاختباري لكل ملف مخزّن على تلك البكرة.

والملف هو كيان بيانات واحد متماسك. بينما المجموع الاختباري هو قيمة فريدة لعملية حسابية، تُعرف باسم دالة التجزئة، ويتم تشغيلها على كامل محتويات الملف لضمان عدم إتلاف محتوياته؛ وتُعرف دالة التجزئة المستخدمة في الأرشيف باسم "SHA-1".

يتكون كود الاستجابة السريعة (QR) من حقل مربعات صغيرة بيضاء أو سوداء يعمل على تشغيل إطار الفيلم بالكامل تقريبًا. ونحن نستخدم كود الاستجابة السريعة لأنها أكثر إحكاما وقوة من النصوص القابلة للقراءة من جانب أي شخص. يتحول كود الاستجابة السريعة (QR) إلى شفرة ثنائية، أي سلسلة من الأحاد والأصفار.

وأن عملية فك التشفير هذه هي الخطوة الأولى فقط نحو تحويل تلك البيانات الثنائية إلى معلومات مفيدة. إنها بيانات مضغوطة، مما يعني أنه تم ضغطها لتوفير مساحة، على غرار الطريقة التي يمكن بها كتابة "128xA" بدلاً من كتابة الحرف A عدد 128 مرة. وبعد فك تشفيرها، يجب فك ضغطها.

تُعرف النتيجة بعد إلغاء الضغط باسم ملف الأرشيف: وهو ملف واحد يحتوي على كامل محتويات مركز مشروع البرنامج الواحد. تشتمل معظم المراكز على العديد من الملفات، لذلك يشبه ملف الأرشيف هذا كتابًا يحتوي على العديد من الفصول المنفصلة، أو مربعًا يحتوي على العديد من الصناديق الأخرى. ومن المفيد عمومًا، وإن لم يكن ضروريًا للغاية، فك ملف الأرشيف إلى ملفات مكوناته قبل الوصول إليها.

وأخيرًا، فإن كل ملف مكون هو مجموعته الخاصة من البيانات الثنائية، أي تلك الأحاد والأصفار. يمكن للمرء أن يدرك البيانات إذا كنت تعرف شكلها. فمثلا في التنسيق المعروف باسم "UTF-8"، وهو التنسيق الأكثر شيوعًا في الأرشيف، يتم تقسيم الأحاد والأصفار إلى مجموعات من ثمانية، والمعروفة باسم البايت، وتمثل البايت الواحدة 01000001 الحرف A؛ وتمثل الثلاثة 01101001 01101110 01110100 الكلمة int؛ ويمثل الاثنان 11000011 10000011 الحرف Ã (A مع وجود علامة في الأعلى.)

كما أن عملية أرشفة البيانات هذه، وهي ملفات ثنائية متضمنة في ملفات أرشيف تم ضغطها أولاً وتحمل ترميز الاستجابة السريعة، معقدة بشكل واضح مقارنة بكل بساطة بنص مكتوب يمكن قراءته من جانب أي شخص. وأن عملية فك الأرشفة التي ستحتاج إليها هي أيضا معقدة، حيث الاستجابة السريعة إلى ضغط ثنائي؛ ومضغوط إلى غير مضغوط؛ وأرشفة ملفات إلى ملفات متعددة؛ وملفات نصية إلى نص مقروء من جانب أي شخص. ذلك لأن هذا التعقيد يسمح لنا بتخزين بيانات أكثر بكثير مما يمكن أن يتاح بطريقة سهلة القراءة في الكمبيوتر.

وإذا كان هذا التعقيد صعبًا ومكلفًا بالنسبة لك، فنحن نعتذر، ولكننا نتوقع أنه إذا كان هذا هو الحال، فإن هذا الدليل وTech Tree المقروءة من جانب أي شخص سوف يخففا من هذا التعقيد، وربما يكونان أكثر فائدة لك من أرشفة المحتويات، على الأقل حتى يتم تطوير أجهزة الكمبيوتر الخاصة بك بما فيه الكفاية بحيث يكون من السهل التعامل مع تعقيد بيانات الأرشيف.

## الملفات والأدلة ومراكز التخزين وتنسيقات البيانات

قد يكون من المفيد مناقشة كيفية تقسيم الأرشيف منطقيًا. ويحتمل أن تكون مناقشة الملفات والأدلة وتنسيقات البيانات أمر مفيد.

والملف عبارة عن مجموعة من البيانات التي تم تجميعها معًا في كيان متماسك باسم واحد: فكر في البيانات على أنها رمال، والملف كنوع من الحقائب يمكنه حمل الرمال، والرمال فقط. والدليل عبارة عن مجموعة من الملفات: فكر في الأمر كنوع من الحقائب يمكنه فقط حمل الحقائب الأخرى. وبعد هذه الاستعارة، يتكون كل مركز تخزين من دليل خارجي، يعرف باسم الدليل الجذر، والذي يحتوي على عدد من الملفات و/أو عدد من الأدلة. يمكن أن يحتوي كل دليل بدوره على الملفات والأدلة نفسها.

وهذه البنية مفضلة لأن الملفات المنظمة في مجموعات أسهل في التعامل معها من مجموعة واحدة من الملفات. ويتكون معرف ملف معين داخل الدليل الخارجي من أسماء جميع الأدلة المرفقة، بدءًا من الجذر، متبوعًا باسمه الفردي، مع حرف / a بين كل اسم. فمثلا سيتم تحديد ملف باسم README.md في الدليل الجذر على أنه /README.md وملف تم التعرف عليه باسم /public/www/index.html سيكون index.html للملف في دليل "www" داخل دليل "عام" داخل دليل الجذر.

يحتوي كل مركز تخزين بدوره على اسمين مفصولين بفاصل، ويكون في الأرشيف _ أو شرطة سفلية. (من الناحية التاريخية، كان / أو شرطة مائلة، ولكن يتم استخدامه أيضًا للإشارة إلى دليل، لذلك نستخدم _ للتوضيح.) الاسم الأول هو حساب GitHub الذي يمتلك هذا المركز؛ والثاني هو اسم المركز الفردي. يمكن استخدام مجموعة من معرفات مركز التخزين ومعرفات الملفات لتحديد ملف فردي في الأرشيف بشكل فريد. فمثلا يمكن تحديد الملف "package.json" في الدليل "web" في مركز التخزين "ykarma" داخل حساب GitHub "rezendi" بشكل فريد على أنه /web/package.json في rezendi_ykarma في الأرشيف.

وهناك أنواع مختلفة من الملفات لها أغراض مختلفة. يتكون أرشيف GitHub إلى حد كبير من ملفات نصية، وهي الملفات التي يقصد من بياناتها تمثيل اللغة المكتوبة. يتم كتابة معظم البرامج في ملفات نصية تحتوي على نص منظم للغاية يعرف باسم كود المصدر. ويقوم برنامج خاص يُعرف باسم برنامج التحويل البرمجي بتحويل كود المصدر القابل للقراءة من جانب أي شخص إلى إرشادات قابلة للقراءة من خلال الكمبيوتر تعرف باسم رمز برنامج التحويل أو رمز الجهاز.

وغالباً ما يشار إلى الملفات غير النصية، مثل الملفات التي تمثل الصور المرئية أو تحتوي على رمز برنامج التحويل، على أنها ملفات ثنائية. وهذا للأسف مصطلح مضلل، حيث أن الملفات النصية هي 1s و0s أيضًا. سنشير إلى الملفات غير النصية باسم ملفات غير نصية.

وهناك العديد من الطرق لتمثيل لغة الإنسان المكتوبة باستخدام 1s و0s. ولأسباب تاريخية، كان كود المصدر مكتوبا معظمه في الأصل في ما يعرف بالحروف اللاتينية. حيث يحتوي النص اللاتيني على 26 حرفًا أساسيًا تُستخدم لتمثيل الكلمات المنطوقة، لكل منها شكلان، الأحرف الكبيرة والصغيرة. وبها 10 أرقام لتمثيل الأرقام. يتم ترميز النص اللاتيني، إلى جانب مختلف الرموز الأخرى المرتبطة المستخدمة للإشارة إلى البنية والمفاهيم الأخرى، إلى 1s و0s بتنسيق يُعرف باسم "ASCII"، والذي يمكن أن يمثل 128 حرفًا مختلفًا ولأسباب تاريخية كانت سائدة في معظم البرامج لسنوات عديدة.

إلا أن الكتابة اللاتينية ليست سوى مجموعة فرعية صغيرة من الطرق العديدة التي يعبر بها الإنسان عن نفسه بلغة مكتوبة. ولدعم البرامج النصية الأخرى، مع السماح أيضًا لجميع البرامج التي تمت كتابتها باستخدام ASCII لمواصلة العمل دون تغييرات (مفهوم يُعرف باسم التوافق مع الإصدارات السابقة)، تم تقديم تنسيق بيانات أخرى تعرف باسم "UTF-8".

يبقى ASCII التنسيق الأكثر شيوعًا لكود المصدر. وتتضمن كل بكرة من هذا الأرشيف دليلًا لأحرف ASCII. ASCII هي مجموعة فرعية من UTF-8، وهذا يعني أن جميع ترميزات ASCII هي ترميزات UTF-8 أيضًا. وتحتوي بكرة توجيه بالإضافة إلى ذلك على مواصفات لجميع أحرف UTF-8. ويجب تشفير جميع الملفات النصية في هذا الأرشيف تقريبًا باسم UTF-8.

تشتمل الملفات غير النصية على ملفات مخصصة لتمثيل الصور والمستندات المنسقة. كما أن الاصطلاح المستخدم على نطاق واسع هو أن ينتهي الملف بحرف "." يليه لاحقة والتي تشير إلى نوعه. فمثلا من المحتمل أن يكون الملف الذي ينتهي بـ .jpg هو ملف صور JPEG؛ والملف الذي ينتهي بـ .PNG من المحتمل أن يكون ملف صورة Portable Network Graphic؛ والملف الذي ينتهي بـ .pdf هو ملف Portable Document Format.

لا توجد لاحقة واحدة تشير إلى الملفات النصية. وبدلاً من ذلك، فيما يتعلق بكود المصدر، من الأرجح أن تشير اللاحقة إلى لغة البرمجة أو الترميز التي تتم كتابة الشفرة فيها. سيتم وصف لغات البرمجة والترميز بمزيد من التفاصيل أدناه.

## كيفية استخراج محتويات الأرشيف

نقدم هنا نظرة عامة حول كيفية فك مركز تخزين مؤرشف معين في ملفاته المكونة المختلفة. مرة أخرى، تتكون هذه العملية من:

1.  تحديد البكرة والإطارات المحددة التي يتم أرشفة بيانات المركز عليها.

2.  فك تشفير كود الاستجابة السريعة، وحقول البكسل الأسود والأبيض والرمادي على تلك الإطارات، إلى ملف ثنائي وتسلسل (على الأقل الآلاف، وغالبًا ملايين) 1s و0s.

3.  فك ضغط الملف الثنائي في ملف أرشيف أطول وغير مضغوط.

4.  تفريغ ملف الأرشيف في الملفات الفرعية المنفصلة التي يحتوي عليها. لاحظ أن بيانات الأرشيف تكون مفهومة بشكل عام، رغم الفوضى، حتى عند حذف هذه الخطوة.

5.  أخيرًا، تحويل هذه الملفات الفرعية - وهي تسلسل من 1s و0s وتتراوح من قصيرة جدًا إلى طويلة جدًا - إلى أحرف مكتوبة، إذا كانت ملفات نصية.

### تحديد بكرة وإطارات محددة يتم أرشفة بيانات مركز الإيداع عليها

تبدأ كل بكرة فيلم بدليل فيلم فارغ، ثم الإطار المرجعي Zero، الذي يتكون من مستطيل أسود صلب في زاوية واحدة من إطار فارغ آخر. الإطار التالي القابل للقراءة من جانب أي شخص هو إطار التحكم، مع معلومات حول البكرة. فيما يلي جدول المحتويات، والذي بدوره يتضمن قائمة بملفات بيانات المستخدم.

يعد كل مركز تخزين على بكرة أحد ملفات بيانات المستخدم هذه. تحتوي القائمة على معرّف فريد ومعرف ملف واسم لكل من هذه الملفات. فمثلا قد يحتوي مركز تخزين CPython الخاص بحساب Python على معرف الملف المدرج كـ 12345، والاسم المدرج كـ python_cpython.tar.

بعد قائمة ملفات بيانات المستخدم، توجد قائمة بمواقع البيانات الرقمية. تتضمن هذه القائمة معرّف الملف وإطار البدء وبايت البدء وإطار النهاية وبايت النهاية. ولذلك باستخدام مثال CPython الافتراضي، قد يكون للعنصر الموجود في هذه القائمة ذي المعرف 12345 إطار بدء 054321، وبايت بدء 03210321، وإطار نهاية 054545، وبايت نهاية 12321232.

وهذا يعني، للحصول على بيانات CPython: انتقل إلى الإطار 54321 من بكرة الفيلم هذه. قم بفك تشفير جميع الإطارات من إطار البدء، 54321، إلى إطار النهاية، 54545، إلى قيم ثنائية، بالوسائل الموضحة أدناه. سيوفر لك هذا 225 قطعة من البيانات المرقمة من 54321 إلى 54545، والتي ستبدأ بمجموعة من القطع الفارغة بدون بيانات. تجاهل أول 3210320 بايت في أول وحدة بيانات غير فارغة. إلحاق جميع وحدات البيانات "الوسطى" بالترتيب. وأخيرًا، إلحاق البايت 12321232 الأولى من وحدة البيانات الأخيرة، 54545. لقد قمت الآن بتجميع مركز تخزين CPython الكامل، كملف أرشيف مضغوط واحد.

### فك تشفير كود الاستجابة السريعة في ملف ثنائي

تم العثور على تفاصيل كيفية فك تشفير إطارات الفيلم إلى بيانات ثنائية في بيانات التمثيل المقروءة من جانب أي شخص والتي تم العثور عليها بعد جدول المحتويات في بداية كل بكرة فيلم في الأرشيف. تم العثور على هذه المعلومات في كل بكرة بحيث، حتى لو تم فصل بكرة فردية عن الأرشيف، فسيظل من الممكن فك محتوياتها. تتضمن بيانات التمثيل هذه، بالترتيب:

1.  دليل برنامج أرشيف GitHub (هذه الوثيقة)

2.  الفهرس الوصفي لـ GitHub، وهو قائمة ووصف موجز لجميع المركز الموجودة على هذه البكرة

3.  وصف بيانات التمثيل

4.  الحفظ الرقمي وكيفية استرداد البيانات، ونظرة عامة على تفاصيل استرجاع البيانات

5.  وصف متوسط التخزين

6.  تقنية استرجاع البيانات

7.  هيكل بكرة الحفظ العام (شكل البكرة)

8.  وصف تنسيق الإطار 4K العام

9.  وصف إزالة تحديد المكتبة (لكود الاستجابة السريعة)

10. ترميز مصدر إزالة تحديد المكتبة

11. مواصفات تنسيق بيانات ASCII

12. مواصفات لغة البرمجة C

13. ترميز مصدر ملف أرشيف TAR

14. ترميز مصدر PDF

15. مواصفات تنسيق ملف XZ (للضغط / إلغاء الضغط، الموصوفة أدناه)

يصف الجزء السادس من هذه العناصر، مستند تقنية استرداد البيانات، المتطلبات والعمليات اللازمة لاستخدام الماسح الضوئي لالتقاط البيانات على إطار فيلم مشفر رقميًا وتحويله إلى نموذج قابل للتحليل من خلال الكمبيوتر. ويقدم الجزء الثامن منها، وصف تنسيق Generic 4K Frame، المعلومات الفنية، بما في ذلك كود المصدر، المطلوب لجهاز الكمبيوتر لالتقاط هذه الصورة الممسوحة ضوئيًا وتحويلها إلى بيانات ثنائية.

ومن الممكن نظريًا، من حيث المبدأ، تحويل مركز تخزين من البيانات المشفرة من خلال الاستجابة السريعة إلى بيانات ثنائية دون استخدام جهاز كمبيوتر. ومع ذلك، سيكون الأمر بالغ الصعوبة وقد يتطلب جهدًا كبيرًا من مجتمع منظم جيدًا على مدار أسابيع عديدة، إن لم يكن أشهر أو سنوات. نظرًا لأن محتويات المركز عبارة عن برنامج مخصص للتشغيل على جهاز كمبيوتر، فإن استخدامها في حالة عدم وجود كمبيوتر سيكون ضئيلًا في أحسن الأحوال.

وفي حالة عدم وجود تابع لهذا الأرشيف في أجهزة الكمبيوتر، فيجب أن يحتفظوا بالأرشيف كاملاً وآمنًا حتى القيام بذلك. ويتمثل أحد أغراض Tech Tree القابلة للقراءة من جانب أي شخص في المساعدة في تسريع عملية تطوير التقنيات وأجهزة الكمبيوتر في حالة حدوث هذا الاحتمال. (والغرض الآخر هو ترميز تقنيتنا وتطويرها للمؤرخين في المستقبل.)

### فك ملف الأرشيف إلى ملفات فرعية منفصلة يحتوي عليها

الملف الثنائي لكل مركز تخزين هو تنسيق معروف باسم TAR، لأرشيف الشريط. يتكون ملف TAR بشكل أساسي من خلال تجميع عدد من الملفات معًا عن طريق ربط نهاية أحد الملفات ببداية التالي، مثل تسجيل أجزاء فردية من الورق معًا في تمرير واحد. يمكن أن يتضمن ملف TAR أي عدد من الملفات، من أي حجم، مقسومًا إلى أي عدد من الأدلة والأدلة.

يتم وضع كل ملف فرعي داخل ملف TAR بسجل رأس 512 بايت، والذي يعمل مثل الشريط في استعارة التمرير. يحتوي سجل الرأس على معلومات حول الملف، مثل الاسم والحجم. يشار إلى نهاية الأرشيف من قبل اثنين على الأقل من 512 بايت كتل.

نظرًا لأن ملفات TAR هي مجرد مجموعات من الملفات التي تحتوي على سجلات نصية بينها، فإذا كان ملف TAR يحتوي على جميع الملفات النصية، فيمكن معالجتها كملف نصي نفسه. وإذا كان يحتوي على خليط، فيمكن التعامل معه كملف نصي يحتوي على مزيج من نص منظم ومفيد (الملفات النصية المكونة) ورطانة غير مفهومة (الملفات غير النصية المكونة.)

من الممكن تداخل ملفات TAR داخل ملفات TAR، حيث حاوية واحدة داخل أخرى، وذلك طريقة تخزين معظم البيانات المؤرشفة لدينا. بالنسبة لأي مركز تخزين، فسوف يحتوي ملف TAR الخارجي على الأقل على ما يلي:

* ملف تعريف واحد غير مضغوط يسمى META، والذي يتضمن اسم المركز واسم الحساب والوصف واللغة وعدد النجوم وعدد التفريعات
* ملف مضغوط (انظر أدناه) باسم COMMITS، والذي يتضمن سجل التغييرات التي تم إجراؤها على المركز بمرور الوقت
* ملف باسم repo.tar.xz، وهو ملف TAR مضغوط يتضمن محتويات مركز التخزين الفعلي

قد يتم أيضًا تضمين بيانات التعريف الأخرى، مثل الويكي وصفحات gh والمشكلات وطلبات السحب، كملفات مضغوطة منفصلة.

ويمكن العثور على تفاصيل محددة لملفات TAR والبرنامج لتشفيرها وفك تشفيرها في بيانات التمثيل في كل بكرة من الأرشيف.

### فك ضغط الملفات المضغوطة في ملفات قابلة للقراءة وغير مضغوطة

لتضمين أكبر عدد ممكن من مراكز التخزين وأكبر قدر ممكن من البيانات، تم ضغط معظم البيانات. والضغط يعني استخدام كمية صغيرة من البيانات لتمثيل كمية أكبر، عن طريق استخدام الأنماط والتكرار في هذه الكمية الأكبر. فمثلا بدلاً من كتابة الحرف تسع مرات متتالية، يمكن للمرء فقط كتابة النص المضغوط 9a، إذا كان المرء واثقًا من أن القارئ يفهم أن 9a تعني aaaaaaaaa كنص غير مضغوط.

بينما خوارزميات الضغط الفعالة أكثر تعقيدًا من ذلك بكثير، لكن يطبق المبدأ نفسه. يستخدم هذا الأرشيف برنامج ضغط يعرف باسم "XZ"، والذي يستخدم بدوره خوارزمية تعرف باسم "LZMA". يحتوي ملف البيانات الثاني في كل بكرة على كود المصدر والوثائق لـ XZ في ملف أرشيف TAR واحد غير مضغوط، موصوف أدناه. (يحتوي ملف البيانات الأول على الإعلان العالمي لحقوق الإنسان بجميع اللغات المكتوبة المتوفرة.)

يجمع LZMA بين ما يُعرف باسم خوارزمية "LZ77" و"تشفير النطاق". يستبدل LZ77 البيانات المتكررة بالإشارات إلى المظاهر السابقة لتلك البيانات. ويكون الإفراط في المبالغة مثلا، إذا ظهرت عبارة 80 بايت مرتين، 400 بايت منفصلة، في المرة الثانية، تقوم الخوارزمية بضغط البيانات بشكل أساسي بالقول "كرر 80 بايت من 400 بايت من قبل". يقوم تشفير النطاق بتحويل الرسالة بالكامل إلى رقم واحد طويل للغاية، والذي بدوره يمكن ترميزه.

يتم وصف الخطوات المحددة للخوارزمية المراد استخدامها لفك ضغط البيانات من خلال كود المصدر XZ الموجود في ملف البيانات الثاني في كل بكرة. وعلى الرغم من أنه من الممكن نظريًا إلغاء الضغط باليد، إلا أنها ستكون عملية كثيفة الاستخدام للوقت والعمل. وفي الممارسة العملية، سيتم استدعاء جهاز كمبيوتر يعمل.

### تحويل كل ملف فردي إلى أحرف مكتوبة

وقد استخدم الإنسان العديد من الأحرف المكتوبة على مدى آلاف السنين. يُعرف الترميز المستخدم لتمثيل هذه الأحرف كـ 1s و0s داخل هذا الأرشيف باسم "UTF-8". يمكن أن يشغل حرف UTF-8 فرديًا، أي رمزًا مكتوبًا واحدًا، في أي مكان من 1 إلى 4 بايت من البيانات الثنائية.

لأسباب تاريخية، نظرًا لأنها كانت الأكثر استخدامًا في الوقت والمنطقة ومكان وزمان بدء تطوير البرامج، يتم ترميز مجموعة من الأحرف (والمفاهيم) المعروفة باسم "ASCII" بكفاءة أكبر، بمعدل 1 بايت لكل حرف. يتم تشفير أي شيء بخلاف ASCII كـ 2 بايت أو أكثر لكل حرف. معظم الملفات النصية في هذا الأرشيف هي ASCII، لكن العدد الكبير ليس كذلك. وسيكون أكثر من ذلك بكثير ASCII مع أحرف ASCII غير عرضية.

يمكن العثور على المواصفات التفصيلية الخاصة بـ ASCII في بيانات التمثيل في كل بكرة من الأرشيف. ويمكن العثور على المواصفات التفصيلية لـ UTF-8 في بكرة التوجيه. سوف يحتوي ملف البيانات الأول على كل بكرة من الأرشيف على نص الإعلان العالمي لحقوق الإنسان بكل لغة مكتوبة متوفرة. سيكون هذا بمثابة أداة ترجمة وكمثال على ASCII وUTF-8.

## أنواع الملفات

هناك العديد من أنواع الملفات النصية المختلفة التي تم إنشاؤها لأسباب مختلفة. النوع الأساسي هنا، والسبب في وجود هذا الأرشيف، هو كود المصدر. كود المصدر هو نص كثيف ومنظم للغاية، يحتوي على رموز مثل '{' و';' ذو أهمية كبيرة.

والعنصر الرئيسي في كود المصدر هو أنه مكتوب لقراءته من قبل برنامج التحويل البرمجي. نظرًا لأن برنامج التحويل البرمجي عبارة عن برنامج، فإن الطريقة الأخرى لصياغة هذا هي كتابة كود المصدر لقراءتها من خلال أجهزة الكمبيوتر. يتم كتابة الرمز الجيد أيضًا حتى يتمكن الآخرون، إذا كانوا مهرة ومتعلمين في مجال البرامج، من فهمه؛ ويكون هذا صحيح فقط إذا تمكن برنامج التحويل البرمجي من فهمه.

سيقوم هذا المحول البرمجي، بدوره، من خلال تسلسلات معقدة موصوفة في Tech Tree، بتحويل كود المصدر إلى تسلسلات من الأحاد والأصفار التي تعمل على قيام الكمبيوتر بأداء المهام والأنشطة الموضحة في التعليمات البرمجية. لضرب مثال بسيط للغاية، فإن سطر الرمز

_لـ (int i=0; i<5; i++) { }_

سيتم تحويلها من خلال برنامج التحويل البرمجي إلى سلسلة من الإرشادات الثنائية التي يتم تغذيتها على جهاز الكمبيوتر، مما يعمل على قيام جزء صغير من الكمبيوتر، يسمى السجل، بضبط قيمته على 0، ثم زيادة هذه القيمة إلى 1، 2، 3، ثم 4. (وهذا ليس المقصود منه أن يكون مثالًا على الترميز المفيد؛ وإنما مجرد مثال لعملية متعددة الطبقات لتحويل كود المصدر إلى برامج قيد التشغيل.)

يتم استخدام أنواع أخرى من الملفات النصية، مثل JSON وXML وHTML لتخزين البيانات (على عكس الأوامر) لأجهزة الكمبيوتر. ويمكن لأي شخص عمومًا قراءتها أيضًا، على الرغم من أن التنسيقات الهيكلية تجعل قراءتها أكثر صعوبة من نص سرد القصص الأقل تنظيماً مثل هذا الملف.

وتهدف معظم أنواع الملفات النصية الأخرى إلى قراءتها في النهاية من جانب أي شخص. بعضها بسيط، ونص غير منظم في الغالب، مثل هذا الملف الذي تقرأه حاليًا. وأن النوع الذي سوف تصادفه على نطاق واسع في الأرشيف هو Markdown، والذي يشير إليه الامتداد .md إلى ملف، وهو نوع من أنواع الوسيط يُقصد به أن يكون قابلاً للقراءة في شكله الأصلي وفي نفس الوقت، يكون منظم بحيث يمكن لأجهزة الكمبيوتر تنسيقها في تخطيطات أكثر جاذبية ومفيدة بصريًا. تحتوي معظم مراكز التخزين الموجودة في هذا الأرشيف على ملف README.md Markdown، والذي يُقصد به عمومًا أن يكون مقدمة مبدئية للمركز، ويصف ماهية هذا المحتوى ولماذا يوجد وكيف يستخدمه.

نظرة عامة مختصرة على أكثر أشكال الملفات النصية شيوعًا والتي قد تكون مفيدة أيضًا. رمز برنامج التحويل غير نصي. تقوم ملفات JPG وPNG بترميز الصور بالتنسيق الرقمي، بينما يقوم تشفير MP3 وWAV بترميز الصوت. تقوم ملفات PDF بترميز المستندات بدقة وتنسيق مثالي. وملفات ZIP وTAR، كما ذكرنا سابقًا، هي ملفات حاويات والتي قد تتضمن بدورها أكثر من ملف آخر.

## اللغات البشرية ولغات البرمجة

### اللغات البشرية

هناك الآلاف من اللغات المكتوبة التي يستخدمها الإنسان اليوم، وحتى أكثر اللغات المنطوقة. ويتم استخدام معظمها فقط من قبل مجموعات صغيرة نسبيًا، ولكن هناك ما لا يقل عن عشرين لغة تستخدم كلغة أولى أو ثانية من قبل 60 مليون شخص على الأقل.

أكثر اللغات استخدامًا في العالم هي الإنجليزية والصينية. لأسباب تاريخية، حدث معظم تطوير البرامج في الدول الناطقة باللغة الإنجليزية لسنوات عديدة، لذا فقد أصبحت اللغة الإنجليزية هي اللغة الافتراضية للبرنامج لفترة من الزمن. وتستخدم معظم لغات البرمجة الكلمات الإنجليزية في بناء الجملة الخاصة بهم. إنها اللغة التي كتب بها هذا الدليل للأرشيف لأول مرة.

ليس مضمونًا أن يعرف الحاصلون على هذا الأرشيف اللغة الإنجليزية، على الرغم من أنها تبدو لغة من المرجح أن تستمر إلى أجل غير مسمى. وفي حالة وجود بعض التوجيهات للغات الأخرى المفيدة، فإننا نقوم بتضمين أكثر من 500 ترجمة متوفرة للإعلان العالمي لحقوق الإنسان كملف UTF-8 غير مضغوط في بداية كل بكرة، وأيضًا ضمن Tech Tree. وهذا الإعلان هو قائمة بحقوق وحريات كل فرد في عصرنا، والتي يجب ألا يلقى بها جانبا.

### لغات البرمجة

لغات البرمجة هي تلك المستخدمة من قبل الإنسان لتوصيل التعليمات إلى أجهزة الكمبيوتر. وهي اللغات التي يتم التعبير عن البرامج بها. ويجب أن يكون الآخرون (المدربون) قادرين على قراءة البرنامج المكتوب بلغات البرمجة، لكن هذا هدف ثانوي.

لغة البرمجة عبارة عن مجموعة من العناصر المحددة مسبقًا، معظمها عبارة عن كلمات، يمكن ترتيبها بطريقة منظمة لتوجيه الكمبيوتر إلى تنفيذ الإجراء المحدد بالطريقة المحددة. تُعرف مجموعة من هذه التعليمات بالبرنامج أو كود المصدر. كود المصدر هو برنامج في شكل مكتوب ومجمد في الأساس.

وتنقسم البرامج عمومًا إلى خطوات منفصلة، تُعرف باسم العبارات، والتي بدورها يتم تجميعها معًا في مجموعات تعرف باسم المهام. وقد يتم تضمين البرنامج بأكمله في ملف واحد، أو قد ينتشر عبر الآلاف.

فهناك المئات من لغات البرمجة المختلفة، تنتشر عبر العديد من الأشكال والمناهج والفلسفات المختلفة. ويتم تجميع بعضها في ملفات ثنائية منفصلة، والتي يتم تنفيذها بعد ذلك؛ ويتم تجميع بعض اللغات، المعروفة باسم اللغات "المفسرة"، بشكل فعال وتشغيلها مرة واحدة، دون أي مرحلة مؤقتة. تشتمل معظم اللغات الحديثة على مكتبات وظائف مكتوبة مسبقًا، ويمكن أن تكون هذه المكتبات ضخمة جدًا ومتقنة. وتتضمن بعض لغات البرمجة الأكثر شيوعًا اليوم:

-   C، واحدة من أقدم وأسرع اللغات وأكثرها شمولية وقوة، فهي بسيطة من بعض النواحي ولكنها محدودة للغاية في لغات أخرى، ولا تكون دائمًا سهلة الاستخدام أو سهلة القراءة أو سهلة التعلم.

-   C ++، تطور أكثر تعقيدًا وتجريدًا وقوة لـ C.

-   C #، تطور إضافي تم تجميعه ليس في رمز الجهاز الثنائي ولكن "وقت التشغيل" الذي تم تفسيره.

-   Java، التي تشبه (ولكن تسبق) C #، هي اللغة الأكثر استخدامًا اليوم.

-   JavaScript، على عكس جافا تمامًا على الرغم من التشابه في الاسم، والمعروف أيضًا باسم "ECMAScript"، هي لغة مستخدمة مبدئيًا بالكامل داخل مستعرض الويب، مثل برنامج الحصول على البيانات وتفسيرها وعرضها من كمبيوتر بعيد يعرف باسم خادم الإنترنت؛ اليوم، ويستخدم رغم ذلك على نطاق واسع على تلك الخوادم أيضًا.

-   TypeScript، وهو شكل من أشكال جافا سكريبت مع قواعد أكثر صرامة بحيث تكون الأخطاء، والمعروفة أيضًا باسم المشكلات، أقل عرضة للعثور على البرامج.

-   Python، لغة أنيقة تحظى بشعبية كبيرة بين العلماء، كلغة قوية ولغة أولى جيدة.

-   Ruby، لغة بديهية غالبًا ما تقرأ بياناتها مثل اللغة الإنجليزية المكتوبة.

-   Go، لغة بسيطة وقوية تتفوق بشكل خاص في البرامج المتوازية، أي البرامج المكتوبة بحيث تعمل وظائف متعددة بشكل مستقل في نفس الوقت.

-   Swift، لغة جديدة تستخدم في الكتابة للهواتف والأجهزة الأخرى التي يستخدمها نحو مليار شخص.

-   Rust، والمقصود بها بديل C، وهو ما يجعل المشكلات الخطرة أقل احتمالا بكثير.

-   PHP، وهي لغة واضحة تستخدم لخوادم الإنترنت.

-   Lisp، وهي لغة قديمة جدًا لها نهج وظيفي مختلف تمامًا في البرمجة.

-   SQL، نوع مختلف تمامًا من اللغة المستخدمة في الحصول على البيانات من مخازن منظمة وفعالة للغاية للبيانات المعروفة باسم قواعد البيانات.

-   المجمع (أو التجميع)، وهي عائلة لغات خفية ومحدودة ولكنها سريعة وقوية حيث توجد علاقة مباشرة بين بنيات اللغة ورمز جهاز الكمبيوتر المعني؛ وقد يعتبر رمز نصف برنامج محول.

## التطوير، التبعيات، والمصدر المفتوح

### التطوير

تعتبر عملية الحصول على ملف ترميز مصدر واحد بسيط وتحويله إلى نبضات كهربائية داخل جهاز كمبيوتر عملية معقدة للغاية. فنحن نتعامل مع هذا التعقيد باستخدام درجات من الاستخراج. يسمح الاستخراج المعروف باسم مجموعة التعليمات باستخدام استخراج رمز الجهاز من برنامج التحويل البرمجي الواحد على العديد من أنواع أجهزة الكمبيوتر المختلفة. ولا يحتاج مؤلف كود المصدر عادةً إلى معرفة أو الاهتمام بنوع الكمبيوتر، أو حتى مجموعة التعليمات، التي سيتم استخدامها لتشغيل هذا الرمز؛ فهذا ما يتم استخلاصه من قبل برنامج التحويل البرمجي.

البرامج الحديثة، بدورها، أكثر تعقيدًا من مؤلف واحد يعمل على برنامج واحد لجهاز كمبيوتر واحد. يتكون من العديد من المؤلفين الذين يعملون على العديد من الملفات داخل مشروع واحد، في وقت واحد، وغالبًا ما يستخدمون لغات برمجة متعددة. وعلاوة على ذلك، يعتمد كل مشروع على مشاريع أخرى منفصلة وذاتية كأدوات و/ أو مكونات، في حين أن هذه المشروعات هي نفسها قيد العمل وبشكل نشط، وتعتمد بدورها على مشاريع أخرى. كما أن القيام بتشغيل كل هذه الأجزاء المتحركة معًا بشكل أنيق وكفء هو في الواقع تحدي تطوير البرامج الحديثة.

وعندما يعمل العديد من مؤلفي كود المصدر، والمعروفين أيضًا باسم مطوري البرامج، على مشروع واحد، يكون لكل منهم جهاز كمبيوتر خاص، ونسخة من المشروع بالكامل على الكمبيوتر الخاص بهم. وإذا قام كل منهم بإجراء تغييرات، يكون لكل منهما إصدار مختلف من نفس المشروع. تُعرف عملية التوفيق بين إصدارات متعددة من المشروع باسم التحكم في الإصدار. ويتم إدارته من خلال برنامج التحكم في الإصدار؛ في هذا الأرشيف، من خلال برنامج يسمى Git، وبعد ذلك يتم تسمية GitHub. كل مركز تخزين في هذا الأرشيف هو مركز Git.

يمكن لـ Git دمج إصدارات مختلفة من البرامج تلقائيًا معًا في شكل واحد متماسك مع الحد الأدنى من التدخل البشري المطلوب. وتحتفظ Git أيضًا بسجل كامل يسمح لك بالعودة إلى إصدار سابق عند الحاجة. ومع ذلك، لتوفير مساحة، لا يتضمن مركز تخزين الأرشيف هذا بشكل عام سجلات Git.

وعندما يأخذ عدة مطورين مشروعًا على مسارات مختلفة متعددة في وقت واحد، يُعرف هذا باسم تشعب المشروع، وتُعرف هذه المسارات باسم الفروع. ويُعرف الفرع الرئيسي المتفق عليه للمشروع باسم الجذع أو الفرع الرئيسي. تتيح Git كيان يمكن للمطورين استخدامه لتلخيص الاختلافات بين فرعين واقتراح الانضمام إلى فروعهم في الكيان الآخر. ويعرف ذلك باسم طلب السحب. يتكون تطوير البرامج الحديثة إلى حد كبير من تفرع مشروع ما أو كتابة البرنامج أو تحريره على الفرع الخاص بك، وعند الانتهاء من ذلك، يتم إرسال طلب سحب لإعادة إدراج عملك في الفرع الرئيسي.

### التبعيات

تدعم كل لغة برمجة بشكل أساسي البناء على عمل الآخرين. وبدون إعادة استخدام عمل الآخرين، سيكون كل مشروع أكثر صعوبة، وأبطأ إلى حد كبير، وسوف يختفي عدد قليل من المشاريع من الاستخدام الفعلي في العالم الحقيقي.

وإذا احتاج المشروع "أ" إلى إدراج المشروع "ب" لكي يقوم "أ" بعمله، فيُعرف "أ" بكونه يعتمد على المشروع "ب"، ويعرف "ب" بتبعية "المشروع أ". ويمكن أن يكون لـ "أ" تبعيات كثيرة، ولكل منهم تبعيات كثيرة خاصة بهم، وهكذا. وعلاوة على ذلك، فإن كل تبعية مخصصة لإصدار معين، أو مجموعة من الإصدارات، لمشروع معين. ويُعرف التصنيف الكامل لجميع طبقات التبعيات المتعددة للمشروع باسم شجرة التبعية الخاصة به.

وبشكل عام، يتم اعتماد التبعيات داخل ملفات كود المصدر، وعادةً ما تكون في الأعلى، وفي كل مرة يعثر فيها برنامج التحويل البرمجي أو على تبعية، فإنه يبحث عنها في مجموعة من الأدلة المحددة مسبقًا. ونظرًا لأن شجرة التبعية للمشروع يمكن أن تكون معقدة للغاية، يتم أحيانًا تحديد عنصرها بالكامل في ملف واحد داخل مشروع يُعرف باسم قائمة الحزم. فمثلا قد تحميل مشاريع Ruby ما يسمى بـ Gemfile لهذا الغرض، وقد يكون لمشاريع JavaScript ملف package.json. يتيح ذلك نوعًا من الأدوات المعروفة باسم برنامج إدارة الحزم لجلب كل التبعيات للمشروع دفعة واحدة، من خادم واحد أو أكثر من خوادم الإنترنت.

وفي حالة هذا الأرشيف، يحتمل أن تكون التبعيات لأي مشروع معين موجودة في مكان آخر في الأرشيف. ومن أجل العثور على التبعية في الأرشيف، يجب على المرء أولاً اكتشاف اسم التبعية في كود المصدر أو قائمة الحزم، حيث تختلف التفاصيل الدقيقة حسب اللغة والإطار، ثم استخدام الفهرس الرئيسي في بكرة التوجيه، أو، في حالة عدم وجودها، فهارس في مقدمة كل بكرة، لتحديد أي بكرة وإطار (إطارات) يمكن العثور عليهما.

### المصدر المفتوح

نظرًا لأن تشغيل برنامج على جهاز كمبيوتر لا يتطلب سوى رمز الجهاز المجمع، فمن الممكن توزيع ذلك مع الحفاظ على سرية كود المصدر. وهذا ما يعرف باسم نموذج مغلق المصدر. وفي الأيام الأولى للحوسبة، كان يتم عادةً توزيع كود المصدر مع رمز الجهاز الخاص بها، ولكن فيما بعد، حيث أصبح البرنامج صناعة مربحة، أصبح نموذج المصدر المغلق أكثر شيوعًا.

لقد تعلمنا منذ ذلك الحين أن جعل كود المصدر عام، بحيث يمكن لأي شخص نسخه، وتحسينه، يعد وسيلة أكثر فاعلية لتطوير البرامج.	 ويعني إتاحة المزيد من الأشخاص الذين يمكنهم قراءة ترميز مصدر المشروع عددًا أكبر من الأشخاص لتحديد الاحتياجات المحتملة والميزات الجديدة المفيدة، والمزيد من الأشخاص الذين يفهمون المشروع بما يكفي للمساهمة فيه، والمزيد من الأشخاص الذين قد يرصدون الأخطاء ويقدمون الحلول، والمزيد من الأشخاص لاختبار والتحقق من عمل هذا الرمز الجديد.

وبشكل عام، يؤدي المصدر المغلق إلى مجتمعات أصغر معزولة ومجزأة تسعى لإيجاد وتبني أفكار جديدة وأفضل. ويؤدي المصدر المفتوح إلى مجتمعات كبيرة ومترابطة، يساعد كل منها على نمو مشاريع الآخر وازدهارها ونجاحها، باستخدام عمل بعضهم البعض كتبعية و/ أو إعادة استخدام الرمز، والتعلم من بعضهم البعض. كما أن برامج المصدر المفتوح عبارة عن مجموعة أدوات للاستخدام الجماعي للجميع، وكلما كانت الأدوات المتوفرة لدينا أكثر وأفضل، تمكنا بشكل أسرع من التقدم كأنواع وفصائل.