Getting Started with Python
---------------------------

New to Python? Let's properly setup up your Python environment:

.. toctree::
   :maxdepth: 2

   starting/which-python

- Properly Install Python on your system:

 .. toctree::
    :maxdepth: 1

    starting/installation
    starting/install3/osx
    starting/install3/win
    starting/install3/linux
    starting/install/osx
    starting/install/win
    starting/install/linux


- Using Virtualenvs with Pipenv:

 .. toctree::
    :maxdepth: 2

    dev/virtualenvs


Python Development Environments
-------------------------------

This part of the guide focuses on the Python development environment,
and the best-practice tools that are available for writing Python code.

.. toctree::
   :maxdepth: 2

   dev/env
   dev/virtualenvs
   dev/pip-virtualenv




Writing Great Python Code
-------------------------

This part of the guide focuses on the best-practices for writing Python code.

.. toctree::
   :maxdepth: 2

   writing/structure
   writing/style
   writing/reading
   writing/documentation
   writing/tests
   writing/logging
   writing/gotchas
   writing/license



Scenario Guide for Python Applications
--------------------------------------

This part of the guide focuses on tool and module advice based on
different scenarios.

.. toctree::
   :maxdepth: 2

   scenarios/client
   scenarios/web
   scenarios/scrape
   scenarios/cli
   scenarios/gui
   scenarios/db
   scenarios/network
   scenarios/admin
   scenarios/ci
   scenarios/speed
   scenarios/scientific
   scenarios/imaging
   scenarios/serialization
   scenarios/xml
   scenarios/json
   scenarios/crypto
   scenarios/ml
   scenarios/clibs


Shipping Great Python Code
--------------------------

This part of the guide focuses on sharing and deploying your Python code.

.. toctree::
   :maxdepth: 2

   shipping/publishing
   shipping/packaging
   shipping/freezing


Additional Notes
----------------

This part of the guide, which is mostly prose, begins with some
background information about Python, and then focuses on next steps.

.. toctree::
   :maxdepth: 2

   intro/duction
   intro/community
   intro/learning
   intro/documentation
   intro/news

.. note::
   Notes defined within all diatonic and chromatic musical scales have been
   intentionally excluded from this list of additional notes. Additionally,
   this note.


--------------------------------------

Contribution notes and legal information (for those interested).

.. toctree::
   :maxdepth: 2

   notes/contribute
   notes/license
   notes/styleguide
