# How to release

- Update `CHANGELOG.md`
- Bump version (YYYY.MM) in `python_docs_theme/__init__.py`
- Commit
- Push to check tests pass on
  [GitHub Actions](https://github.com/python/python-docs-theme/actions)
- Go to https://github.com/python/python-docs-theme/releases
- Click "Draft a new release"
- Click "Tag: Select tag"
- Type the next YYYY.MM version (no leading zero) and
  select "Create new tag"
- Click "Create" for "YYYY.MM will be created on publish"
- Leave the "Release title" blank (it will be autofilled)
- Click "Generate release notes" and amend as required
- Click "Publish release"
- Check the tagged [GitHub Actions build](https://github.com/python/python-docs-theme/actions/workflows/pypi-package.yml)
  has deployed to [PyPI](https://pypi.org/project/python-docs-theme/#history)

# Makefile usage

This project includes a simple Makefile for syncing changes to the theme with
the main CPython repository. Run `make help` for details on available rules.

There is one configurable variable, `CPYTHON_PATH`, which should be the path
to the CPython repository on your machine. By default, it points to
`../cpython`.
