---
title: Integrations Directory marketing guidelines
---

# Marketing guidelines

{:toc}

This document will help you write compelling and well-structured marketing materials to help GitHub users understand the value of your integration. The sections below outline the document structure for integration pages.

## One line blurb

This is a short sentence (70 characters max), that'll show up right below your logo. It can be used for a tagline or quick summary of the integration.

## Description

Write a single paragraph that describes your integration clearly and speaks directly to the audience (think “you” and “your” over “we” and “our”). Answer the following questions in your description:

- What does it do?
- How does it integrate with GitHub?
- How does it empower developers?

Keep this section short and sweet.

**Example**

> Sample CI helps you deploy your code with confidence by continuously running your test suite. Avoid bugs and avert deployment disasters by catching bugs before they reach your users. Sample CI can update the build status on your pull requests as they progress and can deploy successful builds to production automatically.

## Images

Images are optional. Well curated images will help people get a sense for how your integration works with GitHub. Use multiple images as an opportunity to tell a story about your integration's workflow.

### Image guidelines
- Images should show your product in action
- When possible, show how your product integrates with GitHub
- Use no more than four images
- Images must be 1290x728 pixels (will appear as 645x364 pixels)

## Features

List some features to give people a better sense of what your integration offers. An ideal number is between three and six—pick the great ones.

### Feature guidelines
- Each feature should have a heading.
- Does the feature have a name? What is it?
- What does the feature do?
- How does it help people build better software?
- Does it interact with any external services (e.g., can deploy to Heroku, Engine Yard Cloud, etc.)?
- Does your feature require any setup?

**Example**

> **Deploy anywhere, with confidence**

> Deploying to production after a successful build is as easy as setting up a bit of configuration, and we’ll deploy your code to Heroku, Engine Yard Cloud, Nodejitsu, cloudControl, OpenShift, CloudFoundry, AppFog, and Amazon OpsWorks.

> Using a custom deployment? Customize the build to deploy to your servers!

## General tips
- Do not use `H1` level headings.
- Use `H3` for section headings, `H4` for subsections.
- Avoid italics. Use bold for emphasis instead.
- Use sentence case for titles.
- Do not write in all caps to provide emphasis.
- Write in [GitHub Flavored markdown](https://help.github.com/articles/github-flavored-markdown/).

## Logo
- Provide your integration logo as a 128x128 pixel PNG.
- Negative space must be transparent.
- Do not stretch or squish your logo to fill the space.
- You'll need to attach this logo to your GitHub Application, before the listing is published.

## Samples
Feel free to look at existing listings in the Integrations Directory, such as [Gitter](https://github.com/integrations/gitter) or [ZenHub](https://github.com/integrations/zenhub).
