---
title: Preview support for OAuth authorizations grants API
author_name: ptoomey3
---

GitHub recently made changes to [the application authorizations settings screen within GitHub][authorized-application-listing] to display one entry for each OAuth application a user has authorized. Previously this screen showed one entry for each OAuth token that was generated by an OAuth application. For example, if you installed two instances of GitHub Desktop, you would see one entry for each installation. To simplify OAuth application management, we now show a single entry for each OAuth application. For OAuth applications that use the [web flow][web-flow] this was not a problem, since the web flow never generates more than one token for a given OAuth application and user. However, going forward, GitHub would like to allow all OAuth applications, including those that use the web flow, to generate more than one token.

In preparation for that change, we are adding API support to simplify management of OAuth applications that matches what is available on GitHub.com. You can enable these changes during the preview period by providing a custom [media type][media-type] in the `Accept` header:

    application/vnd.github.damage-preview

For example:

``` command-line
curl -u username "https://api.github.com/applications/grants" \
  -H "Accept: application/vnd.github.damage-preview"
```

You can learn more about the new APIs in the [OAuth authorizations][oauth-authorizations-api] documentation.

During the preview period, we may change aspects of these APIs based on developer feedback. We will announce the changes here on the developer blog, but we will not provide advance notice.

If you have any questions or feedback, please [let us know][contact].

[media-type]: /v3/media
[oauth-authorizations-api]: /v3/oauth_authorizations
[authorized-application-listing]: https://github.com/settings/applications#authorized
[contact]: https://github.com/contact?form%5Bsubject%5D=OAuth+Authorizations+Grants+API+Preview
[web-flow]: /v3/oauth/#web-application-flow
