/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script.
 *
 * This part needs to get included in the compilation unit where
 * blocking_handler gets defined due to the way #pragma works.
 */


/** @defgroup CM3_nvic_isrpragmas_STM32L1 User interrupt service routines (ISR) defaults for STM32 L1 series
    @ingroup CM3_nvic_isrpragmas

    @{*/

#pragma weak wwdg_isr = blocking_handler
#pragma weak pvd_isr = blocking_handler
#pragma weak tamper_stamp_isr = blocking_handler
#pragma weak rtc_wkup_isr = blocking_handler
#pragma weak flash_isr = blocking_handler
#pragma weak rcc_isr = blocking_handler
#pragma weak exti0_isr = blocking_handler
#pragma weak exti1_isr = blocking_handler
#pragma weak exti2_isr = blocking_handler
#pragma weak exti3_isr = blocking_handler
#pragma weak exti4_isr = blocking_handler
#pragma weak dma1_channel1_isr = blocking_handler
#pragma weak dma1_channel2_isr = blocking_handler
#pragma weak dma1_channel3_isr = blocking_handler
#pragma weak dma1_channel4_isr = blocking_handler
#pragma weak dma1_channel5_isr = blocking_handler
#pragma weak dma1_channel6_isr = blocking_handler
#pragma weak dma1_channel7_isr = blocking_handler
#pragma weak adc1_isr = blocking_handler
#pragma weak usb_hp_isr = blocking_handler
#pragma weak usb_lp_isr = blocking_handler
#pragma weak dac_isr = blocking_handler
#pragma weak comp_isr = blocking_handler
#pragma weak exti9_5_isr = blocking_handler
#pragma weak lcd_isr = blocking_handler
#pragma weak tim9_isr = blocking_handler
#pragma weak tim10_isr = blocking_handler
#pragma weak tim11_isr = blocking_handler
#pragma weak tim2_isr = blocking_handler
#pragma weak tim3_isr = blocking_handler
#pragma weak tim4_isr = blocking_handler
#pragma weak i2c1_ev_isr = blocking_handler
#pragma weak i2c1_er_isr = blocking_handler
#pragma weak i2c2_ev_isr = blocking_handler
#pragma weak i2c2_er_isr = blocking_handler
#pragma weak spi1_isr = blocking_handler
#pragma weak spi2_isr = blocking_handler
#pragma weak usart1_isr = blocking_handler
#pragma weak usart2_isr = blocking_handler
#pragma weak usart3_isr = blocking_handler
#pragma weak exti15_10_isr = blocking_handler
#pragma weak rtc_alarm_isr = blocking_handler
#pragma weak usb_fs_wakeup_isr = blocking_handler
#pragma weak tim6_isr = blocking_handler
#pragma weak tim7_isr = blocking_handler
#pragma weak sdio_isr = blocking_handler
#pragma weak tim5_isr = blocking_handler
#pragma weak spi3_isr = blocking_handler
#pragma weak uart4_isr = blocking_handler
#pragma weak uart5_isr = blocking_handler
#pragma weak dma2_ch1_isr = blocking_handler
#pragma weak dma2_ch2_isr = blocking_handler
#pragma weak dma2_ch3_isr = blocking_handler
#pragma weak dma2_ch4_isr = blocking_handler
#pragma weak dma2_ch5_isr = blocking_handler
#pragma weak aes_isr = blocking_handler
#pragma weak comp_acq_isr = blocking_handler

/**@}*/

/* Initialization template for the interrupt vector table. This definition is
 * used by the startup code generator (vector.c) to set the initial values for
 * the interrupt handling routines to the chip family specific _isr weak
 * symbols. */

#define IRQ_HANDLERS \
    [NVIC_WWDG_IRQ] = wwdg_isr, \
    [NVIC_PVD_IRQ] = pvd_isr, \
    [NVIC_TAMPER_STAMP_IRQ] = tamper_stamp_isr, \
    [NVIC_RTC_WKUP_IRQ] = rtc_wkup_isr, \
    [NVIC_FLASH_IRQ] = flash_isr, \
    [NVIC_RCC_IRQ] = rcc_isr, \
    [NVIC_EXTI0_IRQ] = exti0_isr, \
    [NVIC_EXTI1_IRQ] = exti1_isr, \
    [NVIC_EXTI2_IRQ] = exti2_isr, \
    [NVIC_EXTI3_IRQ] = exti3_isr, \
    [NVIC_EXTI4_IRQ] = exti4_isr, \
    [NVIC_DMA1_CHANNEL1_IRQ] = dma1_channel1_isr, \
    [NVIC_DMA1_CHANNEL2_IRQ] = dma1_channel2_isr, \
    [NVIC_DMA1_CHANNEL3_IRQ] = dma1_channel3_isr, \
    [NVIC_DMA1_CHANNEL4_IRQ] = dma1_channel4_isr, \
    [NVIC_DMA1_CHANNEL5_IRQ] = dma1_channel5_isr, \
    [NVIC_DMA1_CHANNEL6_IRQ] = dma1_channel6_isr, \
    [NVIC_DMA1_CHANNEL7_IRQ] = dma1_channel7_isr, \
    [NVIC_ADC1_IRQ] = adc1_isr, \
    [NVIC_USB_HP_IRQ] = usb_hp_isr, \
    [NVIC_USB_LP_IRQ] = usb_lp_isr, \
    [NVIC_DAC_IRQ] = dac_isr, \
    [NVIC_COMP_IRQ] = comp_isr, \
    [NVIC_EXTI9_5_IRQ] = exti9_5_isr, \
    [NVIC_LCD_IRQ] = lcd_isr, \
    [NVIC_TIM9_IRQ] = tim9_isr, \
    [NVIC_TIM10_IRQ] = tim10_isr, \
    [NVIC_TIM11_IRQ] = tim11_isr, \
    [NVIC_TIM2_IRQ] = tim2_isr, \
    [NVIC_TIM3_IRQ] = tim3_isr, \
    [NVIC_TIM4_IRQ] = tim4_isr, \
    [NVIC_I2C1_EV_IRQ] = i2c1_ev_isr, \
    [NVIC_I2C1_ER_IRQ] = i2c1_er_isr, \
    [NVIC_I2C2_EV_IRQ] = i2c2_ev_isr, \
    [NVIC_I2C2_ER_IRQ] = i2c2_er_isr, \
    [NVIC_SPI1_IRQ] = spi1_isr, \
    [NVIC_SPI2_IRQ] = spi2_isr, \
    [NVIC_USART1_IRQ] = usart1_isr, \
    [NVIC_USART2_IRQ] = usart2_isr, \
    [NVIC_USART3_IRQ] = usart3_isr, \
    [NVIC_EXTI15_10_IRQ] = exti15_10_isr, \
    [NVIC_RTC_ALARM_IRQ] = rtc_alarm_isr, \
    [NVIC_USB_FS_WAKEUP_IRQ] = usb_fs_wakeup_isr, \
    [NVIC_TIM6_IRQ] = tim6_isr, \
    [NVIC_TIM7_IRQ] = tim7_isr, \
    [NVIC_SDIO_IRQ] = sdio_isr, \
    [NVIC_TIM5_IRQ] = tim5_isr, \
    [NVIC_SPI3_IRQ] = spi3_isr, \
    [NVIC_UART4_IRQ] = uart4_isr, \
    [NVIC_UART5_IRQ] = uart5_isr, \
    [NVIC_DMA2_CH1_IRQ] = dma2_ch1_isr, \
    [NVIC_DMA2_CH2_IRQ] = dma2_ch2_isr, \
    [NVIC_DMA2_CH3_IRQ] = dma2_ch3_isr, \
    [NVIC_DMA2_CH4_IRQ] = dma2_ch4_isr, \
    [NVIC_DMA2_CH5_IRQ] = dma2_ch5_isr, \
    [NVIC_AES_IRQ] = aes_isr, \
    [NVIC_COMP_ACQ_IRQ] = comp_acq_isr
