/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script.
 *
 * This part needs to get included in the compilation unit where
 * blocking_handler gets defined due to the way #pragma works.
 */


/** @defgroup CM3_nvic_isrpragmas_STM32L0 User interrupt service routines (ISR) defaults for STM32 L0 series
    @ingroup CM3_nvic_isrpragmas

    @{*/

#pragma weak wwdg_isr = blocking_handler
#pragma weak pvd_isr = blocking_handler
#pragma weak rtc_isr = blocking_handler
#pragma weak flash_isr = blocking_handler
#pragma weak rcc_isr = blocking_handler
#pragma weak exti0_1_isr = blocking_handler
#pragma weak exti2_3_isr = blocking_handler
#pragma weak exti4_15_isr = blocking_handler
#pragma weak tsc_isr = blocking_handler
#pragma weak dma1_channel1_isr = blocking_handler
#pragma weak dma1_channel2_3_isr = blocking_handler
#pragma weak dma1_channel4_5_isr = blocking_handler
#pragma weak adc_comp_isr = blocking_handler
#pragma weak lptim1_isr = blocking_handler
#pragma weak reserved1_isr = blocking_handler
#pragma weak tim2_isr = blocking_handler
#pragma weak reserved2_isr = blocking_handler
#pragma weak tim6_dac_isr = blocking_handler
#pragma weak reserved3_isr = blocking_handler
#pragma weak reserved4_isr = blocking_handler
#pragma weak tim21_isr = blocking_handler
#pragma weak reserved5_isr = blocking_handler
#pragma weak tim22_isr = blocking_handler
#pragma weak i2c1_isr = blocking_handler
#pragma weak i2c2_isr = blocking_handler
#pragma weak spi1_isr = blocking_handler
#pragma weak spi2_isr = blocking_handler
#pragma weak usart1_isr = blocking_handler
#pragma weak usart2_isr = blocking_handler
#pragma weak lpuart1_isr = blocking_handler
#pragma weak lcd_isr = blocking_handler
#pragma weak usb_isr = blocking_handler

/**@}*/

/* Initialization template for the interrupt vector table. This definition is
 * used by the startup code generator (vector.c) to set the initial values for
 * the interrupt handling routines to the chip family specific _isr weak
 * symbols. */

#define IRQ_HANDLERS \
    [NVIC_WWDG_IRQ] = wwdg_isr, \
    [NVIC_PVD_IRQ] = pvd_isr, \
    [NVIC_RTC_IRQ] = rtc_isr, \
    [NVIC_FLASH_IRQ] = flash_isr, \
    [NVIC_RCC_IRQ] = rcc_isr, \
    [NVIC_EXTI0_1_IRQ] = exti0_1_isr, \
    [NVIC_EXTI2_3_IRQ] = exti2_3_isr, \
    [NVIC_EXTI4_15_IRQ] = exti4_15_isr, \
    [NVIC_TSC_IRQ] = tsc_isr, \
    [NVIC_DMA1_CHANNEL1_IRQ] = dma1_channel1_isr, \
    [NVIC_DMA1_CHANNEL2_3_IRQ] = dma1_channel2_3_isr, \
    [NVIC_DMA1_CHANNEL4_5_IRQ] = dma1_channel4_5_isr, \
    [NVIC_ADC_COMP_IRQ] = adc_comp_isr, \
    [NVIC_LPTIM1_IRQ] = lptim1_isr, \
    [NVIC_RESERVED1_IRQ] = reserved1_isr, \
    [NVIC_TIM2_IRQ] = tim2_isr, \
    [NVIC_RESERVED2_IRQ] = reserved2_isr, \
    [NVIC_TIM6_DAC_IRQ] = tim6_dac_isr, \
    [NVIC_RESERVED3_IRQ] = reserved3_isr, \
    [NVIC_RESERVED4_IRQ] = reserved4_isr, \
    [NVIC_TIM21_IRQ] = tim21_isr, \
    [NVIC_RESERVED5_IRQ] = reserved5_isr, \
    [NVIC_TIM22_IRQ] = tim22_isr, \
    [NVIC_I2C1_IRQ] = i2c1_isr, \
    [NVIC_I2C2_IRQ] = i2c2_isr, \
    [NVIC_SPI1_IRQ] = spi1_isr, \
    [NVIC_SPI2_IRQ] = spi2_isr, \
    [NVIC_USART1_IRQ] = usart1_isr, \
    [NVIC_USART2_IRQ] = usart2_isr, \
    [NVIC_LPUART1_IRQ] = lpuart1_isr, \
    [NVIC_LCD_IRQ] = lcd_isr, \
    [NVIC_USB_IRQ] = usb_isr
