/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script.
 *
 * This part needs to get included in the compilation unit where
 * blocking_handler gets defined due to the way #pragma works.
 */


/** @defgroup CM3_nvic_isrpragmas_STM32F7 User interrupt service routines (ISR) defaults for STM32 F7 series
    @ingroup CM3_nvic_isrpragmas

    @{*/

#pragma weak nvic_wwdg_isr = blocking_handler
#pragma weak pvd_isr = blocking_handler
#pragma weak tamp_stamp_isr = blocking_handler
#pragma weak rtc_wkup_isr = blocking_handler
#pragma weak flash_isr = blocking_handler
#pragma weak rcc_isr = blocking_handler
#pragma weak exti0_isr = blocking_handler
#pragma weak exti1_isr = blocking_handler
#pragma weak exti2_isr = blocking_handler
#pragma weak exti3_isr = blocking_handler
#pragma weak exti4_isr = blocking_handler
#pragma weak dma1_stream0_isr = blocking_handler
#pragma weak dma1_stream1_isr = blocking_handler
#pragma weak dma1_stream2_isr = blocking_handler
#pragma weak dma1_stream3_isr = blocking_handler
#pragma weak dma1_stream4_isr = blocking_handler
#pragma weak dma1_stream5_isr = blocking_handler
#pragma weak dma1_stream6_isr = blocking_handler
#pragma weak adc_isr = blocking_handler
#pragma weak can1_tx_isr = blocking_handler
#pragma weak can1_rx0_isr = blocking_handler
#pragma weak can1_rx1_isr = blocking_handler
#pragma weak can1_sce_isr = blocking_handler
#pragma weak exti9_5_isr = blocking_handler
#pragma weak tim1_brk_tim9_isr = blocking_handler
#pragma weak tim1_up_tim10_isr = blocking_handler
#pragma weak tim1_trg_com_tim11_isr = blocking_handler
#pragma weak tim1_cc_isr = blocking_handler
#pragma weak tim2_isr = blocking_handler
#pragma weak tim3_isr = blocking_handler
#pragma weak tim4_isr = blocking_handler
#pragma weak i2c1_ev_isr = blocking_handler
#pragma weak i2c1_er_isr = blocking_handler
#pragma weak i2c2_ev_isr = blocking_handler
#pragma weak i2c2_er_isr = blocking_handler
#pragma weak spi1_isr = blocking_handler
#pragma weak spi2_isr = blocking_handler
#pragma weak usart1_isr = blocking_handler
#pragma weak usart2_isr = blocking_handler
#pragma weak usart3_isr = blocking_handler
#pragma weak exti15_10_isr = blocking_handler
#pragma weak rtc_alarm_isr = blocking_handler
#pragma weak usb_fs_wkup_isr = blocking_handler
#pragma weak tim8_brk_tim12_isr = blocking_handler
#pragma weak tim8_up_tim13_isr = blocking_handler
#pragma weak tim8_trg_com_tim14_isr = blocking_handler
#pragma weak tim8_cc_isr = blocking_handler
#pragma weak dma1_stream7_isr = blocking_handler
#pragma weak fsmc_isr = blocking_handler
#pragma weak sdmmc1_isr = blocking_handler
#pragma weak tim5_isr = blocking_handler
#pragma weak spi3_isr = blocking_handler
#pragma weak uart4_isr = blocking_handler
#pragma weak uart5_isr = blocking_handler
#pragma weak tim6_dac_isr = blocking_handler
#pragma weak tim7_isr = blocking_handler
#pragma weak dma2_stream0_isr = blocking_handler
#pragma weak dma2_stream1_isr = blocking_handler
#pragma weak dma2_stream2_isr = blocking_handler
#pragma weak dma2_stream3_isr = blocking_handler
#pragma weak dma2_stream4_isr = blocking_handler
#pragma weak eth_isr = blocking_handler
#pragma weak eth_wkup_isr = blocking_handler
#pragma weak can2_tx_isr = blocking_handler
#pragma weak can2_rx0_isr = blocking_handler
#pragma weak can2_rx1_isr = blocking_handler
#pragma weak can2_sce_isr = blocking_handler
#pragma weak otg_fs_isr = blocking_handler
#pragma weak dma2_stream5_isr = blocking_handler
#pragma weak dma2_stream6_isr = blocking_handler
#pragma weak dma2_stream7_isr = blocking_handler
#pragma weak usart6_isr = blocking_handler
#pragma weak i2c3_ev_isr = blocking_handler
#pragma weak i2c3_er_isr = blocking_handler
#pragma weak otg_hs_ep1_out_isr = blocking_handler
#pragma weak otg_hs_ep1_in_isr = blocking_handler
#pragma weak otg_hs_wkup_isr = blocking_handler
#pragma weak otg_hs_isr = blocking_handler
#pragma weak dcmi_isr = blocking_handler
#pragma weak cryp_isr = blocking_handler
#pragma weak hash_rng_isr = blocking_handler
#pragma weak fpu_isr = blocking_handler
#pragma weak uart7_isr = blocking_handler
#pragma weak uart8_isr = blocking_handler
#pragma weak spi4_isr = blocking_handler
#pragma weak spi5_isr = blocking_handler
#pragma weak spi6_isr = blocking_handler
#pragma weak sai1_isr = blocking_handler
#pragma weak lcd_tft_isr = blocking_handler
#pragma weak lcd_tft_err_isr = blocking_handler
#pragma weak dma2d_isr = blocking_handler
#pragma weak sai2_isr = blocking_handler
#pragma weak quadspi_isr = blocking_handler
#pragma weak i2c4_ev_isr = blocking_handler
#pragma weak i2c4_er_isr = blocking_handler
#pragma weak spdifrx_isr = blocking_handler

/**@}*/

/* Initialization template for the interrupt vector table. This definition is
 * used by the startup code generator (vector.c) to set the initial values for
 * the interrupt handling routines to the chip family specific _isr weak
 * symbols. */

#define IRQ_HANDLERS \
    [NVIC_NVIC_WWDG_IRQ] = nvic_wwdg_isr, \
    [NVIC_PVD_IRQ] = pvd_isr, \
    [NVIC_TAMP_STAMP_IRQ] = tamp_stamp_isr, \
    [NVIC_RTC_WKUP_IRQ] = rtc_wkup_isr, \
    [NVIC_FLASH_IRQ] = flash_isr, \
    [NVIC_RCC_IRQ] = rcc_isr, \
    [NVIC_EXTI0_IRQ] = exti0_isr, \
    [NVIC_EXTI1_IRQ] = exti1_isr, \
    [NVIC_EXTI2_IRQ] = exti2_isr, \
    [NVIC_EXTI3_IRQ] = exti3_isr, \
    [NVIC_EXTI4_IRQ] = exti4_isr, \
    [NVIC_DMA1_STREAM0_IRQ] = dma1_stream0_isr, \
    [NVIC_DMA1_STREAM1_IRQ] = dma1_stream1_isr, \
    [NVIC_DMA1_STREAM2_IRQ] = dma1_stream2_isr, \
    [NVIC_DMA1_STREAM3_IRQ] = dma1_stream3_isr, \
    [NVIC_DMA1_STREAM4_IRQ] = dma1_stream4_isr, \
    [NVIC_DMA1_STREAM5_IRQ] = dma1_stream5_isr, \
    [NVIC_DMA1_STREAM6_IRQ] = dma1_stream6_isr, \
    [NVIC_ADC_IRQ] = adc_isr, \
    [NVIC_CAN1_TX_IRQ] = can1_tx_isr, \
    [NVIC_CAN1_RX0_IRQ] = can1_rx0_isr, \
    [NVIC_CAN1_RX1_IRQ] = can1_rx1_isr, \
    [NVIC_CAN1_SCE_IRQ] = can1_sce_isr, \
    [NVIC_EXTI9_5_IRQ] = exti9_5_isr, \
    [NVIC_TIM1_BRK_TIM9_IRQ] = tim1_brk_tim9_isr, \
    [NVIC_TIM1_UP_TIM10_IRQ] = tim1_up_tim10_isr, \
    [NVIC_TIM1_TRG_COM_TIM11_IRQ] = tim1_trg_com_tim11_isr, \
    [NVIC_TIM1_CC_IRQ] = tim1_cc_isr, \
    [NVIC_TIM2_IRQ] = tim2_isr, \
    [NVIC_TIM3_IRQ] = tim3_isr, \
    [NVIC_TIM4_IRQ] = tim4_isr, \
    [NVIC_I2C1_EV_IRQ] = i2c1_ev_isr, \
    [NVIC_I2C1_ER_IRQ] = i2c1_er_isr, \
    [NVIC_I2C2_EV_IRQ] = i2c2_ev_isr, \
    [NVIC_I2C2_ER_IRQ] = i2c2_er_isr, \
    [NVIC_SPI1_IRQ] = spi1_isr, \
    [NVIC_SPI2_IRQ] = spi2_isr, \
    [NVIC_USART1_IRQ] = usart1_isr, \
    [NVIC_USART2_IRQ] = usart2_isr, \
    [NVIC_USART3_IRQ] = usart3_isr, \
    [NVIC_EXTI15_10_IRQ] = exti15_10_isr, \
    [NVIC_RTC_ALARM_IRQ] = rtc_alarm_isr, \
    [NVIC_USB_FS_WKUP_IRQ] = usb_fs_wkup_isr, \
    [NVIC_TIM8_BRK_TIM12_IRQ] = tim8_brk_tim12_isr, \
    [NVIC_TIM8_UP_TIM13_IRQ] = tim8_up_tim13_isr, \
    [NVIC_TIM8_TRG_COM_TIM14_IRQ] = tim8_trg_com_tim14_isr, \
    [NVIC_TIM8_CC_IRQ] = tim8_cc_isr, \
    [NVIC_DMA1_STREAM7_IRQ] = dma1_stream7_isr, \
    [NVIC_FSMC_IRQ] = fsmc_isr, \
    [NVIC_SDMMC1_IRQ] = sdmmc1_isr, \
    [NVIC_TIM5_IRQ] = tim5_isr, \
    [NVIC_SPI3_IRQ] = spi3_isr, \
    [NVIC_UART4_IRQ] = uart4_isr, \
    [NVIC_UART5_IRQ] = uart5_isr, \
    [NVIC_TIM6_DAC_IRQ] = tim6_dac_isr, \
    [NVIC_TIM7_IRQ] = tim7_isr, \
    [NVIC_DMA2_STREAM0_IRQ] = dma2_stream0_isr, \
    [NVIC_DMA2_STREAM1_IRQ] = dma2_stream1_isr, \
    [NVIC_DMA2_STREAM2_IRQ] = dma2_stream2_isr, \
    [NVIC_DMA2_STREAM3_IRQ] = dma2_stream3_isr, \
    [NVIC_DMA2_STREAM4_IRQ] = dma2_stream4_isr, \
    [NVIC_ETH_IRQ] = eth_isr, \
    [NVIC_ETH_WKUP_IRQ] = eth_wkup_isr, \
    [NVIC_CAN2_TX_IRQ] = can2_tx_isr, \
    [NVIC_CAN2_RX0_IRQ] = can2_rx0_isr, \
    [NVIC_CAN2_RX1_IRQ] = can2_rx1_isr, \
    [NVIC_CAN2_SCE_IRQ] = can2_sce_isr, \
    [NVIC_OTG_FS_IRQ] = otg_fs_isr, \
    [NVIC_DMA2_STREAM5_IRQ] = dma2_stream5_isr, \
    [NVIC_DMA2_STREAM6_IRQ] = dma2_stream6_isr, \
    [NVIC_DMA2_STREAM7_IRQ] = dma2_stream7_isr, \
    [NVIC_USART6_IRQ] = usart6_isr, \
    [NVIC_I2C3_EV_IRQ] = i2c3_ev_isr, \
    [NVIC_I2C3_ER_IRQ] = i2c3_er_isr, \
    [NVIC_OTG_HS_EP1_OUT_IRQ] = otg_hs_ep1_out_isr, \
    [NVIC_OTG_HS_EP1_IN_IRQ] = otg_hs_ep1_in_isr, \
    [NVIC_OTG_HS_WKUP_IRQ] = otg_hs_wkup_isr, \
    [NVIC_OTG_HS_IRQ] = otg_hs_isr, \
    [NVIC_DCMI_IRQ] = dcmi_isr, \
    [NVIC_CRYP_IRQ] = cryp_isr, \
    [NVIC_HASH_RNG_IRQ] = hash_rng_isr, \
    [NVIC_FPU_IRQ] = fpu_isr, \
    [NVIC_UART7_IRQ] = uart7_isr, \
    [NVIC_UART8_IRQ] = uart8_isr, \
    [NVIC_SPI4_IRQ] = spi4_isr, \
    [NVIC_SPI5_IRQ] = spi5_isr, \
    [NVIC_SPI6_IRQ] = spi6_isr, \
    [NVIC_SAI1_IRQ] = sai1_isr, \
    [NVIC_LCD_TFT_IRQ] = lcd_tft_isr, \
    [NVIC_LCD_TFT_ERR_IRQ] = lcd_tft_err_isr, \
    [NVIC_DMA2D_IRQ] = dma2d_isr, \
    [NVIC_SAI2_IRQ] = sai2_isr, \
    [NVIC_QUADSPI_IRQ] = quadspi_isr, \
    [NVIC_I2C4_EV_IRQ] = i2c4_ev_isr, \
    [NVIC_I2C4_ER_IRQ] = i2c4_er_isr, \
    [NVIC_SPDIFRX_IRQ] = spdifrx_isr
