/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script.
 *
 * This part needs to get included in the compilation unit where
 * blocking_handler gets defined due to the way #pragma works.
 */


/** @defgroup CM3_nvic_isrpragmas_STM32F3 User interrupt service routines (ISR) defaults for STM32 F3 series
    @ingroup CM3_nvic_isrpragmas

    @{*/

#pragma weak nvic_wwdg_isr = blocking_handler
#pragma weak pvd_isr = blocking_handler
#pragma weak tamp_stamp_isr = blocking_handler
#pragma weak rtc_wkup_isr = blocking_handler
#pragma weak flash_isr = blocking_handler
#pragma weak rcc_isr = blocking_handler
#pragma weak exti0_isr = blocking_handler
#pragma weak exti1_isr = blocking_handler
#pragma weak exti2_tsc_isr = blocking_handler
#pragma weak exti3_isr = blocking_handler
#pragma weak exti4_isr = blocking_handler
#pragma weak dma1_channel1_isr = blocking_handler
#pragma weak dma1_channel2_isr = blocking_handler
#pragma weak dma1_channel3_isr = blocking_handler
#pragma weak dma1_channel4_isr = blocking_handler
#pragma weak dma1_channel5_isr = blocking_handler
#pragma weak dma1_channel6_isr = blocking_handler
#pragma weak dma1_channel7_isr = blocking_handler
#pragma weak adc1_2_isr = blocking_handler
#pragma weak usb_hp_can1_tx_isr = blocking_handler
#pragma weak usb_lp_can1_rx0_isr = blocking_handler
#pragma weak can1_rx1_isr = blocking_handler
#pragma weak can1_sce_isr = blocking_handler
#pragma weak exti9_5_isr = blocking_handler
#pragma weak tim1_brk_tim15_isr = blocking_handler
#pragma weak tim1_up_tim16_isr = blocking_handler
#pragma weak tim1_trg_com_tim17_isr = blocking_handler
#pragma weak tim1_cc_isr = blocking_handler
#pragma weak tim2_isr = blocking_handler
#pragma weak tim3_isr = blocking_handler
#pragma weak tim4_isr = blocking_handler
#pragma weak i2c1_ev_exti23_isr = blocking_handler
#pragma weak i2c1_er_isr = blocking_handler
#pragma weak i2c2_ev_exti24_isr = blocking_handler
#pragma weak i2c2_er_isr = blocking_handler
#pragma weak spi1_isr = blocking_handler
#pragma weak spi2_isr = blocking_handler
#pragma weak usart1_exti25_isr = blocking_handler
#pragma weak usart2_exti26_isr = blocking_handler
#pragma weak usart3_exti28_isr = blocking_handler
#pragma weak exti15_10_isr = blocking_handler
#pragma weak rtc_alarm_isr = blocking_handler
#pragma weak usb_wkup_a_isr = blocking_handler
#pragma weak tim8_brk_isr = blocking_handler
#pragma weak tim8_up_isr = blocking_handler
#pragma weak tim8_trg_com_isr = blocking_handler
#pragma weak tim8_cc_isr = blocking_handler
#pragma weak adc3_isr = blocking_handler
#pragma weak reserved_1_isr = blocking_handler
#pragma weak reserved_2_isr = blocking_handler
#pragma weak reserved_3_isr = blocking_handler
#pragma weak spi3_isr = blocking_handler
#pragma weak uart4_exti34_isr = blocking_handler
#pragma weak uart5_exti35_isr = blocking_handler
#pragma weak tim6_dac_isr = blocking_handler
#pragma weak tim7_isr = blocking_handler
#pragma weak dma2_channel1_isr = blocking_handler
#pragma weak dma2_channel2_isr = blocking_handler
#pragma weak dma2_channel3_isr = blocking_handler
#pragma weak dma2_channel4_isr = blocking_handler
#pragma weak dma2_channel5_isr = blocking_handler
#pragma weak eth_isr = blocking_handler
#pragma weak reserved_4_isr = blocking_handler
#pragma weak reserved_5_isr = blocking_handler
#pragma weak comp123_isr = blocking_handler
#pragma weak comp456_isr = blocking_handler
#pragma weak comp7_isr = blocking_handler
#pragma weak reserved_6_isr = blocking_handler
#pragma weak reserved_7_isr = blocking_handler
#pragma weak reserved_8_isr = blocking_handler
#pragma weak reserved_9_isr = blocking_handler
#pragma weak reserved_10_isr = blocking_handler
#pragma weak reserved_11_isr = blocking_handler
#pragma weak reserved_12_isr = blocking_handler
#pragma weak usb_hp_isr = blocking_handler
#pragma weak usb_lp_isr = blocking_handler
#pragma weak usb_wkup_isr = blocking_handler
#pragma weak reserved_13_isr = blocking_handler
#pragma weak reserved_14_isr = blocking_handler
#pragma weak reserved_15_isr = blocking_handler
#pragma weak reserved_16_isr = blocking_handler

/**@}*/

/* Initialization template for the interrupt vector table. This definition is
 * used by the startup code generator (vector.c) to set the initial values for
 * the interrupt handling routines to the chip family specific _isr weak
 * symbols. */

#define IRQ_HANDLERS \
    [NVIC_NVIC_WWDG_IRQ] = nvic_wwdg_isr, \
    [NVIC_PVD_IRQ] = pvd_isr, \
    [NVIC_TAMP_STAMP_IRQ] = tamp_stamp_isr, \
    [NVIC_RTC_WKUP_IRQ] = rtc_wkup_isr, \
    [NVIC_FLASH_IRQ] = flash_isr, \
    [NVIC_RCC_IRQ] = rcc_isr, \
    [NVIC_EXTI0_IRQ] = exti0_isr, \
    [NVIC_EXTI1_IRQ] = exti1_isr, \
    [NVIC_EXTI2_TSC_IRQ] = exti2_tsc_isr, \
    [NVIC_EXTI3_IRQ] = exti3_isr, \
    [NVIC_EXTI4_IRQ] = exti4_isr, \
    [NVIC_DMA1_CHANNEL1_IRQ] = dma1_channel1_isr, \
    [NVIC_DMA1_CHANNEL2_IRQ] = dma1_channel2_isr, \
    [NVIC_DMA1_CHANNEL3_IRQ] = dma1_channel3_isr, \
    [NVIC_DMA1_CHANNEL4_IRQ] = dma1_channel4_isr, \
    [NVIC_DMA1_CHANNEL5_IRQ] = dma1_channel5_isr, \
    [NVIC_DMA1_CHANNEL6_IRQ] = dma1_channel6_isr, \
    [NVIC_DMA1_CHANNEL7_IRQ] = dma1_channel7_isr, \
    [NVIC_ADC1_2_IRQ] = adc1_2_isr, \
    [NVIC_USB_HP_CAN1_TX_IRQ] = usb_hp_can1_tx_isr, \
    [NVIC_USB_LP_CAN1_RX0_IRQ] = usb_lp_can1_rx0_isr, \
    [NVIC_CAN1_RX1_IRQ] = can1_rx1_isr, \
    [NVIC_CAN1_SCE_IRQ] = can1_sce_isr, \
    [NVIC_EXTI9_5_IRQ] = exti9_5_isr, \
    [NVIC_TIM1_BRK_TIM15_IRQ] = tim1_brk_tim15_isr, \
    [NVIC_TIM1_UP_TIM16_IRQ] = tim1_up_tim16_isr, \
    [NVIC_TIM1_TRG_COM_TIM17_IRQ] = tim1_trg_com_tim17_isr, \
    [NVIC_TIM1_CC_IRQ] = tim1_cc_isr, \
    [NVIC_TIM2_IRQ] = tim2_isr, \
    [NVIC_TIM3_IRQ] = tim3_isr, \
    [NVIC_TIM4_IRQ] = tim4_isr, \
    [NVIC_I2C1_EV_EXTI23_IRQ] = i2c1_ev_exti23_isr, \
    [NVIC_I2C1_ER_IRQ] = i2c1_er_isr, \
    [NVIC_I2C2_EV_EXTI24_IRQ] = i2c2_ev_exti24_isr, \
    [NVIC_I2C2_ER_IRQ] = i2c2_er_isr, \
    [NVIC_SPI1_IRQ] = spi1_isr, \
    [NVIC_SPI2_IRQ] = spi2_isr, \
    [NVIC_USART1_EXTI25_IRQ] = usart1_exti25_isr, \
    [NVIC_USART2_EXTI26_IRQ] = usart2_exti26_isr, \
    [NVIC_USART3_EXTI28_IRQ] = usart3_exti28_isr, \
    [NVIC_EXTI15_10_IRQ] = exti15_10_isr, \
    [NVIC_RTC_ALARM_IRQ] = rtc_alarm_isr, \
    [NVIC_USB_WKUP_A_IRQ] = usb_wkup_a_isr, \
    [NVIC_TIM8_BRK_IRQ] = tim8_brk_isr, \
    [NVIC_TIM8_UP_IRQ] = tim8_up_isr, \
    [NVIC_TIM8_TRG_COM_IRQ] = tim8_trg_com_isr, \
    [NVIC_TIM8_CC_IRQ] = tim8_cc_isr, \
    [NVIC_ADC3_IRQ] = adc3_isr, \
    [NVIC_RESERVED_1_IRQ] = reserved_1_isr, \
    [NVIC_RESERVED_2_IRQ] = reserved_2_isr, \
    [NVIC_RESERVED_3_IRQ] = reserved_3_isr, \
    [NVIC_SPI3_IRQ] = spi3_isr, \
    [NVIC_UART4_EXTI34_IRQ] = uart4_exti34_isr, \
    [NVIC_UART5_EXTI35_IRQ] = uart5_exti35_isr, \
    [NVIC_TIM6_DAC_IRQ] = tim6_dac_isr, \
    [NVIC_TIM7_IRQ] = tim7_isr, \
    [NVIC_DMA2_CHANNEL1_IRQ] = dma2_channel1_isr, \
    [NVIC_DMA2_CHANNEL2_IRQ] = dma2_channel2_isr, \
    [NVIC_DMA2_CHANNEL3_IRQ] = dma2_channel3_isr, \
    [NVIC_DMA2_CHANNEL4_IRQ] = dma2_channel4_isr, \
    [NVIC_DMA2_CHANNEL5_IRQ] = dma2_channel5_isr, \
    [NVIC_ETH_IRQ] = eth_isr, \
    [NVIC_RESERVED_4_IRQ] = reserved_4_isr, \
    [NVIC_RESERVED_5_IRQ] = reserved_5_isr, \
    [NVIC_COMP123_IRQ] = comp123_isr, \
    [NVIC_COMP456_IRQ] = comp456_isr, \
    [NVIC_COMP7_IRQ] = comp7_isr, \
    [NVIC_RESERVED_6_IRQ] = reserved_6_isr, \
    [NVIC_RESERVED_7_IRQ] = reserved_7_isr, \
    [NVIC_RESERVED_8_IRQ] = reserved_8_isr, \
    [NVIC_RESERVED_9_IRQ] = reserved_9_isr, \
    [NVIC_RESERVED_10_IRQ] = reserved_10_isr, \
    [NVIC_RESERVED_11_IRQ] = reserved_11_isr, \
    [NVIC_RESERVED_12_IRQ] = reserved_12_isr, \
    [NVIC_USB_HP_IRQ] = usb_hp_isr, \
    [NVIC_USB_LP_IRQ] = usb_lp_isr, \
    [NVIC_USB_WKUP_IRQ] = usb_wkup_isr, \
    [NVIC_RESERVED_13_IRQ] = reserved_13_isr, \
    [NVIC_RESERVED_14_IRQ] = reserved_14_isr, \
    [NVIC_RESERVED_15_IRQ] = reserved_15_isr, \
    [NVIC_RESERVED_16_IRQ] = reserved_16_isr
