/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script.
 *
 * This part needs to get included in the compilation unit where
 * blocking_handler gets defined due to the way #pragma works.
 */


/** @defgroup CM3_nvic_isrpragmas_SAM3X User interrupt service routines (ISR) defaults for Atmel SAM3X series
    @ingroup CM3_nvic_isrpragmas

    @{*/

#pragma weak supc_isr = blocking_handler
#pragma weak rstc_isr = blocking_handler
#pragma weak rtc_isr = blocking_handler
#pragma weak rtt_isr = blocking_handler
#pragma weak wdt_isr = blocking_handler
#pragma weak pmc_isr = blocking_handler
#pragma weak eefc0_isr = blocking_handler
#pragma weak eefc1_isr = blocking_handler
#pragma weak uart_isr = blocking_handler
#pragma weak smc_sdramc_isr = blocking_handler
#pragma weak sdramc_isr = blocking_handler
#pragma weak pioa_isr = blocking_handler
#pragma weak piob_isr = blocking_handler
#pragma weak pioc_isr = blocking_handler
#pragma weak piod_isr = blocking_handler
#pragma weak pioe_isr = blocking_handler
#pragma weak piof_isr = blocking_handler
#pragma weak usart0_isr = blocking_handler
#pragma weak usart1_isr = blocking_handler
#pragma weak usart2_isr = blocking_handler
#pragma weak usart3_isr = blocking_handler
#pragma weak hsmci_isr = blocking_handler
#pragma weak twi0_isr = blocking_handler
#pragma weak twi1_isr = blocking_handler
#pragma weak spi0_isr = blocking_handler
#pragma weak spi1_isr = blocking_handler
#pragma weak ssc_isr = blocking_handler
#pragma weak tc0_isr = blocking_handler
#pragma weak tc1_isr = blocking_handler
#pragma weak tc2_isr = blocking_handler
#pragma weak tc3_isr = blocking_handler
#pragma weak tc4_isr = blocking_handler
#pragma weak tc5_isr = blocking_handler
#pragma weak tc6_isr = blocking_handler
#pragma weak tc7_isr = blocking_handler
#pragma weak tc8_isr = blocking_handler
#pragma weak pwm_isr = blocking_handler
#pragma weak adc_isr = blocking_handler
#pragma weak dacc_isr = blocking_handler
#pragma weak dmac_isr = blocking_handler
#pragma weak uotghs_isr = blocking_handler
#pragma weak trng_isr = blocking_handler
#pragma weak emac_isr = blocking_handler
#pragma weak can0_isr = blocking_handler
#pragma weak can1_isr = blocking_handler

/**@}*/

/* Initialization template for the interrupt vector table. This definition is
 * used by the startup code generator (vector.c) to set the initial values for
 * the interrupt handling routines to the chip family specific _isr weak
 * symbols. */

#define IRQ_HANDLERS \
    [NVIC_SUPC_IRQ] = supc_isr, \
    [NVIC_RSTC_IRQ] = rstc_isr, \
    [NVIC_RTC_IRQ] = rtc_isr, \
    [NVIC_RTT_IRQ] = rtt_isr, \
    [NVIC_WDT_IRQ] = wdt_isr, \
    [NVIC_PMC_IRQ] = pmc_isr, \
    [NVIC_EEFC0_IRQ] = eefc0_isr, \
    [NVIC_EEFC1_IRQ] = eefc1_isr, \
    [NVIC_UART_IRQ] = uart_isr, \
    [NVIC_SMC_SDRAMC_IRQ] = smc_sdramc_isr, \
    [NVIC_SDRAMC_IRQ] = sdramc_isr, \
    [NVIC_PIOA_IRQ] = pioa_isr, \
    [NVIC_PIOB_IRQ] = piob_isr, \
    [NVIC_PIOC_IRQ] = pioc_isr, \
    [NVIC_PIOD_IRQ] = piod_isr, \
    [NVIC_PIOE_IRQ] = pioe_isr, \
    [NVIC_PIOF_IRQ] = piof_isr, \
    [NVIC_USART0_IRQ] = usart0_isr, \
    [NVIC_USART1_IRQ] = usart1_isr, \
    [NVIC_USART2_IRQ] = usart2_isr, \
    [NVIC_USART3_IRQ] = usart3_isr, \
    [NVIC_HSMCI_IRQ] = hsmci_isr, \
    [NVIC_TWI0_IRQ] = twi0_isr, \
    [NVIC_TWI1_IRQ] = twi1_isr, \
    [NVIC_SPI0_IRQ] = spi0_isr, \
    [NVIC_SPI1_IRQ] = spi1_isr, \
    [NVIC_SSC_IRQ] = ssc_isr, \
    [NVIC_TC0_IRQ] = tc0_isr, \
    [NVIC_TC1_IRQ] = tc1_isr, \
    [NVIC_TC2_IRQ] = tc2_isr, \
    [NVIC_TC3_IRQ] = tc3_isr, \
    [NVIC_TC4_IRQ] = tc4_isr, \
    [NVIC_TC5_IRQ] = tc5_isr, \
    [NVIC_TC6_IRQ] = tc6_isr, \
    [NVIC_TC7_IRQ] = tc7_isr, \
    [NVIC_TC8_IRQ] = tc8_isr, \
    [NVIC_PWM_IRQ] = pwm_isr, \
    [NVIC_ADC_IRQ] = adc_isr, \
    [NVIC_DACC_IRQ] = dacc_isr, \
    [NVIC_DMAC_IRQ] = dmac_isr, \
    [NVIC_UOTGHS_IRQ] = uotghs_isr, \
    [NVIC_TRNG_IRQ] = trng_isr, \
    [NVIC_EMAC_IRQ] = emac_isr, \
    [NVIC_CAN0_IRQ] = can0_isr, \
    [NVIC_CAN1_IRQ] = can1_isr
