/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script.
 *
 * This part needs to get included in the compilation unit where
 * blocking_handler gets defined due to the way #pragma works.
 */


/** @defgroup CM3_nvic_isrpragmas_SAM3U User interrupt service routines (ISR) defaults for Atmel SAM3U series
    @ingroup CM3_nvic_isrpragmas

    @{*/

#pragma weak supc_isr = blocking_handler
#pragma weak rstc_isr = blocking_handler
#pragma weak rtc_isr = blocking_handler
#pragma weak rtt_isr = blocking_handler
#pragma weak wdt_isr = blocking_handler
#pragma weak pmc_isr = blocking_handler
#pragma weak eefc0_isr = blocking_handler
#pragma weak eefc1_isr = blocking_handler
#pragma weak uart_isr = blocking_handler
#pragma weak smc_isr = blocking_handler
#pragma weak pioa_isr = blocking_handler
#pragma weak piob_isr = blocking_handler
#pragma weak pioc_isr = blocking_handler
#pragma weak usart0_isr = blocking_handler
#pragma weak usart1_isr = blocking_handler
#pragma weak usart2_isr = blocking_handler
#pragma weak usart3_isr = blocking_handler
#pragma weak hsmci_isr = blocking_handler
#pragma weak twi0_isr = blocking_handler
#pragma weak twi1_isr = blocking_handler
#pragma weak spi_isr = blocking_handler
#pragma weak ssc_isr = blocking_handler
#pragma weak tc0_isr = blocking_handler
#pragma weak tc1_isr = blocking_handler
#pragma weak tc2_isr = blocking_handler
#pragma weak pwm_isr = blocking_handler
#pragma weak adc12b_isr = blocking_handler
#pragma weak adc_isr = blocking_handler
#pragma weak dmac_isr = blocking_handler
#pragma weak udphs_isr = blocking_handler

/**@}*/

/* Initialization template for the interrupt vector table. This definition is
 * used by the startup code generator (vector.c) to set the initial values for
 * the interrupt handling routines to the chip family specific _isr weak
 * symbols. */

#define IRQ_HANDLERS \
    [NVIC_SUPC_IRQ] = supc_isr, \
    [NVIC_RSTC_IRQ] = rstc_isr, \
    [NVIC_RTC_IRQ] = rtc_isr, \
    [NVIC_RTT_IRQ] = rtt_isr, \
    [NVIC_WDT_IRQ] = wdt_isr, \
    [NVIC_PMC_IRQ] = pmc_isr, \
    [NVIC_EEFC0_IRQ] = eefc0_isr, \
    [NVIC_EEFC1_IRQ] = eefc1_isr, \
    [NVIC_UART_IRQ] = uart_isr, \
    [NVIC_SMC_IRQ] = smc_isr, \
    [NVIC_PIOA_IRQ] = pioa_isr, \
    [NVIC_PIOB_IRQ] = piob_isr, \
    [NVIC_PIOC_IRQ] = pioc_isr, \
    [NVIC_USART0_IRQ] = usart0_isr, \
    [NVIC_USART1_IRQ] = usart1_isr, \
    [NVIC_USART2_IRQ] = usart2_isr, \
    [NVIC_USART3_IRQ] = usart3_isr, \
    [NVIC_HSMCI_IRQ] = hsmci_isr, \
    [NVIC_TWI0_IRQ] = twi0_isr, \
    [NVIC_TWI1_IRQ] = twi1_isr, \
    [NVIC_SPI_IRQ] = spi_isr, \
    [NVIC_SSC_IRQ] = ssc_isr, \
    [NVIC_TC0_IRQ] = tc0_isr, \
    [NVIC_TC1_IRQ] = tc1_isr, \
    [NVIC_TC2_IRQ] = tc2_isr, \
    [NVIC_PWM_IRQ] = pwm_isr, \
    [NVIC_ADC12B_IRQ] = adc12b_isr, \
    [NVIC_ADC_IRQ] = adc_isr, \
    [NVIC_DMAC_IRQ] = dmac_isr, \
    [NVIC_UDPHS_IRQ] = udphs_isr
