/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script.
 */

#ifndef LIBOPENCM3_STM32_L1_NVIC_H
#define LIBOPENCM3_STM32_L1_NVIC_H

#include <libopencm3/cm3/nvic.h>

/** @defgroup CM3_nvic_defines_STM32L1 User interrupts for STM32 L1 series
    @ingroup CM3_nvic_defines

    @{*/

#define NVIC_WWDG_IRQ 0
#define NVIC_PVD_IRQ 1
#define NVIC_TAMPER_STAMP_IRQ 2
#define NVIC_RTC_WKUP_IRQ 3
#define NVIC_FLASH_IRQ 4
#define NVIC_RCC_IRQ 5
#define NVIC_EXTI0_IRQ 6
#define NVIC_EXTI1_IRQ 7
#define NVIC_EXTI2_IRQ 8
#define NVIC_EXTI3_IRQ 9
#define NVIC_EXTI4_IRQ 10
#define NVIC_DMA1_CHANNEL1_IRQ 11
#define NVIC_DMA1_CHANNEL2_IRQ 12
#define NVIC_DMA1_CHANNEL3_IRQ 13
#define NVIC_DMA1_CHANNEL4_IRQ 14
#define NVIC_DMA1_CHANNEL5_IRQ 15
#define NVIC_DMA1_CHANNEL6_IRQ 16
#define NVIC_DMA1_CHANNEL7_IRQ 17
#define NVIC_ADC1_IRQ 18
#define NVIC_USB_HP_IRQ 19
#define NVIC_USB_LP_IRQ 20
#define NVIC_DAC_IRQ 21
#define NVIC_COMP_IRQ 22
#define NVIC_EXTI9_5_IRQ 23
#define NVIC_LCD_IRQ 24
#define NVIC_TIM9_IRQ 25
#define NVIC_TIM10_IRQ 26
#define NVIC_TIM11_IRQ 27
#define NVIC_TIM2_IRQ 28
#define NVIC_TIM3_IRQ 29
#define NVIC_TIM4_IRQ 30
#define NVIC_I2C1_EV_IRQ 31
#define NVIC_I2C1_ER_IRQ 32
#define NVIC_I2C2_EV_IRQ 33
#define NVIC_I2C2_ER_IRQ 34
#define NVIC_SPI1_IRQ 35
#define NVIC_SPI2_IRQ 36
#define NVIC_USART1_IRQ 37
#define NVIC_USART2_IRQ 38
#define NVIC_USART3_IRQ 39
#define NVIC_EXTI15_10_IRQ 40
#define NVIC_RTC_ALARM_IRQ 41
#define NVIC_USB_FS_WAKEUP_IRQ 42
#define NVIC_TIM6_IRQ 43
#define NVIC_TIM7_IRQ 44
#define NVIC_SDIO_IRQ 45
#define NVIC_TIM5_IRQ 46
#define NVIC_SPI3_IRQ 47
#define NVIC_UART4_IRQ 48
#define NVIC_UART5_IRQ 49
#define NVIC_DMA2_CH1_IRQ 50
#define NVIC_DMA2_CH2_IRQ 51
#define NVIC_DMA2_CH3_IRQ 52
#define NVIC_DMA2_CH4_IRQ 53
#define NVIC_DMA2_CH5_IRQ 54
#define NVIC_AES_IRQ 55
#define NVIC_COMP_ACQ_IRQ 56

#define NVIC_IRQ_COUNT 57

/**@}*/

/** @defgroup CM3_nvic_isrprototypes_STM32L1 User interrupt service routines (ISR) prototypes for STM32 L1 series
    @ingroup CM3_nvic_isrprototypes

    @{*/

BEGIN_DECLS

void wwdg_isr(void);
void pvd_isr(void);
void tamper_stamp_isr(void);
void rtc_wkup_isr(void);
void flash_isr(void);
void rcc_isr(void);
void exti0_isr(void);
void exti1_isr(void);
void exti2_isr(void);
void exti3_isr(void);
void exti4_isr(void);
void dma1_channel1_isr(void);
void dma1_channel2_isr(void);
void dma1_channel3_isr(void);
void dma1_channel4_isr(void);
void dma1_channel5_isr(void);
void dma1_channel6_isr(void);
void dma1_channel7_isr(void);
void adc1_isr(void);
void usb_hp_isr(void);
void usb_lp_isr(void);
void dac_isr(void);
void comp_isr(void);
void exti9_5_isr(void);
void lcd_isr(void);
void tim9_isr(void);
void tim10_isr(void);
void tim11_isr(void);
void tim2_isr(void);
void tim3_isr(void);
void tim4_isr(void);
void i2c1_ev_isr(void);
void i2c1_er_isr(void);
void i2c2_ev_isr(void);
void i2c2_er_isr(void);
void spi1_isr(void);
void spi2_isr(void);
void usart1_isr(void);
void usart2_isr(void);
void usart3_isr(void);
void exti15_10_isr(void);
void rtc_alarm_isr(void);
void usb_fs_wakeup_isr(void);
void tim6_isr(void);
void tim7_isr(void);
void sdio_isr(void);
void tim5_isr(void);
void spi3_isr(void);
void uart4_isr(void);
void uart5_isr(void);
void dma2_ch1_isr(void);
void dma2_ch2_isr(void);
void dma2_ch3_isr(void);
void dma2_ch4_isr(void);
void dma2_ch5_isr(void);
void aes_isr(void);
void comp_acq_isr(void);

END_DECLS

/**@}*/

#endif /* LIBOPENCM3_STM32_L1_NVIC_H */
