#include <inttypes.h>
#include <stdio.h>
#include "../common/stm32wrapper.h"

extern uint32_t accumulate(uint32_t *array, size_t arraylen);

int main(void)
{
  uint32_t array[1000];
  char outstr[128];
  unsigned int oldcount, newcount;

  clock_setup();
  gpio_setup();
  usart_setup(115200);

  SCS_DEMCR |= SCS_DEMCR_TRCENA;
  DWT_CYCCNT = 0;
  DWT_CTRL |= DWT_CTRL_CYCCNTENA;


  oldcount = DWT_CYCCNT;
  accumulate(array,1000);
  newcount = DWT_CYCCNT-oldcount;
  
  send_USART_str((unsigned char*)"\n============ IGNORE OUTPUT BEFORE THIS LINE ============\n");

  sprintf(outstr, "\ncycles: %u", newcount);
  send_USART_str(outstr);

  while(1);
  return 0;
}

