#include <stdio.h>

extern void doit(long long *,long long);

__attribute__ ((aligned (1024))) long long storage[1048576];

long long cpucycles(void)
{
  unsigned long long result;
  asm volatile(".byte 15;.byte 49;shlq $32,%%rdx;orq %%rdx,%%rax" : "=a" (result) ::  "%rdx");
  return result;
}

#define SECRETS 4096
long long secrets[SECRETS];

int main()
{
  int pos;
  long long secret;
  long long t0;
  long long t1;
  long long timings[SECRETS];
  int offset=0;
  long long *shifted;

  for (pos = 0;pos < SECRETS;++pos) {
    secrets[pos] = getchar() & 7;
  }

  // Uncomment to run with different byte offsets to the aligned data
  //for (offset = 0;offset < 8;offset += 1) 
  {
    shifted = (long long *) (offset + (char *) storage);
    for (pos = 0;pos < SECRETS;++pos) 
    {
      secret = secrets[pos];
      t0 = cpucycles();
      doit(shifted,secret);
      t1 = cpucycles();
      timings[pos] = t1 - t0;
    }
    for (pos = 0;pos < SECRETS;++pos) 
    {
      printf("%lld %lld %d %d %d\n",secrets[pos],timings[pos]
          ,4095 & (int) (shifted),4095 & (int) (shifted + secrets[pos])
          ,((4095 & (int) (shifted)) >> 6) == ((4095 & (int) (shifted + secrets[pos])) >> 6)
          );
    }
  }
  return 0;
}
