/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.util.io.BufferingOutputStream;
import org.bouncycastle.util.test.SimpleTest;

public class BufferingOutputStreamTest
extends SimpleTest {
    private void checkStream(byte[] byArray, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferingOutputStream bufferingOutputStream = new BufferingOutputStream(byteArrayOutputStream, n);
        int n2 = 0;
        while (n2 != 10) {
            bufferingOutputStream.write(byArray[0]);
            bufferingOutputStream.write(byArray, 1, byArray.length - 1);
            ++n2;
        }
        bufferingOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n3 = 0;
        while (n3 != 10) {
            int n4 = 0;
            while (n4 != byArray.length) {
                if (byArray2[n3 * byArray.length + n4] != byArray[n4]) {
                    this.fail("data mismatch!");
                }
                ++n4;
            }
            ++n3;
        }
    }

    public String getName() {
        return "BufferingStreamTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new BufferingOutputStreamTest());
    }

    public void performTest() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        int n = 1;
        while (n != 256) {
            byte[] byArray = new byte[n];
            secureRandom.nextBytes(byArray);
            this.checkStream(byArray, 16);
            this.checkStream(byArray, 33);
            this.checkStream(byArray, 128);
            ++n;
        }
    }
}

