/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru;

import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;

public abstract class Polynomial {
    public short[] coeffs;
    protected NTRUParameterSet params;

    public Polynomial(NTRUParameterSet nTRUParameterSet) {
        this.coeffs = new short[nTRUParameterSet.n()];
        this.params = nTRUParameterSet;
    }

    static short bothNegativeMask(short s, short s2) {
        return (short)((s & s2) >>> 15);
    }

    public abstract void lift(Polynomial var1);

    static byte mod3(byte by) {
        return (byte)((by & 0xFF) % 3);
    }

    static short mod3(short s) {
        return (short)((s & 0xFFFF) % 3);
    }

    public void mod3PhiN() {
        int n = this.params.n();
        int n2 = 0;
        while (n2 < n) {
            this.coeffs[n2] = Polynomial.mod3((short)(this.coeffs[n2] + 2 * this.coeffs[n - 1]));
            ++n2;
        }
    }

    static int modQ(int n, int n2) {
        return n % n2;
    }

    public void modQPhiN() {
        int n = this.params.n();
        int n2 = 0;
        while (n2 < n) {
            this.coeffs[n2] = (short)(this.coeffs[n2] - this.coeffs[n - 1]);
            ++n2;
        }
    }

    public void r2Inv(Polynomial polynomial) {
        Polynomial polynomial2 = this.params.createPolynomial();
        Polynomial polynomial3 = this.params.createPolynomial();
        Polynomial polynomial4 = this.params.createPolynomial();
        Polynomial polynomial5 = this.params.createPolynomial();
        this.r2Inv(polynomial, polynomial2, polynomial3, polynomial4, polynomial5);
    }

    void r2Inv(Polynomial polynomial, Polynomial polynomial2, Polynomial polynomial3, Polynomial polynomial4, Polynomial polynomial5) {
        int n = this.coeffs.length;
        polynomial5.coeffs[0] = 1;
        int n2 = 0;
        while (n2 < n) {
            polynomial2.coeffs[n2] = 1;
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            polynomial3.coeffs[n - 2 - n2] = (short)((polynomial.coeffs[n2] ^ polynomial.coeffs[n - 1]) & 1);
            ++n2;
        }
        polynomial3.coeffs[n - 1] = 0;
        int n3 = 1;
        int n4 = 0;
        while (n4 < 2 * (n - 1) - 1) {
            n2 = n - 1;
            while (n2 > 0) {
                polynomial4.coeffs[n2] = polynomial4.coeffs[n2 - 1];
                --n2;
            }
            polynomial4.coeffs[0] = 0;
            short s = (short)(polynomial3.coeffs[0] & polynomial2.coeffs[0]);
            short s2 = Polynomial.bothNegativeMask((short)(-n3), -polynomial3.coeffs[0]);
            n3 = (short)(n3 ^ s2 & (n3 ^ -n3));
            n3 = (short)(n3 + 1);
            n2 = 0;
            while (n2 < n) {
                short s3 = (short)(s2 & (polynomial2.coeffs[n2] ^ polynomial3.coeffs[n2]));
                int n5 = n2;
                polynomial2.coeffs[n5] = (short)(polynomial2.coeffs[n5] ^ s3);
                int n6 = n2;
                polynomial3.coeffs[n6] = (short)(polynomial3.coeffs[n6] ^ s3);
                s3 = (short)(s2 & (polynomial4.coeffs[n2] ^ polynomial5.coeffs[n2]));
                int n7 = n2;
                polynomial4.coeffs[n7] = (short)(polynomial4.coeffs[n7] ^ s3);
                int n8 = n2++;
                polynomial5.coeffs[n8] = (short)(polynomial5.coeffs[n8] ^ s3);
            }
            n2 = 0;
            while (n2 < n) {
                polynomial3.coeffs[n2] = (short)(polynomial3.coeffs[n2] ^ s & polynomial2.coeffs[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                polynomial5.coeffs[n2] = (short)(polynomial5.coeffs[n2] ^ s & polynomial4.coeffs[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < n - 1) {
                polynomial3.coeffs[n2] = polynomial3.coeffs[n2 + 1];
                ++n2;
            }
            polynomial3.coeffs[n - 1] = 0;
            ++n4;
        }
        n2 = 0;
        while (n2 < n - 1) {
            this.coeffs[n2] = polynomial4.coeffs[n - 2 - n2];
            ++n2;
        }
        this.coeffs[n - 1] = 0;
    }

    private void r2InvToRqInv(Polynomial polynomial, Polynomial polynomial2, Polynomial polynomial3, Polynomial polynomial4, Polynomial polynomial5) {
        int n = this.coeffs.length;
        int n2 = 0;
        while (n2 < n) {
            polynomial3.coeffs[n2] = -polynomial2.coeffs[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.coeffs[n2] = polynomial.coeffs[n2];
            ++n2;
        }
        polynomial4.rqMul(this, polynomial3);
        polynomial4.coeffs[0] = (short)(polynomial4.coeffs[0] + 2);
        polynomial5.rqMul(polynomial4, this);
        polynomial4.rqMul(polynomial5, polynomial3);
        polynomial4.coeffs[0] = (short)(polynomial4.coeffs[0] + 2);
        this.rqMul(polynomial4, polynomial5);
        polynomial4.rqMul(this, polynomial3);
        polynomial4.coeffs[0] = (short)(polynomial4.coeffs[0] + 2);
        polynomial5.rqMul(polynomial4, this);
        polynomial4.rqMul(polynomial5, polynomial3);
        polynomial4.coeffs[0] = (short)(polynomial4.coeffs[0] + 2);
        this.rqMul(polynomial4, polynomial5);
    }

    public void rqInv(Polynomial polynomial) {
        Polynomial polynomial2 = this.params.createPolynomial();
        Polynomial polynomial3 = this.params.createPolynomial();
        Polynomial polynomial4 = this.params.createPolynomial();
        Polynomial polynomial5 = this.params.createPolynomial();
        this.rqInv(polynomial, polynomial2, polynomial3, polynomial4, polynomial5);
    }

    void rqInv(Polynomial polynomial, Polynomial polynomial2, Polynomial polynomial3, Polynomial polynomial4, Polynomial polynomial5) {
        polynomial2.r2Inv(polynomial);
        this.r2InvToRqInv(polynomial2, polynomial, polynomial3, polynomial4, polynomial5);
    }

    public void rqMul(Polynomial polynomial, Polynomial polynomial2) {
        int n = this.coeffs.length;
        int n2 = 0;
        while (n2 < n) {
            this.coeffs[n2] = 0;
            int n3 = 1;
            while (n3 < n - n2) {
                int n4 = n2;
                this.coeffs[n4] = (short)(this.coeffs[n4] + polynomial.coeffs[n2 + n3] * polynomial2.coeffs[n - n3]);
                ++n3;
            }
            n3 = 0;
            while (n3 < n2 + 1) {
                int n5 = n2;
                this.coeffs[n5] = (short)(this.coeffs[n5] + polynomial.coeffs[n2 - n3] * polynomial2.coeffs[n3]);
                ++n3;
            }
            ++n2;
        }
    }

    public void rqSumZeroFromBytes(byte[] byArray) {
        int n = this.coeffs.length;
        this.sqFromBytes(byArray);
        this.coeffs[n - 1] = 0;
        int n2 = 0;
        while (n2 < this.params.packDegree()) {
            int n3 = n - 1;
            this.coeffs[n3] = (short)(this.coeffs[n3] - this.coeffs[n2]);
            ++n2;
        }
    }

    public byte[] rqSumZeroToBytes(int n) {
        return this.sqToBytes(n);
    }

    public void rqToS3(Polynomial polynomial) {
        int n = this.coeffs.length;
        int n2 = 0;
        while (n2 < n) {
            this.coeffs[n2] = (short)Polynomial.modQ(polynomial.coeffs[n2] & 0xFFFF, this.params.q());
            short s = (short)(this.coeffs[n2] >>> this.params.logQ() - 1);
            int n3 = n2++;
            this.coeffs[n3] = (short)(this.coeffs[n3] + (s << 1 - (this.params.logQ() & 1)));
        }
        this.mod3PhiN();
    }

    public void s3FromBytes(byte[] byArray) {
        byte by;
        int n = this.coeffs.length;
        int n2 = 0;
        while (n2 < this.params.packDegree() / 5) {
            by = byArray[n2];
            this.coeffs[5 * n2] = by;
            this.coeffs[5 * n2 + 1] = (short)((by & 0xFF) * 171 >>> 9);
            this.coeffs[5 * n2 + 2] = (short)((by & 0xFF) * 57 >>> 9);
            this.coeffs[5 * n2 + 3] = (short)((by & 0xFF) * 19 >>> 9);
            this.coeffs[5 * n2 + 4] = (short)((by & 0xFF) * 203 >>> 14);
            ++n2;
        }
        if (this.params.packDegree() > this.params.packDegree() / 5 * 5) {
            int n3 = this.params.packDegree() / 5;
            by = byArray[n3];
            int n4 = 0;
            while (5 * n3 + n4 < this.params.packDegree()) {
                this.coeffs[5 * n3 + n4] = by;
                by = (byte)((by & 0xFF) * 171 >> 9);
                ++n4;
            }
        }
        this.coeffs[n - 1] = 0;
        this.mod3PhiN();
    }

    public void s3Inv(Polynomial polynomial) {
        Polynomial polynomial2 = this.params.createPolynomial();
        Polynomial polynomial3 = this.params.createPolynomial();
        Polynomial polynomial4 = this.params.createPolynomial();
        Polynomial polynomial5 = this.params.createPolynomial();
        this.s3Inv(polynomial, polynomial2, polynomial3, polynomial4, polynomial5);
    }

    void s3Inv(Polynomial polynomial, Polynomial polynomial2, Polynomial polynomial3, Polynomial polynomial4, Polynomial polynomial5) {
        short s;
        int n = this.coeffs.length;
        polynomial5.coeffs[0] = 1;
        int n2 = 0;
        while (n2 < n) {
            polynomial2.coeffs[n2] = 1;
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            polynomial3.coeffs[n - 2 - n2] = Polynomial.mod3((short)((polynomial.coeffs[n2] & 3) + 2 * (polynomial.coeffs[n - 1] & 3)));
            ++n2;
        }
        polynomial3.coeffs[n - 1] = 0;
        int n3 = 1;
        int n4 = 0;
        while (n4 < 2 * (n - 1) - 1) {
            n2 = n - 1;
            while (n2 > 0) {
                polynomial4.coeffs[n2] = polynomial4.coeffs[n2 - 1];
                --n2;
            }
            polynomial4.coeffs[0] = 0;
            s = Polynomial.mod3((byte)(2 * polynomial3.coeffs[0] * polynomial2.coeffs[0]));
            short s2 = Polynomial.bothNegativeMask((short)(-n3), -polynomial3.coeffs[0]);
            n3 = (short)(n3 ^ s2 & (n3 ^ -n3));
            n3 = (short)(n3 + 1);
            n2 = 0;
            while (n2 < n) {
                short s3 = (short)(s2 & (polynomial2.coeffs[n2] ^ polynomial3.coeffs[n2]));
                int n5 = n2;
                polynomial2.coeffs[n5] = (short)(polynomial2.coeffs[n5] ^ s3);
                int n6 = n2;
                polynomial3.coeffs[n6] = (short)(polynomial3.coeffs[n6] ^ s3);
                s3 = (short)(s2 & (polynomial4.coeffs[n2] ^ polynomial5.coeffs[n2]));
                int n7 = n2;
                polynomial4.coeffs[n7] = (short)(polynomial4.coeffs[n7] ^ s3);
                int n8 = n2++;
                polynomial5.coeffs[n8] = (short)(polynomial5.coeffs[n8] ^ s3);
            }
            n2 = 0;
            while (n2 < n) {
                polynomial3.coeffs[n2] = Polynomial.mod3((byte)(polynomial3.coeffs[n2] + s * polynomial2.coeffs[n2]));
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                polynomial5.coeffs[n2] = Polynomial.mod3((byte)(polynomial5.coeffs[n2] + s * polynomial4.coeffs[n2]));
                ++n2;
            }
            n2 = 0;
            while (n2 < n - 1) {
                polynomial3.coeffs[n2] = polynomial3.coeffs[n2 + 1];
                ++n2;
            }
            polynomial3.coeffs[n - 1] = 0;
            ++n4;
        }
        s = polynomial2.coeffs[0];
        n2 = 0;
        while (n2 < n - 1) {
            this.coeffs[n2] = Polynomial.mod3((byte)(s * polynomial4.coeffs[n - 2 - n2]));
            ++n2;
        }
        this.coeffs[n - 1] = 0;
    }

    public void s3Mul(Polynomial polynomial, Polynomial polynomial2) {
        this.rqMul(polynomial, polynomial2);
        this.mod3PhiN();
    }

    public byte[] s3ToBytes(int n) {
        byte by;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < this.params.packDegree() / 5) {
            by = (byte)(this.coeffs[5 * n2 + 4] & 0xFF);
            by = (byte)(3 * by + this.coeffs[5 * n2 + 3] & 0xFF);
            by = (byte)(3 * by + this.coeffs[5 * n2 + 2] & 0xFF);
            by = (byte)(3 * by + this.coeffs[5 * n2 + 1] & 0xFF);
            byArray[n2] = by = (byte)(3 * by + this.coeffs[5 * n2] & 0xFF);
            ++n2;
        }
        if (this.params.packDegree() > this.params.packDegree() / 5 * 5) {
            int n3 = this.params.packDegree() / 5;
            by = 0;
            int n4 = this.params.packDegree() - 5 * n3 - 1;
            while (n4 >= 0) {
                by = (byte)(3 * by + this.coeffs[5 * n3 + n4] & 0xFF);
                --n4;
            }
            byArray[n3] = by;
        }
        return byArray;
    }

    public abstract void sqFromBytes(byte[] var1);

    public void sqMul(Polynomial polynomial, Polynomial polynomial2) {
        this.rqMul(polynomial, polynomial2);
        this.modQPhiN();
    }

    public abstract byte[] sqToBytes(int var1);

    public void trinaryZqToZ3() {
        int n = this.coeffs.length;
        int n2 = 0;
        while (n2 < n) {
            this.coeffs[n2] = (short)Polynomial.modQ(this.coeffs[n2] & 0xFFFF, this.params.q());
            this.coeffs[n2] = (short)(3 & (this.coeffs[n2] ^ this.coeffs[n2] >>> this.params.logQ() - 1));
            ++n2;
        }
    }

    public void z3ToZq() {
        int n = this.coeffs.length;
        int n2 = 0;
        while (n2 < n) {
            this.coeffs[n2] = (short)(this.coeffs[n2] | -(this.coeffs[n2] >>> 1) & this.params.q() - 1);
            ++n2;
        }
    }
}

