/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru;

import org.bouncycastle.pqc.math.ntru.HPSPolynomial;
import org.bouncycastle.pqc.math.ntru.Polynomial;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUHPSParameterSet;

public class HPS4096Polynomial
extends HPSPolynomial {
    public HPS4096Polynomial(NTRUHPSParameterSet nTRUHPSParameterSet) {
        super(nTRUHPSParameterSet);
    }

    public void sqFromBytes(byte[] byArray) {
        int n = 0;
        while (n < this.params.packDegree() / 2) {
            this.coeffs[2 * n] = (short)(byArray[3 * n] & 0xFF | ((short)(byArray[3 * n + 1] & 0xFF) & 0xF) << 8);
            this.coeffs[2 * n + 1] = (short)((byArray[3 * n + 1] & 0xFF) >>> 4 | ((short)(byArray[3 * n + 2] & 0xFF) & 0xFF) << 4);
            ++n;
        }
        this.coeffs[this.params.n() - 1] = 0;
    }

    public byte[] sqToBytes(int n) {
        byte[] byArray = new byte[n];
        int n2 = this.params.q();
        int n3 = 0;
        while (n3 < this.params.packDegree() / 2) {
            byArray[3 * n3] = (byte)(Polynomial.modQ(this.coeffs[2 * n3] & 0xFFFF, n2) & 0xFF);
            byArray[3 * n3 + 1] = (byte)(Polynomial.modQ(this.coeffs[2 * n3] & 0xFFFF, n2) >>> 8 | (Polynomial.modQ(this.coeffs[2 * n3 + 1] & 0xFFFF, n2) & 0xF) << 4);
            byArray[3 * n3 + 2] = (byte)(Polynomial.modQ(this.coeffs[2 * n3 + 1] & 0xFFFF, n2) >>> 4);
            ++n3;
        }
        return byArray;
    }
}

