/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.linearalgebra;

import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialGF2mSmallM;

public class PolynomialRingGF2m {
    private GF2mField field;
    private PolynomialGF2mSmallM p;
    protected PolynomialGF2mSmallM[] sqMatrix;
    protected PolynomialGF2mSmallM[] sqRootMatrix;

    public PolynomialRingGF2m(GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.field = gF2mField;
        this.p = polynomialGF2mSmallM;
        this.computeSquaringMatrix();
        this.computeSquareRootMatrix();
    }

    private void computeSquareRootMatrix() {
        int n = this.p.getDegree();
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            polynomialGF2mSmallMArray[n2] = new PolynomialGF2mSmallM(this.sqMatrix[n2]);
            --n2;
        }
        this.sqRootMatrix = new PolynomialGF2mSmallM[n];
        int n3 = n - 1;
        while (n3 >= 0) {
            this.sqRootMatrix[n3] = new PolynomialGF2mSmallM(this.field, n3);
            --n3;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6;
            if (polynomialGF2mSmallMArray[n4].getCoefficient(n4) == 0) {
                n6 = 0;
                n5 = n4 + 1;
                while (n5 < n) {
                    if (polynomialGF2mSmallMArray[n5].getCoefficient(n4) != 0) {
                        n6 = 1;
                        PolynomialRingGF2m.swapColumns(polynomialGF2mSmallMArray, n4, n5);
                        PolynomialRingGF2m.swapColumns(this.sqRootMatrix, n4, n5);
                        n5 = n;
                    }
                    ++n5;
                }
                if (n6 == 0) {
                    throw new ArithmeticException("Squaring matrix is not invertible.");
                }
            }
            n6 = polynomialGF2mSmallMArray[n4].getCoefficient(n4);
            n5 = this.field.inverse(n6);
            polynomialGF2mSmallMArray[n4].multThisWithElement(n5);
            this.sqRootMatrix[n4].multThisWithElement(n5);
            int n7 = 0;
            while (n7 < n) {
                if (n7 != n4 && (n6 = polynomialGF2mSmallMArray[n7].getCoefficient(n4)) != 0) {
                    PolynomialGF2mSmallM polynomialGF2mSmallM = polynomialGF2mSmallMArray[n4].multWithElement(n6);
                    PolynomialGF2mSmallM polynomialGF2mSmallM2 = this.sqRootMatrix[n4].multWithElement(n6);
                    polynomialGF2mSmallMArray[n7].addToThis(polynomialGF2mSmallM);
                    this.sqRootMatrix[n7].addToThis(polynomialGF2mSmallM2);
                }
                ++n7;
            }
            ++n4;
        }
    }

    private void computeSquaringMatrix() {
        int n = this.p.getDegree();
        this.sqMatrix = new PolynomialGF2mSmallM[n];
        int n2 = 0;
        while (n2 < n >> 1) {
            int[] nArray = new int[(n2 << 1) + 1];
            nArray[n2 << 1] = 1;
            this.sqMatrix[n2] = new PolynomialGF2mSmallM(this.field, nArray);
            ++n2;
        }
        int n3 = n >> 1;
        while (n3 < n) {
            int[] nArray = new int[(n3 << 1) + 1];
            nArray[n3 << 1] = 1;
            PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, nArray);
            this.sqMatrix[n3] = polynomialGF2mSmallM.mod(this.p);
            ++n3;
        }
    }

    public PolynomialGF2mSmallM[] getSquareRootMatrix() {
        return this.sqRootMatrix;
    }

    public PolynomialGF2mSmallM[] getSquaringMatrix() {
        return this.sqMatrix;
    }

    private static void swapColumns(PolynomialGF2mSmallM[] polynomialGF2mSmallMArray, int n, int n2) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = polynomialGF2mSmallMArray[n];
        polynomialGF2mSmallMArray[n] = polynomialGF2mSmallMArray[n2];
        polynomialGF2mSmallMArray[n2] = polynomialGF2mSmallM;
    }
}

