/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.legacy.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.legacy.math.linearalgebra.IntegerFunctions;
import org.bouncycastle.pqc.legacy.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.legacy.math.linearalgebra.RandUtils;
import org.bouncycastle.util.Arrays;

public class Permutation {
    private int[] perm;

    public Permutation(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            this.perm[n2] = n2;
            --n2;
        }
    }

    public Permutation(int n, SecureRandom secureRandom) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n];
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        int n3 = n;
        int n4 = 0;
        while (n4 < n) {
            int n5 = RandUtils.nextInt(secureRandom, n3);
            this.perm[n4] = nArray[n5];
            nArray[n5] = nArray[--n3];
            ++n4;
        }
    }

    public Permutation(byte[] byArray) {
        int n;
        if (byArray.length <= 4) {
            throw new IllegalArgumentException("invalid encoding");
        }
        int n2 = LittleEndianConversions.OS2IP(byArray, 0);
        if (byArray.length != 4 + n2 * (n = IntegerFunctions.ceilLog256(n2 - 1))) {
            throw new IllegalArgumentException("invalid encoding");
        }
        this.perm = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.perm[n3] = LittleEndianConversions.OS2IP(byArray, 4 + n3 * n, n);
            ++n3;
        }
        if (!this.isPermutation(this.perm)) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public Permutation(int[] nArray) {
        if (!this.isPermutation(nArray)) {
            throw new IllegalArgumentException("array is not a permutation vector");
        }
        this.perm = IntUtils.clone(nArray);
    }

    public Permutation computeInverse() {
        Permutation permutation = new Permutation(this.perm.length);
        int n = this.perm.length - 1;
        while (n >= 0) {
            permutation.perm[this.perm[n]] = n;
            --n;
        }
        return permutation;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Permutation)) {
            return false;
        }
        Permutation permutation = (Permutation)object;
        return IntUtils.equals(this.perm, permutation.perm);
    }

    public byte[] getEncoded() {
        int n = this.perm.length;
        int n2 = IntegerFunctions.ceilLog256(n - 1);
        byte[] byArray = new byte[4 + n * n2];
        LittleEndianConversions.I2OSP(n, byArray, 0);
        int n3 = 0;
        while (n3 < n) {
            LittleEndianConversions.I2OSP(this.perm[n3], byArray, 4 + n3 * n2, n2);
            ++n3;
        }
        return byArray;
    }

    public int[] getVector() {
        return IntUtils.clone(this.perm);
    }

    public int hashCode() {
        return Arrays.hashCode(this.perm);
    }

    private boolean isPermutation(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] < 0 || nArray[n2] >= n || blArray[nArray[n2]]) {
                return false;
            }
            blArray[nArray[n2]] = true;
            ++n2;
        }
        return true;
    }

    public Permutation rightMultiply(Permutation permutation) {
        if (permutation.perm.length != this.perm.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        Permutation permutation2 = new Permutation(this.perm.length);
        int n = this.perm.length - 1;
        while (n >= 0) {
            permutation2.perm[n] = this.perm[permutation.perm[n]];
            --n;
        }
        return permutation2;
    }

    public String toString() {
        String string = "[" + this.perm[0];
        int n = 1;
        while (n < this.perm.length) {
            string = String.valueOf(string) + ", " + this.perm[n];
            ++n;
        }
        string = String.valueOf(string) + "]";
        return string;
    }
}

