/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.linearalgebra;

import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nField;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomial;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomialElement;

public class GF2nPolynomialField
extends GF2nField {
    GF2Polynomial[] squaringMatrix;
    private boolean isTrinomial = false;
    private boolean isPentanomial = false;
    private int tc;
    private int[] pc = new int[3];

    public GF2nPolynomialField(int n, SecureRandom secureRandom) {
        super(secureRandom);
        if (n < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = n;
        this.computeFieldPolynomial();
        this.computeSquaringMatrix();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public GF2nPolynomialField(int n, SecureRandom secureRandom, GF2Polynomial gF2Polynomial) throws RuntimeException {
        super(secureRandom);
        if (n < 3) {
            throw new IllegalArgumentException("degree must be at least 3");
        }
        if (gF2Polynomial.getLength() != n + 1) {
            throw new RuntimeException();
        }
        if (!gF2Polynomial.isIrreducible()) {
            throw new RuntimeException();
        }
        this.mDegree = n;
        this.fieldPolynomial = gF2Polynomial;
        this.computeSquaringMatrix();
        int n2 = 2;
        int n3 = 1;
        while (n3 < this.fieldPolynomial.getLength() - 1) {
            if (this.fieldPolynomial.testBit(n3)) {
                if (++n2 == 3) {
                    this.tc = n3;
                }
                if (n2 <= 5) {
                    this.pc[n2 - 3] = n3;
                }
            }
            ++n3;
        }
        if (n2 == 3) {
            this.isTrinomial = true;
        }
        if (n2 == 5) {
            this.isPentanomial = true;
        }
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public GF2nPolynomialField(int n, SecureRandom secureRandom, boolean bl) {
        super(secureRandom);
        if (n < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = n;
        if (bl) {
            this.computeFieldPolynomial();
        } else {
            this.computeFieldPolynomial2();
        }
        this.computeSquaringMatrix();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    protected void computeCOBMatrix(GF2nField gF2nField) {
        GF2nElement[] gF2nElementArray;
        GF2nElement gF2nElement;
        if (this.mDegree != gF2nField.mDegree) {
            throw new IllegalArgumentException("GF2nPolynomialField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
        }
        if (gF2nField instanceof GF2nONBField) {
            gF2nField.computeCOBMatrix(this);
            return;
        }
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[this.mDegree];
        int n = 0;
        while (n < this.mDegree) {
            gF2PolynomialArray[n] = new GF2Polynomial(this.mDegree);
            ++n;
        }
        while ((gF2nElement = gF2nField.getRandomRoot(this.fieldPolynomial)).isZero()) {
        }
        if (gF2nElement instanceof GF2nONBElement) {
            gF2nElementArray = new GF2nONBElement[this.mDegree];
            gF2nElementArray[this.mDegree - 1] = GF2nONBElement.ONE((GF2nONBField)gF2nField);
        } else {
            gF2nElementArray = new GF2nPolynomialElement[this.mDegree];
            gF2nElementArray[this.mDegree - 1] = GF2nPolynomialElement.ONE((GF2nPolynomialField)gF2nField);
        }
        gF2nElementArray[this.mDegree - 2] = gF2nElement;
        n = this.mDegree - 3;
        while (n >= 0) {
            gF2nElementArray[n] = (GF2nElement)gF2nElementArray[n + 1].multiply(gF2nElement);
            --n;
        }
        if (gF2nField instanceof GF2nONBField) {
            n = 0;
            while (n < this.mDegree) {
                int n2 = 0;
                while (n2 < this.mDegree) {
                    if (gF2nElementArray[n].testBit(this.mDegree - n2 - 1)) {
                        gF2PolynomialArray[this.mDegree - n2 - 1].setBit(this.mDegree - n - 1);
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < this.mDegree) {
                int n3 = 0;
                while (n3 < this.mDegree) {
                    if (gF2nElementArray[n].testBit(n3)) {
                        gF2PolynomialArray[this.mDegree - n3 - 1].setBit(this.mDegree - n - 1);
                    }
                    ++n3;
                }
                ++n;
            }
        }
        this.fields.addElement(gF2nField);
        this.matrices.addElement(gF2PolynomialArray);
        gF2nField.fields.addElement(this);
        gF2nField.matrices.addElement(this.invertMatrix(gF2PolynomialArray));
    }

    protected void computeFieldPolynomial() {
        if (this.testTrinomials()) {
            return;
        }
        if (this.testPentanomials()) {
            return;
        }
        this.testRandom();
    }

    protected void computeFieldPolynomial2() {
        if (this.testTrinomials()) {
            return;
        }
        if (this.testPentanomials()) {
            return;
        }
        this.testRandom();
    }

    private void computeSquaringMatrix() {
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[this.mDegree - 1];
        this.squaringMatrix = new GF2Polynomial[this.mDegree];
        int n = 0;
        while (n < this.squaringMatrix.length) {
            this.squaringMatrix[n] = new GF2Polynomial(this.mDegree, "ZERO");
            ++n;
        }
        n = 0;
        while (n < this.mDegree - 1) {
            gF2PolynomialArray[n] = new GF2Polynomial(1, "ONE").shiftLeft(this.mDegree + n).remainder(this.fieldPolynomial);
            ++n;
        }
        n = 1;
        while (n <= Math.abs(this.mDegree >> 1)) {
            int n2 = 1;
            while (n2 <= this.mDegree) {
                if (gF2PolynomialArray[this.mDegree - (n << 1)].testBit(this.mDegree - n2)) {
                    this.squaringMatrix[n2 - 1].setBit(this.mDegree - n);
                }
                ++n2;
            }
            ++n;
        }
        n = Math.abs(this.mDegree >> 1) + 1;
        while (n <= this.mDegree) {
            this.squaringMatrix[(n << 1) - this.mDegree - 1].setBit(this.mDegree - n);
            ++n;
        }
    }

    public int[] getPc() throws RuntimeException {
        if (!this.isPentanomial) {
            throw new RuntimeException();
        }
        int[] nArray = new int[3];
        System.arraycopy(this.pc, 0, nArray, 0, 3);
        return nArray;
    }

    protected GF2nElement getRandomRoot(GF2Polynomial gF2Polynomial) {
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(gF2Polynomial, this);
        int n = gF2nPolynomial.getDegree();
        while (n > 1) {
            GF2nPolynomial gF2nPolynomial2;
            int n2;
            do {
                GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this, this.random);
                GF2nPolynomial gF2nPolynomial3 = new GF2nPolynomial(2, GF2nPolynomialElement.ZERO(this));
                gF2nPolynomial3.set(1, gF2nPolynomialElement);
                GF2nPolynomial gF2nPolynomial4 = new GF2nPolynomial(gF2nPolynomial3);
                int n3 = 1;
                while (n3 <= this.mDegree - 1) {
                    gF2nPolynomial4 = gF2nPolynomial4.multiplyAndReduce(gF2nPolynomial4, gF2nPolynomial);
                    gF2nPolynomial4 = gF2nPolynomial4.add(gF2nPolynomial3);
                    ++n3;
                }
                gF2nPolynomial2 = gF2nPolynomial4.gcd(gF2nPolynomial);
                n2 = gF2nPolynomial2.getDegree();
                n = gF2nPolynomial.getDegree();
            } while (n2 == 0 || n2 == n);
            gF2nPolynomial = n2 << 1 > n ? gF2nPolynomial.quotient(gF2nPolynomial2) : new GF2nPolynomial(gF2nPolynomial2);
            n = gF2nPolynomial.getDegree();
        }
        return gF2nPolynomial.at(0);
    }

    public GF2Polynomial getSquaringVector(int n) {
        return new GF2Polynomial(this.squaringMatrix[n]);
    }

    public int getTc() throws RuntimeException {
        if (!this.isTrinomial) {
            throw new RuntimeException();
        }
        return this.tc;
    }

    public boolean isPentanomial() {
        return this.isPentanomial;
    }

    public boolean isTrinomial() {
        return this.isTrinomial;
    }

    private boolean testPentanomials() {
        boolean bl = false;
        int n = 0;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        int n2 = 1;
        while (n2 <= this.mDegree - 3 && !bl) {
            this.fieldPolynomial.setBit(n2);
            int n3 = n2 + 1;
            while (n3 <= this.mDegree - 2 && !bl) {
                this.fieldPolynomial.setBit(n3);
                int n4 = n3 + 1;
                while (n4 <= this.mDegree - 1 && !bl) {
                    this.fieldPolynomial.setBit(n4);
                    if ((this.mDegree & 1) != 0 | (n2 & 1) != 0 | (n3 & 1) != 0 | (n4 & 1) != 0) {
                        bl = this.fieldPolynomial.isIrreducible();
                        ++n;
                        if (bl) {
                            this.isPentanomial = true;
                            this.pc[0] = n2;
                            this.pc[1] = n3;
                            this.pc[2] = n4;
                            return bl;
                        }
                    }
                    this.fieldPolynomial.resetBit(n4);
                    ++n4;
                }
                this.fieldPolynomial.resetBit(n3);
                ++n3;
            }
            this.fieldPolynomial.resetBit(n2);
            ++n2;
        }
        return bl;
    }

    private boolean testRandom() {
        boolean bl = false;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        int n = 0;
        while (!bl) {
            ++n;
            this.fieldPolynomial.randomize();
            this.fieldPolynomial.setBit(this.mDegree);
            this.fieldPolynomial.setBit(0);
            if (!this.fieldPolynomial.isIrreducible()) continue;
            bl = true;
            return bl;
        }
        return bl;
    }

    private boolean testTrinomials() {
        boolean bl = false;
        int n = 0;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        int n2 = 1;
        while (n2 < this.mDegree && !bl) {
            this.fieldPolynomial.setBit(n2);
            bl = this.fieldPolynomial.isIrreducible();
            ++n;
            if (bl) {
                this.isTrinomial = true;
                this.tc = n2;
                return bl;
            }
            this.fieldPolynomial.resetBit(n2);
            bl = this.fieldPolynomial.isIrreducible();
            ++n2;
        }
        return bl;
    }
}

