/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.linearalgebra;

import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.legacy.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.legacy.math.linearalgebra.Matrix;
import org.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.legacy.math.linearalgebra.Vector;

public class GF2mMatrix
extends Matrix {
    protected GF2mField field;
    protected int[][] matrix;

    public GF2mMatrix(GF2mField gF2mField, byte[] byArray) {
        this.field = gF2mField;
        int n = 8;
        int n2 = 1;
        while (gF2mField.getDegree() > n) {
            ++n2;
            n += 8;
        }
        if (byArray.length < 5) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numRows = (byArray[3] & 0xFF) << 24 ^ (byArray[2] & 0xFF) << 16 ^ (byArray[1] & 0xFF) << 8 ^ byArray[0] & 0xFF;
        int n3 = n2 * this.numRows;
        if (this.numRows <= 0 || (byArray.length - 4) % n3 != 0) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numColumns = (byArray.length - 4) / n3;
        this.matrix = new int[this.numRows][this.numColumns];
        n2 = 4;
        int n4 = 0;
        while (n4 < this.numRows) {
            int n5 = 0;
            while (n5 < this.numColumns) {
                int n6 = 0;
                while (n6 < n) {
                    int[] nArray = this.matrix[n4];
                    int n7 = n5;
                    nArray[n7] = nArray[n7] ^ (byArray[n2++] & 0xFF) << n6;
                    n6 += 8;
                }
                if (!this.field.isElementOfThisField(this.matrix[n4][n5])) {
                    throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
                }
                ++n5;
            }
            ++n4;
        }
    }

    protected GF2mMatrix(GF2mField gF2mField, int[][] nArray) {
        this.field = gF2mField;
        this.matrix = nArray;
        this.numRows = nArray.length;
        this.numColumns = nArray[0].length;
    }

    public GF2mMatrix(GF2mMatrix gF2mMatrix) {
        this.numRows = gF2mMatrix.numRows;
        this.numColumns = gF2mMatrix.numColumns;
        this.field = gF2mMatrix.field;
        this.matrix = new int[this.numRows][];
        int n = 0;
        while (n < this.numRows) {
            this.matrix[n] = IntUtils.clone(gF2mMatrix.matrix[n]);
            ++n;
        }
    }

    private void addToRow(int[] nArray, int[] nArray2) {
        int n = nArray2.length - 1;
        while (n >= 0) {
            nArray2[n] = this.field.add(nArray[n], nArray2[n]);
            --n;
        }
    }

    public Matrix computeInverse() {
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] nArray = new int[this.numRows][this.numRows];
        int n = this.numRows - 1;
        while (n >= 0) {
            nArray[n] = IntUtils.clone(this.matrix[n]);
            --n;
        }
        int[][] nArray2 = new int[this.numRows][this.numRows];
        int n2 = this.numRows - 1;
        while (n2 >= 0) {
            nArray2[n2][n2] = 1;
            --n2;
        }
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4;
            int n5;
            if (nArray[n3][n3] == 0) {
                n5 = 0;
                n4 = n3 + 1;
                while (n4 < this.numRows) {
                    if (nArray[n4][n3] != 0) {
                        n5 = 1;
                        GF2mMatrix.swapColumns(nArray, n3, n4);
                        GF2mMatrix.swapColumns(nArray2, n3, n4);
                        n4 = this.numRows;
                    }
                    ++n4;
                }
                if (n5 == 0) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            n5 = nArray[n3][n3];
            n4 = this.field.inverse(n5);
            this.multRowWithElementThis(nArray[n3], n4);
            this.multRowWithElementThis(nArray2[n3], n4);
            int n6 = 0;
            while (n6 < this.numRows) {
                if (n6 != n3 && (n5 = nArray[n6][n3]) != 0) {
                    int[] nArray3 = this.multRowWithElement(nArray[n3], n5);
                    int[] nArray4 = this.multRowWithElement(nArray2[n3], n5);
                    this.addToRow(nArray3, nArray[n6]);
                    this.addToRow(nArray4, nArray2[n6]);
                }
                ++n6;
            }
            ++n3;
        }
        return new GF2mMatrix(this.field, nArray2);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2mMatrix)) {
            return false;
        }
        GF2mMatrix gF2mMatrix = (GF2mMatrix)object;
        if (!this.field.equals(gF2mMatrix.field) || gF2mMatrix.numRows != this.numColumns || gF2mMatrix.numColumns != this.numColumns) {
            return false;
        }
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numColumns) {
                if (this.matrix[n][n2] != gF2mMatrix.matrix[n][n2]) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public byte[] getEncoded() {
        int n = 8;
        int n2 = 1;
        while (this.field.getDegree() > n) {
            ++n2;
            n += 8;
        }
        byte[] byArray = new byte[this.numRows * this.numColumns * n2 + 4];
        byArray[0] = (byte)(this.numRows & 0xFF);
        byArray[1] = (byte)(this.numRows >>> 8 & 0xFF);
        byArray[2] = (byte)(this.numRows >>> 16 & 0xFF);
        byArray[3] = (byte)(this.numRows >>> 24 & 0xFF);
        n2 = 4;
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4 = 0;
            while (n4 < this.numColumns) {
                int n5 = 0;
                while (n5 < n) {
                    byArray[n2++] = (byte)(this.matrix[n3][n4] >>> n5);
                    n5 += 8;
                }
                ++n4;
            }
            ++n3;
        }
        return byArray;
    }

    public int hashCode() {
        int n = (this.field.hashCode() * 31 + this.numRows) * 31 + this.numColumns;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            while (n3 < this.numColumns) {
                n = n * 31 + this.matrix[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public boolean isZero() {
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numColumns) {
                if (this.matrix[n][n2] != 0) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public Vector leftMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    private int[] multRowWithElement(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            nArray2[n2] = this.field.mult(nArray[n2], n);
            --n2;
        }
        return nArray2;
    }

    private void multRowWithElementThis(int[] nArray, int n) {
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            nArray[n2] = this.field.mult(nArray[n2], n);
            --n2;
        }
    }

    public Matrix rightMultiply(Matrix matrix) {
        throw new RuntimeException("Not implemented.");
    }

    public Matrix rightMultiply(Permutation permutation) {
        throw new RuntimeException("Not implemented.");
    }

    public Vector rightMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    private static void swapColumns(int[][] nArray, int n, int n2) {
        int[] nArray2 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = nArray2;
    }

    public String toString() {
        String string = String.valueOf(this.numRows) + " x " + this.numColumns + " Matrix over " + this.field.toString() + ": \n";
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numColumns) {
                string = String.valueOf(string) + this.field.elementToStr(this.matrix[n][n2]) + " : ";
                ++n2;
            }
            string = String.valueOf(string) + "\n";
            ++n;
        }
        return string;
    }
}

