/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.rainbow.util;

import org.bouncycastle.pqc.legacy.crypto.rainbow.util.GF2Field;

public class ComputeInField {
    private short[][] A;
    short[] x;

    public short[][] addSquareMatrix(short[][] sArray, short[][] sArray2) {
        if (sArray.length != sArray2.length || sArray[0].length != sArray2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray.length];
        int n = 0;
        while (n < sArray.length) {
            int n2 = 0;
            while (n2 < sArray2.length) {
                sArray3[n][n2] = GF2Field.addElem(sArray[n][n2], sArray2[n][n2]);
                ++n2;
            }
            ++n;
        }
        return sArray3;
    }

    public short[] addVect(short[] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[] sArray3 = new short[sArray.length];
        int n = 0;
        while (n < sArray3.length) {
            sArray3[n] = GF2Field.addElem(sArray[n], sArray2[n]);
            ++n;
        }
        return sArray3;
    }

    private void computeZerosAbove() throws RuntimeException {
        short s = 0;
        int n = this.A.length - 1;
        while (n > 0) {
            int n2 = n - 1;
            while (n2 >= 0) {
                short s2 = this.A[n2][n];
                short s3 = GF2Field.invElem(this.A[n][n]);
                if (s3 == 0) {
                    throw new RuntimeException("The matrix is not invertible");
                }
                int n3 = n;
                while (n3 < 2 * this.A.length) {
                    s = GF2Field.multElem(this.A[n][n3], s3);
                    s = GF2Field.multElem(s2, s);
                    this.A[n2][n3] = GF2Field.addElem(this.A[n2][n3], s);
                    ++n3;
                }
                --n2;
            }
            --n;
        }
    }

    private void computeZerosUnder(boolean bl) throws RuntimeException {
        short s = 0;
        int n = bl ? 2 * this.A.length : this.A.length + 1;
        int n2 = 0;
        while (n2 < this.A.length - 1) {
            int n3 = n2 + 1;
            while (n3 < this.A.length) {
                short s2 = this.A[n3][n2];
                short s3 = GF2Field.invElem(this.A[n2][n2]);
                if (s3 == 0) {
                    throw new IllegalStateException("Matrix not invertible! We have to choose another one!");
                }
                int n4 = n2;
                while (n4 < n) {
                    s = GF2Field.multElem(this.A[n2][n4], s3);
                    s = GF2Field.multElem(s2, s);
                    this.A[n3][n4] = GF2Field.addElem(this.A[n3][n4], s);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public short[][] inverse(short[][] sArray) {
        try {
            int n;
            int n2;
            this.A = new short[sArray.length][2 * sArray.length];
            if (sArray.length != sArray[0].length) {
                throw new RuntimeException("The matrix is not invertible. Please choose another one!");
            }
            int n3 = 0;
            while (n3 < sArray.length) {
                n2 = 0;
                while (n2 < sArray.length) {
                    this.A[n3][n2] = sArray[n3][n2];
                    ++n2;
                }
                n = sArray.length;
                while (n < 2 * sArray.length) {
                    this.A[n3][n] = 0;
                    ++n;
                }
                this.A[n3][n3 + this.A.length] = 1;
                ++n3;
            }
            this.computeZerosUnder(true);
            n2 = 0;
            while (n2 < this.A.length) {
                short s = GF2Field.invElem(this.A[n2][n2]);
                n = n2;
                while (n < 2 * this.A.length) {
                    this.A[n2][n] = GF2Field.multElem(this.A[n2][n], s);
                    ++n;
                }
                ++n2;
            }
            this.computeZerosAbove();
            short[][] sArray2 = new short[this.A.length][this.A.length];
            n = 0;
            while (n < this.A.length) {
                int n4 = this.A.length;
                while (n4 < 2 * this.A.length) {
                    sArray2[n][n4 - this.A.length] = this.A[n][n4];
                    ++n4;
                }
                ++n;
            }
            return sArray2;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public short[][] multMatrix(short s, short[][] sArray) {
        short[][] sArray2 = new short[sArray.length][sArray[0].length];
        int n = 0;
        while (n < sArray.length) {
            int n2 = 0;
            while (n2 < sArray[0].length) {
                sArray2[n][n2] = GF2Field.multElem(s, sArray[n][n2]);
                ++n2;
            }
            ++n;
        }
        return sArray2;
    }

    public short[] multVect(short s, short[] sArray) {
        short[] sArray2 = new short[sArray.length];
        int n = 0;
        while (n < sArray2.length) {
            sArray2[n] = GF2Field.multElem(s, sArray[n]);
            ++n;
        }
        return sArray2;
    }

    public short[][] multVects(short[] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray2.length];
        int n = 0;
        while (n < sArray.length) {
            int n2 = 0;
            while (n2 < sArray2.length) {
                sArray3[n][n2] = GF2Field.multElem(sArray[n], sArray2[n2]);
                ++n2;
            }
            ++n;
        }
        return sArray3;
    }

    public short[] multiplyMatrix(short[][] sArray, short[] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s = 0;
        short[] sArray3 = new short[sArray.length];
        int n = 0;
        while (n < sArray.length) {
            int n2 = 0;
            while (n2 < sArray2.length) {
                s = GF2Field.multElem(sArray[n][n2], sArray2[n2]);
                sArray3[n] = GF2Field.addElem(sArray3[n], s);
                ++n2;
            }
            ++n;
        }
        return sArray3;
    }

    public short[][] multiplyMatrix(short[][] sArray, short[][] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s = 0;
        this.A = new short[sArray.length][sArray2[0].length];
        int n = 0;
        while (n < sArray.length) {
            int n2 = 0;
            while (n2 < sArray2.length) {
                int n3 = 0;
                while (n3 < sArray2[0].length) {
                    s = GF2Field.multElem(sArray[n][n2], sArray2[n2][n3]);
                    this.A[n][n3] = GF2Field.addElem(this.A[n][n3], s);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return this.A;
    }

    public short[] solveEquation(short[][] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            return null;
        }
        try {
            int n;
            this.A = new short[sArray.length][sArray.length + 1];
            this.x = new short[sArray.length];
            int n2 = 0;
            while (n2 < sArray.length) {
                n = 0;
                while (n < sArray[0].length) {
                    this.A[n2][n] = sArray[n2][n];
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n < sArray2.length) {
                this.A[n][sArray2.length] = GF2Field.addElem(sArray2[n], this.A[n][sArray2.length]);
                ++n;
            }
            this.computeZerosUnder(false);
            this.substitute();
            return this.x;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private void substitute() throws IllegalStateException {
        short s = GF2Field.invElem(this.A[this.A.length - 1][this.A.length - 1]);
        if (s == 0) {
            throw new IllegalStateException("The equation system is not solvable");
        }
        this.x[this.A.length - 1] = GF2Field.multElem(this.A[this.A.length - 1][this.A.length], s);
        int n = this.A.length - 2;
        while (n >= 0) {
            short s2 = this.A[n][this.A.length];
            int n2 = this.A.length - 1;
            while (n2 > n) {
                s = GF2Field.multElem(this.A[n][n2], this.x[n2]);
                s2 = GF2Field.addElem(s2, s);
                --n2;
            }
            s = GF2Field.invElem(this.A[n][n]);
            if (s == 0) {
                throw new IllegalStateException("Not solvable equation system");
            }
            this.x[n] = GF2Field.multElem(s2, s);
            --n;
        }
    }
}

