/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.rainbow;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.legacy.crypto.rainbow.Layer;
import org.bouncycastle.pqc.legacy.crypto.rainbow.RainbowKeyGenerationParameters;
import org.bouncycastle.pqc.legacy.crypto.rainbow.RainbowParameters;
import org.bouncycastle.pqc.legacy.crypto.rainbow.RainbowPrivateKeyParameters;
import org.bouncycastle.pqc.legacy.crypto.rainbow.RainbowPublicKeyParameters;
import org.bouncycastle.pqc.legacy.crypto.rainbow.util.ComputeInField;
import org.bouncycastle.pqc.legacy.crypto.rainbow.util.GF2Field;

public class RainbowKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private boolean initialized = false;
    private SecureRandom sr;
    private RainbowKeyGenerationParameters rainbowParams;
    private short[][] A1;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2;
    private short[][] A2inv;
    private short[] b2;
    private int numOfLayers;
    private Layer[] layers;
    private int[] vi;
    private short[][] pub_quadratic;
    private short[][] pub_singular;
    private short[] pub_scalar;

    private void compactPublicKey(short[][][] sArray) {
        int n = sArray.length;
        int n2 = sArray[0].length;
        int n3 = n2 * (n2 + 1) / 2;
        this.pub_quadratic = new short[n][n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 = 0;
            int n6 = 0;
            while (n6 < n2) {
                int n7 = n6;
                while (n7 < n2) {
                    this.pub_quadratic[n5][n4] = n7 == n6 ? sArray[n5][n6][n7] : GF2Field.addElem(sArray[n5][n6][n7], sArray[n5][n7][n6]);
                    ++n4;
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
    }

    private void computePublicKey() {
        int n;
        ComputeInField computeInField = new ComputeInField();
        int n2 = this.vi[this.vi.length - 1] - this.vi[0];
        int n3 = this.vi[this.vi.length - 1];
        short[][][] sArray = new short[n2][n3][n3];
        this.pub_singular = new short[n2][n3];
        this.pub_scalar = new short[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        short[] sArray2 = new short[n3];
        short s = 0;
        int n7 = 0;
        while (n7 < this.layers.length) {
            short[][][] sArray3 = this.layers[n7].getCoeffAlpha();
            short[][][] sArray4 = this.layers[n7].getCoeffBeta();
            short[][] sArray5 = this.layers[n7].getCoeffGamma();
            short[] sArray6 = this.layers[n7].getCoeffEta();
            n4 = sArray3[0].length;
            n5 = sArray4[0].length;
            int n8 = 0;
            while (n8 < n4) {
                int n9;
                int n10 = 0;
                while (n10 < n4) {
                    n9 = 0;
                    while (n9 < n5) {
                        sArray2 = computeInField.multVect(sArray3[n8][n10][n9], this.A2[n10 + n5]);
                        sArray[n6 + n8] = computeInField.addSquareMatrix(sArray[n6 + n8], computeInField.multVects(sArray2, this.A2[n9]));
                        sArray2 = computeInField.multVect(this.b2[n9], sArray2);
                        this.pub_singular[n6 + n8] = computeInField.addVect(sArray2, this.pub_singular[n6 + n8]);
                        sArray2 = computeInField.multVect(sArray3[n8][n10][n9], this.A2[n9]);
                        sArray2 = computeInField.multVect(this.b2[n10 + n5], sArray2);
                        this.pub_singular[n6 + n8] = computeInField.addVect(sArray2, this.pub_singular[n6 + n8]);
                        s = GF2Field.multElem(sArray3[n8][n10][n9], this.b2[n10 + n5]);
                        this.pub_scalar[n6 + n8] = GF2Field.addElem(this.pub_scalar[n6 + n8], GF2Field.multElem(s, this.b2[n9]));
                        ++n9;
                    }
                    ++n10;
                }
                n9 = 0;
                while (n9 < n5) {
                    n = 0;
                    while (n < n5) {
                        sArray2 = computeInField.multVect(sArray4[n8][n9][n], this.A2[n9]);
                        sArray[n6 + n8] = computeInField.addSquareMatrix(sArray[n6 + n8], computeInField.multVects(sArray2, this.A2[n]));
                        sArray2 = computeInField.multVect(this.b2[n], sArray2);
                        this.pub_singular[n6 + n8] = computeInField.addVect(sArray2, this.pub_singular[n6 + n8]);
                        sArray2 = computeInField.multVect(sArray4[n8][n9][n], this.A2[n]);
                        sArray2 = computeInField.multVect(this.b2[n9], sArray2);
                        this.pub_singular[n6 + n8] = computeInField.addVect(sArray2, this.pub_singular[n6 + n8]);
                        s = GF2Field.multElem(sArray4[n8][n9][n], this.b2[n9]);
                        this.pub_scalar[n6 + n8] = GF2Field.addElem(this.pub_scalar[n6 + n8], GF2Field.multElem(s, this.b2[n]));
                        ++n;
                    }
                    ++n9;
                }
                n = 0;
                while (n < n5 + n4) {
                    sArray2 = computeInField.multVect(sArray5[n8][n], this.A2[n]);
                    this.pub_singular[n6 + n8] = computeInField.addVect(sArray2, this.pub_singular[n6 + n8]);
                    this.pub_scalar[n6 + n8] = GF2Field.addElem(this.pub_scalar[n6 + n8], GF2Field.multElem(sArray5[n8][n], this.b2[n]));
                    ++n;
                }
                this.pub_scalar[n6 + n8] = GF2Field.addElem(this.pub_scalar[n6 + n8], sArray6[n8]);
                ++n8;
            }
            n6 += n4;
            ++n7;
        }
        short[][][] sArray7 = new short[n2][n3][n3];
        short[][] sArray8 = new short[n2][n3];
        short[] sArray9 = new short[n2];
        n = 0;
        while (n < n2) {
            int n11 = 0;
            while (n11 < this.A1.length) {
                sArray7[n] = computeInField.addSquareMatrix(sArray7[n], computeInField.multMatrix(this.A1[n][n11], sArray[n11]));
                sArray8[n] = computeInField.addVect(sArray8[n], computeInField.multVect(this.A1[n][n11], this.pub_singular[n11]));
                sArray9[n] = GF2Field.addElem(sArray9[n], GF2Field.multElem(this.A1[n][n11], this.pub_scalar[n11]));
                ++n11;
            }
            sArray9[n] = GF2Field.addElem(sArray9[n], this.b1[n]);
            ++n;
        }
        sArray = sArray7;
        this.pub_singular = sArray8;
        this.pub_scalar = sArray9;
        this.compactPublicKey(sArray);
    }

    public AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        this.keygen();
        RainbowPrivateKeyParameters rainbowPrivateKeyParameters = new RainbowPrivateKeyParameters(this.A1inv, this.b1, this.A2inv, this.b2, this.vi, this.layers);
        RainbowPublicKeyParameters rainbowPublicKeyParameters = new RainbowPublicKeyParameters(this.vi[this.vi.length - 1] - this.vi[0], this.pub_quadratic, this.pub_singular, this.pub_scalar);
        return new AsymmetricCipherKeyPair(rainbowPublicKeyParameters, rainbowPrivateKeyParameters);
    }

    private void generateF() {
        this.layers = new Layer[this.numOfLayers];
        int n = 0;
        while (n < this.numOfLayers) {
            this.layers[n] = new Layer(this.vi[n], this.vi[n + 1], this.sr);
            ++n;
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }

    private void generateL1() {
        int n;
        int n2 = this.vi[this.vi.length - 1] - this.vi[0];
        this.A1 = new short[n2][n2];
        this.A1inv = null;
        ComputeInField computeInField = new ComputeInField();
        while (this.A1inv == null) {
            n = 0;
            while (n < n2) {
                int n3 = 0;
                while (n3 < n2) {
                    this.A1[n][n3] = (short)(this.sr.nextInt() & 0xFF);
                    ++n3;
                }
                ++n;
            }
            this.A1inv = computeInField.inverse(this.A1);
        }
        this.b1 = new short[n2];
        n = 0;
        while (n < n2) {
            this.b1[n] = (short)(this.sr.nextInt() & 0xFF);
            ++n;
        }
    }

    private void generateL2() {
        int n;
        int n2 = this.vi[this.vi.length - 1];
        this.A2 = new short[n2][n2];
        this.A2inv = null;
        ComputeInField computeInField = new ComputeInField();
        while (this.A2inv == null) {
            n = 0;
            while (n < n2) {
                int n3 = 0;
                while (n3 < n2) {
                    this.A2[n][n3] = (short)(this.sr.nextInt() & 0xFF);
                    ++n3;
                }
                ++n;
            }
            this.A2inv = computeInField.inverse(this.A2);
        }
        this.b2 = new short[n2];
        n = 0;
        while (n < n2) {
            this.b2[n] = (short)(this.sr.nextInt() & 0xFF);
            ++n;
        }
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    public void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.rainbowParams = (RainbowKeyGenerationParameters)keyGenerationParameters;
        this.sr = this.rainbowParams.getRandom();
        this.vi = this.rainbowParams.getParameters().getVi();
        this.numOfLayers = this.rainbowParams.getParameters().getNumOfLayers();
        this.initialized = true;
    }

    private void initializeDefault() {
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters = new RainbowKeyGenerationParameters(CryptoServicesRegistrar.getSecureRandom(), new RainbowParameters());
        this.initialize(rainbowKeyGenerationParameters);
    }

    private void keygen() {
        this.generateL1();
        this.generateL2();
        this.generateF();
        this.computePublicKey();
    }
}

