/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.mceliece;

import java.math.BigInteger;
import org.bouncycastle.pqc.legacy.math.linearalgebra.BigIntUtils;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2Vector;
import org.bouncycastle.pqc.legacy.math.linearalgebra.IntegerFunctions;

final class Conversions {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    private Conversions() {
    }

    public static byte[] decode(int n, int n2, GF2Vector gF2Vector) {
        if (gF2Vector.getLength() != n || gF2Vector.getHammingWeight() != n2) {
            throw new IllegalArgumentException("vector has wrong length or hamming weight");
        }
        int[] nArray = gF2Vector.getVecArray();
        BigInteger bigInteger = IntegerFunctions.binomial(n, n2);
        BigInteger bigInteger2 = ZERO;
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        while (n5 < n) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(n3 - n4)).divide(BigInteger.valueOf(n3));
            --n3;
            int n6 = n5 >> 5;
            int n7 = nArray[n6] & 1 << (n5 & 0x1F);
            if (n7 != 0) {
                bigInteger2 = bigInteger2.add(bigInteger);
                bigInteger = n3 == --n4 ? ONE : bigInteger.multiply(BigInteger.valueOf(n4 + 1)).divide(BigInteger.valueOf(n3 - n4));
            }
            ++n5;
        }
        return BigIntUtils.toMinimalByteArray(bigInteger2);
    }

    public static GF2Vector encode(int n, int n2, byte[] byArray) {
        if (n < n2) {
            throw new IllegalArgumentException("n < t");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = IntegerFunctions.binomial(n, n2);
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            throw new IllegalArgumentException("Encoded number too large.");
        }
        GF2Vector gF2Vector = new GF2Vector(n);
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        while (n5 < n) {
            bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(n3 - n4)).divide(BigInteger.valueOf(n3));
            --n3;
            if (bigInteger2.compareTo(bigInteger) <= 0) {
                gF2Vector.setBit(n5);
                bigInteger = bigInteger.subtract(bigInteger2);
                bigInteger2 = n3 == --n4 ? ONE : bigInteger2.multiply(BigInteger.valueOf(n4 + 1)).divide(BigInteger.valueOf(n3 - n4));
            }
            ++n5;
        }
        return gF2Vector;
    }

    public static byte[] signConversion(int n, int n2, byte[] byArray) {
        int n3;
        int n4;
        byte[] byArray2;
        if (n < n2) {
            throw new IllegalArgumentException("n < t");
        }
        BigInteger bigInteger = IntegerFunctions.binomial(n, n2);
        int n5 = bigInteger.bitLength() - 1;
        int n6 = n5 >> 3;
        int n7 = n5 & 7;
        if (n7 == 0) {
            --n6;
            n7 = 8;
        }
        int n8 = n >> 3;
        int n9 = n & 7;
        if (n9 == 0) {
            --n8;
            n9 = 8;
        }
        if (byArray.length < (byArray2 = new byte[n8 + 1]).length) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            n4 = byArray.length;
            while (n4 < byArray2.length) {
                byArray2[n4] = 0;
                ++n4;
            }
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, n8);
            n4 = (1 << n9) - 1;
            byArray2[n8] = (byte)(n4 & byArray[n8]);
        }
        BigInteger bigInteger2 = ZERO;
        int n10 = n;
        int n11 = n2;
        int n12 = 0;
        while (n12 < n) {
            bigInteger = bigInteger.multiply(new BigInteger(Integer.toString(n10 - n11))).divide(new BigInteger(Integer.toString(n10)));
            --n10;
            int n13 = n12 >>> 3;
            int n14 = n12 & 7;
            n3 = (byte)((n14 = 1 << n14) & byArray2[n13]);
            if (n3 != 0) {
                bigInteger2 = bigInteger2.add(bigInteger);
                bigInteger = n10 == --n11 ? ONE : bigInteger.multiply(new BigInteger(Integer.toString(n11 + 1))).divide(new BigInteger(Integer.toString(n10 - n11)));
            }
            ++n12;
        }
        byte[] byArray3 = new byte[n6 + 1];
        byte[] byArray4 = bigInteger2.toByteArray();
        if (byArray4.length < byArray3.length) {
            System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
            n3 = byArray4.length;
            while (n3 < byArray3.length) {
                byArray3[n3] = 0;
                ++n3;
            }
        } else {
            System.arraycopy(byArray4, 0, byArray3, 0, n6);
            byArray3[n6] = (byte)((1 << n7) - 1 & byArray4[n6]);
        }
        return byArray3;
    }
}

