/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincsplus;

import java.util.LinkedList;
import org.bouncycastle.pqc.crypto.sphincsplus.ADRS;
import org.bouncycastle.pqc.crypto.sphincsplus.NodeEntry;
import org.bouncycastle.pqc.crypto.sphincsplus.SIG_XMSS;
import org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import org.bouncycastle.pqc.crypto.sphincsplus.WotsPlus;
import org.bouncycastle.util.Arrays;

class HT {
    private final byte[] skSeed;
    private final byte[] pkSeed;
    SPHINCSPlusEngine engine;
    WotsPlus wots;
    final byte[] htPubKey;

    public HT(SPHINCSPlusEngine sPHINCSPlusEngine, byte[] byArray, byte[] byArray2) {
        this.skSeed = byArray;
        this.pkSeed = byArray2;
        this.engine = sPHINCSPlusEngine;
        this.wots = new WotsPlus(sPHINCSPlusEngine);
        ADRS aDRS = new ADRS();
        aDRS.setLayerAddress(sPHINCSPlusEngine.D - 1);
        aDRS.setTreeAddress(0L);
        this.htPubKey = (byte[])(byArray != null ? this.xmss_PKgen(byArray, byArray2, aDRS) : null);
    }

    byte[] sign(byte[] byArray, long l, int n) {
        ADRS aDRS = new ADRS();
        aDRS.setLayerAddress(0);
        aDRS.setTreeAddress(l);
        SIG_XMSS sIG_XMSS = this.xmss_sign(byArray, this.skSeed, n, this.pkSeed, aDRS);
        SIG_XMSS[] sIG_XMSSArray = new SIG_XMSS[this.engine.D];
        sIG_XMSSArray[0] = sIG_XMSS;
        aDRS.setLayerAddress(0);
        aDRS.setTreeAddress(l);
        byte[] byArray2 = this.xmss_pkFromSig(n, sIG_XMSS, byArray, this.pkSeed, aDRS);
        int n2 = 1;
        while (n2 < this.engine.D) {
            n = (int)(l & (long)((1 << this.engine.H_PRIME) - 1));
            aDRS.setLayerAddress(n2);
            aDRS.setTreeAddress(l >>>= this.engine.H_PRIME);
            sIG_XMSSArray[n2] = sIG_XMSS = this.xmss_sign(byArray2, this.skSeed, n, this.pkSeed, aDRS);
            if (n2 < this.engine.D - 1) {
                byArray2 = this.xmss_pkFromSig(n, sIG_XMSS, byArray2, this.pkSeed, aDRS);
            }
            ++n2;
        }
        byte[][] byArray3 = new byte[sIG_XMSSArray.length][];
        int n3 = 0;
        while (n3 != byArray3.length) {
            byArray3[n3] = Arrays.concatenate(sIG_XMSSArray[n3].sig, Arrays.concatenate(sIG_XMSSArray[n3].auth));
            ++n3;
        }
        return Arrays.concatenate(byArray3);
    }

    byte[] treehash(byte[] byArray, int n, int n2, byte[] byArray2, ADRS aDRS) {
        if (n >>> n2 << n2 != n) {
            return null;
        }
        LinkedList<NodeEntry> linkedList = new LinkedList<NodeEntry>();
        ADRS aDRS2 = new ADRS(aDRS);
        int n3 = 0;
        while (n3 < 1 << n2) {
            aDRS2.setTypeAndClear(0);
            aDRS2.setKeyPairAddress(n + n3);
            byte[] byArray3 = this.wots.pkGen(byArray, byArray2, aDRS2);
            aDRS2.setTypeAndClear(2);
            aDRS2.setTreeHeight(1);
            aDRS2.setTreeIndex(n + n3);
            int n4 = 1;
            int n5 = n + n3;
            while (!linkedList.isEmpty() && ((NodeEntry)linkedList.get((int)0)).nodeHeight == n4) {
                n5 = (n5 - 1) / 2;
                aDRS2.setTreeIndex(n5);
                NodeEntry nodeEntry = (NodeEntry)linkedList.remove(0);
                byArray3 = this.engine.H(byArray2, aDRS2, nodeEntry.nodeValue, byArray3);
                aDRS2.setTreeHeight(++n4);
            }
            linkedList.add(0, new NodeEntry(byArray3, n4));
            ++n3;
        }
        return ((NodeEntry)linkedList.get((int)0)).nodeValue;
    }

    public boolean verify(byte[] byArray, SIG_XMSS[] sIG_XMSSArray, byte[] byArray2, long l, int n, byte[] byArray3) {
        ADRS aDRS = new ADRS();
        SIG_XMSS sIG_XMSS = sIG_XMSSArray[0];
        aDRS.setLayerAddress(0);
        aDRS.setTreeAddress(l);
        byte[] byArray4 = this.xmss_pkFromSig(n, sIG_XMSS, byArray, byArray2, aDRS);
        int n2 = 1;
        while (n2 < this.engine.D) {
            n = (int)(l & (long)((1 << this.engine.H_PRIME) - 1));
            sIG_XMSS = sIG_XMSSArray[n2];
            aDRS.setLayerAddress(n2);
            aDRS.setTreeAddress(l >>>= this.engine.H_PRIME);
            byArray4 = this.xmss_pkFromSig(n, sIG_XMSS, byArray4, byArray2, aDRS);
            ++n2;
        }
        return Arrays.areEqual(byArray3, byArray4);
    }

    byte[] xmss_PKgen(byte[] byArray, byte[] byArray2, ADRS aDRS) {
        return this.treehash(byArray, 0, this.engine.H_PRIME, byArray2, aDRS);
    }

    byte[] xmss_pkFromSig(int n, SIG_XMSS sIG_XMSS, byte[] byArray, byte[] byArray2, ADRS aDRS) {
        ADRS aDRS2 = new ADRS(aDRS);
        aDRS2.setTypeAndClear(0);
        aDRS2.setKeyPairAddress(n);
        byte[] byArray3 = sIG_XMSS.getWOTSSig();
        byte[][] byArray4 = sIG_XMSS.getXMSSAUTH();
        byte[] byArray5 = this.wots.pkFromSig(byArray3, byArray, byArray2, aDRS2);
        byte[] byArray6 = null;
        aDRS2.setTypeAndClear(2);
        aDRS2.setTreeIndex(n);
        int n2 = 0;
        while (n2 < this.engine.H_PRIME) {
            aDRS2.setTreeHeight(n2 + 1);
            if (n / (1 << n2) % 2 == 0) {
                aDRS2.setTreeIndex(aDRS2.getTreeIndex() / 2);
                byArray6 = this.engine.H(byArray2, aDRS2, byArray5, byArray4[n2]);
            } else {
                aDRS2.setTreeIndex((aDRS2.getTreeIndex() - 1) / 2);
                byArray6 = this.engine.H(byArray2, aDRS2, byArray4[n2], byArray5);
            }
            byArray5 = byArray6;
            ++n2;
        }
        return byArray5;
    }

    SIG_XMSS xmss_sign(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, ADRS aDRS) {
        byte[][] byArray4 = new byte[this.engine.H_PRIME][];
        ADRS aDRS2 = new ADRS(aDRS);
        aDRS2.setTypeAndClear(2);
        aDRS2.setLayerAddress(aDRS.getLayerAddress());
        aDRS2.setTreeAddress(aDRS.getTreeAddress());
        int n2 = 0;
        while (n2 < this.engine.H_PRIME) {
            int n3 = n >>> n2 ^ 1;
            byArray4[n2] = this.treehash(byArray2, n3 << n2, n2, byArray3, aDRS2);
            ++n2;
        }
        aDRS2 = new ADRS(aDRS);
        aDRS2.setTypeAndClear(0);
        aDRS2.setKeyPairAddress(n);
        byte[] byArray5 = this.wots.sign(byArray, byArray2, byArray3, aDRS2);
        return new SIG_XMSS(byArray5, byArray4);
    }
}

