/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincs;

import org.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import org.bouncycastle.pqc.crypto.sphincs.Seed;

class Wots {
    static final int WOTS_LOGW = 4;
    static final int WOTS_W = 16;
    static final int WOTS_L1 = 64;
    static final int WOTS_L = 67;
    static final int WOTS_LOG_L = 7;
    static final int WOTS_SIGBYTES = 2144;

    Wots() {
    }

    private static void clear(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 != n2) {
            byArray[n3 + n] = 0;
            ++n3;
        }
    }

    static void expand_seed(byte[] byArray, int n, byte[] byArray2, int n2) {
        Wots.clear(byArray, n, 2144);
        Seed.prg(byArray, n, 2144L, byArray2, n2);
    }

    static void gen_chain(HashFunctions hashFunctions, byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3, int n4) {
        int n5 = 0;
        while (n5 < 32) {
            byArray[n5 + n] = byArray2[n5 + n2];
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4 && n6 < 16) {
            hashFunctions.hash_n_n_mask(byArray, n, byArray, n, byArray3, n3 + n6 * 32);
            ++n6;
        }
    }

    void wots_pkgen(HashFunctions hashFunctions, byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        Wots.expand_seed(byArray, n, byArray2, n2);
        int n4 = 0;
        while (n4 < 67) {
            Wots.gen_chain(hashFunctions, byArray, n + n4 * 32, byArray, n + n4 * 32, byArray3, n3, 15);
            ++n4;
        }
    }

    void wots_sign(HashFunctions hashFunctions, byte[] byArray, int n, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int[] nArray = new int[67];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 64) {
            nArray[n3] = byArray2[n3 / 2] & 0xF;
            nArray[n3 + 1] = (byArray2[n3 / 2] & 0xFF) >>> 4;
            n2 += 15 - nArray[n3];
            n2 += 15 - nArray[n3 + 1];
            n3 += 2;
        }
        while (n3 < 67) {
            nArray[n3] = n2 & 0xF;
            n2 >>>= 4;
            ++n3;
        }
        Wots.expand_seed(byArray, n, byArray3, 0);
        n3 = 0;
        while (n3 < 67) {
            Wots.gen_chain(hashFunctions, byArray, n + n3 * 32, byArray, n + n3 * 32, byArray4, 0, nArray[n3]);
            ++n3;
        }
    }

    void wots_verify(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        int[] nArray = new int[67];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 64) {
            nArray[n3] = byArray3[n3 / 2] & 0xF;
            nArray[n3 + 1] = (byArray3[n3 / 2] & 0xFF) >>> 4;
            n2 += 15 - nArray[n3];
            n2 += 15 - nArray[n3 + 1];
            n3 += 2;
        }
        while (n3 < 67) {
            nArray[n3] = n2 & 0xF;
            n2 >>>= 4;
            ++n3;
        }
        n3 = 0;
        while (n3 < 67) {
            Wots.gen_chain(hashFunctions, byArray, n3 * 32, byArray2, n + n3 * 32, byArray4, nArray[n3] * 32, 15 - nArray[n3]);
            ++n3;
        }
    }
}

